; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX942 %s


define void @v_shuffle_v3f32_v2f32__u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v3f32_v2f32__u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> poison
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__0_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__0_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__0_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__0_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx3 v2, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__1_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__1_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__1_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__1_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx3 v2, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 poison, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__2_u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v3f32_v2f32__2_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 poison, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx3 v2, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx3 v2, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 poison>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__u_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__u_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v0, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__u_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__u_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 poison, i32 0, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> zeroinitializer
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__1_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__1_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__1_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__1_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__2_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__2_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v0, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__2_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__2_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 0, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx3 v5, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx3 v6, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v6, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:5]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx3 v6, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 0>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__u_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__u_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__u_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__u_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 poison, i32 1, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__0_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__0_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__0_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__0_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 0, i32 1, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 1, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__2_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__2_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__2_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__2_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 1, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx3 v5, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx3 v6, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v6, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:5]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx3 v6, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 1>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__u_2_2(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v3f32_v2f32__u_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 poison, i32 2, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__0_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__0_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__0_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__0_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx3 v2, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 0, i32 2, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__1_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__1_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__1_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx3 v2, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__1_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx3 v2, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 2, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v3f32_v2f32__2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 2, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx3 v1, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx3 v1, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    global_store_dwordx3 v6, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v6, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:5]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    global_store_dwordx3 v6, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 2>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__u_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__u_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__u_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__u_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 poison, i32 3, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__0_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__0_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__0_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__0_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 0, i32 3, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__1_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__1_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__1_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__1_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 1, i32 3, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__2_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__2_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__2_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__2_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 2, i32 3, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v6, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    global_store_dwordx3 v6, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v6, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:5]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v5
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    global_store_dwordx3 v6, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v3f32_v2f32__3_2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v3f32_v2f32__3_2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx3 v3, v[0:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v3f32_v2f32__3_2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx3 v4, v[0:2], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v3f32_v2f32__3_2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx3 v4, v[0:2], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=v"()
  %vec1 = call <2 x float> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 3>
  store <3 x float> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @s_shuffle_v3f32_v2f32__u_u_u() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__0_u_u() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__0_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__0_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__0_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__1_u_u() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__1_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__1_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__1_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__2_u_u() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__2_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_u_u() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_0_u() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_1_u() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_2_u() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_3_u() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__3_3_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_3_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s9
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_3_1() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s9
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_3_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_3_3() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__u_0_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__u_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__u_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__u_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 poison, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__0_0_0() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__0_0_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__1_0_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__1_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__1_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__1_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__2_0_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__2_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__2_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__2_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_0_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_u_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_1_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_2_0() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__u_1_1() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__u_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 poison, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__0_1_1() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__0_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 0, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__1_1_1() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__1_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__2_1_1() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__2_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_1_1() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_u_1() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_0_1() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_2_1() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__u_2_2() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__u_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 poison, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__0_2_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__0_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__0_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__0_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 0, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__1_2_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__1_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__1_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__1_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 1, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__2_2_2() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> poison, <3 x i32> <i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_2_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_u_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_0_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_1_2() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__u_3_3() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__u_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 poison, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__0_3_3() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__0_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__0_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__0_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 0, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__1_3_3() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__1_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__1_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__1_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 1, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__2_3_3() {
; GFX9-LABEL: s_shuffle_v3f32_v2f32__2_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 2, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_u_3() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_0_3() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_1_3() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}

define void @s_shuffle_v3f32_v2f32__3_2_3() {
; GFX900-LABEL: s_shuffle_v3f32_v2f32__3_2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v3f32_v2f32__3_2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v3f32_v2f32__3_2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x float> asm "; def $0", "=s"()
  %vec1 = call <2 x float> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x float> %vec0, <2 x float> %vec1, <3 x i32> <i32 3, i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:10]}"(<3 x float> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
