; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu | FileCheck %s

; Transform "a == C ? C : x" to "a == C ? a : x" to avoid materializing C.
define i32 @test1(i32 %x) {
; CHECK-LABEL: test1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7
; CHECK-NEXT:    cmp w0, #2
; CHECK-NEXT:    csel w0, w0, w8, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i32 %x, 2
  %res = select i1 %cmp, i32 2, i32 7
  ret i32 %res
}

; Transform "a == C ? C : x" to "a == C ? a : x" to avoid materializing C.
define i64 @test2(i64 %x) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7
; CHECK-NEXT:    cmp x0, #2
; CHECK-NEXT:    csel x0, x0, x8, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, 2
  %res = select i1 %cmp, i64 2, i64 7
  ret i64 %res
}

; Transform "a != C ? x : C" to "a != C ? x : a" to avoid materializing C.
define i64 @test3(i64 %x) {
; CHECK-LABEL: test3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2
; CHECK-NEXT:    cmp x0, #7
; CHECK-NEXT:    csel x0, x8, x0, ne
; CHECK-NEXT:    ret
  %cmp = icmp ne i64 %x, 7
  %res = select i1 %cmp, i64 2, i64 7
  ret i64 %res
}

; Don't transform "a == C ? C : x" to "a == C ? a : x" if a == 0.  If we did we
; would needlessly extend the live range of x0 when we can just use xzr.
define i64 @test4(i64 %x) {
; CHECK-LABEL: test4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x0, xzr, x8, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, 0
  %res = select i1 %cmp, i64 0, i64 7
  ret i64 %res
}

; Don't transform "a == C ? C : x" to "a == C ? a : x" if a == 1.  If we did we
; would needlessly extend the live range of x0 when we can just use xzr with
; CSINC to materialize the 1.
define i64 @test5(i64 %x) {
; CHECK-LABEL: test5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7
; CHECK-NEXT:    cmp x0, #1
; CHECK-NEXT:    csinc x0, x8, xzr, ne
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, 1
  %res = select i1 %cmp, i64 1, i64 7
  ret i64 %res
}

; Don't transform "a == C ? C : x" to "a == C ? a : x" if a == -1.  If we did we
; would needlessly extend the live range of x0 when we can just use xzr with
; CSINV to materialize the -1.
define i64 @test6(i64 %x) {
; CHECK-LABEL: test6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7
; CHECK-NEXT:    cmn x0, #1
; CHECK-NEXT:    csinv x0, x8, xzr, ne
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, -1
  %res = select i1 %cmp, i64 -1, i64 7
  ret i64 %res
}

define i64 @test7(i64 %x) {
; CHECK-LABEL: test7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, #7
; CHECK-NEXT:    csinc x0, x0, xzr, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, 7
  %res = select i1 %cmp, i64 7, i64 1
  ret i64 %res
}

define i64 @test8(i64 %x) {
; CHECK-LABEL: test8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, #7
; CHECK-NEXT:    csinc x0, x0, xzr, eq
; CHECK-NEXT:    ret
  %cmp = icmp ne i64 %x, 7
  %res = select i1 %cmp, i64 1, i64 7
  ret i64 %res
}

define i64 @test9(i64 %x) {
; CHECK-LABEL: test9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, #7
; CHECK-NEXT:    csinv x0, x0, xzr, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i64 %x, 7
  %res = select i1 %cmp, i64 7, i64 -1
  ret i64 %res
}

; Rather than use a CNEG, use a CSINV to transform "a == 1 ? 1 : -1" to
; "a == 1 ? a : -1" to avoid materializing a constant.
define i32 @test10(i32 %x) {
; CHECK-LABEL: test10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, #1
; CHECK-NEXT:    csinv w0, w0, wzr, eq
; CHECK-NEXT:    ret
  %cmp = icmp eq i32 %x, 1
  %res = select i1 %cmp, i32 1, i32 -1
  ret i32 %res
}
