; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -mattr=-neon -fp-contract=fast | FileCheck %s --check-prefix=Aarch64
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -mattr=+neon -fp-contract=fast | FileCheck %s --check-prefix=Aarch64-Neon

define float @f1(float %a, float %b, float %c) {
; Aarch64-LABEL: f1:
; Aarch64:       // %bb.0:
; Aarch64-NEXT:    fmadd s0, s1, s0, s2
; Aarch64-NEXT:    ret
;
; Aarch64-Neon-LABEL: f1:
; Aarch64-Neon:       // %bb.0:
; Aarch64-Neon-NEXT:    fmadd s0, s1, s0, s2
; Aarch64-Neon-NEXT:    ret
  %mul = fmul fast float %b, %a
  %add = fadd fast float %mul, %c
  ret float %add
}

define float @f2(float %a, float %b, float %c) {
; Aarch64-LABEL: f2:
; Aarch64:       // %bb.0:
; Aarch64-NEXT:    fmul s0, s1, s0
; Aarch64-NEXT:    //ARITH_FENCE
; Aarch64-NEXT:    fadd s0, s0, s2
; Aarch64-NEXT:    ret
;
; Aarch64-Neon-LABEL: f2:
; Aarch64-Neon:       // %bb.0:
; Aarch64-Neon-NEXT:    fmul s0, s1, s0
; Aarch64-Neon-NEXT:    //ARITH_FENCE
; Aarch64-Neon-NEXT:    fadd s0, s0, s2
; Aarch64-Neon-NEXT:    ret
  %mul = fmul fast float %b, %a
  %tmp = call float @llvm.arithmetic.fence.f32(float %mul)
  %add = fadd fast float %tmp, %c
  ret float %add
}

define double @f3(double %a) {
; Aarch64-LABEL: f3:
; Aarch64:       // %bb.0:
; Aarch64-NEXT:    fmov d1, #4.00000000
; Aarch64-NEXT:    fmul d0, d0, d1
; Aarch64-NEXT:    ret
;
; Aarch64-Neon-LABEL: f3:
; Aarch64-Neon:       // %bb.0:
; Aarch64-Neon-NEXT:    fmov d1, #4.00000000
; Aarch64-Neon-NEXT:    fmul d0, d0, d1
; Aarch64-Neon-NEXT:    ret
  %1 = fadd fast double %a, %a
  %2 = fadd fast double %a, %a
  %3 = fadd fast double %1, %2
  ret double %3
}

define double @f4(double %a) {
; Aarch64-LABEL: f4:
; Aarch64:       // %bb.0:
; Aarch64-NEXT:    fadd d0, d0, d0
; Aarch64-NEXT:    fmov d1, d0
; Aarch64-NEXT:    //ARITH_FENCE
; Aarch64-NEXT:    fadd d0, d1, d0
; Aarch64-NEXT:    ret
;
; Aarch64-Neon-LABEL: f4:
; Aarch64-Neon:       // %bb.0:
; Aarch64-Neon-NEXT:    fadd d0, d0, d0
; Aarch64-Neon-NEXT:    fmov d1, d0
; Aarch64-Neon-NEXT:    //ARITH_FENCE
; Aarch64-Neon-NEXT:    fadd d0, d1, d0
; Aarch64-Neon-NEXT:    ret
  %1 = fadd fast double %a, %a
  %t = call double @llvm.arithmetic.fence.f64(double %1)
  %2 = fadd fast double %a, %a
  %3 = fadd fast double %t, %2
  ret double %3
}

define <2 x float> @f5(<2 x float> %a) {
; Aarch64-LABEL: f5:
; Aarch64:       // %bb.0:
; Aarch64-NEXT:    fmov s2, #4.00000000
; Aarch64-NEXT:    fmul s0, s0, s2
; Aarch64-NEXT:    fmul s1, s1, s2
; Aarch64-NEXT:    ret
;
; Aarch64-Neon-LABEL: f5:
; Aarch64-Neon:       // %bb.0:
; Aarch64-Neon-NEXT:    fmov v1.2s, #4.00000000
; Aarch64-Neon-NEXT:    fmul v0.2s, v0.2s, v1.2s
; Aarch64-Neon-NEXT:    ret
  %1 = fadd fast <2 x float> %a, %a
  %2 = fadd fast <2 x float> %a, %a
  %3 = fadd fast <2 x float> %1, %2
  ret <2 x float> %3
}

define <2 x float> @f6(<2 x float> %a) {
; Aarch64-LABEL: f6:
; Aarch64:       // %bb.0:
; Aarch64-NEXT:    fadd s0, s0, s0
; Aarch64-NEXT:    fadd s1, s1, s1
; Aarch64-NEXT:    fmov s2, s1
; Aarch64-NEXT:    fmov s3, s0
; Aarch64-NEXT:    //ARITH_FENCE
; Aarch64-NEXT:    //ARITH_FENCE
; Aarch64-NEXT:    fadd s0, s3, s0
; Aarch64-NEXT:    fadd s1, s2, s1
; Aarch64-NEXT:    ret
;
; Aarch64-Neon-LABEL: f6:
; Aarch64-Neon:       // %bb.0:
; Aarch64-Neon-NEXT:    fadd v0.2s, v0.2s, v0.2s
; Aarch64-Neon-NEXT:    fmov d1, d0
; Aarch64-Neon-NEXT:    //ARITH_FENCE
; Aarch64-Neon-NEXT:    fadd v0.2s, v1.2s, v0.2s
; Aarch64-Neon-NEXT:    ret
  %1 = fadd fast <2 x float> %a, %a
  %t = call <2 x float> @llvm.arithmetic.fence.v2f32(<2 x float> %1)
  %2 = fadd fast <2 x float> %a, %a
  %3 = fadd fast <2 x float> %t, %2
  ret <2 x float> %3
}

declare float @llvm.arithmetic.fence.f32(float)
declare double @llvm.arithmetic.fence.f64(double)
declare <2 x float> @llvm.arithmetic.fence.v2f32(<2 x float>)
