; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "\b(sp)\b" --filter "^\s*(ld[^r]|st[^r]|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; The base test file was generated by ./llvm/test/CodeGen/AArch64/Atomics/generate-tests.py
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+v8a -O0 | FileCheck %s --check-prefixes=CHECK,-O0
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+v8a -O1 | FileCheck %s --check-prefixes=CHECK,-O1

define dso_local half @atomicrmw_fadd_half_aligned_monotonic(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fadd_half_aligned_monotonic:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fadd_half_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, half %value monotonic, align 2
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_aligned_acquire(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fadd_half_aligned_acquire:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fadd_half_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, half %value acquire, align 2
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_aligned_release(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fadd_half_aligned_release:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fadd_half_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, half %value release, align 2
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_aligned_acq_rel(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fadd_half_aligned_acq_rel:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fadd_half_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, half %value acq_rel, align 2
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_aligned_seq_cst(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fadd_half_aligned_seq_cst:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fadd_half_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, half %value seq_cst, align 2
    ret half %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_aligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_aligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fadd_bfloat_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fadd ptr %ptr, bfloat %value monotonic, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_aligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_aligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fadd_bfloat_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fadd ptr %ptr, bfloat %value acquire, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_aligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_aligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fadd_bfloat_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fadd ptr %ptr, bfloat %value release, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_aligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_aligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fadd_bfloat_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fadd ptr %ptr, bfloat %value acq_rel, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_aligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_aligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fadd_bfloat_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fadd ptr %ptr, bfloat %value seq_cst, align 2
    ret bfloat %r
}

define dso_local float @atomicrmw_fadd_float_aligned_monotonic(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fadd_float_aligned_monotonic:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fadd_float_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, float %value monotonic, align 4
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_aligned_acquire(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fadd_float_aligned_acquire:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fadd_float_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, float %value acquire, align 4
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_aligned_release(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fadd_float_aligned_release:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fadd_float_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, float %value release, align 4
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_aligned_acq_rel(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fadd_float_aligned_acq_rel:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fadd_float_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, float %value acq_rel, align 4
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_aligned_seq_cst(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fadd_float_aligned_seq_cst:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fadd_float_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fadd ptr %ptr, float %value seq_cst, align 4
    ret float %r
}

define dso_local double @atomicrmw_fadd_double_aligned_monotonic(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fadd_double_aligned_monotonic:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fadd_double_aligned_monotonic:
; -O1:    ldxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fadd ptr %ptr, double %value monotonic, align 8
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_aligned_acquire(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fadd_double_aligned_acquire:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fadd_double_aligned_acquire:
; -O1:    ldaxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fadd ptr %ptr, double %value acquire, align 8
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_aligned_release(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fadd_double_aligned_release:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fadd_double_aligned_release:
; -O1:    ldxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fadd ptr %ptr, double %value release, align 8
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_aligned_acq_rel(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fadd_double_aligned_acq_rel:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fadd_double_aligned_acq_rel:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fadd ptr %ptr, double %value acq_rel, align 8
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_aligned_seq_cst(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fadd_double_aligned_seq_cst:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fadd_double_aligned_seq_cst:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fadd ptr %ptr, double %value seq_cst, align 8
    ret double %r
}

define dso_local half @atomicrmw_fadd_half_unaligned_monotonic(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fadd_half_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, half %value monotonic, align 1
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_unaligned_acquire(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fadd_half_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, half %value acquire, align 1
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_unaligned_release(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fadd_half_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, half %value release, align 1
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_unaligned_acq_rel(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fadd_half_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, half %value acq_rel, align 1
    ret half %r
}

define dso_local half @atomicrmw_fadd_half_unaligned_seq_cst(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fadd_half_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, half %value seq_cst, align 1
    ret half %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_unaligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_unaligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fadd_bfloat_unaligned_monotonic:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, bfloat %value monotonic, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_unaligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_unaligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fadd_bfloat_unaligned_acquire:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, bfloat %value acquire, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_unaligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_unaligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fadd_bfloat_unaligned_release:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, bfloat %value release, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_unaligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_unaligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fadd_bfloat_unaligned_acq_rel:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, bfloat %value acq_rel, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fadd_bfloat_unaligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fadd_bfloat_unaligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fadd_bfloat_unaligned_seq_cst:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, bfloat %value seq_cst, align 1
    ret bfloat %r
}

define dso_local float @atomicrmw_fadd_float_unaligned_monotonic(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fadd_float_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, float %value monotonic, align 1
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_unaligned_acquire(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fadd_float_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, float %value acquire, align 1
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_unaligned_release(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fadd_float_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, float %value release, align 1
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_unaligned_acq_rel(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fadd_float_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, float %value acq_rel, align 1
    ret float %r
}

define dso_local float @atomicrmw_fadd_float_unaligned_seq_cst(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fadd_float_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, float %value seq_cst, align 1
    ret float %r
}

define dso_local double @atomicrmw_fadd_double_unaligned_monotonic(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fadd_double_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, double %value monotonic, align 1
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_unaligned_acquire(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fadd_double_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, double %value acquire, align 1
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_unaligned_release(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fadd_double_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, double %value release, align 1
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_unaligned_acq_rel(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fadd_double_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, double %value acq_rel, align 1
    ret double %r
}

define dso_local double @atomicrmw_fadd_double_unaligned_seq_cst(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fadd_double_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fadd ptr %ptr, double %value seq_cst, align 1
    ret double %r
}

define dso_local half @atomicrmw_fsub_half_aligned_monotonic(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fsub_half_aligned_monotonic:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fsub_half_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, half %value monotonic, align 2
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_aligned_acquire(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fsub_half_aligned_acquire:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fsub_half_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, half %value acquire, align 2
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_aligned_release(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fsub_half_aligned_release:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fsub_half_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, half %value release, align 2
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_aligned_acq_rel(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fsub_half_aligned_acq_rel:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fsub_half_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, half %value acq_rel, align 2
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_aligned_seq_cst(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fsub_half_aligned_seq_cst:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fsub_half_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, half %value seq_cst, align 2
    ret half %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_aligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_aligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fsub_bfloat_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fsub ptr %ptr, bfloat %value monotonic, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_aligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_aligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fsub_bfloat_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fsub ptr %ptr, bfloat %value acquire, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_aligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_aligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fsub_bfloat_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fsub ptr %ptr, bfloat %value release, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_aligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_aligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fsub_bfloat_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fsub ptr %ptr, bfloat %value acq_rel, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_aligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_aligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fsub_bfloat_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fsub ptr %ptr, bfloat %value seq_cst, align 2
    ret bfloat %r
}

define dso_local float @atomicrmw_fsub_float_aligned_monotonic(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fsub_float_aligned_monotonic:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fsub_float_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, float %value monotonic, align 4
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_aligned_acquire(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fsub_float_aligned_acquire:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fsub_float_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, float %value acquire, align 4
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_aligned_release(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fsub_float_aligned_release:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fsub_float_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, float %value release, align 4
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_aligned_acq_rel(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fsub_float_aligned_acq_rel:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fsub_float_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, float %value acq_rel, align 4
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_aligned_seq_cst(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fsub_float_aligned_seq_cst:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fsub_float_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fsub ptr %ptr, float %value seq_cst, align 4
    ret float %r
}

define dso_local double @atomicrmw_fsub_double_aligned_monotonic(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fsub_double_aligned_monotonic:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fsub_double_aligned_monotonic:
; -O1:    ldxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fsub ptr %ptr, double %value monotonic, align 8
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_aligned_acquire(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fsub_double_aligned_acquire:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fsub_double_aligned_acquire:
; -O1:    ldaxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fsub ptr %ptr, double %value acquire, align 8
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_aligned_release(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fsub_double_aligned_release:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fsub_double_aligned_release:
; -O1:    ldxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fsub ptr %ptr, double %value release, align 8
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_aligned_acq_rel(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fsub_double_aligned_acq_rel:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fsub_double_aligned_acq_rel:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fsub ptr %ptr, double %value acq_rel, align 8
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_aligned_seq_cst(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fsub_double_aligned_seq_cst:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fsub_double_aligned_seq_cst:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fsub ptr %ptr, double %value seq_cst, align 8
    ret double %r
}

define dso_local half @atomicrmw_fsub_half_unaligned_monotonic(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fsub_half_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, half %value monotonic, align 1
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_unaligned_acquire(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fsub_half_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, half %value acquire, align 1
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_unaligned_release(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fsub_half_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, half %value release, align 1
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_unaligned_acq_rel(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fsub_half_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, half %value acq_rel, align 1
    ret half %r
}

define dso_local half @atomicrmw_fsub_half_unaligned_seq_cst(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fsub_half_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, half %value seq_cst, align 1
    ret half %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_unaligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_unaligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fsub_bfloat_unaligned_monotonic:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, bfloat %value monotonic, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_unaligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_unaligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fsub_bfloat_unaligned_acquire:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, bfloat %value acquire, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_unaligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_unaligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fsub_bfloat_unaligned_release:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, bfloat %value release, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_unaligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_unaligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fsub_bfloat_unaligned_acq_rel:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, bfloat %value acq_rel, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fsub_bfloat_unaligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fsub_bfloat_unaligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fsub_bfloat_unaligned_seq_cst:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, bfloat %value seq_cst, align 1
    ret bfloat %r
}

define dso_local float @atomicrmw_fsub_float_unaligned_monotonic(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fsub_float_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, float %value monotonic, align 1
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_unaligned_acquire(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fsub_float_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, float %value acquire, align 1
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_unaligned_release(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fsub_float_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, float %value release, align 1
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_unaligned_acq_rel(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fsub_float_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, float %value acq_rel, align 1
    ret float %r
}

define dso_local float @atomicrmw_fsub_float_unaligned_seq_cst(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fsub_float_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, float %value seq_cst, align 1
    ret float %r
}

define dso_local double @atomicrmw_fsub_double_unaligned_monotonic(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fsub_double_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, double %value monotonic, align 1
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_unaligned_acquire(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fsub_double_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, double %value acquire, align 1
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_unaligned_release(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fsub_double_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, double %value release, align 1
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_unaligned_acq_rel(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fsub_double_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, double %value acq_rel, align 1
    ret double %r
}

define dso_local double @atomicrmw_fsub_double_unaligned_seq_cst(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fsub_double_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fsub ptr %ptr, double %value seq_cst, align 1
    ret double %r
}

define dso_local half @atomicrmw_fmax_half_aligned_monotonic(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmax_half_aligned_monotonic:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmax_half_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, half %value monotonic, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_aligned_acquire(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmax_half_aligned_acquire:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmax_half_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, half %value acquire, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_aligned_release(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmax_half_aligned_release:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmax_half_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, half %value release, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_aligned_acq_rel(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmax_half_aligned_acq_rel:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmax_half_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, half %value acq_rel, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_aligned_seq_cst(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmax_half_aligned_seq_cst:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmax_half_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, half %value seq_cst, align 2
    ret half %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_aligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_aligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmax_bfloat_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fmax ptr %ptr, bfloat %value monotonic, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_aligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_aligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmax_bfloat_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fmax ptr %ptr, bfloat %value acquire, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_aligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_aligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmax_bfloat_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmax ptr %ptr, bfloat %value release, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_aligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_aligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmax_bfloat_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmax ptr %ptr, bfloat %value acq_rel, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_aligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_aligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmax_bfloat_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmax ptr %ptr, bfloat %value seq_cst, align 2
    ret bfloat %r
}

define dso_local float @atomicrmw_fmax_float_aligned_monotonic(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmax_float_aligned_monotonic:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmax_float_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, float %value monotonic, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_aligned_acquire(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmax_float_aligned_acquire:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmax_float_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, float %value acquire, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_aligned_release(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmax_float_aligned_release:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmax_float_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, float %value release, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_aligned_acq_rel(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmax_float_aligned_acq_rel:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmax_float_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, float %value acq_rel, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_aligned_seq_cst(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmax_float_aligned_seq_cst:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmax_float_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmax ptr %ptr, float %value seq_cst, align 4
    ret float %r
}

define dso_local double @atomicrmw_fmax_double_aligned_monotonic(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmax_double_aligned_monotonic:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmax_double_aligned_monotonic:
; -O1:    ldxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fmax ptr %ptr, double %value monotonic, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_aligned_acquire(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmax_double_aligned_acquire:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmax_double_aligned_acquire:
; -O1:    ldaxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fmax ptr %ptr, double %value acquire, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_aligned_release(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmax_double_aligned_release:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmax_double_aligned_release:
; -O1:    ldxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmax ptr %ptr, double %value release, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_aligned_acq_rel(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmax_double_aligned_acq_rel:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmax_double_aligned_acq_rel:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmax ptr %ptr, double %value acq_rel, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_aligned_seq_cst(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmax_double_aligned_seq_cst:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmax_double_aligned_seq_cst:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmax ptr %ptr, double %value seq_cst, align 8
    ret double %r
}

define dso_local half @atomicrmw_fmax_half_unaligned_monotonic(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmax_half_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, half %value monotonic, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_unaligned_acquire(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmax_half_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, half %value acquire, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_unaligned_release(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmax_half_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, half %value release, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_unaligned_acq_rel(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmax_half_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, half %value acq_rel, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmax_half_unaligned_seq_cst(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmax_half_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, half %value seq_cst, align 1
    ret half %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_unaligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_unaligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmax_bfloat_unaligned_monotonic:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, bfloat %value monotonic, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_unaligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_unaligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmax_bfloat_unaligned_acquire:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, bfloat %value acquire, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_unaligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_unaligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmax_bfloat_unaligned_release:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, bfloat %value release, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_unaligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_unaligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmax_bfloat_unaligned_acq_rel:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, bfloat %value acq_rel, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmax_bfloat_unaligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmax_bfloat_unaligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmax_bfloat_unaligned_seq_cst:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, bfloat %value seq_cst, align 1
    ret bfloat %r
}

define dso_local float @atomicrmw_fmax_float_unaligned_monotonic(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmax_float_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, float %value monotonic, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_unaligned_acquire(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmax_float_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, float %value acquire, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_unaligned_release(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmax_float_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, float %value release, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_unaligned_acq_rel(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmax_float_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, float %value acq_rel, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmax_float_unaligned_seq_cst(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmax_float_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, float %value seq_cst, align 1
    ret float %r
}

define dso_local double @atomicrmw_fmax_double_unaligned_monotonic(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmax_double_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, double %value monotonic, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_unaligned_acquire(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmax_double_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, double %value acquire, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_unaligned_release(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmax_double_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, double %value release, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_unaligned_acq_rel(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmax_double_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, double %value acq_rel, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmax_double_unaligned_seq_cst(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmax_double_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmax ptr %ptr, double %value seq_cst, align 1
    ret double %r
}

define dso_local half @atomicrmw_fmin_half_aligned_monotonic(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmin_half_aligned_monotonic:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmin_half_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, half %value monotonic, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_aligned_acquire(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmin_half_aligned_acquire:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmin_half_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, half %value acquire, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_aligned_release(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmin_half_aligned_release:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmin_half_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, half %value release, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_aligned_acq_rel(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmin_half_aligned_acq_rel:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmin_half_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, half %value acq_rel, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_aligned_seq_cst(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmin_half_aligned_seq_cst:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmin_half_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, half %value seq_cst, align 2
    ret half %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_aligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_aligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmin_bfloat_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fmin ptr %ptr, bfloat %value monotonic, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_aligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_aligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmin_bfloat_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fmin ptr %ptr, bfloat %value acquire, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_aligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_aligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmin_bfloat_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmin ptr %ptr, bfloat %value release, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_aligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_aligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmin_bfloat_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmin ptr %ptr, bfloat %value acq_rel, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_aligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_aligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmin_bfloat_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmin ptr %ptr, bfloat %value seq_cst, align 2
    ret bfloat %r
}

define dso_local float @atomicrmw_fmin_float_aligned_monotonic(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmin_float_aligned_monotonic:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmin_float_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, float %value monotonic, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_aligned_acquire(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmin_float_aligned_acquire:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmin_float_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, float %value acquire, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_aligned_release(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmin_float_aligned_release:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmin_float_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, float %value release, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_aligned_acq_rel(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmin_float_aligned_acq_rel:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmin_float_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, float %value acq_rel, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_aligned_seq_cst(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmin_float_aligned_seq_cst:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmin_float_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmin ptr %ptr, float %value seq_cst, align 4
    ret float %r
}

define dso_local double @atomicrmw_fmin_double_aligned_monotonic(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmin_double_aligned_monotonic:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmin_double_aligned_monotonic:
; -O1:    ldxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fmin ptr %ptr, double %value monotonic, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_aligned_acquire(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmin_double_aligned_acquire:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmin_double_aligned_acquire:
; -O1:    ldaxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fmin ptr %ptr, double %value acquire, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_aligned_release(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmin_double_aligned_release:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmin_double_aligned_release:
; -O1:    ldxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmin ptr %ptr, double %value release, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_aligned_acq_rel(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmin_double_aligned_acq_rel:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmin_double_aligned_acq_rel:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmin ptr %ptr, double %value acq_rel, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_aligned_seq_cst(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmin_double_aligned_seq_cst:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmin_double_aligned_seq_cst:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmin ptr %ptr, double %value seq_cst, align 8
    ret double %r
}

define dso_local half @atomicrmw_fmin_half_unaligned_monotonic(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmin_half_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, half %value monotonic, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_unaligned_acquire(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmin_half_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, half %value acquire, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_unaligned_release(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmin_half_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, half %value release, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_unaligned_acq_rel(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmin_half_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, half %value acq_rel, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmin_half_unaligned_seq_cst(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmin_half_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, half %value seq_cst, align 1
    ret half %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_unaligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_unaligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmin_bfloat_unaligned_monotonic:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, bfloat %value monotonic, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_unaligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_unaligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmin_bfloat_unaligned_acquire:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, bfloat %value acquire, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_unaligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_unaligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmin_bfloat_unaligned_release:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, bfloat %value release, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_unaligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_unaligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmin_bfloat_unaligned_acq_rel:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, bfloat %value acq_rel, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmin_bfloat_unaligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmin_bfloat_unaligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmin_bfloat_unaligned_seq_cst:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, bfloat %value seq_cst, align 1
    ret bfloat %r
}

define dso_local float @atomicrmw_fmin_float_unaligned_monotonic(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmin_float_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, float %value monotonic, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_unaligned_acquire(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmin_float_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, float %value acquire, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_unaligned_release(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmin_float_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, float %value release, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_unaligned_acq_rel(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmin_float_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, float %value acq_rel, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmin_float_unaligned_seq_cst(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmin_float_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, float %value seq_cst, align 1
    ret float %r
}

define dso_local double @atomicrmw_fmin_double_unaligned_monotonic(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmin_double_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, double %value monotonic, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_unaligned_acquire(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmin_double_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, double %value acquire, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_unaligned_release(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmin_double_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, double %value release, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_unaligned_acq_rel(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmin_double_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, double %value acq_rel, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmin_double_unaligned_seq_cst(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmin_double_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmin ptr %ptr, double %value seq_cst, align 1
    ret double %r
}

define dso_local half @atomicrmw_fmaximum_half_aligned_monotonic(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmaximum_half_aligned_monotonic:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_half_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, half %value monotonic, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_aligned_acquire(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmaximum_half_aligned_acquire:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_half_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, half %value acquire, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_aligned_release(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmaximum_half_aligned_release:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_half_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, half %value release, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_aligned_acq_rel(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmaximum_half_aligned_acq_rel:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_half_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, half %value acq_rel, align 2
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_aligned_seq_cst(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fmaximum_half_aligned_seq_cst:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_half_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, half %value seq_cst, align 2
    ret half %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_aligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_aligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value monotonic, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_aligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_aligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value acquire, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_aligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_aligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value release, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_aligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_aligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value acq_rel, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_aligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_aligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value seq_cst, align 2
    ret bfloat %r
}

define dso_local float @atomicrmw_fmaximum_float_aligned_monotonic(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmaximum_float_aligned_monotonic:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmaximum_float_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, float %value monotonic, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_aligned_acquire(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmaximum_float_aligned_acquire:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmaximum_float_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, float %value acquire, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_aligned_release(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmaximum_float_aligned_release:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmaximum_float_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, float %value release, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_aligned_acq_rel(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmaximum_float_aligned_acq_rel:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmaximum_float_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, float %value acq_rel, align 4
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_aligned_seq_cst(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fmaximum_float_aligned_seq_cst:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fmaximum_float_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, float %value seq_cst, align 4
    ret float %r
}

define dso_local double @atomicrmw_fmaximum_double_aligned_monotonic(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmaximum_double_aligned_monotonic:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmaximum_double_aligned_monotonic:
; -O1:    ldxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, double %value monotonic, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_aligned_acquire(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmaximum_double_aligned_acquire:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmaximum_double_aligned_acquire:
; -O1:    ldaxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, double %value acquire, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_aligned_release(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmaximum_double_aligned_release:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmaximum_double_aligned_release:
; -O1:    ldxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, double %value release, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_aligned_acq_rel(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmaximum_double_aligned_acq_rel:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmaximum_double_aligned_acq_rel:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, double %value acq_rel, align 8
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_aligned_seq_cst(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fmaximum_double_aligned_seq_cst:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fmaximum_double_aligned_seq_cst:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fmaximum ptr %ptr, double %value seq_cst, align 8
    ret double %r
}

define dso_local half @atomicrmw_fmaximum_half_unaligned_monotonic(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmaximum_half_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, half %value monotonic, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_unaligned_acquire(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmaximum_half_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, half %value acquire, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_unaligned_release(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmaximum_half_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, half %value release, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_unaligned_acq_rel(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmaximum_half_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, half %value acq_rel, align 1
    ret half %r
}

define dso_local half @atomicrmw_fmaximum_half_unaligned_seq_cst(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fmaximum_half_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, half %value seq_cst, align 1
    ret half %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_unaligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_unaligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_unaligned_monotonic:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value monotonic, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_unaligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_unaligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_unaligned_acquire:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value acquire, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_unaligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_unaligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_unaligned_release:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value release, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_unaligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_unaligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_unaligned_acq_rel:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value acq_rel, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fmaximum_bfloat_unaligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fmaximum_bfloat_unaligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fmaximum_bfloat_unaligned_seq_cst:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, bfloat %value seq_cst, align 1
    ret bfloat %r
}

define dso_local float @atomicrmw_fmaximum_float_unaligned_monotonic(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmaximum_float_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, float %value monotonic, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_unaligned_acquire(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmaximum_float_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, float %value acquire, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_unaligned_release(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmaximum_float_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, float %value release, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_unaligned_acq_rel(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmaximum_float_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, float %value acq_rel, align 1
    ret float %r
}

define dso_local float @atomicrmw_fmaximum_float_unaligned_seq_cst(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fmaximum_float_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, float %value seq_cst, align 1
    ret float %r
}

define dso_local double @atomicrmw_fmaximum_double_unaligned_monotonic(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmaximum_double_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, double %value monotonic, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_unaligned_acquire(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmaximum_double_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, double %value acquire, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_unaligned_release(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmaximum_double_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, double %value release, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_unaligned_acq_rel(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmaximum_double_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, double %value acq_rel, align 1
    ret double %r
}

define dso_local double @atomicrmw_fmaximum_double_unaligned_seq_cst(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fmaximum_double_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fmaximum ptr %ptr, double %value seq_cst, align 1
    ret double %r
}

define dso_local half @atomicrmw_fminimum_half_aligned_monotonic(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fminimum_half_aligned_monotonic:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fminimum_half_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, half %value monotonic, align 2
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_aligned_acquire(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fminimum_half_aligned_acquire:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fminimum_half_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, half %value acquire, align 2
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_aligned_release(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fminimum_half_aligned_release:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fminimum_half_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, half %value release, align 2
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_aligned_acq_rel(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fminimum_half_aligned_acq_rel:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fminimum_half_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, half %value acq_rel, align 2
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_aligned_seq_cst(ptr %ptr, half %value) {
; -O0-LABEL: atomicrmw_fminimum_half_aligned_seq_cst:
; -O0:    ldaxrh w0, [x9]
; -O0:    cmp w0, w10, uxth
; -O0:    stlxrh w8, w11, [x9]
; -O0:    subs w8, w8, w0, uxth
;
; -O1-LABEL: atomicrmw_fminimum_half_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, half %value seq_cst, align 2
    ret half %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_aligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_aligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fminimum ptr %ptr, bfloat %value monotonic, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_aligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_aligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw fminimum ptr %ptr, bfloat %value acquire, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_aligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_aligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fminimum ptr %ptr, bfloat %value release, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_aligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_aligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fminimum ptr %ptr, bfloat %value acq_rel, align 2
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_aligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_aligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    ldaxrh w8, [x11]
; -O0:    cmp w8, w9, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w9, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    add w9, w9, w8
; -O1:    add w9, w10, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw fminimum ptr %ptr, bfloat %value seq_cst, align 2
    ret bfloat %r
}

define dso_local float @atomicrmw_fminimum_float_aligned_monotonic(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fminimum_float_aligned_monotonic:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fminimum_float_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, float %value monotonic, align 4
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_aligned_acquire(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fminimum_float_aligned_acquire:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fminimum_float_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    stxr w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, float %value acquire, align 4
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_aligned_release(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fminimum_float_aligned_release:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fminimum_float_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, float %value release, align 4
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_aligned_acq_rel(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fminimum_float_aligned_acq_rel:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fminimum_float_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, float %value acq_rel, align 4
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_aligned_seq_cst(ptr %ptr, float %value) {
; -O0-LABEL: atomicrmw_fminimum_float_aligned_seq_cst:
; -O0:    ldaxr w0, [x9]
; -O0:    cmp w0, w10
; -O0:    stlxr w8, w11, [x9]
; -O0:    subs w8, w0, w8
;
; -O1-LABEL: atomicrmw_fminimum_float_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    stlxr w9, w8, [x0]
    %r = atomicrmw fminimum ptr %ptr, float %value seq_cst, align 4
    ret float %r
}

define dso_local double @atomicrmw_fminimum_double_aligned_monotonic(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fminimum_double_aligned_monotonic:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fminimum_double_aligned_monotonic:
; -O1:    ldxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fminimum ptr %ptr, double %value monotonic, align 8
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_aligned_acquire(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fminimum_double_aligned_acquire:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fminimum_double_aligned_acquire:
; -O1:    ldaxr x8, [x0]
; -O1:    stxr w9, x8, [x0]
    %r = atomicrmw fminimum ptr %ptr, double %value acquire, align 8
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_aligned_release(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fminimum_double_aligned_release:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fminimum_double_aligned_release:
; -O1:    ldxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fminimum ptr %ptr, double %value release, align 8
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_aligned_acq_rel(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fminimum_double_aligned_acq_rel:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fminimum_double_aligned_acq_rel:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fminimum ptr %ptr, double %value acq_rel, align 8
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_aligned_seq_cst(ptr %ptr, double %value) {
; -O0-LABEL: atomicrmw_fminimum_double_aligned_seq_cst:
; -O0:    ldaxr x0, [x9]
; -O0:    cmp x0, x10
; -O0:    stlxr w8, x11, [x9]
; -O0:    subs x8, x0, x8
;
; -O1-LABEL: atomicrmw_fminimum_double_aligned_seq_cst:
; -O1:    ldaxr x8, [x0]
; -O1:    stlxr w9, x8, [x0]
    %r = atomicrmw fminimum ptr %ptr, double %value seq_cst, align 8
    ret double %r
}

define dso_local half @atomicrmw_fminimum_half_unaligned_monotonic(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fminimum_half_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, half %value monotonic, align 1
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_unaligned_acquire(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fminimum_half_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, half %value acquire, align 1
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_unaligned_release(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fminimum_half_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, half %value release, align 1
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_unaligned_acq_rel(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fminimum_half_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, half %value acq_rel, align 1
    ret half %r
}

define dso_local half @atomicrmw_fminimum_half_unaligned_seq_cst(ptr %ptr, half %value) {
; CHECK-LABEL: atomicrmw_fminimum_half_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, half %value seq_cst, align 1
    ret half %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_unaligned_monotonic(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_unaligned_monotonic:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_unaligned_monotonic:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, bfloat %value monotonic, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_unaligned_acquire(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_unaligned_acquire:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_unaligned_acquire:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, bfloat %value acquire, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_unaligned_release(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_unaligned_release:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_unaligned_release:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, bfloat %value release, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_unaligned_acq_rel(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_unaligned_acq_rel:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_unaligned_acq_rel:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, bfloat %value acq_rel, align 1
    ret bfloat %r
}

define dso_local bfloat @atomicrmw_fminimum_bfloat_unaligned_seq_cst(ptr %ptr, bfloat %value) {
; -O0-LABEL: atomicrmw_fminimum_bfloat_unaligned_seq_cst:
; -O0:    add w8, w8, w9
; -O0:    add w8, w8, w9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_fminimum_bfloat_unaligned_seq_cst:
; -O1:    add w8, w8, w20
; -O1:    add w8, w9, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, bfloat %value seq_cst, align 1
    ret bfloat %r
}

define dso_local float @atomicrmw_fminimum_float_unaligned_monotonic(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fminimum_float_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, float %value monotonic, align 1
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_unaligned_acquire(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fminimum_float_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, float %value acquire, align 1
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_unaligned_release(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fminimum_float_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, float %value release, align 1
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_unaligned_acq_rel(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fminimum_float_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, float %value acq_rel, align 1
    ret float %r
}

define dso_local float @atomicrmw_fminimum_float_unaligned_seq_cst(ptr %ptr, float %value) {
; CHECK-LABEL: atomicrmw_fminimum_float_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, float %value seq_cst, align 1
    ret float %r
}

define dso_local double @atomicrmw_fminimum_double_unaligned_monotonic(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fminimum_double_unaligned_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, double %value monotonic, align 1
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_unaligned_acquire(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fminimum_double_unaligned_acquire:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, double %value acquire, align 1
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_unaligned_release(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fminimum_double_unaligned_release:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, double %value release, align 1
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_unaligned_acq_rel(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fminimum_double_unaligned_acq_rel:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, double %value acq_rel, align 1
    ret double %r
}

define dso_local double @atomicrmw_fminimum_double_unaligned_seq_cst(ptr %ptr, double %value) {
; CHECK-LABEL: atomicrmw_fminimum_double_unaligned_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %r = atomicrmw fminimum ptr %ptr, double %value seq_cst, align 1
    ret double %r
}
