; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare { float, i32 } @llvm.frexp.f32.i32(float)
declare void @use(float)

; Basic test case - constant in true position
define float @test_select_frexp_basic(float %x, i1 %cond) {
; CHECK-LABEL: define float @test_select_frexp_basic(
; CHECK-SAME: float [[X:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[X]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { float, i32 } [[FREXP]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select i1 [[COND]], float 5.000000e-01, float [[FREXP_0]]
; CHECK-NEXT:    ret float [[SELECT_FREXP]]
;
  %sel = select i1 %cond, float 1.000000e+00, float %x
  %frexp = call { float, i32 } @llvm.frexp.f32.i32(float %sel)
  %frexp.0 = extractvalue { float, i32 } %frexp, 0
  ret float %frexp.0
}

; Test with constant in false position
define float @test_select_frexp_const_false(float %x, i1 %cond) {
; CHECK-LABEL: define float @test_select_frexp_const_false(
; CHECK-SAME: float [[X:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[X]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { float, i32 } [[FREXP]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select i1 [[COND]], float [[FREXP_0]], float 5.000000e-01
; CHECK-NEXT:    ret float [[SELECT_FREXP]]
;
  %sel = select i1 %cond, float %x, float 1.000000e+00
  %frexp = call { float, i32 } @llvm.frexp.f32.i32(float %sel)
  %frexp.0 = extractvalue { float, i32 } %frexp, 0
  ret float %frexp.0
}

; Multi-use test
define float @test_select_frexp_multi_use(float %x, i1 %cond) {
; CHECK-LABEL: define float @test_select_frexp_multi_use(
; CHECK-SAME: float [[X:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], float 1.000000e+00, float [[X]]
; CHECK-NEXT:    call void @use(float [[SEL]])
; CHECK-NEXT:    [[FREXP:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[SEL]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { float, i32 } [[FREXP]], 0
; CHECK-NEXT:    ret float [[FREXP_0]]
;
  %sel = select i1 %cond, float 1.000000e+00, float %x
  call void @use(float %sel)
  %frexp = call { float, i32 } @llvm.frexp.f32.i32(float %sel)
  %frexp.0 = extractvalue { float, i32 } %frexp, 0
  ret float %frexp.0
}

; Vector test - splat constant
define <2 x float> @test_select_frexp_vec_splat(<2 x float> %x, <2 x i1> %cond) {
; CHECK-LABEL: define <2 x float> @test_select_frexp_vec_splat(
; CHECK-SAME: <2 x float> [[X:%.*]], <2 x i1> [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP:%.*]] = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> [[X]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { <2 x float>, <2 x i32> } [[FREXP]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select <2 x i1> [[COND]], <2 x float> splat (float 5.000000e-01), <2 x float> [[FREXP_0]]
; CHECK-NEXT:    ret <2 x float> [[SELECT_FREXP]]
;
  %sel = select <2 x i1> %cond, <2 x float> <float 1.000000e+00, float 1.000000e+00>, <2 x float> %x
  %frexp = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %sel)
  %frexp.0 = extractvalue { <2 x float>, <2 x i32> } %frexp, 0
  ret <2 x float> %frexp.0
}

; Vector test with poison
define <2 x float> @test_select_frexp_vec_poison(<2 x float> %x, <2 x i1> %cond) {
; CHECK-LABEL: define <2 x float> @test_select_frexp_vec_poison(
; CHECK-SAME: <2 x float> [[X:%.*]], <2 x i1> [[COND:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[COND]], <2 x float> <float 1.000000e+00, float poison>, <2 x float> [[X]]
; CHECK-NEXT:    [[FREXP:%.*]] = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> [[SEL]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { <2 x float>, <2 x i32> } [[FREXP]], 0
; CHECK-NEXT:    ret <2 x float> [[FREXP_0]]
;
  %sel = select <2 x i1> %cond, <2 x float> <float 1.000000e+00, float poison>, <2 x float> %x
  %frexp = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %sel)
  %frexp.0 = extractvalue { <2 x float>, <2 x i32> } %frexp, 0
  ret <2 x float> %frexp.0
}

; Vector test - non-splat (should not fold)
define <2 x float> @test_select_frexp_vec_nonsplat(<2 x float> %x, <2 x i1> %cond) {
; CHECK-LABEL: define <2 x float> @test_select_frexp_vec_nonsplat(
; CHECK-SAME: <2 x float> [[X:%.*]], <2 x i1> [[COND:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select <2 x i1> [[COND]], <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x float> [[X]]
; CHECK-NEXT:    [[FREXP:%.*]] = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> [[SEL]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { <2 x float>, <2 x i32> } [[FREXP]], 0
; CHECK-NEXT:    ret <2 x float> [[FREXP_0]]
;
  %sel = select <2 x i1> %cond, <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x float> %x
  %frexp = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %sel)
  %frexp.0 = extractvalue { <2 x float>, <2 x i32> } %frexp, 0
  ret <2 x float> %frexp.0
}

; Negative test - both operands non-constant
define float @test_select_frexp_no_const(float %x, float %y, i1 %cond) {
; CHECK-LABEL: define float @test_select_frexp_no_const(
; CHECK-SAME: float [[X:%.*]], float [[Y:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], float [[X]], float [[Y]]
; CHECK-NEXT:    [[FREXP:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[SEL]])
; CHECK-NEXT:    [[FREXP_0:%.*]] = extractvalue { float, i32 } [[FREXP]], 0
; CHECK-NEXT:    ret float [[FREXP_0]]
;
  %sel = select i1 %cond, float %x, float %y
  %frexp = call { float, i32 } @llvm.frexp.f32.i32(float %sel)
  %frexp.0 = extractvalue { float, i32 } %frexp, 0
  ret float %frexp.0
}

; Negative test - extracting exp instead of mantissa
define i32 @test_select_frexp_extract_exp(float %x, i1 %cond) {
; CHECK-LABEL: define i32 @test_select_frexp_extract_exp(
; CHECK-SAME: float [[X:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], float 1.000000e+00, float [[X]]
; CHECK-NEXT:    [[FREXP:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[SEL]])
; CHECK-NEXT:    [[FREXP_1:%.*]] = extractvalue { float, i32 } [[FREXP]], 1
; CHECK-NEXT:    ret i32 [[FREXP_1]]
;
  %sel = select i1 %cond, float 1.000000e+00, float %x
  %frexp = call { float, i32 } @llvm.frexp.f32.i32(float %sel)
  %frexp.1 = extractvalue { float, i32 } %frexp, 1
  ret i32 %frexp.1
}

; Test with fast math flags
define float @test_select_frexp_fast_math_select(float %x, i1 %cond) {
; CHECK-LABEL: define float @test_select_frexp_fast_math_select(
; CHECK-SAME: float [[X:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP1:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[X]])
; CHECK-NEXT:    [[MANTISSA:%.*]] = extractvalue { float, i32 } [[FREXP1]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select nnan ninf nsz i1 [[COND]], float 5.000000e-01, float [[MANTISSA]]
; CHECK-NEXT:    ret float [[SELECT_FREXP]]
;
  %sel = select nnan ninf nsz i1 %cond, float 1.000000e+00, float %x
  %frexp = call { float, i32 } @llvm.frexp.f32.i32(float %sel)
  %frexp.0 = extractvalue { float, i32 } %frexp, 0
  ret float %frexp.0
}


; Test vector case with fast math flags
define <2 x float> @test_select_frexp_vec_fast_math(<2 x float> %x, <2 x i1> %cond) {
; CHECK-LABEL: define <2 x float> @test_select_frexp_vec_fast_math(
; CHECK-SAME: <2 x float> [[X:%.*]], <2 x i1> [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP1:%.*]] = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> [[X]])
; CHECK-NEXT:    [[MANTISSA:%.*]] = extractvalue { <2 x float>, <2 x i32> } [[FREXP1]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select nnan ninf nsz <2 x i1> [[COND]], <2 x float> splat (float 5.000000e-01), <2 x float> [[MANTISSA]]
; CHECK-NEXT:    ret <2 x float> [[SELECT_FREXP]]
;
  %sel = select nnan ninf nsz <2 x i1> %cond, <2 x float> <float 1.000000e+00, float 1.000000e+00>, <2 x float> %x
  %frexp = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %sel)
  %frexp.0 = extractvalue { <2 x float>, <2 x i32> } %frexp, 0
  ret <2 x float> %frexp.0
}

; Test with scalable vectors with constant at True Position
define <vscale x 2 x float> @test_select_frexp_scalable_vec0(<vscale x 2 x float> %x, <vscale x 2 x i1> %cond) {
; CHECK-LABEL: define <vscale x 2 x float> @test_select_frexp_scalable_vec0(
; CHECK-SAME: <vscale x 2 x float> [[X:%.*]], <vscale x 2 x i1> [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP1:%.*]] = call { <vscale x 2 x float>, <vscale x 2 x i32> } @llvm.frexp.nxv2f32.nxv2i32(<vscale x 2 x float> [[X]])
; CHECK-NEXT:    [[MANTISSA:%.*]] = extractvalue { <vscale x 2 x float>, <vscale x 2 x i32> } [[FREXP1]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select <vscale x 2 x i1> [[COND]], <vscale x 2 x float> splat (float 5.000000e-01), <vscale x 2 x float> [[MANTISSA]]
; CHECK-NEXT:    ret <vscale x 2 x float> [[SELECT_FREXP]]
;
  %sel = select <vscale x 2 x i1> %cond, <vscale x 2 x float> splat (float 1.000000e+00), <vscale x 2 x float> %x
  %frexp = call { <vscale x 2 x float>, <vscale x 2 x i32> } @llvm.frexp.nxv2f32.nxv2i32(<vscale x 2 x float> %sel)
  %frexp.0 = extractvalue { <vscale x 2 x float>, <vscale x 2 x i32> } %frexp, 0
  ret <vscale x 2 x float> %frexp.0
}

; Test with scalable vectors with constant at False Position
define <vscale x 2 x float> @test_select_frexp_scalable_vec1(<vscale x 2 x float> %x, <vscale x 2 x i1> %cond) {
; CHECK-LABEL: define <vscale x 2 x float> @test_select_frexp_scalable_vec1(
; CHECK-SAME: <vscale x 2 x float> [[X:%.*]], <vscale x 2 x i1> [[COND:%.*]]) {
; CHECK-NEXT:    [[FREXP1:%.*]] = call { <vscale x 2 x float>, <vscale x 2 x i32> } @llvm.frexp.nxv2f32.nxv2i32(<vscale x 2 x float> [[X]])
; CHECK-NEXT:    [[MANTISSA:%.*]] = extractvalue { <vscale x 2 x float>, <vscale x 2 x i32> } [[FREXP1]], 0
; CHECK-NEXT:    [[SELECT_FREXP:%.*]] = select <vscale x 2 x i1> [[COND]], <vscale x 2 x float> [[MANTISSA]], <vscale x 2 x float> splat (float 5.000000e-01)
; CHECK-NEXT:    ret <vscale x 2 x float> [[SELECT_FREXP]]
;
  %sel = select <vscale x 2 x i1> %cond, <vscale x 2 x float> %x, <vscale x 2 x float> splat (float 1.000000e+00)
  %frexp = call { <vscale x 2 x float>, <vscale x 2 x i32> } @llvm.frexp.nxv2f32.nxv2i32(<vscale x 2 x float> %sel)
  %frexp.0 = extractvalue { <vscale x 2 x float>, <vscale x 2 x i32> } %frexp, 0
  ret <vscale x 2 x float> %frexp.0
}

declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>)
declare { <vscale x 2 x float>, <vscale x 2 x i32> } @llvm.frexp.nxv2f32.nxv2i32(<vscale x 2 x float>)
