; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @llvm.memcpy.p0.p0.i32(ptr nocapture, ptr nocapture, i32, i1) nounwind
declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind

; Same src/dest.

define void @test1(ptr %a) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %a, i32 100, i1 false)
  ret void
}

; PR8267 - same src/dest, but volatile.

define void @test2(ptr %a) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i32(ptr [[A:%.*]], ptr [[A]], i32 100, i1 true)
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %a, i32 100, i1 true)
  ret void
}

; 17179869184 == 0x400000000 - make sure that doesn't get truncated to 32-bit.

define void @test3(ptr %d, ptr %s) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 4 dereferenceable(17179869184) [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(17179869184) [[S:%.*]], i64 17179869184, i1 false)
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memcpy.p0.p0.i64(ptr align 4 %d, ptr align 4 %s, i64 17179869184, i1 false)
  ret void
}

@UnknownConstant = external constant i128

define void @memcpy_to_constant(ptr %src) {
; CHECK-LABEL: @memcpy_to_constant(
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i32(ptr @UnknownConstant, ptr %src, i32 16, i1 false)
  ret void
}
