; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p indvars -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"

declare void @use(ptr)
declare void @use.i64(i64)

define i64 @test_simplifycompare_rhs_constant(i64 %num_bytes, ptr %src) {
; CHECK-LABEL: define i64 @test_simplifycompare_rhs_constant(
; CHECK-SAME: i64 [[NUM_BYTES:%.*]], ptr [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[CMP_NOT_I:%.*]] = icmp ne i64 [[NUM_BYTES]], 0
; CHECK-NEXT:    [[COND_I:%.*]] = zext i1 [[CMP_NOT_I]] to i64
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 1, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[C_0:%.*]] = icmp ule i64 [[IV]], [[COND_I]]
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[GEP_SRC:%.*]] = getelementptr i32, ptr [[SRC]], i64 [[IV]]
; CHECK-NEXT:    [[L:%.*]] = load i32, ptr [[GEP_SRC]], align 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i32 [[L]], 0
; CHECK-NEXT:    br i1 [[C_1]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[THEN]]:
; CHECK-NEXT:    call void @use(ptr [[SRC]])
; CHECK-NEXT:    br label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    br label %[[LOOP]]
;
entry:
  %cmp.not.i = icmp ne i64 %num_bytes, 0
  %cond.i = zext i1 %cmp.not.i to i64
  br label %loop

loop:
  %iv = phi i64 [ 1, %entry ], [ %iv.next, %loop.latch ]
  %c.0 = icmp ule i64 %iv, %cond.i
  tail call void @llvm.assume(i1 %c.0)
  %gep.src = getelementptr i32, ptr %src, i64 %iv
  %l = load i32, ptr %gep.src, align 4
  %c.1 = icmp eq i32 %l, 0
  br i1 %c.1, label %then, label %loop.latch

then:
  call void @use(ptr %src)
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  br label %loop
}

define void @test_simplifycompare_rhs_not_constant1() {
; CHECK-LABEL: define void @test_simplifycompare_rhs_not_constant1() {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[P:%.*]] = alloca i64, align 8
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    call void @use(ptr [[P]])
; CHECK-NEXT:    br i1 true, label %[[EXIT:.*]], label %[[LOOP]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  %p = alloca i64, align 8
  br label %loop

loop:
  %ptr.iv = phi ptr [ %p, %entry ], [ %ptr.iv.next, %loop ]
  %ptr.iv.next = getelementptr i8, ptr %ptr.iv, i64 -8
  call void @use(ptr %ptr.iv)
  %ec = icmp ult ptr %ptr.iv.next, %p
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_simplifycompare_rhs_not_constant2(i32 %x) {
; CHECK-LABEL: define void @test_simplifycompare_rhs_not_constant2(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[OUTER_HEADER:.*]]
; CHECK:       [[OUTER_HEADER_LOOPEXIT:.*]]:
; CHECK-NEXT:    [[INDVARS_IV_NEXT:%.*]] = add nuw i64 [[INDVARS_IV:%.*]], 2
; CHECK-NEXT:    br label %[[OUTER_HEADER]]
; CHECK:       [[OUTER_HEADER]]:
; CHECK-NEXT:    [[INDVARS_IV]] = phi i64 [ [[INDVARS_IV_NEXT]], %[[OUTER_HEADER_LOOPEXIT]] ], [ 0, %[[ENTRY]] ]
; CHECK-NEXT:    [[IV_1:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[IV_1_NEXT:%.*]], %[[OUTER_HEADER_LOOPEXIT]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sgt i32 [[X]], 0
; CHECK-NEXT:    br i1 [[C_1]], label %[[EXIT_LOOP_PREHEADER:.*]], label %[[OUTER_LATCH_PREHEADER:.*]]
; CHECK:       [[EXIT_LOOP_PREHEADER]]:
; CHECK-NEXT:    [[INDVARS_IV_LCSSA:%.*]] = phi i64 [ [[INDVARS_IV]], %[[OUTER_HEADER]] ]
; CHECK-NEXT:    br label %[[EXIT_LOOP:.*]]
; CHECK:       [[OUTER_LATCH_PREHEADER]]:
; CHECK-NEXT:    [[IV_1_NEXT]] = add nuw nsw i32 [[IV_1]], 2
; CHECK-NEXT:    br label %[[OUTER_LATCH:.*]]
; CHECK:       [[OUTER_LATCH]]:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, %[[OUTER_LATCH_PREHEADER]] ], [ [[X]], %[[OUTER_LATCH]] ]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult i32 [[P]], [[IV_1_NEXT]]
; CHECK-NEXT:    br i1 [[C_2]], label %[[OUTER_LATCH]], label %[[OUTER_HEADER_LOOPEXIT]]
; CHECK:       [[EXIT_LOOP]]:
; CHECK-NEXT:    [[INDVARS_IV1:%.*]] = phi i64 [ [[INDVARS_IV_LCSSA]], %[[EXIT_LOOP_PREHEADER]] ], [ [[INDVARS_IV_NEXT2:%.*]], %[[EXIT_LOOP]] ]
; CHECK-NEXT:    call void @use.i64(i64 [[INDVARS_IV1]])
; CHECK-NEXT:    [[INDVARS_IV_NEXT2]] = add nuw nsw i64 [[INDVARS_IV1]], 1
; CHECK-NEXT:    br label %[[EXIT_LOOP]]
;
entry:
  br label %outer.header

outer.header:
  %iv.1 = phi i32 [ 0, %entry ], [ %iv.1.next, %outer.latch ]
  %c.1 = icmp sgt i32 %x, 0
  br i1 %c.1, label %exit.loop, label %outer.latch.preheader

outer.latch.preheader:
  %iv.1.next = add nsw i32 %iv.1, 2
  br label %outer.latch

outer.latch:
  %p = phi i32 [ 0, %outer.latch.preheader ], [ %x, %outer.latch ]
  %c.2 = icmp ult i32 %p, %iv.1.next
  br i1 %c.2, label %outer.latch, label %outer.header

exit.loop:
  %iv.2 = phi i32 [ %iv.1, %outer.header ], [ %iv.2.next, %exit.loop ]
  %iv.2.ext = zext i32 %iv.2 to i64
  call void @use.i64(i64 %iv.2.ext)
  %iv.2.next = add nsw i32 %iv.2, 1
  br label %exit.loop
}

define void @test_simplifycompare_rhs_addrec(i32 %x) {
; CHECK-LABEL: define void @test_simplifycompare_rhs_addrec(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[OUTER_HEADER:.*]]
; CHECK:       [[OUTER_HEADER_LOOPEXIT:.*]]:
; CHECK-NEXT:    [[INDVARS_IV_NEXT:%.*]] = add nuw nsw i64 [[INDVARS_IV:%.*]], 2
; CHECK-NEXT:    br label %[[OUTER_HEADER]]
; CHECK:       [[OUTER_HEADER]]:
; CHECK-NEXT:    [[INDVARS_IV]] = phi i64 [ [[INDVARS_IV_NEXT]], %[[OUTER_HEADER_LOOPEXIT]] ], [ 0, %[[ENTRY]] ]
; CHECK-NEXT:    [[IV_1:%.*]] = phi i32 [ 2, %[[ENTRY]] ], [ [[IV_1_NEXT:%.*]], %[[OUTER_HEADER_LOOPEXIT]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sgt i32 [[X]], 0
; CHECK-NEXT:    br i1 [[C_1]], label %[[OUTER_EXIT:.*]], label %[[OUTER_LATCH_PREHEADER:.*]]
; CHECK:       [[OUTER_LATCH_PREHEADER]]:
; CHECK-NEXT:    [[IV_1_NEXT]] = add nuw nsw i32 [[IV_1]], 2
; CHECK-NEXT:    br label %[[OUTER_LATCH:.*]]
; CHECK:       [[OUTER_LATCH]]:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[X]], %[[OUTER_LATCH]] ], [ 0, %[[OUTER_LATCH_PREHEADER]] ]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult i32 [[P]], [[IV_1_NEXT]]
; CHECK-NEXT:    br i1 [[C_2]], label %[[OUTER_LATCH]], label %[[OUTER_HEADER_LOOPEXIT]]
; CHECK:       [[OUTER_EXIT]]:
; CHECK-NEXT:    [[INDVARS_IV_LCSSA:%.*]] = phi i64 [ [[INDVARS_IV]], %[[OUTER_HEADER]] ]
; CHECK-NEXT:    br label %[[EXIT_LOOP:.*]]
; CHECK:       [[EXIT_LOOP]]:
; CHECK-NEXT:    [[INDVARS_IV1:%.*]] = phi i64 [ [[INDVARS_IV_NEXT2:%.*]], %[[EXIT_LOOP]] ], [ [[INDVARS_IV_LCSSA]], %[[OUTER_EXIT]] ]
; CHECK-NEXT:    call void @use.i64(i64 [[INDVARS_IV1]])
; CHECK-NEXT:    [[INDVARS_IV_NEXT2]] = add nuw nsw i64 [[INDVARS_IV1]], 1
; CHECK-NEXT:    br label %[[EXIT_LOOP]]
;
entry:
  br label %outer.header

outer.header:
  %iv.1 = phi i32 [ 2, %entry ], [ %iv.1.next, %outer.latch ]
  %c.1 = icmp sgt i32 %x, 0
  br i1 %c.1, label %outer.exit, label %outer.latch.preheader

outer.latch.preheader:
  %iv.1.next = add nuw nsw i32 %iv.1, 2
  br label %outer.latch

outer.latch:
  %p = phi i32 [ %x, %outer.latch ], [ 0, %outer.latch.preheader ]
  %c.2 = icmp ult i32 %p, %iv.1.next
  br i1 %c.2, label %outer.latch, label %outer.header

outer.exit:
  %sub = add nsw i32 %iv.1, -2
  br label %exit.loop

exit.loop:
  %iv.2 = phi i32 [ %sub, %outer.exit ], [ %iv.2.next, %exit.loop ]
  %iv.2.ext = sext i32 %iv.2 to i64
  call void @use.i64(i64 %iv.2.ext)
  %iv.2.next = add nsw i32 %iv.2, 1
  br label %exit.loop
}
