; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X64

declare <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double>, <4 x i64>, <4 x double>) #1

define <4 x double> @concat_vpermv3_ops_vpermv_v4f64(ptr %p0, <4 x i64> %m) {
; X86-LABEL: concat_vpermv3_ops_vpermv_v4f64:
; X86:       # %bb.0:
; X86-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpermpd (%eax), %zmm0, %zmm0
; X86-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-NEXT:    retl
;
; X64-LABEL: concat_vpermv3_ops_vpermv_v4f64:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X64-NEXT:    vpermpd (%rdi), %zmm0, %zmm0
; X64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X64-NEXT:    retq
  %p1 = getelementptr inbounds nuw i8, ptr %p0, i64 32
  %lo = load <4 x double>, ptr %p0, align 32
  %hi = load <4 x double>, ptr %p1, align 32
  %res = tail call noundef <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %lo, <4 x i64> %m, <4 x double> %hi)
  ret <4 x double> %res
}

define <4 x double> @concat_vpermv3_ops_vpermv_swap_v4f64(ptr %p0, <4 x i64> %m) {
; X86-LABEL: concat_vpermv3_ops_vpermv_swap_v4f64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovapd 32(%eax), %ymm1
; X86-NEXT:    vpermi2pd (%eax), %ymm1, %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: concat_vpermv3_ops_vpermv_swap_v4f64:
; X64:       # %bb.0:
; X64-NEXT:    vmovapd 32(%rdi), %ymm1
; X64-NEXT:    vpermi2pd (%rdi), %ymm1, %ymm0
; X64-NEXT:    retq
  %p1 = getelementptr inbounds nuw i8, ptr %p0, i64 32
  %lo = load <4 x double>, ptr %p1, align 32
  %hi = load <4 x double>, ptr %p0, align 32
  %res = tail call noundef <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %lo, <4 x i64> %m, <4 x double> %hi)
  ret <4 x double> %res
}

define void @PR142995(ptr %p0, ptr %p1, ptr %p2) nounwind #0 {
; X86-LABEL: PR142995:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movb $17, %bl
; X86-NEXT:    kmovw %ebx, %k1
; X86-NEXT:    vmovdqu32 (%edx), %ymm0 {%k1} {z}
; X86-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    movw $6144, %dx # imm = 0x1800
; X86-NEXT:    kmovw %edx, %k1
; X86-NEXT:    vmovdqu32 128(%ecx), %zmm2 {%k1} {z}
; X86-NEXT:    movw $1031, %dx # imm = 0x407
; X86-NEXT:    kmovw %edx, %k1
; X86-NEXT:    vmovdqu32 (%ecx), %zmm3 {%k1} {z}
; X86-NEXT:    vpbroadcastd 252(%ecx), %zmm4
; X86-NEXT:    vpbroadcastd %xmm1, %xmm5
; X86-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm5[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero
; X86-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; X86-NEXT:    vpunpckldq {{.*#+}} zmm2 = zmm4[0],zmm2[0],zmm4[1],zmm2[1],zmm4[4],zmm2[4],zmm4[5],zmm2[5],zmm4[8],zmm2[8],zmm4[9],zmm2[9],zmm4[12],zmm2[12],zmm4[13],zmm2[13]
; X86-NEXT:    vextracti32x4 $3, %zmm2, %xmm2
; X86-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; X86-NEXT:    vpaddd %xmm1, %xmm5, %xmm1
; X86-NEXT:    vmovdqu %xmm1, (%eax)
; X86-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [4,0,10,0,4,4,14,0]
; X86-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X86-NEXT:    vpermi2d %ymm2, %ymm0, %ymm1
; X86-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm4[1],ymm1[2,3,4,5,6,7]
; X86-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3],ymm0[4,5,6,7]
; X86-NEXT:    vmovdqu %ymm0, (%eax)
; X86-NEXT:    popl %ebx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: PR142995:
; X64:       # %bb.0:
; X64-NEXT:    movb $17, %al
; X64-NEXT:    kmovw %eax, %k1
; X64-NEXT:    vmovdqu32 (%rdi), %ymm0 {%k1} {z}
; X64-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    movw $6144, %ax # imm = 0x1800
; X64-NEXT:    kmovw %eax, %k1
; X64-NEXT:    vmovdqu32 128(%rsi), %zmm2 {%k1} {z}
; X64-NEXT:    movw $1031, %ax # imm = 0x407
; X64-NEXT:    kmovw %eax, %k1
; X64-NEXT:    vmovdqu32 (%rsi), %zmm3 {%k1} {z}
; X64-NEXT:    vpbroadcastd 252(%rsi), %zmm4
; X64-NEXT:    vpbroadcastd %xmm1, %xmm5
; X64-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm5[4,5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero
; X64-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; X64-NEXT:    vpunpckldq {{.*#+}} zmm2 = zmm4[0],zmm2[0],zmm4[1],zmm2[1],zmm4[4],zmm2[4],zmm4[5],zmm2[5],zmm4[8],zmm2[8],zmm4[9],zmm2[9],zmm4[12],zmm2[12],zmm4[13],zmm2[13]
; X64-NEXT:    vextracti32x4 $3, %zmm2, %xmm2
; X64-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; X64-NEXT:    vpaddd %xmm1, %xmm5, %xmm1
; X64-NEXT:    vmovdqu %xmm1, (%rax)
; X64-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [4,0,10,0,4,4,14,0]
; X64-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; X64-NEXT:    vpermi2d %ymm2, %ymm0, %ymm1
; X64-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm4[1],ymm1[2,3,4,5,6,7]
; X64-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3],ymm0[4,5,6,7]
; X64-NEXT:    vmovdqu %ymm0, (%rdx)
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
  %i = tail call <5 x i32> @llvm.masked.load.v5i32.p0(ptr %p0, i32 4, <5 x i1> <i1 true, i1 false, i1 false, i1 false, i1 true>, <5 x i32> poison)
  %i1 = load <2 x i32>, ptr poison, align 4
  %i2 = tail call <64 x i32> @llvm.masked.load.v64i32.p0(ptr %p1, i32 4, <64 x i1> <i1 true, i1 true, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true>, <64 x i32> poison)
  %i3 = shufflevector <2 x i32> %i1, <2 x i32> poison, <4 x i32> <i32 0, i32 poison, i32 poison, i32 poison>
  %i4 = shufflevector <4 x i32> zeroinitializer, <4 x i32> %i3, <4 x i32> <i32 poison, i32 poison, i32 4, i32 3>
  %i5 = shufflevector <4 x i32> poison, <4 x i32> %i4, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %i6 = add <4 x i32> zeroinitializer, %i5
  %i7 = shufflevector <2 x i32> %i1, <2 x i32> poison, <64 x i32> <i32 poison, i32 1, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
  %i8 = shufflevector <64 x i32> %i2, <64 x i32> %i7, <4 x i32> <i32 63, i32 44, i32 1, i32 65>
  %i9 = add <4 x i32> %i6, %i8
  %i10 = add <4 x i32> %i9, zeroinitializer
  store <4 x i32> %i10, ptr poison, align 4
  %i11 = shufflevector <5 x i32> %i, <5 x i32> poison, <6 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 4, i32 poison>
  %i12 = shufflevector <6 x i32> %i11, <6 x i32> zeroinitializer, <8 x i32> <i32 4, i32 poison, i32 6, i32 poison, i32 poison, i32 poison, i32 10, i32 0>
  %i13 = shufflevector <8 x i32> %i12, <8 x i32> poison, <64 x i32> <i32 0, i32 poison, i32 2, i32 poison, i32 poison, i32 poison, i32 6, i32 7, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
  %i14 = shufflevector <64 x i32> %i13, <64 x i32> %i2, <8 x i32> <i32 0, i32 127, i32 2, i32 poison, i32 poison, i32 poison, i32 6, i32 7>
  %i15 = shufflevector <8 x i32> %i14, <8 x i32> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 10, i32 poison, i32 poison, i32 6, i32 7>
  %i16 = shufflevector <8 x i32> %i15, <8 x i32> poison, <19 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 poison, i32 6, i32 7, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
  %i17 = shufflevector <19 x i32> %i16, <19 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 19, i32 6, i32 7>
  %i18 = add <8 x i32> zeroinitializer, %i17
  %i19 = add <8 x i32> %i18, zeroinitializer
  store <8 x i32> %i19, ptr %p2, align 4
  ret void
}
declare <5 x i32> @llvm.masked.load.v5i32.p0(ptr captures(none), i32 immarg, <5 x i1>, <5 x i32>)
declare <64 x i32> @llvm.masked.load.v64i32.p0(ptr captures(none), i32 immarg, <64 x i1>, <64 x i32>)

define <8 x double> @PR143606(ptr %px, ptr %py) {
; X86-LABEL: PR143606:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    vmovapd (%ecx), %ymm0
; X86-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0],mem[1,2],ymm0[3]
; X86-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],mem[0],ymm0[2],mem[3]
; X86-NEXT:    vinsertf64x4 $1, %ymm0, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: PR143606:
; X64:       # %bb.0:
; X64-NEXT:    vmovapd (%rdi), %ymm0
; X64-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0],mem[1,2],ymm0[3]
; X64-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],mem[0],ymm0[2],mem[3]
; X64-NEXT:    vinsertf64x4 $1, %ymm0, %zmm1, %zmm0
; X64-NEXT:    retq
  %x = load <4 x double>, ptr %px, align 32
  %y.lo = load <4 x double>, ptr %py, align 32
  %py.hi = getelementptr inbounds nuw i8, ptr %py, i64 32
  %y.hi = load <4 x double>, ptr %py.hi, align 32
  %lo = shufflevector <4 x double> %x, <4 x double> %y.lo, <4 x i32> <i32 0, i32 5, i32 6, i32 3>
  %hi = call <4 x double> @llvm.x86.avx512.vpermi2var.pd.256(<4 x double> %x, <4 x i64> <i64 1, i64 4, i64 2, i64 7>, <4 x double> %y.hi)
  %res = shufflevector <4 x double> %lo, <4 x double> %hi, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x double> %res
}
