; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512

; Test codegen for under aligned nontemporal vector loads

; XMM versions.

define <2 x double> @test_v2f64_align1(ptr %src) nounwind {
; SSE-LABEL: test_v2f64_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v2f64_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, ptr %src, align 1, !nontemporal !1
  ret <2 x double> %1
}

define <4 x float> @test_v4f32_align1(ptr %src) nounwind {
; SSE-LABEL: test_v4f32_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v4f32_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, ptr %src, align 1, !nontemporal !1
  ret <4 x float> %1
}

define <2 x i64> @test_v2i64_align1(ptr %src) nounwind {
; SSE-LABEL: test_v2i64_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v2i64_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x i64>, ptr %src, align 1, !nontemporal !1
  ret <2 x i64> %1
}

define <4 x i32> @test_v4i32_align1(ptr %src) nounwind {
; SSE-LABEL: test_v4i32_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v4i32_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x i32>, ptr %src, align 1, !nontemporal !1
  ret <4 x i32> %1
}

define <8 x i16> @test_v8i16_align1(ptr %src) nounwind {
; SSE-LABEL: test_v8i16_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v8i16_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %1 = load <8 x i16>, ptr %src, align 1, !nontemporal !1
  ret <8 x i16> %1
}

define <16 x i8> @test_v16i8_align1(ptr %src) nounwind {
; SSE-LABEL: test_v16i8_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v16i8_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
  %1 = load <16 x i8>, ptr %src, align 1, !nontemporal !1
  ret <16 x i8> %1
}

; YMM versions.

define <4 x double> @test_v4f64_align1(ptr %src) nounwind {
; SSE-LABEL: test_v4f64_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v4f64_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, ptr %src, align 1, !nontemporal !1
  ret <4 x double> %1
}

define <8 x float> @test_v8f32_align1(ptr %src) nounwind {
; SSE-LABEL: test_v8f32_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v8f32_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, ptr %src, align 1, !nontemporal !1
  ret <8 x float> %1
}

define <4 x i64> @test_v4i64_align1(ptr %src) nounwind {
; SSE-LABEL: test_v4i64_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v4i64_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x i64>, ptr %src, align 1, !nontemporal !1
  ret <4 x i64> %1
}

define <8 x i32> @test_v8i32_align1(ptr %src) nounwind {
; SSE-LABEL: test_v8i32_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v8i32_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x i32>, ptr %src, align 1, !nontemporal !1
  ret <8 x i32> %1
}

define <16 x i16> @test_v16i16_align1(ptr %src) nounwind {
; SSE-LABEL: test_v16i16_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v16i16_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
  %1 = load <16 x i16>, ptr %src, align 1, !nontemporal !1
  ret <16 x i16> %1
}

define <32 x i8> @test_v32i8_align1(ptr %src) nounwind {
; SSE-LABEL: test_v32i8_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v32i8_align1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
  %1 = load <32 x i8>, ptr %src, align 1, !nontemporal !1
  ret <32 x i8> %1
}

define <4 x double> @test_v4f64_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v4f64_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4f64_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v4f64_align16:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbp
; AVX-NEXT:    movq %rsp, %rbp
; AVX-NEXT:    andq $-32, %rsp
; AVX-NEXT:    subq $64, %rsp
; AVX-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX-NEXT:    vmovaps (%rsp), %ymm0
; AVX-NEXT:    movq %rbp, %rsp
; AVX-NEXT:    popq %rbp
; AVX-NEXT:    retq
  %1 = load <4 x double>, ptr %src, align 16, !nontemporal !1
  ret <4 x double> %1
}

define <8 x float> @test_v8f32_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v8f32_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8f32_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v8f32_align16:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbp
; AVX-NEXT:    movq %rsp, %rbp
; AVX-NEXT:    andq $-32, %rsp
; AVX-NEXT:    subq $64, %rsp
; AVX-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX-NEXT:    vmovaps (%rsp), %ymm0
; AVX-NEXT:    movq %rbp, %rsp
; AVX-NEXT:    popq %rbp
; AVX-NEXT:    retq
  %1 = load <8 x float>, ptr %src, align 16, !nontemporal !1
  ret <8 x float> %1
}

define <4 x i64> @test_v4i64_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v4i64_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4i64_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v4i64_align16:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbp
; AVX-NEXT:    movq %rsp, %rbp
; AVX-NEXT:    andq $-32, %rsp
; AVX-NEXT:    subq $64, %rsp
; AVX-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX-NEXT:    vmovaps (%rsp), %ymm0
; AVX-NEXT:    movq %rbp, %rsp
; AVX-NEXT:    popq %rbp
; AVX-NEXT:    retq
  %1 = load <4 x i64>, ptr %src, align 16, !nontemporal !1
  ret <4 x i64> %1
}

define <8 x i32> @test_v8i32_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v8i32_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i32_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v8i32_align16:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbp
; AVX-NEXT:    movq %rsp, %rbp
; AVX-NEXT:    andq $-32, %rsp
; AVX-NEXT:    subq $64, %rsp
; AVX-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX-NEXT:    vmovaps (%rsp), %ymm0
; AVX-NEXT:    movq %rbp, %rsp
; AVX-NEXT:    popq %rbp
; AVX-NEXT:    retq
  %1 = load <8 x i32>, ptr %src, align 16, !nontemporal !1
  ret <8 x i32> %1
}

define <16 x i16> @test_v16i16_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v16i16_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i16_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v16i16_align16:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbp
; AVX-NEXT:    movq %rsp, %rbp
; AVX-NEXT:    andq $-32, %rsp
; AVX-NEXT:    subq $64, %rsp
; AVX-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX-NEXT:    vmovaps (%rsp), %ymm0
; AVX-NEXT:    movq %rbp, %rsp
; AVX-NEXT:    popq %rbp
; AVX-NEXT:    retq
  %1 = load <16 x i16>, ptr %src, align 16, !nontemporal !1
  ret <16 x i16> %1
}

define <32 x i8> @test_v32i8_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v32i8_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v32i8_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v32i8_align16:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %rbp
; AVX-NEXT:    movq %rsp, %rbp
; AVX-NEXT:    andq $-32, %rsp
; AVX-NEXT:    subq $64, %rsp
; AVX-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX-NEXT:    vmovaps (%rsp), %ymm0
; AVX-NEXT:    movq %rbp, %rsp
; AVX-NEXT:    popq %rbp
; AVX-NEXT:    retq
  %1 = load <32 x i8>, ptr %src, align 16, !nontemporal !1
  ret <32 x i8> %1
}

; ZMM versions.

define <8 x double> @test_v8f64_align1(ptr %src) nounwind {
; SSE-LABEL: test_v8f64_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_v8f64_align1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8f64_align1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovups (%rdi), %ymm0
; AVX2-NEXT:    vmovups 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8f64_align1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x double>, ptr %src, align 1, !nontemporal !1
  ret <8 x double> %1
}

define <16 x float> @test_v16f32_align1(ptr %src) nounwind {
; SSE-LABEL: test_v16f32_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_v16f32_align1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16f32_align1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovups (%rdi), %ymm0
; AVX2-NEXT:    vmovups 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16f32_align1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x float>, ptr %src, align 1, !nontemporal !1
  ret <16 x float> %1
}

define <8 x i64> @test_v8i64_align1(ptr %src) nounwind {
; SSE-LABEL: test_v8i64_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_v8i64_align1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i64_align1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovups (%rdi), %ymm0
; AVX2-NEXT:    vmovups 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8i64_align1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i64>, ptr %src, align 1, !nontemporal !1
  ret <8 x i64> %1
}

define <16 x i32> @test_v16i32_align1(ptr %src) nounwind {
; SSE-LABEL: test_v16i32_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_v16i32_align1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i32_align1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovups (%rdi), %ymm0
; AVX2-NEXT:    vmovups 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i32_align1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i32>, ptr %src, align 1, !nontemporal !1
  ret <16 x i32> %1
}

define <32 x i16> @test_v32i16_align1(ptr %src) nounwind {
; SSE-LABEL: test_v32i16_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_v32i16_align1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v32i16_align1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovups (%rdi), %ymm0
; AVX2-NEXT:    vmovups 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v32i16_align1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <32 x i16>, ptr %src, align 1, !nontemporal !1
  ret <32 x i16> %1
}

define <64 x i8> @test_v64i8_align1(ptr %src) nounwind {
; SSE-LABEL: test_v64i8_align1:
; SSE:       # %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_v64i8_align1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v64i8_align1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovups (%rdi), %ymm0
; AVX2-NEXT:    vmovups 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v64i8_align1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <64 x i8>, ptr %src, align 1, !nontemporal !1
  ret <64 x i8> %1
}

define <8 x double> @test_v8f64_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v8f64_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8f64_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8f64_align16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $96, %rsp
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovaps (%rsp), %ymm0
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8f64_align16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $96, %rsp
; AVX2-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX2-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovaps (%rsp), %ymm0
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8f64_align16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <8 x double>, ptr %src, align 16, !nontemporal !1
  ret <8 x double> %1
}

define <16 x float> @test_v16f32_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v16f32_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16f32_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16f32_align16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $96, %rsp
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovaps (%rsp), %ymm0
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16f32_align16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $96, %rsp
; AVX2-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX2-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovaps (%rsp), %ymm0
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16f32_align16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <16 x float>, ptr %src, align 16, !nontemporal !1
  ret <16 x float> %1
}

define <8 x i64> @test_v8i64_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v8i64_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i64_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8i64_align16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $96, %rsp
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovaps (%rsp), %ymm0
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i64_align16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $96, %rsp
; AVX2-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX2-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovaps (%rsp), %ymm0
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8i64_align16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <8 x i64>, ptr %src, align 16, !nontemporal !1
  ret <8 x i64> %1
}

define <16 x i32> @test_v16i32_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v16i32_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i32_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i32_align16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $96, %rsp
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovaps (%rsp), %ymm0
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i32_align16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $96, %rsp
; AVX2-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX2-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovaps (%rsp), %ymm0
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i32_align16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <16 x i32>, ptr %src, align 16, !nontemporal !1
  ret <16 x i32> %1
}

define <32 x i16> @test_v32i16_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v32i16_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v32i16_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v32i16_align16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $96, %rsp
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovaps (%rsp), %ymm0
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v32i16_align16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $96, %rsp
; AVX2-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX2-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovaps (%rsp), %ymm0
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v32i16_align16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <32 x i16>, ptr %src, align 16, !nontemporal !1
  ret <32 x i16> %1
}

define <64 x i8> @test_v64i8_align16(ptr %src) nounwind {
; SSE2-LABEL: test_v64i8_align16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v64i8_align16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v64i8_align16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    movq %rsp, %rbp
; AVX1-NEXT:    andq $-32, %rsp
; AVX1-NEXT:    subq $96, %rsp
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    vmovaps (%rsp), %ymm0
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX1-NEXT:    movq %rbp, %rsp
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v64i8_align16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    movq %rsp, %rbp
; AVX2-NEXT:    andq $-32, %rsp
; AVX2-NEXT:    subq $96, %rsp
; AVX2-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX2-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovaps (%rsp), %ymm0
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %ymm1
; AVX2-NEXT:    movq %rbp, %rsp
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v64i8_align16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 32(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa 16(%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <64 x i8>, ptr %src, align 16, !nontemporal !1
  ret <64 x i8> %1
}

define <8 x double> @test_v8f64_align32(ptr %src) nounwind {
; SSE2-LABEL: test_v8f64_align32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8f64_align32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8f64_align32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8f64_align32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8f64_align32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 32(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <8 x double>, ptr %src, align 32, !nontemporal !1
  ret <8 x double> %1
}

define <16 x float> @test_v16f32_align32(ptr %src) nounwind {
; SSE2-LABEL: test_v16f32_align32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16f32_align32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16f32_align32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16f32_align32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16f32_align32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 32(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <16 x float>, ptr %src, align 32, !nontemporal !1
  ret <16 x float> %1
}

define <8 x i64> @test_v8i64_align32(ptr %src) nounwind {
; SSE2-LABEL: test_v8i64_align32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i64_align32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8i64_align32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i64_align32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8i64_align32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 32(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <8 x i64>, ptr %src, align 32, !nontemporal !1
  ret <8 x i64> %1
}

define <16 x i32> @test_v16i32_align32(ptr %src) nounwind {
; SSE2-LABEL: test_v16i32_align32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i32_align32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i32_align32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i32_align32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i32_align32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 32(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <16 x i32>, ptr %src, align 32, !nontemporal !1
  ret <16 x i32> %1
}

define <32 x i16> @test_v32i16_align32(ptr %src) nounwind {
; SSE2-LABEL: test_v32i16_align32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v32i16_align32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v32i16_align32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v32i16_align32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v32i16_align32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 32(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <32 x i16>, ptr %src, align 32, !nontemporal !1
  ret <32 x i16> %1
}

define <64 x i8> @test_v64i8_align32(ptr %src) nounwind {
; SSE2-LABEL: test_v64i8_align32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v64i8_align32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v64i8_align32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovntdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovntdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovntdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v64i8_align32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v64i8_align32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    movq %rsp, %rbp
; AVX512-NEXT:    andq $-64, %rsp
; AVX512-NEXT:    subq $128, %rsp
; AVX512-NEXT:    vmovntdqa 32(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, (%rsp)
; AVX512-NEXT:    vmovaps (%rsp), %zmm0
; AVX512-NEXT:    movq %rbp, %rsp
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %1 = load <64 x i8>, ptr %src, align 32, !nontemporal !1
  ret <64 x i8> %1
}

!1 = !{i32 1}
