; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=-sse2 | FileCheck %s --check-prefixes=CHECK,X64

; It doesn't matter if an x86-64 target has specified "no-sse2"; we still can use mfence.

define void @test() {
; X86-LABEL: test:
; X86:       # %bb.0:
; X86-NEXT:    mfence
; X86-NEXT:    retl
;
; X64-LABEL: test:
; X64:       # %bb.0:
; X64-NEXT:    lock orl $0, -{{[0-9]+}}(%rsp)
; X64-NEXT:    retq
  fence seq_cst
  ret void
}

define i32 @fence(ptr %ptr) {
; X86-LABEL: fence:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mfence
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    retl
;
; X64-LABEL: fence:
; X64:       # %bb.0:
; X64-NEXT:    lock orl $0, -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl (%rdi), %eax
; X64-NEXT:    retq
  %atomic = atomicrmw add ptr %ptr, i32 0 seq_cst
  ret i32 %atomic
}

define void @mfence() nounwind {
; CHECK-LABEL: mfence:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mfence
; CHECK-NEXT:    ret{{[l|q]}}
  call void @llvm.x86.sse2.mfence()
  ret void
}
declare void @llvm.x86.sse2.mfence() nounwind readnone

