; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcilo -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32IXQCILO

define i32 @lb_ri(i8* %a) {
; RV32I-LABEL: lb_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lb a0, 1808(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: lb_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.lb a0, 10000(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i8, i8* %a, i32 10000
  %2 = load i8, i8* %1
  %3 = sext i8 %2 to i32
  ret i32 %3
}

define i32 @lbu_ri(i8* %a) {
; RV32I-LABEL: lbu_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1048574
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a0, 192(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: lbu_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.lbu a0, -8000(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i8, i8* %a, i32 -8000
  %2 = load i8, i8* %1
  %3 = zext i8 %2 to i32
  ret i32 %3
}

define i32 @lh_ri(i16* %a) {
; RV32I-LABEL: lh_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 11
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lhu a0, -612(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: lh_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.lhu a0, 44444(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i16, i16* %a, i32 22222
  %2 = load i16, i16* %1
  %3 = zext i16 %2 to i32
  ret i32 %3
}

define i32 @lhu_ri(i16* %a) {
; RV32I-LABEL: lhu_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1048570
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lhu a0, 120(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: lhu_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.lhu a0, -24456(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i16, i16* %a, i32 -12228
  %2 = load i16, i16* %1
  %3 = zext i16 %2 to i32
  ret i32 %3
}

define i32 @lw_ri(i32* %a) {
; RV32I-LABEL: lw_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 2047
; RV32I-NEXT:    lw a0, 1953(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: lw_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.lw a0, 4000(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i32, i32* %a, i32 1000
  %2 = load i32, i32* %1
  ret i32 %2
}

define void @sb_ri(i8* %a, i8 %b) {
; RV32I-LABEL: sb_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 2
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    sb a1, 1808(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: sb_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.sb a1, 10000(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i8, i8* %a, i32 10000
  store i8 %b, i8* %1
  ret void
}

define void @sh_ri(i16* %a, i16 %b) {
; RV32I-LABEL: sh_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 11
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    sh a1, -612(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: sh_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.sh a1, 44444(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i16, i16* %a, i32 22222
  store i16 %b, i16* %1
  ret void
}

define void @sw_ri(i32* %a, i32 %b) {
; RV32I-LABEL: sw_ri:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 2047
; RV32I-NEXT:    sw a1, 1953(a0)
; RV32I-NEXT:    ret
;
; RV32IXQCILO-LABEL: sw_ri:
; RV32IXQCILO:       # %bb.0:
; RV32IXQCILO-NEXT:    qc.e.sw a1, 4000(a0)
; RV32IXQCILO-NEXT:    ret
  %1 = getelementptr i32, i32* %a, i32 1000
  store i32 %b, i32* %1
  ret void
}
