; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx600 < %s | FileCheck --check-prefixes=GFX6 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx700 < %s | FileCheck --check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 < %s | FileCheck --check-prefixes=GFX10-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX10-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -O0 -mcpu=gfx700 -amdgcn-skip-cache-invalidations < %s | FileCheck --check-prefixes=SKIP-CACHE-INV %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX90A-NOTTGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx90a -mattr=+tgsplit < %s | FileCheck -check-prefixes=GFX90A-TGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX942-NOTTGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx942 -mattr=+tgsplit < %s | FileCheck -check-prefixes=GFX942-TGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 < %s | FileCheck --check-prefixes=GFX11-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX11-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 < %s | FileCheck --check-prefixes=GFX12-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX12-CU %s

define amdgpu_kernel void @global_nontemporal_load_0(
; GFX6-LABEL: global_nontemporal_load_0:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s12, s5
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX6-NEXT:    s_mov_b32 s10, 0x100f000
; GFX6-NEXT:    s_mov_b32 s11, -1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5_sgpr6_sgpr7
; GFX6-NEXT:    s_mov_b32 s5, s12
; GFX6-NEXT:    s_mov_b32 s6, s11
; GFX6-NEXT:    s_mov_b32 s7, s10
; GFX6-NEXT:    s_load_dword s8, s[8:9], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: global_nontemporal_load_0:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: global_nontemporal_load_0:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: global_nontemporal_load_0:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: global_nontemporal_load_0:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, s1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 killed $sgpr0_sgpr1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s6, 0xf000
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s7, -1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 def $sgpr0_sgpr1_sgpr2_sgpr3
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s1, s8
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s7
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s3, s6
; SKIP-CACHE-INV-NEXT:    s_load_dword s4, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s4
; SKIP-CACHE-INV-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: global_nontemporal_load_0:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: global_nontemporal_load_0:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX942-NOTTGSPLIT-LABEL: global_nontemporal_load_0:
; GFX942-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX942-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX942-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX942-TGSPLIT-LABEL: global_nontemporal_load_0:
; GFX942-TGSPLIT:       ; %bb.0: ; %entry
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX942-TGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX942-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: global_nontemporal_load_0:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: global_nontemporal_load_0:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: global_nontemporal_load_0:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: global_nontemporal_load_0:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(1) %in, ptr addrspace(1) %out) {
entry:
  %val = load i32, ptr addrspace(1) %in, align 4, !nontemporal !0
  store i32 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_nontemporal_load_1(
; GFX6-LABEL: global_nontemporal_load_1:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s12, s5
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX6-NEXT:    s_mov_b32 s10, 0x100f000
; GFX6-NEXT:    s_mov_b32 s11, -1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5_sgpr6_sgpr7
; GFX6-NEXT:    s_mov_b32 s5, s12
; GFX6-NEXT:    s_mov_b32 s6, s11
; GFX6-NEXT:    s_mov_b32 s7, s10
; GFX6-NEXT:    s_mov_b32 s12, 0
; GFX6-NEXT:    ; kill: def $sgpr12 killed $sgpr12 def $sgpr12_sgpr13
; GFX6-NEXT:    s_mov_b32 s13, s10
; GFX6-NEXT:    ; kill: def $sgpr8_sgpr9 killed $sgpr8_sgpr9 def $sgpr8_sgpr9_sgpr10_sgpr11
; GFX6-NEXT:    s_mov_b64 s[10:11], s[12:13]
; GFX6-NEXT:    s_mov_b32 s12, 2
; GFX6-NEXT:    v_lshlrev_b32_e64 v0, s12, v0
; GFX6-NEXT:    s_mov_b32 s12, 0
; GFX6-NEXT:    ; implicit-def: $sgpr12
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64 glc slc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: global_nontemporal_load_1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; GFX7-NEXT:    s_mov_b32 s6, 2
; GFX7-NEXT:    v_lshlrev_b32_e64 v1, s6, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    ; implicit-def: $sgpr6
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, s8
; GFX7-NEXT:    v_mov_b32_e32 v0, v1
; GFX7-NEXT:    s_mov_b32 s8, s9
; GFX7-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr1_vgpr2 killed $exec
; GFX7-NEXT:    v_add_i32_e64 v0, s[6:7], s6, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s8
; GFX7-NEXT:    v_addc_u32_e64 v2, s[6:7], v1, v2, s[6:7]
; GFX7-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    flat_load_dword v2, v[0:1] glc slc
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: global_nontemporal_load_1:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-WGP-NEXT:    s_mov_b32 s8, 2
; GFX10-WGP-NEXT:    v_lshlrev_b32_e64 v1, s8, v1
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    global_load_dword v1, v1, s[6:7] slc
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: global_nontemporal_load_1:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-CU-NEXT:    s_mov_b32 s8, 2
; GFX10-CU-NEXT:    v_lshlrev_b32_e64 v1, s8, v1
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    global_load_dword v1, v1, s[6:7] slc
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: global_nontemporal_load_1:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, s1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 killed $sgpr0_sgpr1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s6, 0xf000
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s7, -1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 def $sgpr0_sgpr1_sgpr2_sgpr3
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s1, s8
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s7
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s3, s6
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, 0
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr8 killed $sgpr8 def $sgpr8_sgpr9
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s9, s6
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr4_sgpr5 killed $sgpr4_sgpr5 def $sgpr4_sgpr5_sgpr6_sgpr7
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[6:7], s[8:9]
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, 2
; SKIP-CACHE-INV-NEXT:    v_lshlrev_b32_e64 v0, s8, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, 0
; SKIP-CACHE-INV-NEXT:    ; implicit-def: $sgpr8
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, 0
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, v2
; SKIP-CACHE-INV-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64 glc slc
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: global_nontemporal_load_1:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b32 s8, 0x3ff
; GFX90A-NOTTGSPLIT-NEXT:    v_and_b32_e64 v1, v1, s8
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b32 s8, 2
; GFX90A-NOTTGSPLIT-NEXT:    v_lshlrev_b32_e64 v1, s8, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    global_load_dword v1, v1, s[6:7] glc slc
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: global_nontemporal_load_1:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-TGSPLIT-NEXT:    s_mov_b32 s8, 0x3ff
; GFX90A-TGSPLIT-NEXT:    v_and_b32_e64 v1, v1, s8
; GFX90A-TGSPLIT-NEXT:    s_mov_b32 s8, 2
; GFX90A-TGSPLIT-NEXT:    v_lshlrev_b32_e64 v1, s8, v1
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    global_load_dword v1, v1, s[6:7] glc slc
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX942-NOTTGSPLIT-LABEL: global_nontemporal_load_1:
; GFX942-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NOTTGSPLIT-NEXT:    s_mov_b32 s4, 0x3ff
; GFX942-NOTTGSPLIT-NEXT:    v_and_b32_e64 v1, v1, s4
; GFX942-NOTTGSPLIT-NEXT:    s_mov_b32 s4, 2
; GFX942-NOTTGSPLIT-NEXT:    v_lshlrev_b32_e64 v1, s4, v1
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    global_load_dword v1, v1, s[2:3] nt
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX942-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX942-TGSPLIT-LABEL: global_nontemporal_load_1:
; GFX942-TGSPLIT:       ; %bb.0: ; %entry
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-TGSPLIT-NEXT:    s_mov_b32 s4, 0x3ff
; GFX942-TGSPLIT-NEXT:    v_and_b32_e64 v1, v1, s4
; GFX942-TGSPLIT-NEXT:    s_mov_b32 s4, 2
; GFX942-TGSPLIT-NEXT:    v_lshlrev_b32_e64 v1, s4, v1
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    global_load_dword v1, v1, s[2:3] nt
; GFX942-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-TGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX942-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: global_nontemporal_load_1:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-WGP-NEXT:    s_mov_b32 s4, 0x3ff
; GFX11-WGP-NEXT:    v_and_b32_e64 v1, v1, s4
; GFX11-WGP-NEXT:    s_mov_b32 s4, 2
; GFX11-WGP-NEXT:    v_lshlrev_b32_e64 v1, s4, v1
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    global_load_b32 v1, v1, s[2:3] slc dlc
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: global_nontemporal_load_1:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-CU-NEXT:    s_mov_b32 s4, 0x3ff
; GFX11-CU-NEXT:    v_and_b32_e64 v1, v1, s4
; GFX11-CU-NEXT:    s_mov_b32 s4, 2
; GFX11-CU-NEXT:    v_lshlrev_b32_e64 v1, s4, v1
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    global_load_b32 v1, v1, s[2:3] slc dlc
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: global_nontemporal_load_1:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, v0
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-WGP-NEXT:    s_mov_b32 s4, 0x3ff
; GFX12-WGP-NEXT:    v_and_b32_e64 v1, v1, s4
; GFX12-WGP-NEXT:    s_mov_b32 s4, 2
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_lshlrev_b32_e64 v1, s4, v1
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    global_load_b32 v1, v1, s[2:3] th:TH_LOAD_NT
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: global_nontemporal_load_1:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, v0
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-CU-NEXT:    s_mov_b32 s4, 0x3ff
; GFX12-CU-NEXT:    v_and_b32_e64 v1, v1, s4
; GFX12-CU-NEXT:    s_mov_b32 s4, 2
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_lshlrev_b32_e64 v1, s4, v1
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    global_load_b32 v1, v1, s[2:3] th:TH_LOAD_NT
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(1) %in, ptr addrspace(1) %out) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %val.gep = getelementptr inbounds i32, ptr addrspace(1) %in, i32 %tid
  %val = load i32, ptr addrspace(1) %val.gep, align 4, !nontemporal !0
  store i32 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_nontemporal_store_0(
; GFX6-LABEL: global_nontemporal_store_0:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s12, s5
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX6-NEXT:    s_mov_b32 s10, 0x100f000
; GFX6-NEXT:    s_mov_b32 s11, -1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5_sgpr6_sgpr7
; GFX6-NEXT:    s_mov_b32 s5, s12
; GFX6-NEXT:    s_mov_b32 s6, s11
; GFX6-NEXT:    s_mov_b32 s7, s10
; GFX6-NEXT:    s_load_dword s8, s[8:9], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0 glc slc
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: global_nontemporal_store_0:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    flat_store_dword v[0:1], v2 glc slc
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: global_nontemporal_store_0:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: global_nontemporal_store_0:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: global_nontemporal_store_0:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, s1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 killed $sgpr0_sgpr1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s6, 0xf000
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s7, -1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 def $sgpr0_sgpr1_sgpr2_sgpr3
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s1, s8
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s7
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s3, s6
; SKIP-CACHE-INV-NEXT:    s_load_dword s4, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s4
; SKIP-CACHE-INV-NEXT:    buffer_store_dword v0, off, s[0:3], 0 glc slc
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: global_nontemporal_store_0:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: global_nontemporal_store_0:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX942-NOTTGSPLIT-LABEL: global_nontemporal_store_0:
; GFX942-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX942-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1] nt
; GFX942-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX942-TGSPLIT-LABEL: global_nontemporal_store_0:
; GFX942-TGSPLIT:       ; %bb.0: ; %entry
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX942-TGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1] nt
; GFX942-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: global_nontemporal_store_0:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    global_store_b32 v0, v1, s[0:1] glc slc dlc
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: global_nontemporal_store_0:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    global_store_b32 v0, v1, s[0:1] glc slc dlc
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: global_nontemporal_store_0:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    global_store_b32 v0, v1, s[0:1] th:TH_STORE_NT
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: global_nontemporal_store_0:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    global_store_b32 v0, v1, s[0:1] th:TH_STORE_NT
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(1) %in, ptr addrspace(1) %out) {
entry:
  %val = load i32, ptr addrspace(1) %in, align 4
  store i32 %val, ptr addrspace(1) %out, !nontemporal !0
  ret void
}

define amdgpu_kernel void @global_nontemporal_store_1(
; GFX6-LABEL: global_nontemporal_store_1:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s8, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 s6, 0x100f000
; GFX6-NEXT:    s_mov_b32 s10, 0
; GFX6-NEXT:    ; kill: def $sgpr10 killed $sgpr10 def $sgpr10_sgpr11
; GFX6-NEXT:    s_mov_b32 s11, s6
; GFX6-NEXT:    ; kill: def $sgpr4_sgpr5 killed $sgpr4_sgpr5 def $sgpr4_sgpr5_sgpr6_sgpr7
; GFX6-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GFX6-NEXT:    s_mov_b32 s9, 2
; GFX6-NEXT:    v_lshlrev_b32_e64 v1, s9, v0
; GFX6-NEXT:    s_mov_b32 s9, 0
; GFX6-NEXT:    ; implicit-def: $sgpr9
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    buffer_store_dword v0, v[1:2], s[4:7], 0 addr64 glc slc
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: global_nontemporal_store_1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[8:9], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    s_mov_b32 s5, 2
; GFX7-NEXT:    v_lshlrev_b32_e64 v1, s5, v0
; GFX7-NEXT:    s_mov_b32 s5, 0
; GFX7-NEXT:    ; implicit-def: $sgpr5
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    s_mov_b32 s6, s8
; GFX7-NEXT:    v_mov_b32_e32 v0, v1
; GFX7-NEXT:    s_mov_b32 s5, s9
; GFX7-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr1_vgpr2 killed $exec
; GFX7-NEXT:    v_add_i32_e64 v0, s[6:7], s6, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_addc_u32_e64 v2, s[6:7], v1, v2, s[6:7]
; GFX7-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    flat_store_dword v[0:1], v2 glc slc
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: global_nontemporal_store_1:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_mov_b32 s7, 2
; GFX10-WGP-NEXT:    v_lshlrev_b32_e64 v0, s7, v0
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: global_nontemporal_store_1:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX10-CU-NEXT:    s_mov_b32 s7, 2
; GFX10-CU-NEXT:    v_lshlrev_b32_e64 v0, s7, v0
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: global_nontemporal_store_1:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_load_dword s4, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, 0xf000
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s6, 0
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr6 killed $sgpr6 def $sgpr6_sgpr7
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s7, s2
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0_sgpr1 killed $sgpr0_sgpr1 def $sgpr0_sgpr1_sgpr2_sgpr3
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s5, 2
; SKIP-CACHE-INV-NEXT:    v_lshlrev_b32_e64 v1, s5, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s5, 0
; SKIP-CACHE-INV-NEXT:    ; implicit-def: $sgpr5
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, 0
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, v0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s4
; SKIP-CACHE-INV-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64 glc slc
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: global_nontemporal_store_1:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b32 s7, 0x3ff
; GFX90A-NOTTGSPLIT-NEXT:    v_and_b32_e64 v0, v0, s7
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b32 s7, 2
; GFX90A-NOTTGSPLIT-NEXT:    v_lshlrev_b32_e64 v0, s7, v0
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: global_nontemporal_store_1:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_mov_b32 s7, 0x3ff
; GFX90A-TGSPLIT-NEXT:    v_and_b32_e64 v0, v0, s7
; GFX90A-TGSPLIT-NEXT:    s_mov_b32 s7, 2
; GFX90A-TGSPLIT-NEXT:    v_lshlrev_b32_e64 v0, s7, v0
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5] glc slc
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX942-NOTTGSPLIT-LABEL: global_nontemporal_store_1:
; GFX942-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_mov_b32 s3, 0x3ff
; GFX942-NOTTGSPLIT-NEXT:    v_and_b32_e64 v0, v0, s3
; GFX942-NOTTGSPLIT-NEXT:    s_mov_b32 s3, 2
; GFX942-NOTTGSPLIT-NEXT:    v_lshlrev_b32_e64 v0, s3, v0
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX942-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1] nt
; GFX942-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX942-TGSPLIT-LABEL: global_nontemporal_store_1:
; GFX942-TGSPLIT:       ; %bb.0: ; %entry
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX942-TGSPLIT-NEXT:    s_mov_b32 s3, 0x3ff
; GFX942-TGSPLIT-NEXT:    v_and_b32_e64 v0, v0, s3
; GFX942-TGSPLIT-NEXT:    s_mov_b32 s3, 2
; GFX942-TGSPLIT-NEXT:    v_lshlrev_b32_e64 v0, s3, v0
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX942-TGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1] nt
; GFX942-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: global_nontemporal_store_1:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_mov_b32 s3, 0x3ff
; GFX11-WGP-NEXT:    v_and_b32_e64 v0, v0, s3
; GFX11-WGP-NEXT:    s_mov_b32 s3, 2
; GFX11-WGP-NEXT:    v_lshlrev_b32_e64 v0, s3, v0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    global_store_b32 v0, v1, s[0:1] glc slc dlc
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: global_nontemporal_store_1:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-CU-NEXT:    s_mov_b32 s3, 0x3ff
; GFX11-CU-NEXT:    v_and_b32_e64 v0, v0, s3
; GFX11-CU-NEXT:    s_mov_b32 s3, 2
; GFX11-CU-NEXT:    v_lshlrev_b32_e64 v0, s3, v0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    global_store_b32 v0, v1, s[0:1] glc slc dlc
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: global_nontemporal_store_1:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_mov_b32 s3, 0x3ff
; GFX12-WGP-NEXT:    v_and_b32_e64 v0, v0, s3
; GFX12-WGP-NEXT:    s_mov_b32 s3, 2
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_lshlrev_b32_e64 v0, s3, v0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    global_store_b32 v0, v1, s[0:1] th:TH_STORE_NT
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: global_nontemporal_store_1:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-CU-NEXT:    s_mov_b32 s3, 0x3ff
; GFX12-CU-NEXT:    v_and_b32_e64 v0, v0, s3
; GFX12-CU-NEXT:    s_mov_b32 s3, 2
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_lshlrev_b32_e64 v0, s3, v0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    global_store_b32 v0, v1, s[0:1] th:TH_STORE_NT
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(1) %in, ptr addrspace(1) %out) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %val = load i32, ptr addrspace(1) %in, align 4
  %out.gep = getelementptr inbounds i32, ptr addrspace(1) %out, i32 %tid
  store i32 %val, ptr addrspace(1) %out.gep, !nontemporal !0
  ret void
}

define amdgpu_kernel void @global_nontemporal_volatile_load(
; GFX6-LABEL: global_nontemporal_volatile_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX6-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, s9
; GFX6-NEXT:    ; kill: def $sgpr8 killed $sgpr8 killed $sgpr8_sgpr9
; GFX6-NEXT:    s_mov_b32 s12, 0x100f000
; GFX6-NEXT:    s_mov_b32 s13, -1
; GFX6-NEXT:    ; kill: def $sgpr8 killed $sgpr8 def $sgpr8_sgpr9_sgpr10_sgpr11
; GFX6-NEXT:    s_mov_b32 s9, s6
; GFX6-NEXT:    s_mov_b32 s10, s13
; GFX6-NEXT:    s_mov_b32 s11, s12
; GFX6-NEXT:    s_mov_b32 s14, s5
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5_sgpr6_sgpr7
; GFX6-NEXT:    s_mov_b32 s5, s14
; GFX6-NEXT:    s_mov_b32 s6, s13
; GFX6-NEXT:    s_mov_b32 s7, s12
; GFX6-NEXT:    buffer_load_dword v0, off, s[8:11], 0 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: global_nontemporal_volatile_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    flat_load_dword v2, v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: global_nontemporal_volatile_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    global_load_dword v1, v0, s[6:7] glc dlc
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: global_nontemporal_volatile_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    global_load_dword v1, v0, s[6:7] glc dlc
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: global_nontemporal_volatile_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s5
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s8, 0xf000
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s9, -1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5_sgpr6_sgpr7
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s5, s2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s6, s9
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s7, s8
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s10, s1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 killed $sgpr0_sgpr1
; SKIP-CACHE-INV-NEXT:    ; kill: def $sgpr0 killed $sgpr0 def $sgpr0_sgpr1_sgpr2_sgpr3
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s1, s10
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s9
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s3, s8
; SKIP-CACHE-INV-NEXT:    buffer_load_dword v0, off, s[4:7], 0 glc
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: global_nontemporal_volatile_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    global_load_dword v1, v0, s[6:7] glc
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: global_nontemporal_volatile_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    global_load_dword v1, v0, s[6:7] glc
; GFX90A-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-TGSPLIT-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX942-NOTTGSPLIT-LABEL: global_nontemporal_volatile_load:
; GFX942-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX942-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-NOTTGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    global_load_dword v1, v0, s[2:3] sc0 sc1
; GFX942-NOTTGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NOTTGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX942-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX942-TGSPLIT-LABEL: global_nontemporal_volatile_load:
; GFX942-TGSPLIT:       ; %bb.0: ; %entry
; GFX942-TGSPLIT-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX942-TGSPLIT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX942-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-TGSPLIT-NEXT:    global_load_dword v1, v0, s[2:3] sc0 sc1
; GFX942-TGSPLIT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-TGSPLIT-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX942-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: global_nontemporal_volatile_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: global_nontemporal_volatile_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: global_nontemporal_volatile_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    global_load_b32 v1, v0, s[2:3] th:TH_LOAD_NT scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: global_nontemporal_volatile_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    global_load_b32 v1, v0, s[2:3] th:TH_LOAD_NT scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(1) %in, ptr addrspace(1) %out) {
entry:
  %val = load volatile i32, ptr addrspace(1) %in, align 4, !nontemporal !0
  store i32 %val, ptr addrspace(1) %out
  ret void
}

!0 = !{i32 1}
declare i32 @llvm.amdgcn.workitem.id.x()
