; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -verify-machineinstrs -mtriple=arm64-none-linux-gnu -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <16 x i8> @div16xi8(<16 x i8> %x) {
; CHECK-SD-LABEL: div16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v1.16b, #41
; CHECK-SD-NEXT:    smull2 v2.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    smull v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    uzp2 v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    sshr v0.16b, v0.16b, #2
; CHECK-SD-NEXT:    usra v0.16b, v0.16b, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: div16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.16b, #41
; CHECK-GI-NEXT:    smull2 v2.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    smull v0.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    uzp2 v1.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    sshr v0.16b, v1.16b, #2
; CHECK-GI-NEXT:    ushr v0.16b, v0.16b, #7
; CHECK-GI-NEXT:    ssra v0.16b, v1.16b, #2
; CHECK-GI-NEXT:    ret
  %div = sdiv <16 x i8> %x, <i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25, i8 25>
  ret <16 x i8> %div
}

define <8 x i16> @div8xi16(<8 x i16> %x) {
; CHECK-SD-LABEL: div8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #40815 // =0x9f6f
; CHECK-SD-NEXT:    dup v1.8h, w8
; CHECK-SD-NEXT:    smull2 v2.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    smull v1.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; CHECK-SD-NEXT:    add v0.8h, v1.8h, v0.8h
; CHECK-SD-NEXT:    sshr v0.8h, v0.8h, #12
; CHECK-SD-NEXT:    usra v0.8h, v0.8h, #15
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: div8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI1_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI1_0]
; CHECK-GI-NEXT:    smull2 v2.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    smull v1.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; CHECK-GI-NEXT:    add v1.8h, v1.8h, v0.8h
; CHECK-GI-NEXT:    sshr v0.8h, v1.8h, #12
; CHECK-GI-NEXT:    ushr v0.8h, v0.8h, #15
; CHECK-GI-NEXT:    ssra v0.8h, v1.8h, #12
; CHECK-GI-NEXT:    ret
  %div = sdiv <8 x i16> %x, <i16 6577, i16 6577, i16 6577, i16 6577, i16 6577, i16 6577, i16 6577, i16 6577>
  ret <8 x i16> %div
}

define <4 x i32> @div32xi4(<4 x i32> %x) {
; CHECK-SD-LABEL: div32xi4:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #7527 // =0x1d67
; CHECK-SD-NEXT:    movk w8, #28805, lsl #16
; CHECK-SD-NEXT:    dup v1.4s, w8
; CHECK-SD-NEXT:    smull2 v2.2d, v0.4s, v1.4s
; CHECK-SD-NEXT:    smull v0.2d, v0.2s, v1.2s
; CHECK-SD-NEXT:    uzp2 v1.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    sshr v0.4s, v1.4s, #22
; CHECK-SD-NEXT:    usra v0.4s, v1.4s, #31
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: div32xi4:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI2_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI2_0]
; CHECK-GI-NEXT:    smull2 v2.2d, v0.4s, v1.4s
; CHECK-GI-NEXT:    smull v0.2d, v0.2s, v1.2s
; CHECK-GI-NEXT:    uzp2 v1.4s, v0.4s, v2.4s
; CHECK-GI-NEXT:    sshr v0.4s, v1.4s, #22
; CHECK-GI-NEXT:    ushr v0.4s, v0.4s, #31
; CHECK-GI-NEXT:    ssra v0.4s, v1.4s, #22
; CHECK-GI-NEXT:    ret
  %div = sdiv <4 x i32> %x, <i32 9542677, i32 9542677, i32 9542677, i32 9542677>
  ret <4 x i32> %div
}

define <16 x i8> @udiv16xi8(<16 x i8> %x) {
; CHECK-LABEL: udiv16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #121
; CHECK-NEXT:    umull2 v2.8h, v0.16b, v1.16b
; CHECK-NEXT:    umull v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    uzp2 v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #5
; CHECK-NEXT:    ret
  %div = udiv <16 x i8> %x, <i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68, i8 68>
  ret <16 x i8> %div
}

define <8 x i16> @udiv8xi16(<8 x i16> %x) {
; CHECK-SD-LABEL: udiv8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #16593 // =0x40d1
; CHECK-SD-NEXT:    dup v1.8h, w8
; CHECK-SD-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    umull v1.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; CHECK-SD-NEXT:    sub v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    usra v1.8h, v0.8h, #1
; CHECK-SD-NEXT:    ushr v0.8h, v1.8h, #12
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: udiv8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI4_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI4_0]
; CHECK-GI-NEXT:    umull2 v2.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    umull v1.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    uzp2 v1.8h, v1.8h, v2.8h
; CHECK-GI-NEXT:    sub v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    usra v1.8h, v0.8h, #1
; CHECK-GI-NEXT:    ushr v0.8h, v1.8h, #12
; CHECK-GI-NEXT:    ret
  %div = udiv <8 x i16> %x, <i16 6537, i16 6537, i16 6537, i16 6537, i16 6537, i16 6537, i16 6537, i16 6537>
  ret <8 x i16> %div
}

define <4 x i32> @udiv32xi4(<4 x i32> %x) {
; CHECK-SD-LABEL: udiv32xi4:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #16747 // =0x416b
; CHECK-SD-NEXT:    movk w8, #31439, lsl #16
; CHECK-SD-NEXT:    dup v1.4s, w8
; CHECK-SD-NEXT:    umull2 v2.2d, v0.4s, v1.4s
; CHECK-SD-NEXT:    umull v0.2d, v0.2s, v1.2s
; CHECK-SD-NEXT:    uzp2 v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    ushr v0.4s, v0.4s, #22
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: udiv32xi4:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI5_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI5_0]
; CHECK-GI-NEXT:    umull2 v2.2d, v0.4s, v1.4s
; CHECK-GI-NEXT:    umull v0.2d, v0.2s, v1.2s
; CHECK-GI-NEXT:    uzp2 v0.4s, v0.4s, v2.4s
; CHECK-GI-NEXT:    ushr v0.4s, v0.4s, #22
; CHECK-GI-NEXT:    ret
  %div = udiv <4 x i32> %x, <i32 8743143, i32 8743143, i32 8743143, i32 8743143>
  ret <4 x i32> %div
}

define <2 x i64> @udiv_v2i64(<2 x i64> %a) {
; CHECK-SD-LABEL: udiv_v2i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov x8, #9363 // =0x2493
; CHECK-SD-NEXT:    fmov x10, d0
; CHECK-SD-NEXT:    mov x9, v0.d[1]
; CHECK-SD-NEXT:    movk x8, #37449, lsl #16
; CHECK-SD-NEXT:    movk x8, #18724, lsl #32
; CHECK-SD-NEXT:    movk x8, #9362, lsl #48
; CHECK-SD-NEXT:    umulh x11, x10, x8
; CHECK-SD-NEXT:    umulh x8, x9, x8
; CHECK-SD-NEXT:    sub x10, x10, x11
; CHECK-SD-NEXT:    add x10, x11, x10, lsr #1
; CHECK-SD-NEXT:    sub x9, x9, x8
; CHECK-SD-NEXT:    add x8, x8, x9, lsr #1
; CHECK-SD-NEXT:    lsr x9, x10, #2
; CHECK-SD-NEXT:    fmov d0, x9
; CHECK-SD-NEXT:    lsr x8, x8, #2
; CHECK-SD-NEXT:    mov v0.d[1], x8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: udiv_v2i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #9363 // =0x2493
; CHECK-GI-NEXT:    fmov x10, d0
; CHECK-GI-NEXT:    mov x9, v0.d[1]
; CHECK-GI-NEXT:    movk x8, #37449, lsl #16
; CHECK-GI-NEXT:    movk x8, #18724, lsl #32
; CHECK-GI-NEXT:    movk x8, #9362, lsl #48
; CHECK-GI-NEXT:    umulh x10, x10, x8
; CHECK-GI-NEXT:    umulh x8, x9, x8
; CHECK-GI-NEXT:    fmov d1, x10
; CHECK-GI-NEXT:    mov v1.d[1], x8
; CHECK-GI-NEXT:    sub v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    usra v1.2d, v0.2d, #1
; CHECK-GI-NEXT:    ushr v0.2d, v1.2d, #2
; CHECK-GI-NEXT:    ret
  %r = udiv <2 x i64> %a, splat (i64 7)
  ret <2 x i64> %r
}
