; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-linux-gnu -mattr=+addr-lsl-slow-14 | FileCheck %s --check-prefixes=CHECK,CHECK0,CHECK0-SDAG
; RUN: llc < %s -mtriple=aarch64-linux-gnu -mattr=+addr-lsl-slow-14 -global-isel=1 -global-isel-abort=1 | FileCheck %s --check-prefixes=CHECK,CHECK0,CHECK0-GISEL
; RUN: llc < %s -mtriple=aarch64-linux-gnu | FileCheck %s --check-prefixes=CHECK,CHECK3,CHECK3-SDAG
; RUN: llc < %s -mtriple=aarch64-linux-gnu -global-isel=1 -global-isel-abort=1 | FileCheck %s --check-prefixes=CHECK,CHECK3,CHECK3-GISEL

%struct.a = type [256 x i16]
%struct.b = type [256 x i32]
%struct.c = type [256 x i64]

declare void @foo()
define i16 @halfword(ptr %ctx, i32 %xor72) nounwind {
; CHECK0-SDAG-LABEL: halfword:
; CHECK0-SDAG:       // %bb.0:
; CHECK0-SDAG-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK0-SDAG-NEXT:    ubfx x8, x1, #9, #8
; CHECK0-SDAG-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    mov x19, x0
; CHECK0-SDAG-NEXT:    lsl x21, x8, #1
; CHECK0-SDAG-NEXT:    ldrh w20, [x0, x21]
; CHECK0-SDAG-NEXT:    bl foo
; CHECK0-SDAG-NEXT:    mov w0, w20
; CHECK0-SDAG-NEXT:    strh w20, [x19, x21]
; CHECK0-SDAG-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ret
;
; CHECK0-GISEL-LABEL: halfword:
; CHECK0-GISEL:       // %bb.0:
; CHECK0-GISEL-NEXT:    str x30, [sp, #-32]! // 8-byte Folded Spill
; CHECK0-GISEL-NEXT:    lsr w8, w1, #9
; CHECK0-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    add x20, x0, w8, uxtb #1
; CHECK0-GISEL-NEXT:    ldrh w19, [x20]
; CHECK0-GISEL-NEXT:    bl foo
; CHECK0-GISEL-NEXT:    mov w0, w19
; CHECK0-GISEL-NEXT:    strh w19, [x20]
; CHECK0-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ldr x30, [sp], #32 // 8-byte Folded Reload
; CHECK0-GISEL-NEXT:    ret
;
; CHECK3-SDAG-LABEL: halfword:
; CHECK3-SDAG:       // %bb.0:
; CHECK3-SDAG-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK3-SDAG-NEXT:    ubfx x21, x1, #9, #8
; CHECK3-SDAG-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    mov x19, x0
; CHECK3-SDAG-NEXT:    ldrh w20, [x0, x21, lsl #1]
; CHECK3-SDAG-NEXT:    bl foo
; CHECK3-SDAG-NEXT:    mov w0, w20
; CHECK3-SDAG-NEXT:    strh w20, [x19, x21, lsl #1]
; CHECK3-SDAG-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ret
;
; CHECK3-GISEL-LABEL: halfword:
; CHECK3-GISEL:       // %bb.0:
; CHECK3-GISEL-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    lsr w8, w1, #9
; CHECK3-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    mov x19, x0
; CHECK3-GISEL-NEXT:    and x21, x8, #0xff
; CHECK3-GISEL-NEXT:    ldrh w20, [x0, x21, lsl #1]
; CHECK3-GISEL-NEXT:    bl foo
; CHECK3-GISEL-NEXT:    mov w0, w20
; CHECK3-GISEL-NEXT:    strh w20, [x19, x21, lsl #1]
; CHECK3-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ret
  %shr81 = lshr i32 %xor72, 9
  %conv82 = zext i32 %shr81 to i64
  %idxprom83 = and i64 %conv82, 255
  %arrayidx86 = getelementptr inbounds %struct.a, ptr %ctx, i64 0, i64 %idxprom83
  %result = load i16, ptr %arrayidx86, align 2
  call void @foo()
  store i16 %result, ptr %arrayidx86, align 2
  ret i16 %result
}

define i32 @word(ptr %ctx, i32 %xor72) nounwind {
; CHECK0-SDAG-LABEL: word:
; CHECK0-SDAG:       // %bb.0:
; CHECK0-SDAG-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK0-SDAG-NEXT:    ubfx x21, x1, #9, #8
; CHECK0-SDAG-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    mov x19, x0
; CHECK0-SDAG-NEXT:    ldr w20, [x0, x21, lsl #2]
; CHECK0-SDAG-NEXT:    bl foo
; CHECK0-SDAG-NEXT:    mov w0, w20
; CHECK0-SDAG-NEXT:    str w20, [x19, x21, lsl #2]
; CHECK0-SDAG-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ret
;
; CHECK0-GISEL-LABEL: word:
; CHECK0-GISEL:       // %bb.0:
; CHECK0-GISEL-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    lsr w8, w1, #9
; CHECK0-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    mov x19, x0
; CHECK0-GISEL-NEXT:    and x21, x8, #0xff
; CHECK0-GISEL-NEXT:    ldr w20, [x0, x21, lsl #2]
; CHECK0-GISEL-NEXT:    bl foo
; CHECK0-GISEL-NEXT:    mov w0, w20
; CHECK0-GISEL-NEXT:    str w20, [x19, x21, lsl #2]
; CHECK0-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ret
;
; CHECK3-SDAG-LABEL: word:
; CHECK3-SDAG:       // %bb.0:
; CHECK3-SDAG-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK3-SDAG-NEXT:    ubfx x21, x1, #9, #8
; CHECK3-SDAG-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    mov x19, x0
; CHECK3-SDAG-NEXT:    ldr w20, [x0, x21, lsl #2]
; CHECK3-SDAG-NEXT:    bl foo
; CHECK3-SDAG-NEXT:    mov w0, w20
; CHECK3-SDAG-NEXT:    str w20, [x19, x21, lsl #2]
; CHECK3-SDAG-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ret
;
; CHECK3-GISEL-LABEL: word:
; CHECK3-GISEL:       // %bb.0:
; CHECK3-GISEL-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    lsr w8, w1, #9
; CHECK3-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    mov x19, x0
; CHECK3-GISEL-NEXT:    and x21, x8, #0xff
; CHECK3-GISEL-NEXT:    ldr w20, [x0, x21, lsl #2]
; CHECK3-GISEL-NEXT:    bl foo
; CHECK3-GISEL-NEXT:    mov w0, w20
; CHECK3-GISEL-NEXT:    str w20, [x19, x21, lsl #2]
; CHECK3-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ret
  %shr81 = lshr i32 %xor72, 9
  %conv82 = zext i32 %shr81 to i64
  %idxprom83 = and i64 %conv82, 255
  %arrayidx86 = getelementptr inbounds %struct.b, ptr %ctx, i64 0, i64 %idxprom83
  %result = load i32, ptr %arrayidx86, align 4
  call void @foo()
  store i32 %result, ptr %arrayidx86, align 4
  ret i32 %result
}

define i64 @doubleword(ptr %ctx, i32 %xor72) nounwind {
; CHECK0-SDAG-LABEL: doubleword:
; CHECK0-SDAG:       // %bb.0:
; CHECK0-SDAG-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK0-SDAG-NEXT:    ubfx x21, x1, #9, #8
; CHECK0-SDAG-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    mov x19, x0
; CHECK0-SDAG-NEXT:    ldr x20, [x0, x21, lsl #3]
; CHECK0-SDAG-NEXT:    bl foo
; CHECK0-SDAG-NEXT:    mov x0, x20
; CHECK0-SDAG-NEXT:    str x20, [x19, x21, lsl #3]
; CHECK0-SDAG-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ret
;
; CHECK0-GISEL-LABEL: doubleword:
; CHECK0-GISEL:       // %bb.0:
; CHECK0-GISEL-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    lsr w8, w1, #9
; CHECK0-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    mov x19, x0
; CHECK0-GISEL-NEXT:    and x21, x8, #0xff
; CHECK0-GISEL-NEXT:    ldr x20, [x0, x21, lsl #3]
; CHECK0-GISEL-NEXT:    bl foo
; CHECK0-GISEL-NEXT:    mov x0, x20
; CHECK0-GISEL-NEXT:    str x20, [x19, x21, lsl #3]
; CHECK0-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ret
;
; CHECK3-SDAG-LABEL: doubleword:
; CHECK3-SDAG:       // %bb.0:
; CHECK3-SDAG-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK3-SDAG-NEXT:    ubfx x21, x1, #9, #8
; CHECK3-SDAG-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    mov x19, x0
; CHECK3-SDAG-NEXT:    ldr x20, [x0, x21, lsl #3]
; CHECK3-SDAG-NEXT:    bl foo
; CHECK3-SDAG-NEXT:    mov x0, x20
; CHECK3-SDAG-NEXT:    str x20, [x19, x21, lsl #3]
; CHECK3-SDAG-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ret
;
; CHECK3-GISEL-LABEL: doubleword:
; CHECK3-GISEL:       // %bb.0:
; CHECK3-GISEL-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    lsr w8, w1, #9
; CHECK3-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    mov x19, x0
; CHECK3-GISEL-NEXT:    and x21, x8, #0xff
; CHECK3-GISEL-NEXT:    ldr x20, [x0, x21, lsl #3]
; CHECK3-GISEL-NEXT:    bl foo
; CHECK3-GISEL-NEXT:    mov x0, x20
; CHECK3-GISEL-NEXT:    str x20, [x19, x21, lsl #3]
; CHECK3-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ret
  %shr81 = lshr i32 %xor72, 9
  %conv82 = zext i32 %shr81 to i64
  %idxprom83 = and i64 %conv82, 255
  %arrayidx86 = getelementptr inbounds %struct.c, ptr %ctx, i64 0, i64 %idxprom83
  %result = load i64, ptr %arrayidx86, align 8
  call void @foo()
  store i64 %result, ptr %arrayidx86, align 8
  ret i64 %result
}

define i16 @multi_use_half_word(ptr %ctx, i32 %xor72) {
; CHECK0-SDAG-LABEL: multi_use_half_word:
; CHECK0-SDAG:       // %bb.0: // %entry
; CHECK0-SDAG-NEXT:    str x30, [sp, #-48]! // 8-byte Folded Spill
; CHECK0-SDAG-NEXT:    stp x22, x21, [sp, #16] // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK0-SDAG-NEXT:    .cfi_def_cfa_offset 48
; CHECK0-SDAG-NEXT:    .cfi_offset w19, -8
; CHECK0-SDAG-NEXT:    .cfi_offset w20, -16
; CHECK0-SDAG-NEXT:    .cfi_offset w21, -24
; CHECK0-SDAG-NEXT:    .cfi_offset w22, -32
; CHECK0-SDAG-NEXT:    .cfi_offset w30, -48
; CHECK0-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK0-SDAG-NEXT:    ubfx x8, x1, #9, #8
; CHECK0-SDAG-NEXT:    mov x19, x0
; CHECK0-SDAG-NEXT:    lsl x21, x8, #1
; CHECK0-SDAG-NEXT:    ldrh w20, [x0, x21]
; CHECK0-SDAG-NEXT:    add w22, w20, #1
; CHECK0-SDAG-NEXT:    bl foo
; CHECK0-SDAG-NEXT:    mov w0, w20
; CHECK0-SDAG-NEXT:    strh w22, [x19, x21]
; CHECK0-SDAG-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ldp x22, x21, [sp, #16] // 16-byte Folded Reload
; CHECK0-SDAG-NEXT:    ldr x30, [sp], #48 // 8-byte Folded Reload
; CHECK0-SDAG-NEXT:    ret
;
; CHECK0-GISEL-LABEL: multi_use_half_word:
; CHECK0-GISEL:       // %bb.0: // %entry
; CHECK0-GISEL-NEXT:    stp x30, x21, [sp, #-32]! // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK0-GISEL-NEXT:    .cfi_def_cfa_offset 32
; CHECK0-GISEL-NEXT:    .cfi_offset w19, -8
; CHECK0-GISEL-NEXT:    .cfi_offset w20, -16
; CHECK0-GISEL-NEXT:    .cfi_offset w21, -24
; CHECK0-GISEL-NEXT:    .cfi_offset w30, -32
; CHECK0-GISEL-NEXT:    lsr w8, w1, #9
; CHECK0-GISEL-NEXT:    add x20, x0, w8, uxtb #1
; CHECK0-GISEL-NEXT:    ldrh w19, [x20]
; CHECK0-GISEL-NEXT:    add w21, w19, #1
; CHECK0-GISEL-NEXT:    bl foo
; CHECK0-GISEL-NEXT:    strh w19, [x20]
; CHECK0-GISEL-NEXT:    mov w0, w19
; CHECK0-GISEL-NEXT:    strh w21, [x20]
; CHECK0-GISEL-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ldp x30, x21, [sp], #32 // 16-byte Folded Reload
; CHECK0-GISEL-NEXT:    ret
;
; CHECK3-SDAG-LABEL: multi_use_half_word:
; CHECK3-SDAG:       // %bb.0: // %entry
; CHECK3-SDAG-NEXT:    str x30, [sp, #-48]! // 8-byte Folded Spill
; CHECK3-SDAG-NEXT:    stp x22, x21, [sp, #16] // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK3-SDAG-NEXT:    .cfi_def_cfa_offset 48
; CHECK3-SDAG-NEXT:    .cfi_offset w19, -8
; CHECK3-SDAG-NEXT:    .cfi_offset w20, -16
; CHECK3-SDAG-NEXT:    .cfi_offset w21, -24
; CHECK3-SDAG-NEXT:    .cfi_offset w22, -32
; CHECK3-SDAG-NEXT:    .cfi_offset w30, -48
; CHECK3-SDAG-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK3-SDAG-NEXT:    ubfx x21, x1, #9, #8
; CHECK3-SDAG-NEXT:    mov x19, x0
; CHECK3-SDAG-NEXT:    ldrh w20, [x0, x21, lsl #1]
; CHECK3-SDAG-NEXT:    add w22, w20, #1
; CHECK3-SDAG-NEXT:    bl foo
; CHECK3-SDAG-NEXT:    mov w0, w20
; CHECK3-SDAG-NEXT:    strh w22, [x19, x21, lsl #1]
; CHECK3-SDAG-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ldp x22, x21, [sp, #16] // 16-byte Folded Reload
; CHECK3-SDAG-NEXT:    ldr x30, [sp], #48 // 8-byte Folded Reload
; CHECK3-SDAG-NEXT:    ret
;
; CHECK3-GISEL-LABEL: multi_use_half_word:
; CHECK3-GISEL:       // %bb.0: // %entry
; CHECK3-GISEL-NEXT:    str x30, [sp, #-48]! // 8-byte Folded Spill
; CHECK3-GISEL-NEXT:    stp x22, x21, [sp, #16] // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK3-GISEL-NEXT:    .cfi_def_cfa_offset 48
; CHECK3-GISEL-NEXT:    .cfi_offset w19, -8
; CHECK3-GISEL-NEXT:    .cfi_offset w20, -16
; CHECK3-GISEL-NEXT:    .cfi_offset w21, -24
; CHECK3-GISEL-NEXT:    .cfi_offset w22, -32
; CHECK3-GISEL-NEXT:    .cfi_offset w30, -48
; CHECK3-GISEL-NEXT:    lsr w8, w1, #9
; CHECK3-GISEL-NEXT:    mov x19, x0
; CHECK3-GISEL-NEXT:    and x21, x8, #0xff
; CHECK3-GISEL-NEXT:    ldrh w20, [x0, x21, lsl #1]
; CHECK3-GISEL-NEXT:    add w22, w20, #1
; CHECK3-GISEL-NEXT:    bl foo
; CHECK3-GISEL-NEXT:    strh w20, [x19, x21, lsl #1]
; CHECK3-GISEL-NEXT:    mov w0, w20
; CHECK3-GISEL-NEXT:    strh w22, [x19, x21, lsl #1]
; CHECK3-GISEL-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ldp x22, x21, [sp, #16] // 16-byte Folded Reload
; CHECK3-GISEL-NEXT:    ldr x30, [sp], #48 // 8-byte Folded Reload
; CHECK3-GISEL-NEXT:    ret
entry:
  %shr81 = lshr i32 %xor72, 9
  %conv82 = zext i32 %shr81 to i64
  %idxprom83 = and i64 %conv82, 255
  %arrayidx86 = getelementptr inbounds %struct.a, ptr %ctx, i64 0, i64 %idxprom83
  %result = load i16, ptr %arrayidx86, align 2
  %result2 = add i16 %result, 1
  call void @foo()
  store i16 %result, ptr %arrayidx86, align 2
  store i16 %result2, ptr %arrayidx86, align 2
  ret i16 %result
}

define i64 @multi_use_non_memory_call(i64 %a, i64 %b) {
; CHECK-LABEL: multi_use_non_memory_call:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    lsl x8, x0, #3
; CHECK-NEXT:    lsl x9, x1, #3
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.lt .LBB4_2
; CHECK-NEXT:  // %bb.1: // %falsebb
; CHECK-NEXT:    csel x0, x8, x9, gt
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_2: // %truebb
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl foo
entry:
  %mul1 = shl i64 %a, 3
  %mul2 = shl i64 %b, 3
  %cmp = icmp slt i64 %mul1, %mul2
  br i1 %cmp, label %truebb, label %falsebb
truebb:
  tail call void @foo()
  unreachable
falsebb:
  %cmp2 = icmp sgt i64 %mul1, %mul2
  br i1 %cmp2, label %exitbb, label %endbb
exitbb:
 ret i64 %mul1
endbb:
 ret i64 %mul2
}

define i64 @gep3(ptr %p, i64 %b) {
; CHECK-LABEL: gep3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    ldr x0, [x0, x1, lsl #3]
; CHECK-NEXT:    str x1, [x8, x1, lsl #3]
; CHECK-NEXT:    ret
  %g = getelementptr inbounds i64, ptr %p, i64 %b
  %l = load i64, ptr %g
  store i64 %b, ptr %g
  ret i64 %l
}

define i128 @gep4(ptr %p, i128 %a, i64 %b) {
; CHECK0-SDAG-LABEL: gep4:
; CHECK0-SDAG:       // %bb.0:
; CHECK0-SDAG-NEXT:    add x8, x0, x4, lsl #4
; CHECK0-SDAG-NEXT:    ldp x0, x1, [x8]
; CHECK0-SDAG-NEXT:    stp x2, x3, [x8]
; CHECK0-SDAG-NEXT:    ret
;
; CHECK0-GISEL-LABEL: gep4:
; CHECK0-GISEL:       // %bb.0:
; CHECK0-GISEL-NEXT:    add x8, x0, x4, lsl #4
; CHECK0-GISEL-NEXT:    mov v0.d[0], x2
; CHECK0-GISEL-NEXT:    ldr q1, [x8]
; CHECK0-GISEL-NEXT:    mov d2, v1.d[1]
; CHECK0-GISEL-NEXT:    mov v0.d[1], x3
; CHECK0-GISEL-NEXT:    fmov x0, d1
; CHECK0-GISEL-NEXT:    fmov x1, d2
; CHECK0-GISEL-NEXT:    str q0, [x8]
; CHECK0-GISEL-NEXT:    ret
;
; CHECK3-SDAG-LABEL: gep4:
; CHECK3-SDAG:       // %bb.0:
; CHECK3-SDAG-NEXT:    add x8, x0, x4, lsl #4
; CHECK3-SDAG-NEXT:    ldp x0, x1, [x8]
; CHECK3-SDAG-NEXT:    stp x2, x3, [x8]
; CHECK3-SDAG-NEXT:    ret
;
; CHECK3-GISEL-LABEL: gep4:
; CHECK3-GISEL:       // %bb.0:
; CHECK3-GISEL-NEXT:    ldr q1, [x0, x4, lsl #4]
; CHECK3-GISEL-NEXT:    mov v0.d[0], x2
; CHECK3-GISEL-NEXT:    mov x8, x0
; CHECK3-GISEL-NEXT:    mov d2, v1.d[1]
; CHECK3-GISEL-NEXT:    fmov x0, d1
; CHECK3-GISEL-NEXT:    mov v0.d[1], x3
; CHECK3-GISEL-NEXT:    fmov x1, d2
; CHECK3-GISEL-NEXT:    str q0, [x8, x4, lsl #4]
; CHECK3-GISEL-NEXT:    ret
  %g = getelementptr inbounds i128, ptr %p, i64 %b
  %l = load i128, ptr %g
  store i128 %a, ptr %g
  ret i128 %l
}

define i64 @addlsl3(i64 %a, i64 %b) {
; CHECK-LABEL: addlsl3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl x8, x0, #3
; CHECK-NEXT:    add x9, x1, x8
; CHECK-NEXT:    sub x8, x1, x8
; CHECK-NEXT:    eor x0, x9, x8
; CHECK-NEXT:    ret
  %x = shl i64 %a, 3
  %y = add i64 %b, %x
  %z = sub i64 %b, %x
  %r = xor i64 %y, %z
  ret i64 %r
}

define i64 @addlsl4(i64 %a, i64 %b) {
; CHECK-LABEL: addlsl4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl x8, x0, #4
; CHECK-NEXT:    add x9, x1, x8
; CHECK-NEXT:    sub x8, x1, x8
; CHECK-NEXT:    eor x0, x9, x8
; CHECK-NEXT:    ret
  %x = shl i64 %a, 4
  %y = add i64 %b, %x
  %z = sub i64 %b, %x
  %r = xor i64 %y, %z
  ret i64 %r
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK0: {{.*}}
; CHECK3: {{.*}}
