# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=cortex-a55 -timeline -timeline-max-iterations=1 -timeline-max-cycles=1000 < %s | FileCheck %s

# This test demonstrates the latency into a load address operand.

add      x2, x3, #1
ldr      b0, [x2, #16]
add      x2, x3, #1
ldr      b0, [x2, #16]!
add      x2, x3, #1
ldr      b0, [x2], #16
add      x2, x3, #1
ldr      d0, [x2], #16
add      x2, x3, #1
ldr      d0, [x2, #16]!
add      x2, x3, #1
ldr      d0, [x2, #16]
add      x2, x3, #1
ldr      h0, [x2], #16
add      x2, x3, #1
ldr      h0, [x2, #16]!
add      x2, x3, #1
ldr      h0, [x2, #16]
add      x2, x3, #1
ldr      q0, [x2], #16
add      x2, x3, #1
ldr      q0, [x2, #16]!
add      x2, x3, #1
ldr      q0, [x2, #16]
add      x2, x3, #1
ldr      s0, [x2], #16
add      x2, x3, #1
ldr      s0, [x2, #16]!
add      x2, x3, #1
ldr      s0, [x2, #16]
add      x2, x3, #1
ldr      w0, [x2], #16
add      x2, x3, #1
ldr      w0, [x2, #16]!
add      x2, x3, #1
ldr      w0, [x2, #16]
add      x2, x3, #1
ldr      x0, [x2], #16
add      x2, x3, #1
ldr      x0, [x2, #16]!
add      x2, x3, #1
ldr      x0, [x2, #16]
add      x2, x3, #1
ldrb     w0, [x2], #16
add      x2, x3, #1
ldrb     w0, [x2, #16]!
add      x2, x3, #1
ldrb     w0, [x2, #16]
add      x2, x3, #1
ldrsb    w0, [x2], #16
add      x2, x3, #1
ldrsb    w0, [x2, #16]!
add      x2, x3, #1
ldrsb    w0, [x2, #16]
add      x2, x3, #1
ldrh     w0, [x2], #16
add      x2, x3, #1
ldrh     w0, [x2, #16]!
add      x2, x3, #1
ldrh     w0, [x2, #16]
add      x2, x3, #1
ldrsh    w0, [x2], #16
add      x2, x3, #1
ldrsh    w0, [x2, #16]!
add      x2, x3, #1
ldrsh    w0, [x2, #16]
add      x2, x3, #1
ldrsw    x0, [x2], #16
add      x2, x3, #1
ldrsw    x0, [x2, #16]!
add      x2, x3, #1
ldrsw    x0, [x2, #16]
add      x2, x3, #1
ldr      d0, [x2, x2, lsl #3]
add      x2, x3, #1
ldr      q0, [x2, w0, sxtw]
add      x2, x3, #1
ldr      w0, [x2, w0, sxtw]
add      x2, x3, #1
ldr      x0, [x2, w0, sxtw]
add      x2, x3, #1
ldrb     w0, [x2, w0, sxtw]
add      x2, x3, #1
ldrsb    w0, [x2, w0, sxtw]
add      x2, x3, #1
ldrh     w0, [x2, w0, sxtw]
add      x2, x3, #1
ldrsh    w0, [x2, w0, sxtw]
add      x2, x3, #1
ldrsw    x0, [x2, w0, sxtw]
add      x2, x3, #1
ldur     b0, [x2, #255]
add      x2, x3, #1
ldur     d0, [x2, #255]
add      x2, x3, #1
ldur     h0, [x2, #255]
add      x2, x3, #1
ldur     q0, [x2, #255]
add      x2, x3, #1
ldur     s0, [x2, #255]
add      x2, x3, #1
ldur     w0, [x2, #255]
add      x2, x3, #1
ldurb    w0, [x2, #255]
add      x2, x3, #1
ldurh    w0, [x2, #255]
add      x2, x3, #1
ldursb   w0, [x2, #255]
add      x2, x3, #1
ldursh   w0, [x2, #255]
add      x2, x3, #1
ldursw   x0, [x2, #255]

add      x2, x3, #1
ldnp     d0, d1, [x2, #16]
add      x2, x3, #1
ldnp     q0, q1, [x2, #16]
add      x2, x3, #1
ldnp     s0, s1, [x2, #16]
add      x2, x3, #1
ldnp     s0, s1, [x2, #16]
add      x2, x3, #1
ldnp     w0, w1, [x2, #16]
add      x2, x3, #1
ldnp     x0, x1, [x2, #16]
add      x2, x3, #1
ldp      d0, d1, [x2, #16]
add      x2, x3, #1
ldp      d0, d1, [x2, #16]!
add      x2, x3, #1
ldp      d0, d1, [x2], #16
add      x2, x3, #1
ldp      q0, q1, [x2, #16]
add      x2, x3, #1
ldp      q0, q1, [x2, #16]!
add      x2, x3, #1
ldp      q0, q1, [x2], #16
add      x2, x3, #1
ldp      s0, s1, [x2, #16]
add      x2, x3, #1
ldp      s0, s1, [x2, #16]!
add      x2, x3, #1
ldp      s0, s1, [x2], #16
add      x2, x3, #1
ldp      x0, x1, [x2, #16]
add      x2, x3, #1
ldp      x0, x1, [x2, #16]!
add      x2, x3, #1
ldp      x0, x1, [x2], #16
add      x2, x3, #1
ldpsw    x0, x1, [x2, #16]
add      x2, x3, #1
ldpsw    x0, x1, [x2, #16]!
add      x2, x3, #1
ldpsw    x0, x1, [x2], #16

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      15400
# CHECK-NEXT: Total Cycles:      30303
# CHECK-NEXT: Total uOps:        20900

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.69
# CHECK-NEXT: IPC:               0.51
# CHECK-NEXT: Block RThroughput: 104.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	b0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	b0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	b0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	d0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	d0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	d0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	h0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	h0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	h0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	q0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	q0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	q0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	s0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	s0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	s0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	x0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldr	x0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldr	x0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrb	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrb	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldrb	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrsb	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrsb	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldrsb	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrh	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrh	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldrh	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrsh	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrsh	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldrsh	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrsw	x0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      3     1.00    *                   ldrsw	x0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldrsw	x0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldr	d0, [x2, x2, lsl #3]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldr	q0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldr	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldr	x0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldrb	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldrsb	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldrh	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldrsh	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      4     1.00    *                   ldrsw	x0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldur	b0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldur	d0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldur	h0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldur	q0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldur	s0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldur	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldurb	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldurh	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldursb	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldursh	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      3     1.00    *                   ldursw	x0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldnp	d0, d1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldnp	q0, q1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldnp	s0, s1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldnp	s0, s1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldnp	w0, w1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldnp	x0, x1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldp	d0, d1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      5     2.00    *                   ldp	d0, d1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      5     2.00    *                   ldp	d0, d1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      6     6.00    *                   ldp	q0, q1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      6     6.00    *                   ldp	q0, q1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      6     6.00    *                   ldp	q0, q1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      4     1.00    *                   ldp	s0, s1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      4     1.00    *                   ldp	s0, s1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      4     1.00    *                   ldp	s0, s1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      5     2.00    *                   ldp	x0, x1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      5     2.00    *                   ldp	x0, x1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      5     2.00    *                   ldp	x0, x1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      4     1.00    *                   ldpsw	x0, x1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      4     1.00    *                   ldpsw	x0, x1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  3      4     1.00    *                   ldpsw	x0, x1, [x2], #16

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - CortexA55UnitALU
# CHECK-NEXT: [0.1] - CortexA55UnitALU
# CHECK-NEXT: [1]   - CortexA55UnitB
# CHECK-NEXT: [2]   - CortexA55UnitDiv
# CHECK-NEXT: [3.0] - CortexA55UnitFPALU
# CHECK-NEXT: [3.1] - CortexA55UnitFPALU
# CHECK-NEXT: [4]   - CortexA55UnitFPDIV
# CHECK-NEXT: [5.0] - CortexA55UnitFPMAC
# CHECK-NEXT: [5.1] - CortexA55UnitFPMAC
# CHECK-NEXT: [6]   - CortexA55UnitLd
# CHECK-NEXT: [7]   - CortexA55UnitMAC
# CHECK-NEXT: [8]   - CortexA55UnitSt

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4]    [5.0]  [5.1]  [6]    [7]    [8]
# CHECK-NEXT: 38.50  38.50   -      -      -      -      -      -      -     104.00  -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4]    [5.0]  [5.1]  [6]    [7]    [8]    Instructions:
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	b0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	b0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	b0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	d0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	d0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	d0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	h0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	h0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	h0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	q0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	q0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	q0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	s0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	s0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	s0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	x0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	x0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	x0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrb	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrb	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrb	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsb	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsb	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsb	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrh	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrh	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrh	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsh	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsh	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsh	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsw	x0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsw	x0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsw	x0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	d0, [x2, x2, lsl #3]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	q0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldr	x0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrb	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsb	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrh	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsh	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldrsw	x0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldur	b0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldur	d0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldur	h0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldur	q0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldur	s0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldur	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldurb	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldurh	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldursb	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldursh	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldursw	x0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldnp	d0, d1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldnp	q0, q1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldnp	s0, s1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldnp	s0, s1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldnp	w0, w1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldnp	x0, x1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldp	d0, d1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldp	d0, d1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldp	d0, d1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     6.00    -      -     ldp	q0, q1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     6.00    -      -     ldp	q0, q1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     6.00    -      -     ldp	q0, q1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldp	s0, s1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldp	s0, s1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldp	s0, s1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldp	x0, x1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldp	x0, x1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -     ldp	x0, x1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldpsw	x0, x1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldpsw	x0, x1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     ldpsw	x0, x1, [x2], #16

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          012345

# CHECK:      [0,0]     DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,1]     .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	b0, [x2, #16]
# CHECK-NEXT: [0,2]     .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,3]     .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	b0, [x2, #16]!
# CHECK-NEXT: [0,4]     .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,5]     .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	b0, [x2], #16
# CHECK-NEXT: [0,6]     .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,7]     .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	d0, [x2], #16
# CHECK-NEXT: [0,8]     .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,9]     .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	d0, [x2, #16]!
# CHECK-NEXT: [0,10]    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,11]    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	d0, [x2, #16]
# CHECK-NEXT: [0,12]    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,13]    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	h0, [x2], #16
# CHECK-NEXT: [0,14]    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,15]    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	h0, [x2, #16]!
# CHECK-NEXT: [0,16]    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,17]    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	h0, [x2, #16]
# CHECK-NEXT: [0,18]    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,19]    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	q0, [x2], #16
# CHECK-NEXT: [0,20]    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,21]    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	q0, [x2, #16]!
# CHECK-NEXT: [0,22]    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,23]    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	q0, [x2, #16]
# CHECK-NEXT: [0,24]    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,25]    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	s0, [x2], #16
# CHECK-NEXT: [0,26]    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,27]    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	s0, [x2, #16]!
# CHECK-NEXT: [0,28]    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,29]    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	s0, [x2, #16]
# CHECK-NEXT: [0,30]    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,31]    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	w0, [x2], #16
# CHECK-NEXT: [0,32]    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,33]    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	w0, [x2, #16]!
# CHECK-NEXT: [0,34]    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,35]    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	w0, [x2, #16]
# CHECK-NEXT: [0,36]    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,37]    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	x0, [x2], #16
# CHECK-NEXT: [0,38]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,39]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	x0, [x2, #16]!
# CHECK-NEXT: [0,40]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,41]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	x0, [x2, #16]
# CHECK-NEXT: [0,42]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,43]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrb	w0, [x2], #16
# CHECK-NEXT: [0,44]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,45]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrb	w0, [x2, #16]!
# CHECK-NEXT: [0,46]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,47]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrb	w0, [x2, #16]
# CHECK-NEXT: [0,48]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,49]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsb	w0, [x2], #16
# CHECK-NEXT: [0,50]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,51]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsb	w0, [x2, #16]!
# CHECK-NEXT: [0,52]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,53]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsb	w0, [x2, #16]
# CHECK-NEXT: [0,54]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,55]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrh	w0, [x2], #16
# CHECK-NEXT: [0,56]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,57]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrh	w0, [x2, #16]!
# CHECK-NEXT: [0,58]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,59]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrh	w0, [x2, #16]
# CHECK-NEXT: [0,60]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,61]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsh	w0, [x2], #16
# CHECK-NEXT: [0,62]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,63]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsh	w0, [x2, #16]!
# CHECK-NEXT: [0,64]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,65]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsh	w0, [x2, #16]
# CHECK-NEXT: [0,66]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,67]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsw	x0, [x2], #16
# CHECK-NEXT: [0,68]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,69]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsw	x0, [x2, #16]!
# CHECK-NEXT: [0,70]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,71]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsw	x0, [x2, #16]
# CHECK-NEXT: [0,72]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,73]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	d0, [x2, x2, lsl #3]
# CHECK-NEXT: [0,74]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,75]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	q0, [x2, w0, sxtw]
# CHECK-NEXT: [0,76]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,77]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,78]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,79]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldr	x0, [x2, w0, sxtw]
# CHECK-NEXT: [0,80]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,81]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrb	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,82]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,83]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsb	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,84]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,85]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrh	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,86]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,87]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsh	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,88]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,89]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldrsw	x0, [x2, w0, sxtw]
# CHECK-NEXT: [0,90]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,91]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldur	b0, [x2, #255]
# CHECK-NEXT: [0,92]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,93]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldur	d0, [x2, #255]
# CHECK-NEXT: [0,94]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,95]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldur	h0, [x2, #255]
# CHECK-NEXT: [0,96]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,97]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldur	q0, [x2, #255]
# CHECK-NEXT: [0,98]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,99]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldur	s0, [x2, #255]
# CHECK-NEXT: [0,100]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,101]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldur	w0, [x2, #255]
# CHECK-NEXT: [0,102]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,103]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldurb	w0, [x2, #255]
# CHECK-NEXT: [0,104]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,105]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldurh	w0, [x2, #255]
# CHECK-NEXT: [0,106]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,107]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldursb	w0, [x2, #255]
# CHECK-NEXT: [0,108]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,109]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldursh	w0, [x2, #255]
# CHECK-NEXT: [0,110]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,111]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldursw	x0, [x2, #255]
# CHECK-NEXT: [0,112]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,113]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldnp	d0, d1, [x2, #16]
# CHECK-NEXT: [0,114]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,115]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldnp	q0, q1, [x2, #16]
# CHECK-NEXT: [0,116]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,117]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldnp	s0, s1, [x2, #16]
# CHECK-NEXT: [0,118]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,119]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldnp	s0, s1, [x2, #16]
# CHECK-NEXT: [0,120]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,121]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldnp	w0, w1, [x2, #16]
# CHECK-NEXT: [0,122]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,123]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldnp	x0, x1, [x2, #16]
# CHECK-NEXT: [0,124]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,125]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .   ldp	d0, d1, [x2, #16]
# CHECK-NEXT: [0,126]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,127]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .    .   ldp	d0, d1, [x2, #16]!
# CHECK-NEXT: [0,128]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,129]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .    .    .    .    .    .    .    .   ldp	d0, d1, [x2], #16
# CHECK-NEXT: [0,130]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,131]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeeE .    .    .    .    .    .    .    .    .    .    .   ldp	q0, q1, [x2, #16]
# CHECK-NEXT: [0,132]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,133]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeeeeE.    .    .    .    .    .    .    .    .    .   ldp	q0, q1, [x2, #16]!
# CHECK-NEXT: [0,134]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,135]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeeeeE    .    .    .    .    .    .    .    .   ldp	q0, q1, [x2], #16
# CHECK-NEXT: [0,136]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,137]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeeE.    .    .    .    .    .    .    .   ldp	s0, s1, [x2, #16]
# CHECK-NEXT: [0,138]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,139]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeeE .    .    .    .    .    .    .   ldp	s0, s1, [x2, #16]!
# CHECK-NEXT: [0,140]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,141]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeeE  .    .    .    .    .    .   ldp	s0, s1, [x2], #16
# CHECK-NEXT: [0,142]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,143]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .    .   ldp	x0, x1, [x2, #16]
# CHECK-NEXT: [0,144]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,145]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .    .   ldp	x0, x1, [x2, #16]!
# CHECK-NEXT: [0,146]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,147]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeeE  .    .    .   ldp	x0, x1, [x2], #16
# CHECK-NEXT: [0,148]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .   add	x2, x3, #1
# CHECK-NEXT: [0,149]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeeE   .    .   ldpsw	x0, x1, [x2, #16]
# CHECK-NEXT: [0,150]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .   add	x2, x3, #1
# CHECK-NEXT: [0,151]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeeE    .   ldpsw	x0, x1, [x2, #16]!
# CHECK-NEXT: [0,152]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .   add	x2, x3, #1
# CHECK-NEXT: [0,153]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeeE   ldpsw	x0, x1, [x2], #16

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       ldr	b0, [x2, #16]
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       ldr	b0, [x2, #16]!
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       ldr	b0, [x2], #16
# CHECK-NEXT: 6.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 7.     1     0.0    0.0    0.0       ldr	d0, [x2], #16
# CHECK-NEXT: 8.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 9.     1     0.0    0.0    0.0       ldr	d0, [x2, #16]!
# CHECK-NEXT: 10.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 11.    1     0.0    0.0    0.0       ldr	d0, [x2, #16]
# CHECK-NEXT: 12.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 13.    1     0.0    0.0    0.0       ldr	h0, [x2], #16
# CHECK-NEXT: 14.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 15.    1     0.0    0.0    0.0       ldr	h0, [x2, #16]!
# CHECK-NEXT: 16.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 17.    1     0.0    0.0    0.0       ldr	h0, [x2, #16]
# CHECK-NEXT: 18.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 19.    1     0.0    0.0    0.0       ldr	q0, [x2], #16
# CHECK-NEXT: 20.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 21.    1     0.0    0.0    0.0       ldr	q0, [x2, #16]!
# CHECK-NEXT: 22.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 23.    1     0.0    0.0    0.0       ldr	q0, [x2, #16]
# CHECK-NEXT: 24.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 25.    1     0.0    0.0    0.0       ldr	s0, [x2], #16
# CHECK-NEXT: 26.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 27.    1     0.0    0.0    0.0       ldr	s0, [x2, #16]!
# CHECK-NEXT: 28.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 29.    1     0.0    0.0    0.0       ldr	s0, [x2, #16]
# CHECK-NEXT: 30.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 31.    1     0.0    0.0    0.0       ldr	w0, [x2], #16
# CHECK-NEXT: 32.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 33.    1     0.0    0.0    0.0       ldr	w0, [x2, #16]!
# CHECK-NEXT: 34.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 35.    1     0.0    0.0    0.0       ldr	w0, [x2, #16]
# CHECK-NEXT: 36.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 37.    1     0.0    0.0    0.0       ldr	x0, [x2], #16
# CHECK-NEXT: 38.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 39.    1     0.0    0.0    0.0       ldr	x0, [x2, #16]!
# CHECK-NEXT: 40.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 41.    1     0.0    0.0    0.0       ldr	x0, [x2, #16]
# CHECK-NEXT: 42.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 43.    1     0.0    0.0    0.0       ldrb	w0, [x2], #16
# CHECK-NEXT: 44.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 45.    1     0.0    0.0    0.0       ldrb	w0, [x2, #16]!
# CHECK-NEXT: 46.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 47.    1     0.0    0.0    0.0       ldrb	w0, [x2, #16]
# CHECK-NEXT: 48.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 49.    1     0.0    0.0    0.0       ldrsb	w0, [x2], #16
# CHECK-NEXT: 50.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 51.    1     0.0    0.0    0.0       ldrsb	w0, [x2, #16]!
# CHECK-NEXT: 52.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 53.    1     0.0    0.0    0.0       ldrsb	w0, [x2, #16]
# CHECK-NEXT: 54.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 55.    1     0.0    0.0    0.0       ldrh	w0, [x2], #16
# CHECK-NEXT: 56.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 57.    1     0.0    0.0    0.0       ldrh	w0, [x2, #16]!
# CHECK-NEXT: 58.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 59.    1     0.0    0.0    0.0       ldrh	w0, [x2, #16]
# CHECK-NEXT: 60.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 61.    1     0.0    0.0    0.0       ldrsh	w0, [x2], #16
# CHECK-NEXT: 62.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 63.    1     0.0    0.0    0.0       ldrsh	w0, [x2, #16]!
# CHECK-NEXT: 64.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 65.    1     0.0    0.0    0.0       ldrsh	w0, [x2, #16]
# CHECK-NEXT: 66.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 67.    1     0.0    0.0    0.0       ldrsw	x0, [x2], #16
# CHECK-NEXT: 68.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 69.    1     0.0    0.0    0.0       ldrsw	x0, [x2, #16]!
# CHECK-NEXT: 70.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 71.    1     0.0    0.0    0.0       ldrsw	x0, [x2, #16]
# CHECK-NEXT: 72.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 73.    1     0.0    0.0    0.0       ldr	d0, [x2, x2, lsl #3]
# CHECK-NEXT: 74.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 75.    1     0.0    0.0    0.0       ldr	q0, [x2, w0, sxtw]
# CHECK-NEXT: 76.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 77.    1     0.0    0.0    0.0       ldr	w0, [x2, w0, sxtw]
# CHECK-NEXT: 78.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 79.    1     0.0    0.0    0.0       ldr	x0, [x2, w0, sxtw]
# CHECK-NEXT: 80.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 81.    1     0.0    0.0    0.0       ldrb	w0, [x2, w0, sxtw]
# CHECK-NEXT: 82.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 83.    1     0.0    0.0    0.0       ldrsb	w0, [x2, w0, sxtw]
# CHECK-NEXT: 84.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 85.    1     0.0    0.0    0.0       ldrh	w0, [x2, w0, sxtw]
# CHECK-NEXT: 86.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 87.    1     0.0    0.0    0.0       ldrsh	w0, [x2, w0, sxtw]
# CHECK-NEXT: 88.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 89.    1     0.0    0.0    0.0       ldrsw	x0, [x2, w0, sxtw]
# CHECK-NEXT: 90.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 91.    1     0.0    0.0    0.0       ldur	b0, [x2, #255]
# CHECK-NEXT: 92.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 93.    1     0.0    0.0    0.0       ldur	d0, [x2, #255]
# CHECK-NEXT: 94.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 95.    1     0.0    0.0    0.0       ldur	h0, [x2, #255]
# CHECK-NEXT: 96.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 97.    1     0.0    0.0    0.0       ldur	q0, [x2, #255]
# CHECK-NEXT: 98.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 99.    1     0.0    0.0    0.0       ldur	s0, [x2, #255]
# CHECK-NEXT: 100.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 101.   1     0.0    0.0    0.0       ldur	w0, [x2, #255]
# CHECK-NEXT: 102.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 103.   1     0.0    0.0    0.0       ldurb	w0, [x2, #255]
# CHECK-NEXT: 104.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 105.   1     0.0    0.0    0.0       ldurh	w0, [x2, #255]
# CHECK-NEXT: 106.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 107.   1     0.0    0.0    0.0       ldursb	w0, [x2, #255]
# CHECK-NEXT: 108.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 109.   1     0.0    0.0    0.0       ldursh	w0, [x2, #255]
# CHECK-NEXT: 110.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 111.   1     0.0    0.0    0.0       ldursw	x0, [x2, #255]
# CHECK-NEXT: 112.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 113.   1     0.0    0.0    0.0       ldnp	d0, d1, [x2, #16]
# CHECK-NEXT: 114.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 115.   1     0.0    0.0    0.0       ldnp	q0, q1, [x2, #16]
# CHECK-NEXT: 116.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 117.   1     0.0    0.0    0.0       ldnp	s0, s1, [x2, #16]
# CHECK-NEXT: 118.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 119.   1     0.0    0.0    0.0       ldnp	s0, s1, [x2, #16]
# CHECK-NEXT: 120.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 121.   1     0.0    0.0    0.0       ldnp	w0, w1, [x2, #16]
# CHECK-NEXT: 122.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 123.   1     0.0    0.0    0.0       ldnp	x0, x1, [x2, #16]
# CHECK-NEXT: 124.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 125.   1     0.0    0.0    0.0       ldp	d0, d1, [x2, #16]
# CHECK-NEXT: 126.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 127.   1     0.0    0.0    0.0       ldp	d0, d1, [x2, #16]!
# CHECK-NEXT: 128.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 129.   1     0.0    0.0    0.0       ldp	d0, d1, [x2], #16
# CHECK-NEXT: 130.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 131.   1     0.0    0.0    0.0       ldp	q0, q1, [x2, #16]
# CHECK-NEXT: 132.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 133.   1     0.0    0.0    0.0       ldp	q0, q1, [x2, #16]!
# CHECK-NEXT: 134.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 135.   1     0.0    0.0    0.0       ldp	q0, q1, [x2], #16
# CHECK-NEXT: 136.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 137.   1     0.0    0.0    0.0       ldp	s0, s1, [x2, #16]
# CHECK-NEXT: 138.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 139.   1     0.0    0.0    0.0       ldp	s0, s1, [x2, #16]!
# CHECK-NEXT: 140.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 141.   1     0.0    0.0    0.0       ldp	s0, s1, [x2], #16
# CHECK-NEXT: 142.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 143.   1     0.0    0.0    0.0       ldp	x0, x1, [x2, #16]
# CHECK-NEXT: 144.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 145.   1     0.0    0.0    0.0       ldp	x0, x1, [x2, #16]!
# CHECK-NEXT: 146.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 147.   1     0.0    0.0    0.0       ldp	x0, x1, [x2], #16
# CHECK-NEXT: 148.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 149.   1     0.0    0.0    0.0       ldpsw	x0, x1, [x2, #16]
# CHECK-NEXT: 150.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 151.   1     0.0    0.0    0.0       ldpsw	x0, x1, [x2, #16]!
# CHECK-NEXT: 152.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 153.   1     0.0    0.0    0.0       ldpsw	x0, x1, [x2], #16
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
