; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=dse -enable-dse-partial-store-merging -S < %s | FileCheck %s
target datalayout = "E-m:e-i64:64-i128:128-n32:64-S128"

define void @byte_by_byte_replacement(ptr %ptr) {
; CHECK-LABEL: @byte_by_byte_replacement(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 151653132, ptr [[PTR:%.*]]
; CHECK-NEXT:    ret void
;
entry:
  ;; This store's value should be modified as it should be better to use one
  ;; larger store than several smaller ones.
  ;; store will turn into 0x090A0B0C == 151653132
  store i32 305419896, ptr %ptr  ; 0x12345678
  %bptr1 = getelementptr inbounds i8, ptr %ptr, i64 1
  %bptr2 = getelementptr inbounds i8, ptr %ptr, i64 2
  %bptr3 = getelementptr inbounds i8, ptr %ptr, i64 3

  ;; We should be able to merge these four stores with the i32 above
  ; value (and bytes) stored before  ; 0x12345678
  store i8 9, ptr %ptr              ;   09
  store i8 10, ptr %bptr1            ;     0A
  store i8 11, ptr %bptr2            ;       0B
  store i8 12, ptr %bptr3            ;         0C
  ;                                    0x090A0B0C

  ret void
}

define void @word_replacement(ptr %ptr) {
; CHECK-LABEL: @word_replacement(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i64 72638273700655232, ptr [[PTR:%.*]]
; CHECK-NEXT:    ret void
;
entry:
  store i64 72623859790382856, ptr %ptr  ; 0x0102030405060708

  %wptr1 = getelementptr inbounds i16, ptr %ptr, i64 1
  %wptr3 = getelementptr inbounds i16, ptr %ptr, i64 3

  ;; We should be able to merge these two stores with the i64 one above
  ; value (and bytes) stored before  ; 0x0102030405060708
  store i16  4128, ptr %wptr1       ;       1020
  store i16 28800, ptr %wptr3       ;               7080
  ;                                    0x0102102005067080

  ret void
}


define void @differently_sized_replacements(ptr %ptr) {
; CHECK-LABEL: @differently_sized_replacements(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i64 289077004501059343, ptr [[PTR:%.*]]
; CHECK-NEXT:    ret void
;
entry:
  store i64 579005069656919567, ptr %ptr  ; 0x08090a0b0c0d0e0f

  %bptr6 = getelementptr inbounds i8, ptr %ptr, i64 6
  %wptr2 = getelementptr inbounds i16, ptr %ptr, i64 2

  ;; We should be able to merge all these stores with the i64 one above
  ; value (and bytes) stored before  ; 0x08090a0b0c0d0e0f
  store i8         7, ptr  %bptr6    ;               07
  store i16     1541, ptr %wptr2    ;           0605
  store i32 67305985, ptr %ptr     ;   04030201
  ;                                    0x040302010605070f
  ret void
}


define void @multiple_replacements_to_same_byte(ptr %ptr) {
; CHECK-LABEL: @multiple_replacements_to_same_byte(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i64 289077004602248719, ptr [[PTR:%.*]]
; CHECK-NEXT:    ret void
;
entry:
  store i64 579005069656919567, ptr %ptr  ; 0x08090a0b0c0d0e0f

  %bptr3 = getelementptr inbounds i8, ptr %ptr, i64 3
  %wptr1 = getelementptr inbounds i16, ptr %ptr, i64 1

  ;; We should be able to merge all these stores with the i64 one above
  ; value (and bytes) stored before  ; 0x08090a0b0c0d0e0f
  store i8         7, ptr  %bptr3    ;         07
  store i16     1541, ptr %wptr1    ;       0605
  store i32 67305985, ptr %ptr     ;   04030201
  ;                                    0x040302010c0d0e0f
  ret void
}

define void @merged_merges(ptr %ptr) {
; CHECK-LABEL: @merged_merges(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i64 289081428418563599, ptr [[PTR:%.*]]
; CHECK-NEXT:    ret void
;
entry:
  store i64 579005069656919567, ptr %ptr  ; 0x08090a0b0c0d0e0f

  %bptr3 = getelementptr inbounds i8, ptr %ptr, i64 3
  %wptr1 = getelementptr inbounds i16, ptr %ptr, i64 1

  ;; We should be able to merge all these stores with the i64 one above
  ; value (not bytes) stored before  ; 0x08090a0b0c0d0e0f
  store i32 67305985, ptr %ptr     ;   04030201
  store i16     1541, ptr %wptr1    ;       0605
  store i8         7, ptr  %bptr3    ;         07
  ;                                    0x040306070c0d0e0f
  ret void
}

define signext i8 @shouldnt_merge_since_theres_a_full_overlap(ptr %ptr) {
; CHECK-LABEL: @shouldnt_merge_since_theres_a_full_overlap(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[BPTRM1:%.*]] = getelementptr inbounds i8, ptr [[PTR:%.*]], i64 -1
; CHECK-NEXT:    [[BPTR3:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 3
; CHECK-NEXT:    store i32 1234, ptr [[BPTRM1]], align 1
; CHECK-NEXT:    store i64 5678, ptr [[BPTR3]], align 1
; CHECK-NEXT:    ret i8 0
;
entry:

  store i64 0, ptr %ptr

  %bptrm1 = getelementptr inbounds i8, ptr %ptr, i64 -1
  %bptr3 = getelementptr inbounds i8, ptr %ptr, i64 3

  store i32 1234, ptr %bptrm1, align 1
  store i64 5678, ptr %bptr3, align 1

  ret i8 0
}

;; Test case from PR31777
%union.U = type { i64 }

define void @foo(ptr nocapture %u) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i64 11821949021847552, ptr [[U:%.*]], align 8
; CHECK-NEXT:    ret void
;
entry:
  store i64 0, ptr %u, align 8
  store i16 42, ptr %u, align 8
  ret void
}
