; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=avx512fp16 -O3 | FileCheck %s --check-prefixes=CHECK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512fp16 -O3 | FileCheck %s --check-prefixes=CHECK


declare <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f16(<8 x half>, metadata)
declare <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f16(<8 x half>, metadata)
declare <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f16(<16 x half>, metadata)
declare <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f16(<16 x half>, metadata)
declare <32 x i16> @llvm.experimental.constrained.fptosi.v32i16.v32f16(<32 x half>, metadata)
declare <32 x i16> @llvm.experimental.constrained.fptoui.v32i16.v32f16(<32 x half>, metadata)
declare <32 x i8> @llvm.experimental.constrained.fptosi.v32i8.v32f16(<32 x half>, metadata)
declare <32 x i8> @llvm.experimental.constrained.fptoui.v32i8.v32f16(<32 x half>, metadata)
declare <32 x i1> @llvm.experimental.constrained.fptosi.v32i1.v32f16(<32 x half>, metadata)
declare <32 x i1> @llvm.experimental.constrained.fptoui.v32i1.v32f16(<32 x half>, metadata)

define <8 x i64> @strict_vector_fptosi_v8f16_to_v8i64(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2qq %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i64> %ret
}

define <8 x i64> @strict_vector_fptoui_v8f16_to_v8i64(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uqq %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i64> %ret
}

define <16 x i32> @strict_vector_fptosi_v16f16_to_v16i32(<16 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v16f16_to_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2dq %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f16(<16 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i32> %ret
}

define <16 x i32> @strict_vector_fptoui_v16f16_to_v16i32(<16 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v16f16_to_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2udq %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f16(<16 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i32> %ret
}

define <32 x i16> @strict_vector_fptosi_v32f16_to_v32i16(<32 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v32f16_to_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x i16> @llvm.experimental.constrained.fptosi.v32i16.v32f16(<32 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <32 x i16> %ret
}

define <32 x i16> @strict_vector_fptoui_v32f16_to_v32i16(<32 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v32f16_to_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uw %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x i16> @llvm.experimental.constrained.fptoui.v32i16.v32f16(<32 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <32 x i16> %ret
}

define <32 x i8> @strict_vector_fptosi_v32f16_to_v32i8(<32 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v32f16_to_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %zmm0, %zmm0
; CHECK-NEXT:    vpmovwb %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x i8> @llvm.experimental.constrained.fptosi.v32i8.v32f16(<32 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <32 x i8> %ret
}

define <32 x i8> @strict_vector_fptoui_v32f16_to_v32i8(<32 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v32f16_to_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %zmm0, %zmm0
; CHECK-NEXT:    vpmovwb %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x i8> @llvm.experimental.constrained.fptoui.v32i8.v32f16(<32 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <32 x i8> %ret
}

define <32 x i1> @strict_vector_fptosi_v32f16_to_v32i1(<32 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v32f16_to_v32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %zmm0, %zmm0
; CHECK-NEXT:    vpmovw2m %zmm0, %k0
; CHECK-NEXT:    vpmovm2b %k0, %zmm0
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x i1> @llvm.experimental.constrained.fptosi.v32i1.v32f16(<32 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <32 x i1> %ret
}

define <32 x i1> @strict_vector_fptoui_v32f16_to_v32i1(<32 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v32f16_to_v32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %zmm0, %zmm0
; CHECK-NEXT:    vpsllw $15, %zmm0, %zmm0
; CHECK-NEXT:    vpmovw2m %zmm0, %k0
; CHECK-NEXT:    vpmovm2b %k0, %zmm0
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x i1> @llvm.experimental.constrained.fptoui.v32i1.v32f16(<32 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <32 x i1> %ret
}

attributes #0 = { strictfp }
