; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -global-isel -o - < %s | FileCheck %s

; Test returning vectors in functions
define <16 x i8> @test_ret_v16i8(<16 x i8> %a){
; CHECK-LABEL: test_ret_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  ret <16 x i8> %a
}

define <8 x i16> @test_ret_v8i16(<8 x i16> %a){
; CHECK-LABEL: test_ret_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  ret <8 x i16> %a
}

define <4 x i32> @test_ret_v4i32(<4 x i32> %a){
; CHECK-LABEL: test_ret_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  ret <4 x i32> %a
}

define <2 x i64> @test_ret_v2i64(<2 x i64> %a){
; CHECK-LABEL: test_ret_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  ret <2 x i64> %a
}

define <4 x float> @test_ret_v4f32(<4 x float> %a){
; CHECK-LABEL: test_ret_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  ret <4 x float> %a
}

define <2 x double> @test_ret_v2f64(<2 x double> %a){
; CHECK-LABEL: test_ret_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  ret <2 x double> %a
}

; Test simple bitcasting of vectors
define <16 x i8> @test_bitcast_v16i8_v16i8(<16 x i8> %a){
; CHECK-LABEL: test_bitcast_v16i8_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <16 x i8> %a to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i8> @test_bitcast_v16i8_v8i16(<8 x i16> %a){
; CHECK-LABEL: test_bitcast_v16i8_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <8 x i16> %a to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i8> @test_bitcast_v16i8_v4i32(<4 x i32> %a){
; CHECK-LABEL: test_bitcast_v16i8_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x i32> %a to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i8> @test_bitcast_v16i8_v2i64(<2 x i64> %a){
; CHECK-LABEL: test_bitcast_v16i8_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x i64> %a to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i8> @test_bitcast_v16i8_v4f32(<4 x float> %a){
; CHECK-LABEL: test_bitcast_v16i8_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x float> %a to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i8> @test_bitcast_v16i8_v2f64(<2 x double> %a){
; CHECK-LABEL: test_bitcast_v16i8_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x double> %a to <16 x i8>
  ret <16 x i8> %res
}

define <8 x i16> @test_bitcast_v8i16_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_bitcast_v8i16_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <16 x i8> %a to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @test_bitcast_v8i16_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_bitcast_v8i16_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <8 x i16> %a to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @test_bitcast_v8i16_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_bitcast_v8i16_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x i32> %a to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @test_bitcast_v8i16_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_bitcast_v8i16_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x i64> %a to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @test_bitcast_v8i16_v4f32(<4 x float> %a){
; CHECK-LABEL: test_bitcast_v8i16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x float> %a to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @test_bitcast_v8i16_v2f64(<2 x double> %a){
; CHECK-LABEL: test_bitcast_v8i16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x double> %a to <8 x i16>
  ret <8 x i16> %res
}

define <4 x i32> @test_bitcast_v4i32_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_bitcast_v4i32_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <16 x i8> %a to <4 x i32>
  ret <4 x i32> %res
}

define <4 x i32> @test_bitcast_v4i32_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_bitcast_v4i32_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <8 x i16> %a to <4 x i32>
  ret <4 x i32> %res
}

define <4 x i32> @test_bitcast_v4i32_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_bitcast_v4i32_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x i32> %a to <4 x i32>
  ret <4 x i32> %res
}

define <4 x i32> @test_bitcast_v4i32_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_bitcast_v4i32_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x i64> %a to <4 x i32>
  ret <4 x i32> %res
}

define <4 x i32> @test_bitcast_v4i32_v4f32(<4 x float> %a){
; CHECK-LABEL: test_bitcast_v4i32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x float> %a to <4 x i32>
  ret <4 x i32> %res
}

define <4 x i32> @test_bitcast_v4i32_v2f64(<2 x double> %a){
; CHECK-LABEL: test_bitcast_v4i32_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x double> %a to <4 x i32>
  ret <4 x i32> %res
}

define <2 x i64> @test_bitcast_v2i64_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_bitcast_v2i64_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <16 x i8> %a to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_bitcast_v2i64_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_bitcast_v2i64_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <8 x i16> %a to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_bitcast_v2i64_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_bitcast_v2i64_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x i32> %a to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_bitcast_v2i64_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_bitcast_v2i64_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x i64> %a to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_bitcast_v2i64_v4f32(<4 x float> %a){
; CHECK-LABEL: test_bitcast_v2i64_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x float> %a to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_bitcast_v2i64_v2f64(<2 x double> %a){
; CHECK-LABEL: test_bitcast_v2i64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x double> %a to <2 x i64>
  ret <2 x i64> %res
}

define <4 x float> @test_bitcast_v4f32_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_bitcast_v4f32_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <16 x i8> %a to <4 x float>
  ret <4 x float> %res
}

define <4 x float> @test_bitcast_v4f32_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_bitcast_v4f32_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <8 x i16> %a to <4 x float>
  ret <4 x float> %res
}

define <4 x float> @test_bitcast_v4f32_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_bitcast_v4f32_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x i32> %a to <4 x float>
  ret <4 x float> %res
}

define <4 x float> @test_bitcast_v4f32_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_bitcast_v4f32_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x i64> %a to <4 x float>
  ret <4 x float> %res
}

define <4 x float> @test_bitcast_v4f32_v4f32(<4 x float> %a){
; CHECK-LABEL: test_bitcast_v4f32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x float> %a to <4 x float>
  ret <4 x float> %res
}

define <4 x float> @test_bitcast_v4f32_v2f64(<2 x double> %a){
; CHECK-LABEL: test_bitcast_v4f32_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x double> %a to <4 x float>
  ret <4 x float> %res
}

define <2 x double> @test_bitcast_v2f64_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_bitcast_v2f64_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <16 x i8> %a to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_bitcast_v2f64_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_bitcast_v2f64_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <8 x i16> %a to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_bitcast_v2f64_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_bitcast_v2f64_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x i32> %a to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_bitcast_v2f64_v2i64(<2 x i64> %a) {
; CHECK-LABEL: test_bitcast_v2f64_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x i64> %a to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_bitcast_v2f64_v4f32(<4 x float> %a){
; CHECK-LABEL: test_bitcast_v2f64_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <4 x float> %a to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_bitcast_v2f64_v2f64(<2 x double> %a){
; CHECK-LABEL: test_bitcast_v2f64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %res = bitcast <2 x double> %a to <2 x double>
  ret <2 x double> %res
}

