; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7a-eabi -mattr=+neon -float-abi=hard %s -o - | FileCheck %s

define <8 x i8> @vaddi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i8 d0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = add <8 x i8> %A, %B
  ret <8 x i8> %tmp3
}

define <4 x i16> @vaddi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i16 d0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = add <4 x i16> %A, %B
  ret <4 x i16> %tmp3
}

define <2 x i32> @vaddi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i32 d0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = add <2 x i32> %A, %B
  ret <2 x i32> %tmp3
}

define <1 x i64> @vaddi64(<1 x i64> %A, <1 x i64> %B) {
; CHECK-LABEL: vaddi64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i64 d0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = add <1 x i64> %A, %B
  ret <1 x i64> %tmp3
}

define <2 x float> @vaddf32(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: vaddf32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.f32 d0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = fadd <2 x float> %A, %B
  ret <2 x float> %tmp3
}

define <16 x i8> @vaddQi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: vaddQi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = add <16 x i8> %A, %B
  ret <16 x i8> %tmp3
}

define <8 x i16> @vaddQi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: vaddQi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = add <8 x i16> %A, %B
  ret <8 x i16> %tmp3
}

define <4 x i32> @vaddQi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: vaddQi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = add <4 x i32> %A, %B
  ret <4 x i32> %tmp3
}

define <2 x i64> @vaddQi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: vaddQi64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.i64 q0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = add <2 x i64> %A, %B
  ret <2 x i64> %tmp3
}

define <4 x float> @vaddQf32(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: vaddQf32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = fadd <4 x float> %A, %B
  ret <4 x float> %tmp3
}

define <8 x i8> @vraddhni16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: vraddhni16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vraddhn.i16 d0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = call <8 x i8> @llvm.arm.neon.vraddhn.v8i8(<8 x i16> %A, <8 x i16> %B)
  ret <8 x i8> %tmp3
}

define <4 x i16> @vraddhni32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: vraddhni32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vraddhn.i32 d0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x i16> @llvm.arm.neon.vraddhn.v4i16(<4 x i32> %A, <4 x i32> %B)
  ret <4 x i16> %tmp3
}

define <2 x i32> @vraddhni64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: vraddhni64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vraddhn.i64 d0, q0, q1
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x i32> @llvm.arm.neon.vraddhn.v2i32(<2 x i64> %A, <2 x i64> %B)
  ret <2 x i32> %tmp3
}

declare <8 x i8>  @llvm.arm.neon.vraddhn.v8i8(<8 x i16>, <8 x i16>) readnone
declare <4 x i16> @llvm.arm.neon.vraddhn.v4i16(<4 x i32>, <4 x i32>) readnone
declare <2 x i32> @llvm.arm.neon.vraddhn.v2i32(<2 x i64>, <2 x i64>) readnone

define <8 x i8> @vaddhni16_natural(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: vaddhni16_natural:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddhn.i16 d0, q0, q1
; CHECK-NEXT:    bx lr
  %sum = add <8 x i16> %A, %B
  %shift = lshr <8 x i16> %sum, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %trunc = trunc <8 x i16> %shift to <8 x i8>
  ret <8 x i8> %trunc
}

define <4 x i16> @vaddhni32_natural(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: vaddhni32_natural:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddhn.i32 d0, q0, q1
; CHECK-NEXT:    bx lr
  %sum = add <4 x i32> %A, %B
  %shift = lshr <4 x i32> %sum, <i32 16, i32 16, i32 16, i32 16>
  %trunc = trunc <4 x i32> %shift to <4 x i16>
  ret <4 x i16> %trunc
}

define <2 x i32> @vaddhni64_natural(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: vaddhni64_natural:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddhn.i64 d0, q0, q1
; CHECK-NEXT:    bx lr
  %sum = add <2 x i64> %A, %B
  %shift = lshr <2 x i64> %sum, <i64 32, i64 32>
  %trunc = trunc <2 x i64> %shift to <2 x i32>
  ret <2 x i32> %trunc
}

define <8 x i16> @vaddls8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddls8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.s8 q0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = sext <8 x i8> %A to <8 x i16>
  %tmp4 = sext <8 x i8> %B to <8 x i16>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}

define <4 x i32> @vaddls16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddls16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.s16 q0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = sext <4 x i16> %A to <4 x i32>
  %tmp4 = sext <4 x i16> %B to <4 x i32>
  %tmp5 = add <4 x i32> %tmp3, %tmp4
  ret <4 x i32> %tmp5
}

define <2 x i64> @vaddls32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddls32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.s32 q0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = sext <2 x i32> %A to <2 x i64>
  %tmp4 = sext <2 x i32> %B to <2 x i64>
  %tmp5 = add <2 x i64> %tmp3, %tmp4
  ret <2 x i64> %tmp5
}

define <8 x i16> @vaddlu8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddlu8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.u8 q0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = zext <8 x i8> %A to <8 x i16>
  %tmp4 = zext <8 x i8> %B to <8 x i16>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}

define <4 x i32> @vaddlu16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddlu16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.u16 q0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = zext <4 x i16> %A to <4 x i32>
  %tmp4 = zext <4 x i16> %B to <4 x i32>
  %tmp5 = add <4 x i32> %tmp3, %tmp4
  ret <4 x i32> %tmp5
}

define <2 x i64> @vaddlu32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddlu32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.u32 q0, d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = zext <2 x i32> %A to <2 x i64>
  %tmp4 = zext <2 x i32> %B to <2 x i64>
  %tmp5 = add <2 x i64> %tmp3, %tmp4
  ret <2 x i64> %tmp5
}

define <8 x i16> @vaddla8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddla8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddl.u8 q0, d0, d1
; CHECK-NEXT:    vbic.i16 q0, #0xff00
; CHECK-NEXT:    bx lr
  %tmp3 = zext <8 x i8> %A to <8 x i16>
  %tmp4 = zext <8 x i8> %B to <8 x i16>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  %and = and <8 x i16> %tmp5, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  ret <8 x i16> %and
}

define <4 x i32> @vaddla16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddla16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q8, #0xffff
; CHECK-NEXT:    vaddl.u16 q9, d0, d1
; CHECK-NEXT:    vand q0, q9, q8
; CHECK-NEXT:    bx lr
  %tmp3 = zext <4 x i16> %A to <4 x i32>
  %tmp4 = zext <4 x i16> %B to <4 x i32>
  %tmp5 = add <4 x i32> %tmp3, %tmp4
  %and = and <4 x i32> %tmp5, <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %and
}

define <2 x i64> @vaddla32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddla32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i64 q8, #0xffffffff
; CHECK-NEXT:    vaddl.u32 q9, d0, d1
; CHECK-NEXT:    vand q0, q9, q8
; CHECK-NEXT:    bx lr
  %tmp3 = zext <2 x i32> %A to <2 x i64>
  %tmp4 = zext <2 x i32> %B to <2 x i64>
  %tmp5 = add <2 x i64> %tmp3, %tmp4
  %and = and <2 x i64> %tmp5, <i64 4294967295, i64 4294967295>
  ret <2 x i64> %and
}

define <8 x i16> @vaddws8(<8 x i16> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddws8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.s8 q0, q0, d2
; CHECK-NEXT:    bx lr
  %tmp3 = sext <8 x i8> %B to <8 x i16>
  %tmp4 = add <8 x i16> %A, %tmp3
  ret <8 x i16> %tmp4
}

define <4 x i32> @vaddws16(<4 x i32> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddws16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.s16 q0, q0, d2
; CHECK-NEXT:    bx lr
  %tmp3 = sext <4 x i16> %B to <4 x i32>
  %tmp4 = add <4 x i32> %A, %tmp3
  ret <4 x i32> %tmp4
}

define <2 x i64> @vaddws32(<2 x i64> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddws32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.s32 q0, q0, d2
; CHECK-NEXT:    bx lr
  %tmp3 = sext <2 x i32> %B to <2 x i64>
  %tmp4 = add <2 x i64> %A, %tmp3
  ret <2 x i64> %tmp4
}

define <8 x i16> @vaddwu8(<8 x i16> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddwu8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.u8 q0, q0, d2
; CHECK-NEXT:    bx lr
  %tmp3 = zext <8 x i8> %B to <8 x i16>
  %tmp4 = add <8 x i16> %A, %tmp3
  ret <8 x i16> %tmp4
}

define <4 x i32> @vaddwu16(<4 x i32> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddwu16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.u16 q0, q0, d2
; CHECK-NEXT:    bx lr
  %tmp3 = zext <4 x i16> %B to <4 x i32>
  %tmp4 = add <4 x i32> %A, %tmp3
  ret <4 x i32> %tmp4
}

define <2 x i64> @vaddwu32(<2 x i64> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddwu32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.u32 q0, q0, d2
; CHECK-NEXT:    bx lr
  %tmp3 = zext <2 x i32> %B to <2 x i64>
  %tmp4 = add <2 x i64> %A, %tmp3
  ret <2 x i64> %tmp4
}

define <8 x i16> @vaddwa8(<8 x i16> %A, <8 x i8> %B) {
; CHECK-LABEL: vaddwa8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vaddw.u8 q0, q0, d2
; CHECK-NEXT:    vbic.i16 q0, #0xff00
; CHECK-NEXT:    bx lr
  %tmp3 = zext <8 x i8> %B to <8 x i16>
  %tmp4 = add <8 x i16> %A, %tmp3
  %and = and <8 x i16> %tmp4, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  ret <8 x i16> %and
}

define <4 x i32> @vaddwa16(<4 x i32> %A, <4 x i16> %B) {
; CHECK-LABEL: vaddwa16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q8, #0xffff
; CHECK-NEXT:    vaddw.u16 q9, q0, d2
; CHECK-NEXT:    vand q0, q9, q8
; CHECK-NEXT:    bx lr
  %tmp3 = zext <4 x i16> %B to <4 x i32>
  %tmp4 = add <4 x i32> %A, %tmp3
  %and = and <4 x i32> %tmp4, <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %and
}

define <2 x i64> @vaddwa32(<2 x i64> %A, <2 x i32> %B) {
; CHECK-LABEL: vaddwa32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i64 q8, #0xffffffff
; CHECK-NEXT:    vaddw.u32 q9, q0, d2
; CHECK-NEXT:    vand q0, q9, q8
; CHECK-NEXT:    bx lr
  %tmp3 = zext <2 x i32> %B to <2 x i64>
  %tmp4 = add <2 x i64> %A, %tmp3
  %and = and <2 x i64> %tmp4, <i64 4294967295, i64 4294967295>
  ret <2 x i64> %and
}
