; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI

; CHECK-GI:       warning: Instruction selection used fallback path for trunc_v16i10_v16i16
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for trunc_v16i10_v16i32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for trunc_v16i10_v16i64

define i8 @trunc_i8_to_i16(i16 %a) {
; CHECK-LABEL: trunc_i8_to_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc i16 %a to i8
  ret i8 %c
}

define i8 @trunc_i8_to_i32(i32 %a) {
; CHECK-LABEL: trunc_i8_to_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc i32 %a to i8
  ret i8 %c
}

define i8 @trunc_i8_to_i64(i64 %a) {
; CHECK-LABEL: trunc_i8_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-NEXT:    ret
entry:
  %c = trunc i64 %a to i8
  ret i8 %c
}

define i8 @trunc_i8_to_i10(i10 %a) {
; CHECK-LABEL: trunc_i8_to_i10:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc i10 %a to i8
  ret i8 %c
}

define i16 @trunc_i16_to_i32(i32 %a) {
; CHECK-LABEL: trunc_i16_to_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc i32 %a to i16
  ret i16 %c
}

define i16 @trunc_i16_to_i64(i64 %a) {
; CHECK-LABEL: trunc_i16_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-NEXT:    ret
entry:
  %c = trunc i64 %a to i16
  ret i16 %c
}

define i32 @trunc_i32_to_i64(i64 %a) {
; CHECK-LABEL: trunc_i32_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-NEXT:    ret
entry:
  %c = trunc i64 %a to i32
  ret i32 %c
}

define i10 @trunc_i10_to_i16(i16 %a) {
; CHECK-LABEL: trunc_i10_to_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc i16 %a to i10
  ret i10 %c
}

define i10 @trunc_i10_to_i32(i32 %a) {
; CHECK-LABEL: trunc_i10_to_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc i32 %a to i10
  ret i10 %c
}

define i10 @trunc_i10_to_i64(i64 %a) {
; CHECK-LABEL: trunc_i10_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-NEXT:    ret
entry:
  %c = trunc i64 %a to i10
  ret i10 %c
}

define <2 x i8> @trunc_v2i8_v2i16(<2 x i16> %a) {
; CHECK-LABEL: trunc_v2i8_v2i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i16> %a to <2 x i8>
  ret <2 x i8> %c
}

define <2 x i8> @trunc_v2i8_v2i32(<2 x i32> %a) {
; CHECK-LABEL: trunc_v2i8_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i32> %a to <2 x i8>
  ret <2 x i8> %c
}

define <2 x i8> @trunc_v2i8_v2i64(<2 x i64> %a) {
; CHECK-LABEL: trunc_v2i8_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i64> %a to <2 x i8>
  ret <2 x i8> %c
}

define <2 x i16> @trunc_v2i16_v2i32(<2 x i32> %a) {
; CHECK-LABEL: trunc_v2i16_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i32> %a to <2 x i16>
  ret <2 x i16> %c
}

define <2 x i16> @trunc_v2i16_v2i64(<2 x i64> %a) {
; CHECK-LABEL: trunc_v2i16_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i64> %a to <2 x i16>
  ret <2 x i16> %c
}

define <2 x i32> @trunc_v2i32_v2i64(<2 x i64> %a) {
; CHECK-LABEL: trunc_v2i32_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i64> %a to <2 x i32>
  ret <2 x i32> %c
}

define <2 x i10> @trunc_v2i10_v2i16(<2 x i16> %a) {
; CHECK-LABEL: trunc_v2i10_v2i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i16> %a to <2 x i10>
  ret <2 x i10> %c
}

define <2 x i10> @trunc_v2i10_v2i32(<2 x i32> %a) {
; CHECK-LABEL: trunc_v2i10_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i32> %a to <2 x i10>
  ret <2 x i10> %c
}

define <2 x i10> @trunc_v2i10_v2i64(<2 x i64> %a) {
; CHECK-LABEL: trunc_v2i10_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i64> %a to <2 x i10>
  ret <2 x i10> %c
}

define <3 x i8> @trunc_v3i8_v3i16(<3 x i16> %a) {
; CHECK-LABEL: trunc_v3i8_v3i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    umov w1, v0.h[1]
; CHECK-NEXT:    umov w2, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %c = trunc <3 x i16> %a to <3 x i8>
  ret <3 x i8> %c
}

define <3 x i8> @trunc_v3i8_v3i32(<3 x i32> %a) {
; CHECK-SD-LABEL: trunc_v3i8_v3i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    umov w0, v0.h[0]
; CHECK-SD-NEXT:    umov w1, v0.h[1]
; CHECK-SD-NEXT:    umov w2, v0.h[2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3i8_v3i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    mov s2, v0.s[2]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    fmov w1, s1
; CHECK-GI-NEXT:    fmov w2, s2
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <3 x i32> %a to <3 x i8>
  ret <3 x i8> %c
}

define <3 x i8> @trunc_v3i8_v3i64(<3 x i64> %a) {
; CHECK-SD-LABEL: trunc_v3i8_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    xtn v1.2s, v2.2d
; CHECK-SD-NEXT:    xtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fmov w2, s1
; CHECK-SD-NEXT:    mov w1, v0.s[1]
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3i8_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    fmov x1, d1
; CHECK-GI-NEXT:    fmov x2, d2
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-GI-NEXT:    // kill: def $w1 killed $w1 killed $x1
; CHECK-GI-NEXT:    // kill: def $w2 killed $w2 killed $x2
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <3 x i64> %a to <3 x i8>
  ret <3 x i8> %c
}

define <3 x i16> @trunc_v3i16_v3i32(<3 x i32> %a) {
; CHECK-LABEL: trunc_v3i16_v3i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <3 x i32> %a to <3 x i16>
  ret <3 x i16> %c
}

define <3 x i16> @trunc_v3i16_v3i64(<3 x i64> %a) {
; CHECK-SD-LABEL: trunc_v3i16_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3i16_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    mov v0.h[1], w9
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <3 x i64> %a to <3 x i16>
  ret <3 x i16> %c
}

define <3 x i32> @trunc_v3i32_v3i64(<3 x i64> %a) {
; CHECK-SD-LABEL: trunc_v3i32_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3i32_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    mov v0.s[1], w9
; CHECK-GI-NEXT:    mov v0.s[2], w8
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <3 x i64> %a to <3 x i32>
  ret <3 x i32> %c
}

define <3 x i10> @trunc_v3i10_v3i16(<3 x i16> %a) {
; CHECK-LABEL: trunc_v3i10_v3i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    umov w1, v0.h[1]
; CHECK-NEXT:    umov w2, v0.h[2]
; CHECK-NEXT:    ret
entry:
  %c = trunc <3 x i16> %a to <3 x i10>
  ret <3 x i10> %c
}

define <3 x i10> @trunc_v3i10_v3i32(<3 x i32> %a) {
; CHECK-SD-LABEL: trunc_v3i10_v3i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    umov w0, v0.h[0]
; CHECK-SD-NEXT:    umov w1, v0.h[1]
; CHECK-SD-NEXT:    umov w2, v0.h[2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3i10_v3i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    mov s2, v0.s[2]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    fmov w1, s1
; CHECK-GI-NEXT:    fmov w2, s2
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <3 x i32> %a to <3 x i10>
  ret <3 x i10> %c
}

define <3 x i10> @trunc_v3i10_v3i64(<3 x i64> %a) {
; CHECK-SD-LABEL: trunc_v3i10_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    xtn v1.2s, v2.2d
; CHECK-SD-NEXT:    xtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fmov w2, s1
; CHECK-SD-NEXT:    mov w1, v0.s[1]
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3i10_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    fmov x1, d1
; CHECK-GI-NEXT:    fmov x2, d2
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-GI-NEXT:    // kill: def $w1 killed $w1 killed $x1
; CHECK-GI-NEXT:    // kill: def $w2 killed $w2 killed $x2
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <3 x i64> %a to <3 x i10>
  ret <3 x i10> %c
}

define <4 x i8> @trunc_v4i8_v4i16(<4 x i16> %a) {
; CHECK-LABEL: trunc_v4i8_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i16> %a to <4 x i8>
  ret <4 x i8> %c
}

define <4 x i8> @trunc_v4i8_v4i32(<4 x i32> %a) {
; CHECK-LABEL: trunc_v4i8_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i32> %a to <4 x i8>
  ret <4 x i8> %c
}

define <4 x i8> @trunc_v4i8_v4i64(<4 x i64> %a) {
; CHECK-LABEL: trunc_v4i8_v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i64> %a to <4 x i8>
  ret <4 x i8> %c
}

define <4 x i16> @trunc_v4i16_v4i32(<4 x i32> %a) {
; CHECK-LABEL: trunc_v4i16_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i32> %a to <4 x i16>
  ret <4 x i16> %c
}

define <4 x i16> @trunc_v4i16_v4i64(<4 x i64> %a) {
; CHECK-LABEL: trunc_v4i16_v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i64> %a to <4 x i16>
  ret <4 x i16> %c
}

define <4 x i32> @trunc_v4i32_v4i64(<4 x i64> %a) {
; CHECK-LABEL: trunc_v4i32_v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i64> %a to <4 x i32>
  ret <4 x i32> %c
}

define <4 x i10> @trunc_v4i10_v4i16(<4 x i16> %a) {
; CHECK-LABEL: trunc_v4i10_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i16> %a to <4 x i10>
  ret <4 x i10> %c
}

define <4 x i10> @trunc_v4i10_v4i32(<4 x i32> %a) {
; CHECK-LABEL: trunc_v4i10_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i32> %a to <4 x i10>
  ret <4 x i10> %c
}

define <4 x i10> @trunc_v4i10_v4i64(<4 x i64> %a) {
; CHECK-LABEL: trunc_v4i10_v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <4 x i64> %a to <4 x i10>
  ret <4 x i10> %c
}

define <8 x i8> @trunc_v8i8_v8i16(<8 x i16> %a) {
; CHECK-LABEL: trunc_v8i8_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v0.8b, v0.8h
; CHECK-NEXT:    ret
entry:
  %c = trunc <8 x i16> %a to <8 x i8>
  ret <8 x i8> %c
}

define <8 x i8> @trunc_v8i8_v8i32(<8 x i32> %a) {
; CHECK-LABEL: trunc_v8i8_v8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    xtn v0.8b, v0.8h
; CHECK-NEXT:    ret
entry:
  %c = trunc <8 x i32> %a to <8 x i8>
  ret <8 x i8> %c
}

define <8 x i8> @trunc_v8i8_v8i64(<8 x i64> %a) {
; CHECK-SD-LABEL: trunc_v8i8_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-NEXT:    xtn v0.8b, v0.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v8i8_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <8 x i64> %a to <8 x i8>
  ret <8 x i8> %c
}

define <8 x i16> @trunc_v8i16_v8i32(<8 x i32> %a) {
; CHECK-LABEL: trunc_v8i16_v8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %c = trunc <8 x i32> %a to <8 x i16>
  ret <8 x i16> %c
}

define <8 x i16> @trunc_v8i16_v8i64(<8 x i64> %a) {
; CHECK-SD-LABEL: trunc_v8i16_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v8i16_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <8 x i64> %a to <8 x i16>
  ret <8 x i16> %c
}

define <8 x i32> @trunc_v8i32_v8i64(<8 x i64> %a) {
; CHECK-SD-LABEL: trunc_v8i32_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v8i32_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <8 x i64> %a to <8 x i32>
  ret <8 x i32> %c
}

define <8 x i10> @trunc_v8i10_v8i16(<8 x i16> %a) {
; CHECK-LABEL: trunc_v8i10_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ret
entry:
  %c = trunc <8 x i16> %a to <8 x i10>
  ret <8 x i10> %c
}

define <8 x i10> @trunc_v8i10_v8i32(<8 x i32> %a) {
; CHECK-LABEL: trunc_v8i10_v8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
entry:
  %c = trunc <8 x i32> %a to <8 x i10>
  ret <8 x i10> %c
}

define <8 x i10> @trunc_v8i10_v8i64(<8 x i64> %a) {
; CHECK-SD-LABEL: trunc_v8i10_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v8i10_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <8 x i64> %a to <8 x i10>
  ret <8 x i10> %c
}

define <16 x i8> @trunc_v16i8_v16i16(<16 x i16> %a) {
; CHECK-LABEL: trunc_v16i8_v16i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %c = trunc <16 x i16> %a to <16 x i8>
  ret <16 x i8> %c
}

define <16 x i8> @trunc_v16i8_v16i32(<16 x i32> %a) {
; CHECK-SD-LABEL: trunc_v16i8_v16i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.8h, v2.8h, v3.8h
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    uzp1 v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v16i8_v16i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <16 x i32> %a to <16 x i8>
  ret <16 x i8> %c
}

define <16 x i8> @trunc_v16i8_v16i64(<16 x i64> %a) {
; CHECK-SD-LABEL: trunc_v16i8_v16i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v6.4s, v6.4s, v7.4s
; CHECK-SD-NEXT:    uzp1 v4.4s, v4.4s, v5.4s
; CHECK-SD-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    uzp1 v1.8h, v4.8h, v6.8h
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v16i8_v16i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v2.4s, v4.4s, v5.4s
; CHECK-GI-NEXT:    uzp1 v3.4s, v6.4s, v7.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <16 x i64> %a to <16 x i8>
  ret <16 x i8> %c
}

define <16 x i16> @trunc_v16i16_v16i32(<16 x i32> %a) {
; CHECK-SD-LABEL: trunc_v16i16_v16i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.8h, v2.8h, v3.8h
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v16i16_v16i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <16 x i32> %a to <16 x i16>
  ret <16 x i16> %c
}

define <16 x i16> @trunc_v16i16_v16i64(<16 x i64> %a) {
; CHECK-SD-LABEL: trunc_v16i16_v16i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    uzp1 v1.4s, v6.4s, v7.4s
; CHECK-SD-NEXT:    uzp1 v3.4s, v4.4s, v5.4s
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-NEXT:    uzp1 v1.8h, v3.8h, v1.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v16i16_v16i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v2.4s, v4.4s, v5.4s
; CHECK-GI-NEXT:    uzp1 v3.4s, v6.4s, v7.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    ret
entry:
  %c = trunc <16 x i64> %a to <16 x i16>
  ret <16 x i16> %c
}

define <16 x i32> @trunc_v16i32_v16i64(<16 x i64> %a) {
; CHECK-LABEL: trunc_v16i32_v16i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-NEXT:    uzp1 v2.4s, v4.4s, v5.4s
; CHECK-NEXT:    uzp1 v3.4s, v6.4s, v7.4s
; CHECK-NEXT:    ret
entry:
  %c = trunc <16 x i64> %a to <16 x i32>
  ret <16 x i32> %c
}

define <16 x i10> @trunc_v16i10_v16i16(<16 x i16> %a) {
; CHECK-LABEL: trunc_v16i10_v16i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    umov w9, v1.h[0]
; CHECK-NEXT:    umov w10, v1.h[1]
; CHECK-NEXT:    umov w11, v0.h[0]
; CHECK-NEXT:    umov w12, v0.h[1]
; CHECK-NEXT:    umov w13, v1.h[2]
; CHECK-NEXT:    umov w14, v0.h[2]
; CHECK-NEXT:    umov w15, v1.h[3]
; CHECK-NEXT:    umov w16, v0.h[3]
; CHECK-NEXT:    umov w17, v0.h[4]
; CHECK-NEXT:    umov w18, v1.h[5]
; CHECK-NEXT:    and x9, x9, #0x3ff
; CHECK-NEXT:    and x11, x11, #0x3ff
; CHECK-NEXT:    bfi x9, x10, #10, #10
; CHECK-NEXT:    umov w10, v1.h[4]
; CHECK-NEXT:    bfi x11, x12, #10, #10
; CHECK-NEXT:    umov w12, v1.h[7]
; CHECK-NEXT:    bfi x9, x13, #20, #10
; CHECK-NEXT:    umov w13, v0.h[7]
; CHECK-NEXT:    bfi x11, x14, #20, #10
; CHECK-NEXT:    umov w14, v1.h[6]
; CHECK-NEXT:    bfi x9, x15, #30, #10
; CHECK-NEXT:    umov w15, v0.h[5]
; CHECK-NEXT:    bfi x11, x16, #30, #10
; CHECK-NEXT:    and w10, w10, #0x3ff
; CHECK-NEXT:    umov w16, v0.h[6]
; CHECK-NEXT:    orr x9, x9, x10, lsl #40
; CHECK-NEXT:    lsl w10, w12, #6
; CHECK-NEXT:    and w12, w17, #0x3ff
; CHECK-NEXT:    orr x11, x11, x12, lsl #40
; CHECK-NEXT:    lsl w12, w13, #6
; CHECK-NEXT:    and w13, w18, #0x3ff
; CHECK-NEXT:    orr x9, x9, x13, lsl #50
; CHECK-NEXT:    and w13, w15, #0x3ff
; CHECK-NEXT:    bfxil w10, w14, #4, #6
; CHECK-NEXT:    orr x11, x11, x13, lsl #50
; CHECK-NEXT:    bfxil w12, w16, #4, #6
; CHECK-NEXT:    strh w10, [x8, #18]
; CHECK-NEXT:    orr x9, x9, x14, lsl #60
; CHECK-NEXT:    orr x10, x11, x16, lsl #60
; CHECK-NEXT:    strh w12, [x8, #8]
; CHECK-NEXT:    stur x9, [x8, #10]
; CHECK-NEXT:    str x10, [x8]
; CHECK-NEXT:    ret
entry:
  %c = trunc <16 x i16> %a to <16 x i10>
  ret <16 x i10> %c
}

define <16 x i10> @trunc_v16i10_v16i32(<16 x i32> %a) {
; CHECK-LABEL: trunc_v16i10_v16i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    xtn v2.4h, v2.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    xtn v3.4h, v3.4s
; CHECK-NEXT:    xtn v1.4h, v1.4s
; CHECK-NEXT:    umov w9, v2.h[0]
; CHECK-NEXT:    umov w10, v2.h[1]
; CHECK-NEXT:    umov w11, v0.h[0]
; CHECK-NEXT:    umov w12, v0.h[1]
; CHECK-NEXT:    umov w13, v2.h[2]
; CHECK-NEXT:    umov w14, v0.h[2]
; CHECK-NEXT:    umov w15, v2.h[3]
; CHECK-NEXT:    umov w16, v0.h[3]
; CHECK-NEXT:    umov w17, v1.h[0]
; CHECK-NEXT:    umov w18, v3.h[1]
; CHECK-NEXT:    and x9, x9, #0x3ff
; CHECK-NEXT:    and x11, x11, #0x3ff
; CHECK-NEXT:    bfi x9, x10, #10, #10
; CHECK-NEXT:    umov w10, v3.h[0]
; CHECK-NEXT:    bfi x11, x12, #10, #10
; CHECK-NEXT:    umov w12, v3.h[3]
; CHECK-NEXT:    bfi x9, x13, #20, #10
; CHECK-NEXT:    umov w13, v1.h[3]
; CHECK-NEXT:    bfi x11, x14, #20, #10
; CHECK-NEXT:    umov w14, v3.h[2]
; CHECK-NEXT:    bfi x9, x15, #30, #10
; CHECK-NEXT:    umov w15, v1.h[1]
; CHECK-NEXT:    bfi x11, x16, #30, #10
; CHECK-NEXT:    and w10, w10, #0x3ff
; CHECK-NEXT:    umov w16, v1.h[2]
; CHECK-NEXT:    orr x9, x9, x10, lsl #40
; CHECK-NEXT:    lsl w10, w12, #6
; CHECK-NEXT:    and w12, w17, #0x3ff
; CHECK-NEXT:    orr x11, x11, x12, lsl #40
; CHECK-NEXT:    lsl w12, w13, #6
; CHECK-NEXT:    and w13, w18, #0x3ff
; CHECK-NEXT:    orr x9, x9, x13, lsl #50
; CHECK-NEXT:    and w13, w15, #0x3ff
; CHECK-NEXT:    bfxil w10, w14, #4, #6
; CHECK-NEXT:    orr x11, x11, x13, lsl #50
; CHECK-NEXT:    bfxil w12, w16, #4, #6
; CHECK-NEXT:    strh w10, [x8, #18]
; CHECK-NEXT:    orr x9, x9, x14, lsl #60
; CHECK-NEXT:    orr x10, x11, x16, lsl #60
; CHECK-NEXT:    strh w12, [x8, #8]
; CHECK-NEXT:    stur x9, [x8, #10]
; CHECK-NEXT:    str x10, [x8]
; CHECK-NEXT:    ret
entry:
  %c = trunc <16 x i32> %a to <16 x i10>
  ret <16 x i10> %c
}

define <16 x i10> @trunc_v16i10_v16i64(<16 x i64> %a) {
; CHECK-LABEL: trunc_v16i10_v16i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uzp1 v4.4s, v4.4s, v5.4s
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    uzp1 v2.4s, v2.4s, v3.4s
; CHECK-NEXT:    xtn v1.4h, v4.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    uzp1 v4.4s, v6.4s, v7.4s
; CHECK-NEXT:    xtn v2.4h, v2.4s
; CHECK-NEXT:    umov w9, v1.h[0]
; CHECK-NEXT:    umov w10, v1.h[1]
; CHECK-NEXT:    umov w11, v0.h[0]
; CHECK-NEXT:    xtn v3.4h, v4.4s
; CHECK-NEXT:    umov w12, v0.h[1]
; CHECK-NEXT:    umov w13, v1.h[2]
; CHECK-NEXT:    umov w14, v0.h[2]
; CHECK-NEXT:    umov w15, v1.h[3]
; CHECK-NEXT:    umov w16, v0.h[3]
; CHECK-NEXT:    umov w17, v2.h[0]
; CHECK-NEXT:    and x9, x9, #0x3ff
; CHECK-NEXT:    and x11, x11, #0x3ff
; CHECK-NEXT:    bfi x9, x10, #10, #10
; CHECK-NEXT:    umov w10, v3.h[0]
; CHECK-NEXT:    bfi x11, x12, #10, #10
; CHECK-NEXT:    umov w12, v3.h[3]
; CHECK-NEXT:    umov w18, v3.h[1]
; CHECK-NEXT:    bfi x9, x13, #20, #10
; CHECK-NEXT:    umov w13, v2.h[3]
; CHECK-NEXT:    bfi x11, x14, #20, #10
; CHECK-NEXT:    umov w14, v3.h[2]
; CHECK-NEXT:    bfi x9, x15, #30, #10
; CHECK-NEXT:    umov w15, v2.h[1]
; CHECK-NEXT:    bfi x11, x16, #30, #10
; CHECK-NEXT:    and w10, w10, #0x3ff
; CHECK-NEXT:    umov w16, v2.h[2]
; CHECK-NEXT:    orr x9, x9, x10, lsl #40
; CHECK-NEXT:    lsl w10, w12, #6
; CHECK-NEXT:    and w12, w17, #0x3ff
; CHECK-NEXT:    orr x11, x11, x12, lsl #40
; CHECK-NEXT:    lsl w12, w13, #6
; CHECK-NEXT:    and w13, w18, #0x3ff
; CHECK-NEXT:    orr x9, x9, x13, lsl #50
; CHECK-NEXT:    and w13, w15, #0x3ff
; CHECK-NEXT:    bfxil w10, w14, #4, #6
; CHECK-NEXT:    orr x11, x11, x13, lsl #50
; CHECK-NEXT:    bfxil w12, w16, #4, #6
; CHECK-NEXT:    strh w10, [x8, #18]
; CHECK-NEXT:    orr x9, x9, x14, lsl #60
; CHECK-NEXT:    orr x10, x11, x16, lsl #60
; CHECK-NEXT:    strh w12, [x8, #8]
; CHECK-NEXT:    stur x9, [x8, #10]
; CHECK-NEXT:    str x10, [x8]
; CHECK-NEXT:    ret
entry:
  %c = trunc <16 x i64> %a to <16 x i10>
  ret <16 x i10> %c
}

define <2 x i64> @trunc_v2i64_v2i128(<2 x i128> %a) {
; CHECK-LABEL: trunc_v2i64_v2i128:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d0, x0
; CHECK-NEXT:    mov v0.d[1], x2
; CHECK-NEXT:    ret
entry:
  %c = trunc <2 x i128> %a to <2 x i64>
  ret <2 x i64> %c
}
