; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64 -mattr=+sme -aarch64-stack-hazard-size=0 | FileCheck %s --check-prefix=CHECK0
; RUN: llc < %s -mtriple=aarch64 -mattr=+sme -aarch64-stack-hazard-size=1024 | FileCheck %s --check-prefix=CHECK1024

;; The following run lines check the default values for aarch64-stack-hazard-size/aarch64-streaming-hazard-size.

;; When +sme,+sve is set the hazard size should default to 1024.
; RUN: llc < %s -mtriple=aarch64 -mattr=+sme -mattr=+sve | FileCheck %s --check-prefix=CHECK1024

;; The hazard size can still be overridden/disabled when +sme,+sve is set.
; RUN: llc < %s -mtriple=aarch64 -mattr=+sme -mattr=+sve -aarch64-stack-hazard-size=0 | FileCheck %s --check-prefix=CHECK0

;; When +sme-fa64 is set alongside +sme,+sve the default hazard size should be 0.
; RUN: llc < %s -mtriple=aarch64 -mattr=+sme-fa64 -mattr=+sme -mattr=+sve | FileCheck %s --check-prefix=CHECK0

;; When +sme is set (without +sve) the default hazard size should be 0.
; RUN: llc < %s -mtriple=aarch64 -mattr=+sme | FileCheck %s --check-prefix=CHECK0

define i32 @spill_fpr_with_gpr_stack_object(i64 %d) "aarch64_pstate_sm_compatible" {
; CHECK0-LABEL: spill_fpr_with_gpr_stack_object:
; CHECK0:       // %bb.0: // %entry
; CHECK0-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK0-NEXT:    .cfi_def_cfa_offset 16
; CHECK0-NEXT:    .cfi_offset b8, -16
; CHECK0-NEXT:    mov x8, x0
; CHECK0-NEXT:    mov w0, wzr
; CHECK0-NEXT:    //APP
; CHECK0-NEXT:    //NO_APP
; CHECK0-NEXT:    str x8, [sp, #8]
; CHECK0-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK0-NEXT:    ret
;
; CHECK1024-LABEL: spill_fpr_with_gpr_stack_object:
; CHECK1024:       // %bb.0: // %entry
; CHECK1024-NEXT:    sub sp, sp, #1040
; CHECK1024-NEXT:    str d8, [sp] // 8-byte Folded Spill
; CHECK1024-NEXT:    str x29, [sp, #1032] // 8-byte Folded Spill
; CHECK1024-NEXT:    sub sp, sp, #1040
; CHECK1024-NEXT:    .cfi_def_cfa_offset 2080
; CHECK1024-NEXT:    .cfi_offset w29, -8
; CHECK1024-NEXT:    .cfi_offset b8, -1040
; CHECK1024-NEXT:    mov x8, x0
; CHECK1024-NEXT:    mov w0, wzr
; CHECK1024-NEXT:    //APP
; CHECK1024-NEXT:    //NO_APP
; CHECK1024-NEXT:    str x8, [sp, #8]
; CHECK1024-NEXT:    add sp, sp, #1040
; CHECK1024-NEXT:    ldr x29, [sp, #1032] // 8-byte Folded Reload
; CHECK1024-NEXT:    ldr d8, [sp] // 8-byte Folded Reload
; CHECK1024-NEXT:    add sp, sp, #1040
; CHECK1024-NEXT:    ret
entry:
  %a = alloca i64
  tail call void asm sideeffect "", "~{d8}"() #1
  store i64 %d, ptr %a
  ret i32 0
}
