; RUN: llc -O0 -fast-isel -mtriple=aarch64-apple-ios -o - %s | FileCheck %s
; RUN: not llc -O0 -mtriple=aarch64-apple-ios -o /dev/null -fast-isel -fast-isel-abort=3 %s 2> %t
; RUN: FileCheck %s --check-prefix=CHECK-ERRORS < %t

; The issue here is that FastISel cannot emit an ADDrr where one of the inputs
; is SP. This only ever crops up with function calls, and then only if the
; argument is at an offset > 2^12 * size from SP.

; If FastISel ever starts coping with this and emits an "add xD, sp, xM" it's
; critical to check the encoding as well as the textual assembly. An ADDXrs with
; SP as an operand will still print with SP, but will actually mean XZR.

; CHECK-ERRORS: LLVM ERROR: FastISel missed call

; CHECK-LABEL: foo:
; CHECK: sub
; CHECK-DAG: mov x[[SP:[0-9]+]], sp
; CHECK-DAG: mov w[[OFFSET:[0-9]+]], #4104
; CHECK: strb w0, [x[[SP]], x[[OFFSET]]]

define void @foo(i8 %in) {
  call void @bar(i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; All regs gone.
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 32
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 64
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 128
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 256
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 512
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 1024
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 2048
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef,
                 i64 undef, i64 undef, i64 undef, i64 undef, ; sp + 4096
                 i64 undef, ; sp + 4104 (i.e. not uimm12 or uimm12 << 12).
                 i8 %in)
  ret void
}

declare void @bar(i64, i64, i64, i64,
                  i64, i64, i64, i64, ; All regs gone.
                  i64, i64, i64, i64, ; sp + 32
                  i64, i64, i64, i64, ; sp + 64
                  i64, i64, i64, i64,
                  i64, i64, i64, i64, ; sp + 128
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64, ; sp + 256
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64, ; sp + 512
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64, ; sp + 1024
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64, ; sp + 2048
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64,
                  i64, i64, i64, i64, ; sp + 4096
                  i64,
                  i8)
