; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 %s | FileCheck --check-prefixes=CHECK,CHECK-NOFP16 %s
; RUN: opt -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 -mattr=+fullfp16 %s | FileCheck --check-prefixes=CHECK,CHECK-FP16 %s
; RUN: opt -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 -mattr=+fullfp16,+bf16 %s | FileCheck --check-prefixes=CHECK,CHECK-FP16,CHECK-BF16 %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @ext() {
; CHECK-LABEL: 'ext'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r0 = sext i1 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r1 = zext i1 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r2 = sext i1 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r3 = zext i1 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r4 = sext i1 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r5 = zext i1 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r6 = sext i1 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r7 = zext i1 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r9 = sext i8 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r10 = zext i8 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r11 = sext i8 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r12 = zext i8 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r13 = sext i8 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r14 = zext i8 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r17 = sext i16 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r18 = zext i16 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r19 = sext i16 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r20 = zext i16 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r24 = sext i32 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r25 = zext i32 undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i8i16 = sext <2 x i8> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z2i8i16 = zext <2 x i8> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i8i32 = sext <2 x i8> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z2i8i32 = zext <2 x i8> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i8i64 = sext <2 x i8> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z2i8i64 = zext <2 x i8> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i16i32 = sext <2 x i16> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z2i16i32 = zext <2 x i16> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i16i64 = sext <2 x i16> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z2i16i64 = zext <2 x i16> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i32i64 = sext <2 x i32> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z2i32i64 = zext <2 x i32> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s4i8i16 = sext <4 x i8> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z4i8i16 = zext <4 x i8> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s4i8i32 = sext <4 x i8> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z4i8i32 = zext <4 x i8> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %s4i8i64 = sext <4 x i8> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %z4i8i64 = zext <4 x i8> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s4i16i32 = sext <4 x i16> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z4i16i32 = zext <4 x i16> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %s4i16i64 = sext <4 x i16> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %z4i16i64 = zext <4 x i16> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s4i32i64 = sext <4 x i32> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %z4i32i64 = zext <4 x i32> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s8i8i16 = sext <8 x i8> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z8i8i16 = zext <8 x i8> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %s8i8i32 = sext <8 x i8> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %z8i8i32 = zext <8 x i8> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %s8i8i64 = sext <8 x i8> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %z8i8i64 = zext <8 x i8> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s8i16i32 = sext <8 x i16> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %z8i16i32 = zext <8 x i16> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %s8i16i64 = sext <8 x i16> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %z8i16i64 = zext <8 x i16> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %s8i32i64 = sext <8 x i32> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %z8i32i64 = zext <8 x i32> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s16i8i16 = sext <16 x i8> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %z16i8i16 = zext <16 x i8> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %s16i8i32 = sext <16 x i8> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %z16i8i32 = zext <16 x i8> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:1 Lat:1 SizeLat:1 for: %s16i8i64 = sext <16 x i8> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:1 Lat:1 SizeLat:1 for: %z16i8i64 = zext <16 x i8> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %s16i16i32 = sext <16 x i16> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %z16i16i32 = zext <16 x i16> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %s16i16i64 = sext <16 x i16> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %z16i16i64 = zext <16 x i16> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %s16i32i64 = sext <16 x i32> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %z16i32i64 = zext <16 x i32> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %r0 = sext i1 undef to i8
  %r1 = zext i1 undef to i8
  %r2 = sext i1 undef to i16
  %r3 = zext i1 undef to i16
  %r4 = sext i1 undef to i32
  %r5 = zext i1 undef to i32
  %r6 = sext i1 undef to i64
  %r7 = zext i1 undef to i64
  %r9 = sext i8 undef to i16
  %r10 = zext i8 undef to i16
  %r11 = sext i8 undef to i32
  %r12 = zext i8 undef to i32
  %r13 = sext i8 undef to i64
  %r14 = zext i8 undef to i64
  %r17 = sext i16 undef to i32
  %r18 = zext i16 undef to i32
  %r19 = sext i16 undef to i64
  %r20 = zext i16 undef to i64
  %r24 = sext i32 undef to i64
  %r25 = zext i32 undef to i64

  %s2i8i16 = sext <2 x i8> undef to <2 x i16>
  %z2i8i16 = zext <2 x i8> undef to <2 x i16>
  %s2i8i32 = sext <2 x i8> undef to <2 x i32>
  %z2i8i32 = zext <2 x i8> undef to <2 x i32>
  %s2i8i64 = sext <2 x i8> undef to <2 x i64>
  %z2i8i64 = zext <2 x i8> undef to <2 x i64>
  %s2i16i32 = sext <2 x i16> undef to <2 x i32>
  %z2i16i32 = zext <2 x i16> undef to <2 x i32>
  %s2i16i64 = sext <2 x i16> undef to <2 x i64>
  %z2i16i64 = zext <2 x i16> undef to <2 x i64>
  %s2i32i64 = sext <2 x i32> undef to <2 x i64>
  %z2i32i64 = zext <2 x i32> undef to <2 x i64>

  %s4i8i16 = sext <4 x i8>  undef to <4 x i16>
  %z4i8i16 = zext <4 x i8>  undef to <4 x i16>
  %s4i8i32 = sext <4 x i8>  undef to <4 x i32>
  %z4i8i32 = zext <4 x i8>  undef to <4 x i32>
  %s4i8i64 = sext <4 x i8>  undef to <4 x i64>
  %z4i8i64 = zext <4 x i8>  undef to <4 x i64>
  %s4i16i32 = sext <4 x i16> undef to <4 x i32>
  %z4i16i32 = zext <4 x i16> undef to <4 x i32>
  %s4i16i64 = sext <4 x i16> undef to <4 x i64>
  %z4i16i64 = zext <4 x i16> undef to <4 x i64>
  %s4i32i64 = sext <4 x i32> undef to <4 x i64>
  %z4i32i64 = zext <4 x i32> undef to <4 x i64>

  %s8i8i16 = sext <8 x i8>  undef to <8 x i16>
  %z8i8i16 = zext <8 x i8>  undef to <8 x i16>
  %s8i8i32 = sext <8 x i8>  undef to <8 x i32>
  %z8i8i32 = zext <8 x i8>  undef to <8 x i32>
  %s8i8i64 = sext <8 x i8>  undef to <8 x i64>
  %z8i8i64 = zext <8 x i8>  undef to <8 x i64>
  %s8i16i32 = sext <8 x i16> undef to <8 x i32>
  %z8i16i32 = zext <8 x i16> undef to <8 x i32>
  %s8i16i64 = sext <8 x i16> undef to <8 x i64>
  %z8i16i64 = zext <8 x i16> undef to <8 x i64>
  %s8i32i64 = sext <8 x i32> undef to <8 x i64>
  %z8i32i64 = zext <8 x i32> undef to <8 x i64>

  %s16i8i16 = sext <16 x i8>  undef to <16 x i16>
  %z16i8i16 = zext <16 x i8>  undef to <16 x i16>
  %s16i8i32 = sext <16 x i8>  undef to <16 x i32>
  %z16i8i32 = zext <16 x i8>  undef to <16 x i32>
  %s16i8i64 = sext <16 x i8>  undef to <16 x i64>
  %z16i8i64 = zext <16 x i8>  undef to <16 x i64>
  %s16i16i32 = sext <16 x i16> undef to <16 x i32>
  %z16i16i32 = zext <16 x i16> undef to <16 x i32>
  %s16i16i64 = sext <16 x i16> undef to <16 x i64>
  %z16i16i64 = zext <16 x i16> undef to <16 x i64>
  %s16i32i64 = sext <16 x i32> undef to <16 x i64>
  %z16i32i64 = zext <16 x i32> undef to <16 x i64>
  ret void
}

define void @trunc() {
; CHECK-LABEL: 'trunc'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r8 = trunc i8 undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r15 = trunc i16 undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r16 = trunc i16 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r21 = trunc i32 undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r22 = trunc i32 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r23 = trunc i32 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r26 = trunc i64 undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r27 = trunc i64 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r28 = trunc i64 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r29 = trunc i64 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s2i32i64 = trunc <2 x i64> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s4i32i64 = trunc <4 x i64> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s8i32i64 = trunc <8 x i64> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %r8 = trunc i8 undef to i1
  %r15 = trunc i16 undef to i1
  %r16 = trunc i16 undef to i8
  %r21 = trunc i32 undef to i1
  %r22 = trunc i32 undef to i8
  %r23 = trunc i32 undef to i16
  %r26 = trunc i64 undef to i1
  %r27 = trunc i64 undef to i8
  %r28 = trunc i64 undef to i16
  %r29 = trunc i64 undef to i32

  %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
  %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
  %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
  %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
  %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
  %s2i32i64 = trunc <2 x i64> undef to <2 x i32>

  %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
  %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
  %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
  %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
  %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
  %s4i32i64 = trunc <4 x i64> undef to <4 x i32>

  %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
  %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
  %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
  %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
  %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
  %s8i32i64 = trunc <8 x i64> undef to <8 x i32>

  %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
  %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
  %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
  %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
  %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
  %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
  ret void
}

define i32 @casts_no_users() {
; CHECK-LABEL: 'casts_no_users'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r30 = fptoui float undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r31 = fptosi float undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r32 = fptoui float undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r33 = fptosi float undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r34 = fptoui float undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r35 = fptosi float undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r36 = fptoui float undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r37 = fptosi float undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r38 = fptoui float undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r39 = fptosi float undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r40 = fptoui double undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r41 = fptosi double undef to i1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r42 = fptoui double undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r43 = fptosi double undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r44 = fptoui double undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r45 = fptosi double undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r46 = fptoui double undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r47 = fptosi double undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r48 = fptoui double undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r49 = fptosi double undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r50 = sitofp i1 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r51 = uitofp i1 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r52 = sitofp i1 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r53 = uitofp i1 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r54 = sitofp i8 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r55 = uitofp i8 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r56 = sitofp i8 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r57 = uitofp i8 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r58 = sitofp i16 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r59 = uitofp i16 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r60 = sitofp i16 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r61 = uitofp i16 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r62 = sitofp i32 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r63 = uitofp i32 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r64 = sitofp i32 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r65 = uitofp i32 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r66 = sitofp i64 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r67 = uitofp i64 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r68 = sitofp i64 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r69 = uitofp i64 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r80 = fptrunc double undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r81 = fptrunc <2 x double> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r82 = fptrunc <4 x double> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r83 = fptrunc <8 x double> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r84 = fptrunc <16 x double> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %truncf64f16 = fptrunc double undef to half
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %truncv2f64f16 = fptrunc <2 x double> undef to <2 x half>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %truncv4f64f16 = fptrunc <4 x double> undef to <4 x half>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %truncv8f64f16 = fptrunc <8 x double> undef to <8 x half>
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %truncv16f64f16 = fptrunc <16 x double> undef to <16 x half>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %truncv32f16 = fptrunc float undef to half
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %truncv2f32f16 = fptrunc <2 x float> undef to <2 x half>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %truncv4f32f16 = fptrunc <4 x float> undef to <4 x half>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %truncv8f32f16 = fptrunc <8 x float> undef to <8 x half>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %truncv16f32f16 = fptrunc <16 x float> undef to <16 x half>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r85 = fpext float undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r86 = fpext <2 x float> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r87 = fpext <4 x float> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r88 = fpext <8 x float> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r89 = fpext <16 x float> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %extf16f32 = fpext half undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %extv2f16f32 = fpext <2 x half> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %extv4f16f32 = fpext <4 x half> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extv8f16f32 = fpext <8 x half> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %extv16f16f32 = fpext <16 x half> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %extf16f64 = fpext half undef to double
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extv2f16f64 = fpext <2 x half> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %extv4f16f64 = fpext <4 x half> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %extv8f16f64 = fpext <8 x half> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %extv16f16f64 = fpext <16 x half> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r90 = fptoui <2 x float> undef to <2 x i1>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r91 = fptosi <2 x float> undef to <2 x i1>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r92 = fptoui <2 x float> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r93 = fptosi <2 x float> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r94 = fptoui <2 x float> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r95 = fptosi <2 x float> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r96 = fptoui <2 x float> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r97 = fptosi <2 x float> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r98 = fptoui <2 x float> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r99 = fptosi <2 x float> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r100 = fptoui <2 x double> undef to <2 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r101 = fptosi <2 x double> undef to <2 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r102 = fptoui <2 x double> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r103 = fptosi <2 x double> undef to <2 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r104 = fptoui <2 x double> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r105 = fptosi <2 x double> undef to <2 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r106 = fptoui <2 x double> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r107 = fptosi <2 x double> undef to <2 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r108 = fptoui <2 x double> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r109 = fptosi <2 x double> undef to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r110 = fptoui <4 x float> undef to <4 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r111 = fptosi <4 x float> undef to <4 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r112 = fptoui <4 x float> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r113 = fptosi <4 x float> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r114 = fptoui <4 x float> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r115 = fptosi <4 x float> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r116 = fptoui <4 x float> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r117 = fptosi <4 x float> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r118 = fptoui <4 x float> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r119 = fptosi <4 x float> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r120 = fptoui <4 x double> undef to <4 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r121 = fptosi <4 x double> undef to <4 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r122 = fptoui <4 x double> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r123 = fptosi <4 x double> undef to <4 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r124 = fptoui <4 x double> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r125 = fptosi <4 x double> undef to <4 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r126 = fptoui <4 x double> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r127 = fptosi <4 x double> undef to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r128 = fptoui <4 x double> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r129 = fptosi <4 x double> undef to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:41 CodeSize:1 Lat:1 SizeLat:1 for: %r130 = fptoui <8 x float> undef to <8 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:41 CodeSize:1 Lat:1 SizeLat:1 for: %r131 = fptosi <8 x float> undef to <8 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r132 = fptoui <8 x float> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r133 = fptosi <8 x float> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r134 = fptoui <8 x float> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %r135 = fptosi <8 x float> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r136 = fptoui <8 x float> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r137 = fptosi <8 x float> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r138 = fptoui <8 x float> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r139 = fptosi <8 x float> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %r140 = fptoui <8 x double> undef to <8 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %r141 = fptosi <8 x double> undef to <8 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %r142 = fptoui <8 x double> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %r143 = fptosi <8 x double> undef to <8 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %r144 = fptoui <8 x double> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %r145 = fptosi <8 x double> undef to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r146 = fptoui <8 x double> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r147 = fptosi <8 x double> undef to <8 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r148 = fptoui <8 x double> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r149 = fptosi <8 x double> undef to <8 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %r150 = fptoui <16 x float> undef to <16 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %r151 = fptosi <16 x float> undef to <16 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %r152 = fptoui <16 x float> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %r153 = fptosi <16 x float> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r154 = fptoui <16 x float> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r155 = fptosi <16 x float> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r156 = fptoui <16 x float> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r157 = fptosi <16 x float> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r158 = fptoui <16 x float> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r159 = fptosi <16 x float> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:87 CodeSize:1 Lat:1 SizeLat:1 for: %r160 = fptoui <16 x double> undef to <16 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:87 CodeSize:1 Lat:1 SizeLat:1 for: %r161 = fptosi <16 x double> undef to <16 x i1>
; CHECK-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %r162 = fptoui <16 x double> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %r163 = fptosi <16 x double> undef to <16 x i8>
; CHECK-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:1 SizeLat:1 for: %r164 = fptoui <16 x double> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:1 SizeLat:1 for: %r165 = fptosi <16 x double> undef to <16 x i16>
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r166 = fptoui <16 x double> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r167 = fptosi <16 x double> undef to <16 x i32>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r168 = fptoui <16 x double> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r169 = fptosi <16 x double> undef to <16 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r170 = uitofp <2 x i1> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r171 = sitofp <2 x i1> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r172 = uitofp <2 x i8> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r173 = sitofp <2 x i8> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r174 = uitofp <2 x i16> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r175 = sitofp <2 x i16> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r176 = uitofp <2 x i32> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r177 = sitofp <2 x i32> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r178 = uitofp <2 x i64> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r179 = sitofp <2 x i64> undef to <2 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r180 = uitofp <2 x i1> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r181 = sitofp <2 x i1> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r182 = uitofp <2 x i8> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r183 = sitofp <2 x i8> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r184 = uitofp <2 x i16> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r185 = sitofp <2 x i16> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r186 = uitofp <2 x i32> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r187 = sitofp <2 x i32> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r188 = uitofp <2 x i64> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r189 = sitofp <2 x i64> undef to <2 x double>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r190 = uitofp <4 x i1> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r191 = sitofp <4 x i1> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r192 = uitofp <4 x i8> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r193 = sitofp <4 x i8> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r194 = uitofp <4 x i16> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r195 = sitofp <4 x i16> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r196 = uitofp <4 x i32> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r197 = sitofp <4 x i32> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %r198 = uitofp <4 x i64> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %r199 = sitofp <4 x i64> undef to <4 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r200 = uitofp <4 x i1> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r201 = sitofp <4 x i1> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %r202 = uitofp <4 x i8> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %r203 = sitofp <4 x i8> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %r204 = uitofp <4 x i16> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %r205 = sitofp <4 x i16> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r206 = uitofp <4 x i32> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r207 = sitofp <4 x i32> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r208 = uitofp <4 x i64> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r209 = sitofp <4 x i64> undef to <4 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r210 = uitofp <8 x i1> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r211 = sitofp <8 x i1> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r212 = uitofp <8 x i8> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r213 = sitofp <8 x i8> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r214 = uitofp <8 x i16> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r215 = sitofp <8 x i16> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r216 = uitofp <8 x i32> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r217 = sitofp <8 x i32> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:1 Lat:1 SizeLat:1 for: %r218 = uitofp <8 x i64> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:1 Lat:1 SizeLat:1 for: %r219 = sitofp <8 x i64> undef to <8 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r220 = uitofp <8 x i1> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r221 = sitofp <8 x i1> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %r222 = uitofp <8 x i8> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %r223 = sitofp <8 x i8> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %r224 = uitofp <8 x i16> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %r225 = sitofp <8 x i16> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %r226 = uitofp <8 x i16> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %r227 = sitofp <8 x i16> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r228 = uitofp <8 x i64> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r229 = sitofp <8 x i64> undef to <8 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r230 = uitofp <16 x i1> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r231 = sitofp <16 x i1> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r232 = uitofp <16 x i8> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r233 = sitofp <16 x i8> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r234 = uitofp <16 x i16> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r235 = sitofp <16 x i16> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r236 = uitofp <16 x i32> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r237 = sitofp <16 x i32> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:1 Lat:1 SizeLat:1 for: %r238 = uitofp <16 x i64> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:1 Lat:1 SizeLat:1 for: %r239 = sitofp <16 x i64> undef to <16 x float>
; CHECK-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:1 Lat:1 SizeLat:1 for: %r240 = uitofp <16 x i1> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:1 Lat:1 SizeLat:1 for: %r241 = sitofp <16 x i1> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:39 CodeSize:1 Lat:1 SizeLat:1 for: %r242 = uitofp <16 x i8> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:39 CodeSize:1 Lat:1 SizeLat:1 for: %r243 = sitofp <16 x i8> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:1 SizeLat:1 for: %r244 = uitofp <16 x i16> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:1 SizeLat:1 for: %r245 = sitofp <16 x i16> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:1 SizeLat:1 for: %r246 = uitofp <16 x i16> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:1 SizeLat:1 for: %r247 = sitofp <16 x i16> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r248 = uitofp <16 x i64> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r249 = sitofp <16 x i64> undef to <16 x double>
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %r30 = fptoui float undef to i1
  %r31 = fptosi float undef to i1
  %r32 = fptoui float undef to i8
  %r33 = fptosi float undef to i8
  %r34 = fptoui float undef to i16
  %r35 = fptosi float undef to i16
  %r36 = fptoui float undef to i32
  %r37 = fptosi float undef to i32
  %r38 = fptoui float undef to i64
  %r39 = fptosi float undef to i64
  %r40 = fptoui double undef to i1
  %r41 = fptosi double undef to i1
  %r42 = fptoui double undef to i8
  %r43 = fptosi double undef to i8
  %r44 = fptoui double undef to i16
  %r45 = fptosi double undef to i16
  %r46 = fptoui double undef to i32
  %r47 = fptosi double undef to i32
  %r48 = fptoui double undef to i64
  %r49 = fptosi double undef to i64
  %r50 = sitofp i1 undef to float
  %r51 = uitofp i1 undef to float
  %r52 = sitofp i1 undef to double
  %r53 = uitofp i1 undef to double
  %r54 = sitofp i8 undef to float
  %r55 = uitofp i8 undef to float
  %r56 = sitofp i8 undef to double
  %r57 = uitofp i8 undef to double
  %r58 = sitofp i16 undef to float
  %r59 = uitofp i16 undef to float
  %r60 = sitofp i16 undef to double
  %r61 = uitofp i16 undef to double
  %r62 = sitofp i32 undef to float
  %r63 = uitofp i32 undef to float
  %r64 = sitofp i32 undef to double
  %r65 = uitofp i32 undef to double
  %r66 = sitofp i64 undef to float
  %r67 = uitofp i64 undef to float
  %r68 = sitofp i64 undef to double
  %r69 = uitofp i64 undef to double
  %r80 = fptrunc double undef to float
  %r81 = fptrunc <2 x double> undef to <2 x float>
  %r82 = fptrunc <4 x double> undef to <4 x float>
  %r83 = fptrunc <8 x double> undef to <8 x float>
  %r84 = fptrunc <16 x double> undef to <16 x float>
  %truncf64f16 = fptrunc double undef to half
  %truncv2f64f16 = fptrunc <2 x double> undef to <2 x half>
  %truncv4f64f16 = fptrunc <4 x double> undef to <4 x half>
  %truncv8f64f16 = fptrunc <8 x double> undef to <8 x half>
  %truncv16f64f16 = fptrunc <16 x double> undef to <16 x half>
  %truncv32f16 = fptrunc float undef to half
  %truncv2f32f16 = fptrunc <2 x float> undef to <2 x half>
  %truncv4f32f16 = fptrunc <4 x float> undef to <4 x half>
  %truncv8f32f16 = fptrunc <8 x float> undef to <8 x half>
  %truncv16f32f16 = fptrunc <16 x float> undef to <16 x half>
  %r85 = fpext float undef to double
  %r86 = fpext <2 x float> undef to <2 x double>
  %r87 = fpext <4 x float> undef to <4 x double>
  %r88 = fpext <8 x float> undef to <8 x double>
  %r89 = fpext <16 x float> undef to <16 x double>
  %extf16f32 = fpext half undef to float
  %extv2f16f32 = fpext <2 x half> undef to <2 x float>
  %extv4f16f32 = fpext <4 x half> undef to <4 x float>
  %extv8f16f32 = fpext <8 x half> undef to <8 x float>
  %extv16f16f32 = fpext <16 x half> undef to <16 x float>
  %extf16f64 = fpext half undef to double
  %extv2f16f64 = fpext <2 x half> undef to <2 x double>
  %extv4f16f64 = fpext <4 x half> undef to <4 x double>
  %extv8f16f64 = fpext <8 x half> undef to <8 x double>
  %extv16f16f64 = fpext <16 x half> undef to <16 x double>
  %r90 = fptoui <2 x float> undef to <2 x i1>
  %r91 = fptosi <2 x float> undef to <2 x i1>
  %r92 = fptoui <2 x float> undef to <2 x i8>
  %r93 = fptosi <2 x float> undef to <2 x i8>
  %r94 = fptoui <2 x float> undef to <2 x i16>
  %r95 = fptosi <2 x float> undef to <2 x i16>
  %r96 = fptoui <2 x float> undef to <2 x i32>
  %r97 = fptosi <2 x float> undef to <2 x i32>
  %r98 = fptoui <2 x float> undef to <2 x i64>
  %r99 = fptosi <2 x float> undef to <2 x i64>
  %r100 = fptoui <2 x double> undef to <2 x i1>
  %r101 = fptosi <2 x double> undef to <2 x i1>
  %r102 = fptoui <2 x double> undef to <2 x i8>
  %r103 = fptosi <2 x double> undef to <2 x i8>
  %r104 = fptoui <2 x double> undef to <2 x i16>
  %r105 = fptosi <2 x double> undef to <2 x i16>
  %r106 = fptoui <2 x double> undef to <2 x i32>
  %r107 = fptosi <2 x double> undef to <2 x i32>
  %r108 = fptoui <2 x double> undef to <2 x i64>
  %r109 = fptosi <2 x double> undef to <2 x i64>

  %r110 = fptoui <4 x float> undef to <4 x i1>
  %r111 = fptosi <4 x float> undef to <4 x i1>
  %r112 = fptoui <4 x float> undef to <4 x i8>
  %r113 = fptosi <4 x float> undef to <4 x i8>
  %r114 = fptoui <4 x float> undef to <4 x i16>
  %r115 = fptosi <4 x float> undef to <4 x i16>
  %r116 = fptoui <4 x float> undef to <4 x i32>
  %r117 = fptosi <4 x float> undef to <4 x i32>
  %r118 = fptoui <4 x float> undef to <4 x i64>
  %r119 = fptosi <4 x float> undef to <4 x i64>

  %r120 = fptoui <4 x double> undef to <4 x i1>
  %r121 = fptosi <4 x double> undef to <4 x i1>
  %r122 = fptoui <4 x double> undef to <4 x i8>
  %r123 = fptosi <4 x double> undef to <4 x i8>
  %r124 = fptoui <4 x double> undef to <4 x i16>
  %r125 = fptosi <4 x double> undef to <4 x i16>
  %r126 = fptoui <4 x double> undef to <4 x i32>
  %r127 = fptosi <4 x double> undef to <4 x i32>
  %r128 = fptoui <4 x double> undef to <4 x i64>
  %r129 = fptosi <4 x double> undef to <4 x i64>

  %r130 = fptoui <8 x float> undef to <8 x i1>
  %r131 = fptosi <8 x float> undef to <8 x i1>
  %r132 = fptoui <8 x float> undef to <8 x i8>
  %r133 = fptosi <8 x float> undef to <8 x i8>
  %r134 = fptoui <8 x float> undef to <8 x i16>
  %r135 = fptosi <8 x float> undef to <8 x i16>
  %r136 = fptoui <8 x float> undef to <8 x i32>
  %r137 = fptosi <8 x float> undef to <8 x i32>
  %r138 = fptoui <8 x float> undef to <8 x i64>
  %r139 = fptosi <8 x float> undef to <8 x i64>

  %r140 = fptoui <8 x double> undef to <8 x i1>
  %r141 = fptosi <8 x double> undef to <8 x i1>
  %r142 = fptoui <8 x double> undef to <8 x i8>
  %r143 = fptosi <8 x double> undef to <8 x i8>
  %r144 = fptoui <8 x double> undef to <8 x i16>
  %r145 = fptosi <8 x double> undef to <8 x i16>
  %r146 = fptoui <8 x double> undef to <8 x i32>
  %r147 = fptosi <8 x double> undef to <8 x i32>
  %r148 = fptoui <8 x double> undef to <8 x i64>
  %r149 = fptosi <8 x double> undef to <8 x i64>

  %r150 = fptoui <16 x float> undef to <16 x i1>
  %r151 = fptosi <16 x float> undef to <16 x i1>
  %r152 = fptoui <16 x float> undef to <16 x i8>
  %r153 = fptosi <16 x float> undef to <16 x i8>
  %r154 = fptoui <16 x float> undef to <16 x i16>
  %r155 = fptosi <16 x float> undef to <16 x i16>
  %r156 = fptoui <16 x float> undef to <16 x i32>
  %r157 = fptosi <16 x float> undef to <16 x i32>
  %r158 = fptoui <16 x float> undef to <16 x i64>
  %r159 = fptosi <16 x float> undef to <16 x i64>

  %r160 = fptoui <16 x double> undef to <16 x i1>
  %r161 = fptosi <16 x double> undef to <16 x i1>
  %r162 = fptoui <16 x double> undef to <16 x i8>
  %r163 = fptosi <16 x double> undef to <16 x i8>
  %r164 = fptoui <16 x double> undef to <16 x i16>
  %r165 = fptosi <16 x double> undef to <16 x i16>
  %r166 = fptoui <16 x double> undef to <16 x i32>
  %r167 = fptosi <16 x double> undef to <16 x i32>
  %r168 = fptoui <16 x double> undef to <16 x i64>
  %r169 = fptosi <16 x double> undef to <16 x i64>

  %r170 = uitofp <2 x i1> undef to <2 x float>
  %r171 = sitofp <2 x i1> undef to <2 x float>
  %r172 = uitofp <2 x i8> undef to <2 x float>
  %r173 = sitofp <2 x i8> undef to <2 x float>
  %r174 = uitofp <2 x i16> undef to <2 x float>
  %r175 = sitofp <2 x i16> undef to <2 x float>
  %r176 = uitofp <2 x i32> undef to <2 x float>
  %r177 = sitofp <2 x i32> undef to <2 x float>
  %r178 = uitofp <2 x i64> undef to <2 x float>
  %r179 = sitofp <2 x i64> undef to <2 x float>

  %r180 = uitofp <2 x i1> undef to <2 x double>
  %r181 = sitofp <2 x i1> undef to <2 x double>
  %r182 = uitofp <2 x i8> undef to <2 x double>
  %r183 = sitofp <2 x i8> undef to <2 x double>
  %r184 = uitofp <2 x i16> undef to <2 x double>
  %r185 = sitofp <2 x i16> undef to <2 x double>
  %r186 = uitofp <2 x i32> undef to <2 x double>
  %r187 = sitofp <2 x i32> undef to <2 x double>
  %r188 = uitofp <2 x i64> undef to <2 x double>
  %r189 = sitofp <2 x i64> undef to <2 x double>

  %r190 = uitofp <4 x i1> undef to <4 x float>
  %r191 = sitofp <4 x i1> undef to <4 x float>
  %r192 = uitofp <4 x i8> undef to <4 x float>
  %r193 = sitofp <4 x i8> undef to <4 x float>
  %r194 = uitofp <4 x i16> undef to <4 x float>
  %r195 = sitofp <4 x i16> undef to <4 x float>
  %r196 = uitofp <4 x i32> undef to <4 x float>
  %r197 = sitofp <4 x i32> undef to <4 x float>
  %r198 = uitofp <4 x i64> undef to <4 x float>
  %r199 = sitofp <4 x i64> undef to <4 x float>

  %r200 = uitofp <4 x i1> undef to <4 x double>
  %r201 = sitofp <4 x i1> undef to <4 x double>
  %r202 = uitofp <4 x i8> undef to <4 x double>
  %r203 = sitofp <4 x i8> undef to <4 x double>
  %r204 = uitofp <4 x i16> undef to <4 x double>
  %r205 = sitofp <4 x i16> undef to <4 x double>
  %r206 = uitofp <4 x i32> undef to <4 x double>
  %r207 = sitofp <4 x i32> undef to <4 x double>
  %r208 = uitofp <4 x i64> undef to <4 x double>
  %r209 = sitofp <4 x i64> undef to <4 x double>

  %r210 = uitofp <8 x i1> undef to <8 x float>
  %r211 = sitofp <8 x i1> undef to <8 x float>
  %r212 = uitofp <8 x i8> undef to <8 x float>
  %r213 = sitofp <8 x i8> undef to <8 x float>
  %r214 = uitofp <8 x i16> undef to <8 x float>
  %r215 = sitofp <8 x i16> undef to <8 x float>
  %r216 = uitofp <8 x i32> undef to <8 x float>
  %r217 = sitofp <8 x i32> undef to <8 x float>
  %r218 = uitofp <8 x i64> undef to <8 x float>
  %r219 = sitofp <8 x i64> undef to <8 x float>

  %r220 = uitofp <8 x i1> undef to <8 x double>
  %r221 = sitofp <8 x i1> undef to <8 x double>
  %r222 = uitofp <8 x i8> undef to <8 x double>
  %r223 = sitofp <8 x i8> undef to <8 x double>
  %r224 = uitofp <8 x i16> undef to <8 x double>
  %r225 = sitofp <8 x i16> undef to <8 x double>
  %r226 = uitofp <8 x i16> undef to <8 x double>
  %r227 = sitofp <8 x i16> undef to <8 x double>
  %r228 = uitofp <8 x i64> undef to <8 x double>
  %r229 = sitofp <8 x i64> undef to <8 x double>

  %r230 = uitofp <16 x i1> undef to <16 x float>
  %r231 = sitofp <16 x i1> undef to <16 x float>
  %r232 = uitofp <16 x i8> undef to <16 x float>
  %r233 = sitofp <16 x i8> undef to <16 x float>
  %r234 = uitofp <16 x i16> undef to <16 x float>
  %r235 = sitofp <16 x i16> undef to <16 x float>
  %r236 = uitofp <16 x i32> undef to <16 x float>
  %r237 = sitofp <16 x i32> undef to <16 x float>
  %r238 = uitofp <16 x i64> undef to <16 x float>
  %r239 = sitofp <16 x i64> undef to <16 x float>

  %r240 = uitofp <16 x i1> undef to <16 x double>
  %r241 = sitofp <16 x i1> undef to <16 x double>
  %r242 = uitofp <16 x i8> undef to <16 x double>
  %r243 = sitofp <16 x i8> undef to <16 x double>
  %r244 = uitofp <16 x i16> undef to <16 x double>
  %r245 = sitofp <16 x i16> undef to <16 x double>
  %r246 = uitofp <16 x i16> undef to <16 x double>
  %r247 = sitofp <16 x i16> undef to <16 x double>
  %r248 = uitofp <16 x i64> undef to <16 x double>
  %r249 = sitofp <16 x i64> undef to <16 x double>

  ret i32 undef
}

define i32 @casts_with_users(i8 %a, i16 %b, i32 %c, i64 %d, i1 %e) {
; CHECK-LABEL: 'casts_with_users'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r0 = sext i8 %a to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r1 = sext i8 %a to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r2 = sext i8 %a to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r3 = sext i16 %b to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r4 = sext i16 %b to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r5 = sext i32 %c to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i16 %r0, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r1, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r2, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r3, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r4, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r5, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r6 = zext i8 %a to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r7 = zext i8 %a to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r8 = zext i8 %a to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r9 = zext i16 %b to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r10 = zext i16 %b to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r11 = zext i32 %c to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i16 %r6, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r7, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r8, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r9, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r10, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r11, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r12 = trunc i64 %d to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r13 = trunc i64 %d to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r14 = trunc i64 %d to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r15 = trunc i32 %c to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r16 = trunc i32 %c to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r17 = trunc i16 %b to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %tie.trunc.8 = add i8 %r14, %r16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %tie.trunc.8.1 = add i8 %tie.trunc.8, %r17
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %tie.trunc.16 = add i16 %r13, %r15
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %free.trunc.16.8 = trunc i16 %r6 to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %free.trunc.32.8 = trunc i32 %r7 to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %free.trunc.32.16 = trunc i32 %r9 to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %free.trunc.64.8 = trunc i64 %r8 to i8
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %free.trunc.64.16 = trunc i64 %r10 to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %free.trunc.64.32 = trunc i64 %r11 to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r18 = sext i1 %e to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r19 = sext i1 %e to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r20 = sext i1 %e to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r21 = sext i1 %e to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r22 = zext i1 %e to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r23 = zext i1 %e to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %r24 = zext i1 %e to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r25 = zext i1 %e to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i8 %r18, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i16 %r19, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r20, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r21, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i8 %r22, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i16 %r23, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r24, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i64 %r25, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %r12
;
  %r0 = sext i8 %a to i16
  %r1 = sext i8 %a to i32
  %r2 = sext i8 %a to i64
  %r3 = sext i16 %b to i32
  %r4 = sext i16 %b to i64
  %r5 = sext i32 %c to i64
  store i16 %r0, ptr undef
  store i32 %r1, ptr undef
  store i64 %r2, ptr undef
  store i32 %r3, ptr undef
  store i64 %r4, ptr undef
  store i64 %r5, ptr undef

  %r6 = zext i8 %a to i16
  %r7 = zext i8 %a to i32
  %r8 = zext i8 %a to i64
  %r9 = zext i16 %b to i32
  %r10 = zext i16 %b to i64
  %r11 = zext i32 %c to i64
  store i16 %r6, ptr undef
  store i32 %r7, ptr undef
  store i64 %r8, ptr undef
  store i32 %r9, ptr undef
  store i64 %r10, ptr undef
  store i64 %r11, ptr undef

  %r12 = trunc i64 %d to i32
  %r13 = trunc i64 %d to i16
  %r14 = trunc i64 %d to i8
  %r15 = trunc i32 %c to i16
  %r16 = trunc i32 %c to i8
  %r17 = trunc i16 %b to i8
  %tie.trunc.8 = add i8 %r14, %r16
  %tie.trunc.8.1 = add i8 %tie.trunc.8, %r17
  %tie.trunc.16 = add i16 %r13, %r15

  %free.trunc.16.8 = trunc i16 %r6 to i8
  %free.trunc.32.8 = trunc i32 %r7 to i8
  %free.trunc.32.16 = trunc i32 %r9 to i16
  %free.trunc.64.8 = trunc i64 %r8 to i8
  %free.trunc.64.16 = trunc i64 %r10 to i16
  %free.trunc.64.32 = trunc i64 %r11 to i32

  %r18 = sext i1 %e to i8
  %r19 = sext i1 %e to i16
  %r20 = sext i1 %e to i32
  %r21 = sext i1 %e to i64
  %r22 = zext i1 %e to i8
  %r23 = zext i1 %e to i16
  %r24 = zext i1 %e to i32
  %r25 = zext i1 %e to i64
  store i8 %r18, ptr undef
  store i16 %r19, ptr undef
  store i32 %r20, ptr undef
  store i64 %r21, ptr undef
  store i8 %r22, ptr undef
  store i16 %r23, ptr undef
  store i32 %r24, ptr undef
  store i64 %r25, ptr undef
  ret i32 %r12
}

define i32 @bitcasts() {
; CHECK-LABEL: 'bitcasts'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %a = bitcast i32 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %b = bitcast float undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %c = bitcast i32 undef to float
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %d = bitcast float undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %e = bitcast i64 undef to double
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f = bitcast double undef to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %g = bitcast half undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %h = bitcast i16 undef to half
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %a = bitcast i32 undef to i32
  %b = bitcast float undef to float
  %c = bitcast i32 undef to float
  %d = bitcast float undef to i32
  %e = bitcast i64 undef to double
  %f = bitcast double undef to i64
  %g = bitcast half undef to i16
  %h = bitcast i16 undef to half
  ret i32 undef
}

define i32 @load_extends() {
; CHECK-LABEL: 'load_extends'
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadi8 = load i8, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadi16 = load i16, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadi32 = load i32, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:4 SizeLat:1 for: %loadv2i8 = load <2 x i8>, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %loadv4i8 = load <4 x i8>, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadv8i8 = load <8 x i8>, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:4 SizeLat:1 for: %loadv2i16 = load <2 x i16>, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadv4i16 = load <4 x i16>, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadv2i32 = load <2 x i32>, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %loadv4i32 = load <4 x i32>, ptr undef, align 16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r0 = sext i8 %loadi8 to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r1 = zext i8 %loadi8 to i16
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r2 = sext i8 %loadi8 to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r3 = zext i8 %loadi8 to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r4 = sext i8 %loadi8 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r5 = zext i8 %loadi8 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r6 = sext i16 %loadi16 to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r7 = zext i16 %loadi16 to i32
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r8 = sext i16 %loadi16 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r9 = zext i16 %loadi16 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r10 = sext i32 %loadi32 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r11 = zext i32 %loadi32 to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %loadi8 = load i8, ptr undef
  %loadi16 = load i16, ptr undef
  %loadi32 = load i32, ptr undef
  %loadv2i8 = load <2 x i8>, ptr undef
  %loadv4i8 = load <4 x i8>, ptr undef
  %loadv8i8 = load <8 x i8>, ptr undef
  %loadv2i16 = load <2 x i16>, ptr undef
  %loadv4i16 = load <4 x i16>, ptr undef
  %loadv2i32 = load <2 x i32>, ptr undef
  %loadv4i32 = load <4 x i32>, ptr undef

  %r0 = sext i8 %loadi8 to i16
  %r1 = zext i8 %loadi8 to i16
  %r2 = sext i8 %loadi8 to i32
  %r3 = zext i8 %loadi8 to i32
  %r4 = sext i8 %loadi8 to i64
  %r5 = zext i8 %loadi8 to i64
  %r6 = sext i16 %loadi16 to i32
  %r7 = zext i16 %loadi16 to i32
  %r8 = sext i16 %loadi16 to i64
  %r9 = zext i16 %loadi16 to i64
  %r10 = sext i32 %loadi32 to i64
  %r11 = zext i32 %loadi32 to i64

  %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
  %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
  %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
  %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
  %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
  %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
  %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
  %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
  %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
  %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
  %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
  %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
  %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
  %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>

  ret i32 undef
}

define i32 @store_truncs() {
; CHECK-LABEL: 'store_truncs'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r0 = trunc i64 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i8 %r0, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r1 = trunc i64 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i16 %r1, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r2 = trunc i64 undef to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i32 %r2, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r3 = trunc i32 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i8 %r3, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r4 = trunc i32 undef to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i16 %r4, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r5 = trunc i16 undef to i8
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store i8 %r5, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %r0 = trunc i64 undef to i8
  store i8 %r0, ptr undef
  %r1 = trunc i64 undef to i16
  store i16 %r1, ptr undef
  %r2 = trunc i64 undef to i32
  store i32 %r2, ptr undef
  %r3 = trunc i32 undef to i8
  store i8 %r3, ptr undef
  %r4 = trunc i32 undef to i16
  store i16 %r4, ptr undef
  %r5 = trunc i16 undef to i8
  store i8 %r5, ptr undef
  ret i32 undef
}

define void @extend_extract() {
; CHECK-LABEL: 'extend_extract'
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %e8 = extractelement <8 x i8> undef, i32 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %e16 = extractelement <8 x i16> undef, i32 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %e32 = extractelement <8 x i32> undef, i32 1
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s8_16 = sext i8 %e8 to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z8_16 = zext i8 %e8 to i16
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s8_32 = sext i8 %e8 to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z8_32 = zext i8 %e8 to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s8_64 = sext i8 %e8 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %z8_64 = zext i8 %e8 to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s16_32 = sext i16 %e16 to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %z16_32 = zext i16 %e16 to i32
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s16_64 = sext i16 %e16 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %z16_64 = zext i16 %e16 to i64
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %s32_64 = sext i32 %e32 to i64
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %z32_64 = zext i32 %e32 to i64
; CHECK-NEXT:  Cost Model: Found costs of 13 for: call void @use(i16 %s8_16, i16 %z8_16, i32 %s8_32, i32 %z8_32, i64 %s8_64, i64 %z8_64, i32 %s16_32, i32 %z16_32, i64 %s16_64, i64 %z16_64, i64 %s32_64, i64 %z32_64)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %e8 = extractelement <8 x i8> undef, i32 1
  %e16 = extractelement <8 x i16> undef, i32 1
  %e32 = extractelement <8 x i32> undef, i32 1
  %s8_16 = sext i8 %e8 to i16
  %z8_16 = zext i8 %e8 to i16
  %s8_32 = sext i8 %e8 to i32
  %z8_32 = zext i8 %e8 to i32
  %s8_64 = sext i8 %e8 to i64
  %z8_64 = zext i8 %e8 to i64
  %s16_32 = sext i16 %e16 to i32
  %z16_32 = zext i16 %e16 to i32
  %s16_64 = sext i16 %e16 to i64
  %z16_64 = zext i16 %e16 to i64
  %s32_64 = sext i32 %e32 to i64
  %z32_64 = zext i32 %e32 to i64
  call void @use(i16 %s8_16, i16 %z8_16, i32 %s8_32, i32 %z8_32, i64 %s8_64, i64 %z8_64, i32 %s16_32, i32 %z16_32, i64 %s16_64, i64 %z16_64, i64 %s32_64, i64 %z32_64)
  ret void
}

declare void @use(i16, i16, i32, i32, i64, i64, i32, i32, i64, i64, i64, i64)

define void @fp16cast() {
; CHECK-NOFP16-LABEL: 'fp16cast'
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r30 = fptoui half undef to i1
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r31 = fptosi half undef to i1
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r32 = fptoui half undef to i8
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r33 = fptosi half undef to i8
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r34 = fptoui half undef to i16
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r35 = fptosi half undef to i16
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r36 = fptoui half undef to i32
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r37 = fptosi half undef to i32
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r38 = fptoui half undef to i64
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r39 = fptosi half undef to i64
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r90 = fptoui <2 x half> undef to <2 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r91 = fptosi <2 x half> undef to <2 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r92 = fptoui <2 x half> undef to <2 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r93 = fptosi <2 x half> undef to <2 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r94 = fptoui <2 x half> undef to <2 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r95 = fptosi <2 x half> undef to <2 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r96 = fptoui <2 x half> undef to <2 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r97 = fptosi <2 x half> undef to <2 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r98 = fptoui <2 x half> undef to <2 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r99 = fptosi <2 x half> undef to <2 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r110 = fptoui <4 x half> undef to <4 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r111 = fptosi <4 x half> undef to <4 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r112 = fptoui <4 x half> undef to <4 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r113 = fptosi <4 x half> undef to <4 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r114 = fptoui <4 x half> undef to <4 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r115 = fptosi <4 x half> undef to <4 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r116 = fptoui <4 x half> undef to <4 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %r117 = fptosi <4 x half> undef to <4 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r118 = fptoui <4 x half> undef to <4 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r119 = fptosi <4 x half> undef to <4 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %r130 = fptoui <8 x half> undef to <8 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %r131 = fptosi <8 x half> undef to <8 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %r132 = fptoui <8 x half> undef to <8 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %r133 = fptosi <8 x half> undef to <8 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r134 = fptoui <8 x half> undef to <8 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r135 = fptosi <8 x half> undef to <8 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:41 CodeSize:1 Lat:1 SizeLat:1 for: %r136 = fptoui <8 x half> undef to <8 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:41 CodeSize:1 Lat:1 SizeLat:1 for: %r137 = fptosi <8 x half> undef to <8 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %r138 = fptoui <8 x half> undef to <8 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %r139 = fptosi <8 x half> undef to <8 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:81 CodeSize:1 Lat:1 SizeLat:1 for: %r150 = fptoui <16 x half> undef to <16 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:81 CodeSize:1 Lat:1 SizeLat:1 for: %r151 = fptosi <16 x half> undef to <16 x i1>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:81 CodeSize:1 Lat:1 SizeLat:1 for: %r152 = fptoui <16 x half> undef to <16 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:81 CodeSize:1 Lat:1 SizeLat:1 for: %r153 = fptosi <16 x half> undef to <16 x i8>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r154 = fptoui <16 x half> undef to <16 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r155 = fptosi <16 x half> undef to <16 x i16>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:82 CodeSize:1 Lat:1 SizeLat:1 for: %r156 = fptoui <16 x half> undef to <16 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:82 CodeSize:1 Lat:1 SizeLat:1 for: %r157 = fptosi <16 x half> undef to <16 x i32>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:1 Lat:1 SizeLat:1 for: %r158 = fptoui <16 x half> undef to <16 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:1 Lat:1 SizeLat:1 for: %r159 = fptosi <16 x half> undef to <16 x i64>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r250 = uitofp <8 x i1> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r251 = sitofp <8 x i1> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r252 = uitofp <8 x i8> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r253 = sitofp <8 x i8> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r254 = uitofp <8 x i16> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %r255 = sitofp <8 x i16> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r256 = uitofp <8 x i32> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r257 = sitofp <8 x i32> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r258 = uitofp <8 x i64> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r259 = sitofp <8 x i64> undef to <8 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r260 = uitofp <16 x i1> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r261 = sitofp <16 x i1> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r262 = uitofp <16 x i8> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r263 = sitofp <16 x i8> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r264 = uitofp <16 x i16> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r265 = sitofp <16 x i16> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %r266 = uitofp <16 x i32> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %r267 = sitofp <16 x i32> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %r268 = uitofp <16 x i64> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %r269 = sitofp <16 x i64> undef to <16 x half>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fp16cast'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r30 = fptoui half undef to i1
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r31 = fptosi half undef to i1
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r32 = fptoui half undef to i8
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r33 = fptosi half undef to i8
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r34 = fptoui half undef to i16
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r35 = fptosi half undef to i16
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r36 = fptoui half undef to i32
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r37 = fptosi half undef to i32
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r38 = fptoui half undef to i64
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r39 = fptosi half undef to i64
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r90 = fptoui <2 x half> undef to <2 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r91 = fptosi <2 x half> undef to <2 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r92 = fptoui <2 x half> undef to <2 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r93 = fptosi <2 x half> undef to <2 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r94 = fptoui <2 x half> undef to <2 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r95 = fptosi <2 x half> undef to <2 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r96 = fptoui <2 x half> undef to <2 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r97 = fptosi <2 x half> undef to <2 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r98 = fptoui <2 x half> undef to <2 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %r99 = fptosi <2 x half> undef to <2 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r110 = fptoui <4 x half> undef to <4 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r111 = fptosi <4 x half> undef to <4 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r112 = fptoui <4 x half> undef to <4 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r113 = fptosi <4 x half> undef to <4 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r114 = fptoui <4 x half> undef to <4 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r115 = fptosi <4 x half> undef to <4 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r116 = fptoui <4 x half> undef to <4 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r117 = fptosi <4 x half> undef to <4 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r118 = fptoui <4 x half> undef to <4 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %r119 = fptosi <4 x half> undef to <4 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %r130 = fptoui <8 x half> undef to <8 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %r131 = fptosi <8 x half> undef to <8 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r132 = fptoui <8 x half> undef to <8 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r133 = fptosi <8 x half> undef to <8 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r134 = fptoui <8 x half> undef to <8 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r135 = fptosi <8 x half> undef to <8 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r136 = fptoui <8 x half> undef to <8 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r137 = fptosi <8 x half> undef to <8 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %r138 = fptoui <8 x half> undef to <8 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %r139 = fptosi <8 x half> undef to <8 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:81 CodeSize:1 Lat:1 SizeLat:1 for: %r150 = fptoui <16 x half> undef to <16 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:81 CodeSize:1 Lat:1 SizeLat:1 for: %r151 = fptosi <16 x half> undef to <16 x i1>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r152 = fptoui <16 x half> undef to <16 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r153 = fptosi <16 x half> undef to <16 x i8>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r154 = fptoui <16 x half> undef to <16 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r155 = fptosi <16 x half> undef to <16 x i16>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r156 = fptoui <16 x half> undef to <16 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %r157 = fptosi <16 x half> undef to <16 x i32>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:1 Lat:1 SizeLat:1 for: %r158 = fptoui <16 x half> undef to <16 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:1 Lat:1 SizeLat:1 for: %r159 = fptosi <16 x half> undef to <16 x i64>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r250 = uitofp <8 x i1> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r251 = sitofp <8 x i1> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r252 = uitofp <8 x i8> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r253 = sitofp <8 x i8> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r254 = uitofp <8 x i16> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %r255 = sitofp <8 x i16> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r256 = uitofp <8 x i32> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r257 = sitofp <8 x i32> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r258 = uitofp <8 x i64> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %r259 = sitofp <8 x i64> undef to <8 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r260 = uitofp <16 x i1> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %r261 = sitofp <16 x i1> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r262 = uitofp <16 x i8> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %r263 = sitofp <16 x i8> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r264 = uitofp <16 x i16> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %r265 = sitofp <16 x i16> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %r266 = uitofp <16 x i32> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %r267 = sitofp <16 x i32> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %r268 = uitofp <16 x i64> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %r269 = sitofp <16 x i64> undef to <16 x half>
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %r30 = fptoui half undef to i1
  %r31 = fptosi half undef to i1
  %r32 = fptoui half undef to i8
  %r33 = fptosi half undef to i8
  %r34 = fptoui half undef to i16
  %r35 = fptosi half undef to i16
  %r36 = fptoui half undef to i32
  %r37 = fptosi half undef to i32
  %r38 = fptoui half undef to i64
  %r39 = fptosi half undef to i64

  %r90 = fptoui <2 x half> undef to <2 x i1>
  %r91 = fptosi <2 x half> undef to <2 x i1>
  %r92 = fptoui <2 x half> undef to <2 x i8>
  %r93 = fptosi <2 x half> undef to <2 x i8>
  %r94 = fptoui <2 x half> undef to <2 x i16>
  %r95 = fptosi <2 x half> undef to <2 x i16>
  %r96 = fptoui <2 x half> undef to <2 x i32>
  %r97 = fptosi <2 x half> undef to <2 x i32>
  %r98 = fptoui <2 x half> undef to <2 x i64>
  %r99 = fptosi <2 x half> undef to <2 x i64>

  %r110 = fptoui <4 x half> undef to <4 x i1>
  %r111 = fptosi <4 x half> undef to <4 x i1>
  %r112 = fptoui <4 x half> undef to <4 x i8>
  %r113 = fptosi <4 x half> undef to <4 x i8>
  %r114 = fptoui <4 x half> undef to <4 x i16>
  %r115 = fptosi <4 x half> undef to <4 x i16>
  %r116 = fptoui <4 x half> undef to <4 x i32>
  %r117 = fptosi <4 x half> undef to <4 x i32>
  %r118 = fptoui <4 x half> undef to <4 x i64>
  %r119 = fptosi <4 x half> undef to <4 x i64>

  %r130 = fptoui <8 x half> undef to <8 x i1>
  %r131 = fptosi <8 x half> undef to <8 x i1>
  %r132 = fptoui <8 x half> undef to <8 x i8>
  %r133 = fptosi <8 x half> undef to <8 x i8>
  %r134 = fptoui <8 x half> undef to <8 x i16>
  %r135 = fptosi <8 x half> undef to <8 x i16>
  %r136 = fptoui <8 x half> undef to <8 x i32>
  %r137 = fptosi <8 x half> undef to <8 x i32>
  %r138 = fptoui <8 x half> undef to <8 x i64>
  %r139 = fptosi <8 x half> undef to <8 x i64>

  %r150 = fptoui <16 x half> undef to <16 x i1>
  %r151 = fptosi <16 x half> undef to <16 x i1>
  %r152 = fptoui <16 x half> undef to <16 x i8>
  %r153 = fptosi <16 x half> undef to <16 x i8>
  %r154 = fptoui <16 x half> undef to <16 x i16>
  %r155 = fptosi <16 x half> undef to <16 x i16>
  %r156 = fptoui <16 x half> undef to <16 x i32>
  %r157 = fptosi <16 x half> undef to <16 x i32>
  %r158 = fptoui <16 x half> undef to <16 x i64>
  %r159 = fptosi <16 x half> undef to <16 x i64>

  %r250 = uitofp <8 x i1> undef to <8 x half>
  %r251 = sitofp <8 x i1> undef to <8 x half>
  %r252 = uitofp <8 x i8> undef to <8 x half>
  %r253 = sitofp <8 x i8> undef to <8 x half>
  %r254 = uitofp <8 x i16> undef to <8 x half>
  %r255 = sitofp <8 x i16> undef to <8 x half>
  %r256 = uitofp <8 x i32> undef to <8 x half>
  %r257 = sitofp <8 x i32> undef to <8 x half>
  %r258 = uitofp <8 x i64> undef to <8 x half>
  %r259 = sitofp <8 x i64> undef to <8 x half>

  %r260 = uitofp <16 x i1> undef to <16 x half>
  %r261 = sitofp <16 x i1> undef to <16 x half>
  %r262 = uitofp <16 x i8> undef to <16 x half>
  %r263 = sitofp <16 x i8> undef to <16 x half>
  %r264 = uitofp <16 x i16> undef to <16 x half>
  %r265 = sitofp <16 x i16> undef to <16 x half>
  %r266 = uitofp <16 x i32> undef to <16 x half>
  %r267 = sitofp <16 x i32> undef to <16 x half>
  %r268 = uitofp <16 x i64> undef to <16 x half>
  %r269 = sitofp <16 x i64> undef to <16 x half>
  ret void
}

define void @bf16cast() {
; CHECK-NOFP16-LABEL: 'bf16cast'
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %extf16f32 = fpext bfloat undef to float
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %extv2f16f32 = fpext <2 x bfloat> undef to <2 x float>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of 1 for: %extv4f16f32 = fpext <4 x bfloat> undef to <4 x float>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extv8f16f32 = fpext <8 x bfloat> undef to <8 x float>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %extv16f16f32 = fpext <16 x bfloat> undef to <16 x float>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extf16f64 = fpext bfloat undef to double
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extv2f16f64 = fpext <2 x bfloat> undef to <2 x double>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %extv4f16f64 = fpext <4 x bfloat> undef to <4 x double>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %extv8f16f64 = fpext <8 x bfloat> undef to <8 x double>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %extv16f16f64 = fpext <16 x bfloat> undef to <16 x double>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %truncf16f32 = fptrunc float undef to bfloat
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %truncv2f16f32 = fptrunc <2 x float> undef to <2 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %truncv4f16f32 = fptrunc <4 x float> undef to <4 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:1 Lat:1 SizeLat:1 for: %truncv8f16f32 = fptrunc <8 x float> undef to <8 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:1 Lat:1 SizeLat:1 for: %truncv16f16f32 = fptrunc <16 x float> undef to <16 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %truncf16f64 = fptrunc double undef to bfloat
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %truncv2f16f64 = fptrunc <2 x double> undef to <2 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %truncv4f16f64 = fptrunc <4 x double> undef to <4 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:1 SizeLat:1 for: %truncv8f16f64 = fptrunc <8 x double> undef to <8 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:1 SizeLat:1 for: %truncv16f16f64 = fptrunc <16 x double> undef to <16 x bfloat>
; CHECK-NOFP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-BF16-LABEL: 'bf16cast'
; CHECK-BF16-NEXT:  Cost Model: Found costs of 1 for: %extf16f32 = fpext bfloat undef to float
; CHECK-BF16-NEXT:  Cost Model: Found costs of 1 for: %extv2f16f32 = fpext <2 x bfloat> undef to <2 x float>
; CHECK-BF16-NEXT:  Cost Model: Found costs of 1 for: %extv4f16f32 = fpext <4 x bfloat> undef to <4 x float>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extv8f16f32 = fpext <8 x bfloat> undef to <8 x float>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %extv16f16f32 = fpext <16 x bfloat> undef to <16 x float>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extf16f64 = fpext bfloat undef to double
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %extv2f16f64 = fpext <2 x bfloat> undef to <2 x double>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %extv4f16f64 = fpext <4 x bfloat> undef to <4 x double>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %extv8f16f64 = fpext <8 x bfloat> undef to <8 x double>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %extv16f16f64 = fpext <16 x bfloat> undef to <16 x double>
; CHECK-BF16-NEXT:  Cost Model: Found costs of 1 for: %truncf16f32 = fptrunc float undef to bfloat
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %truncv2f16f32 = fptrunc <2 x float> undef to <2 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of 1 for: %truncv4f16f32 = fptrunc <4 x float> undef to <4 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %truncv8f16f32 = fptrunc <8 x float> undef to <8 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %truncv16f16f32 = fptrunc <16 x float> undef to <16 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of 1 for: %truncf16f64 = fptrunc double undef to bfloat
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %truncv2f16f64 = fptrunc <2 x double> undef to <2 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %truncv4f16f64 = fptrunc <4 x double> undef to <4 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %truncv8f16f64 = fptrunc <8 x double> undef to <8 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %truncv16f16f64 = fptrunc <16 x double> undef to <16 x bfloat>
; CHECK-BF16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %extf16f32 = fpext bfloat undef to float
  %extv2f16f32 = fpext <2 x bfloat> undef to <2 x float>
  %extv4f16f32 = fpext <4 x bfloat> undef to <4 x float>
  %extv8f16f32 = fpext <8 x bfloat> undef to <8 x float>
  %extv16f16f32 = fpext <16 x bfloat> undef to <16 x float>
  %extf16f64 = fpext bfloat undef to double
  %extv2f16f64 = fpext <2 x bfloat> undef to <2 x double>
  %extv4f16f64 = fpext <4 x bfloat> undef to <4 x double>
  %extv8f16f64 = fpext <8 x bfloat> undef to <8 x double>
  %extv16f16f64 = fpext <16 x bfloat> undef to <16 x double>
  %truncf16f32 = fptrunc float undef to bfloat
  %truncv2f16f32 = fptrunc <2 x float> undef to <2 x bfloat>
  %truncv4f16f32 = fptrunc <4 x float> undef to <4 x bfloat>
  %truncv8f16f32 = fptrunc <8 x float> undef to <8 x bfloat>
  %truncv16f16f32 = fptrunc <16 x float> undef to <16 x bfloat>
  %truncf16f64 = fptrunc double undef to bfloat
  %truncv2f16f64 = fptrunc <2 x double> undef to <2 x bfloat>
  %truncv4f16f64 = fptrunc <4 x double> undef to <4 x bfloat>
  %truncv8f16f64 = fptrunc <8 x double> undef to <8 x bfloat>
  %truncv16f16f64 = fptrunc <16 x double> undef to <16 x bfloat>
  ret void
}
