; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; Basic test to check that DominatorTreeAnalysis is preserved by IPSCCP and
; the following analysis can re-use it. The test contains two trivial functions
; IPSCCP can simplify, so we can test the case where IPSCCP makes changes.

; RUN: opt -disable-verify -debug-pass-manager \
; RUN: -passes='function(require<domtree>,require<postdomtree>),ipsccp,function(require<domtree>,require<postdomtree>)' -S  %s 2>&1 \
; RUN:     | FileCheck -check-prefixes=IR,NEW-PM %s

; RUN: opt -passes='function(require<postdomtree>),ipsccp,function(verify<domtree>)' -S  %s | FileCheck -check-prefixes=IR %s

; NEW-PM: Running analysis: DominatorTreeAnalysis on f1
; NEW-PM: Running analysis: PostDominatorTreeAnalysis on f1
; NEW-PM: Running analysis: DominatorTreeAnalysis on f2
; NEW-PM: Running analysis: PostDominatorTreeAnalysis on f2
; NEW-PM: Running pass: IPSCCPPass
; NEW-PM-DAG: Running analysis: AssumptionAnalysis on f1
; NEW-PM-DAG: Running analysis: AssumptionAnalysis on f2
; NEW-PM-NOT: Running analysis: AssumptionAnalysis


define internal i32 @f1() readnone {
; IR-LABEL: define internal i32 @f1(
; IR-SAME: ) #[[ATTR0:[0-9]+]] {
; IR-NEXT:  [[ENTRY:.*:]]
; IR-NEXT:    br label %[[BB2:.*]]
; IR:       [[BB2]]:
; IR-NEXT:    ret i32 poison
;
entry:
  br i1 false, label %bb1, label %bb2
bb1:
  ret i32 10
bb2:
  ret i32 10
}

define i32 @f2(i32 %n) {
; IR-LABEL: define i32 @f2(
; IR-SAME: i32 [[N:%.*]]) {
; IR-NEXT:    [[I:%.*]] = call i32 @f1()
; IR-NEXT:    br label %[[BBTRUE:.*]]
; IR:       [[BBTRUE]]:
; IR-NEXT:    ret i32 0
;
  %i = call i32 @f1()
  %cmp = icmp eq i32 %i, 10
  br i1 %cmp, label %bbtrue, label %bbfalse

bbtrue:
  ret i32 0

bbfalse:
  %res = add i32 %n, %i
  ret i32 %res
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; NEW-PM: {{.*}}
