; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=reassociate,dce -S | FileCheck %s
; PR12985

; Verify the nsw flags are preserved when converting shl to mul.

define i32 @shl_to_mul_nsw(i32 %i) {
;
; CHECK-LABEL: @shl_to_mul_nsw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = mul i32 [[I:%.*]], -2147483648
; CHECK-NEXT:    [[MUL2:%.*]] = add i32 [[MUL]], 1
; CHECK-NEXT:    ret i32 [[MUL2]]
;
entry:
  %mul = shl nsw i32 %i, 31
  %mul2 = add i32 %mul, 1
  ret i32 %mul2
}

define i32 @shl_to_mul_nsw_2(i32 %i) {
;
; CHECK-LABEL: @shl_to_mul_nsw_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[I:%.*]], 1073741824
; CHECK-NEXT:    [[MUL2:%.*]] = add i32 [[MUL]], 1
; CHECK-NEXT:    ret i32 [[MUL2]]
;
entry:
  %mul = shl nsw i32 %i, 30
  %mul2 = add i32 %mul, 1
  ret i32 %mul2
}

define i32 @shl_to_mul_nuw(i32 %i) {
;
; CHECK-LABEL: @shl_to_mul_nuw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = mul nuw i32 [[I:%.*]], 4
; CHECK-NEXT:    [[MUL2:%.*]] = add i32 [[MUL]], 1
; CHECK-NEXT:    ret i32 [[MUL2]]
;
entry:
  %mul = shl nuw i32 %i, 2
  %mul2 = add i32 %mul, 1
  ret i32 %mul2
}

define i32 @shl_to_mul_nuw_nsw(i32 %i) {
;
; CHECK-LABEL: @shl_to_mul_nuw_nsw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = mul nuw nsw i32 [[I:%.*]], 4
; CHECK-NEXT:    [[MUL2:%.*]] = add i32 [[MUL]], 1
; CHECK-NEXT:    ret i32 [[MUL2]]
;
entry:
  %mul = shl nuw nsw i32 %i, 2
  %mul2 = add i32 %mul, 1
  ret i32 %mul2
}

define i32 @shl_to_mul_nuw_nsw_bitwidth_m1(i32 %i) {
;
; CHECK-LABEL: @shl_to_mul_nuw_nsw_bitwidth_m1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = mul nuw nsw i32 [[I:%.*]], -2147483648
; CHECK-NEXT:    [[MUL2:%.*]] = add i32 [[MUL]], 1
; CHECK-NEXT:    ret i32 [[MUL2]]
;
entry:
  %mul = shl nuw nsw i32 %i, 31
  %mul2 = add i32 %mul, 1
  ret i32 %mul2
}

define i2 @pr23926(i2 %X1, i2 %X2) {
;
; CHECK-LABEL: @pr23926(
; CHECK-NEXT:    [[X1_NEG:%.*]] = sub i2 0, [[X1:%.*]]
; CHECK-NEXT:    [[ADD_NEG:%.*]] = add i2 [[X1_NEG]], -1
; CHECK-NEXT:    [[SUB:%.*]] = add i2 [[ADD_NEG]], [[X2:%.*]]
; CHECK-NEXT:    ret i2 [[SUB]]
;
  %add = add nuw i2 %X1, 1
  %sub = sub nuw nsw i2 %X2, %add
  ret i2 %sub
}
