; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-unroll -unroll-full-max-count=0 -S %s | FileCheck %s

declare void @foo(i32)

define void @peel_with_guard_known_nonnegative_1(i32 %n) {
; CHECK-LABEL: define void @peel_with_guard_known_nonnegative_1(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp slt i32 [[N]], 0
; CHECK-NEXT:    br i1 [[PRECOND]], label %[[EXIT:.*]], label %[[PH:.*]]
; CHECK:       [[PH]]:
; CHECK-NEXT:    [[N_EXT:%.*]] = zext i32 [[N]] to i64
; CHECK-NEXT:    [[N_1:%.*]] = add i32 [[N]], 1
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[N_1]] to i64
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[WIDE_TRIP_COUNT]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i64 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TMP1]], label %[[PH_SPLIT:.*]], label %[[EXIT_LOOPEXIT_PEEL_BEGIN:.*]]
; CHECK:       [[PH_SPLIT]]:
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IV1:%.*]] = phi i64 [ 0, %[[PH_SPLIT]] ], [ [[IV_NEXT1:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[IV_NEXT1]] = add nuw nsw i64 [[IV1]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = sub i64 [[WIDE_TRIP_COUNT]], 1
; CHECK-NEXT:    [[EC1:%.*]] = icmp eq i64 [[IV_NEXT1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[EC1]], label %[[EXIT_LOOPEXIT_PEEL_BEGIN_LOOPEXIT:.*]], label %[[LOOP]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       [[EXIT_LOOPEXIT_PEEL_BEGIN_LOOPEXIT]]:
; CHECK-NEXT:    [[DOTPH:%.*]] = phi i64 [ [[IV_NEXT1]], %[[LOOP]] ]
; CHECK-NEXT:    br label %[[EXIT_LOOPEXIT_PEEL_BEGIN]]
; CHECK:       [[EXIT_LOOPEXIT_PEEL_BEGIN]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[PH]] ], [ [[DOTPH]], %[[EXIT_LOOPEXIT_PEEL_BEGIN_LOOPEXIT]] ]
; CHECK-NEXT:    br label %[[LOOP_PEEL:.*]]
; CHECK:       [[LOOP_PEEL]]:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i64 [[IV]], [[N_EXT]]
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[C]], i32 10, i32 20
; CHECK-NEXT:    [[IV_NEXT:%.*]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT_LOOPEXIT_PEEL_NEXT:.*]], label %[[EXIT_LOOPEXIT_PEEL_NEXT]]
; CHECK:       [[EXIT_LOOPEXIT_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[LOOP_PEEL_NEXT:.*]]
; CHECK:       [[LOOP_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[EXIT_LOOPEXIT:.*]]
; CHECK:       [[EXIT_LOOPEXIT]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  %precond = icmp slt i32 %n, 0
  br i1 %precond, label %exit, label %ph

ph:
  %n.ext = zext i32 %n to i64
  %n.1 = add i32 %n, 1
  %wide.trip.count = zext i32 %n.1 to i64
  br label %loop

loop:
  %iv = phi i64 [ 0, %ph ], [ %iv.next, %loop ]
  %c = icmp eq i64 %iv, %n.ext
  %spec.select = select i1 %c, i32 10, i32 20
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %wide.trip.count
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define i32 @peel_with_guard_known_nonnegative_2(ptr %x, i32 %w) {
; CHECK-LABEL: define i32 @peel_with_guard_known_nonnegative_2(
; CHECK-SAME: ptr [[X:%.*]], i32 [[W:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sgt i32 [[W]], 0
; CHECK-NEXT:    br i1 [[PRECOND]], label %[[PH:.*]], label %[[EXIT:.*]]
; CHECK:       [[PH]]:
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i32 [[W]], -1
; CHECK-NEXT:    [[TMP0:%.*]] = zext nneg i32 [[SUB]] to i64
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext nneg i32 [[W]] to i64
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[RED:%.*]] = phi i32 [ 0, %[[PH]] ], [ [[ADD:%.*]], %[[LOOP_LATCH]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i64 [[IV]], [[TMP0]]
; CHECK-NEXT:    br i1 [[CMP1]], label %[[IF_THEN:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    tail call void @foo()
; CHECK-NEXT:    br label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds nuw i32, ptr [[X]], i64 [[IV]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[TMP1]], [[RED]]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT_LOOPEXIT:.*]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT_LOOPEXIT]]:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i32 [ [[ADD]], %[[LOOP_LATCH]] ]
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RED_LCSSA:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[ADD_LCSSA]], %[[EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i32 [[RED_LCSSA]]
;
entry:
  %precond = icmp sgt i32 %w, 0
  br i1 %precond, label %ph, label %exit

ph:
  %sub = add nsw i32 %w, -1
  %0 = zext nneg i32 %sub to i64
  %wide.trip.count = zext nneg i32 %w to i64
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %ph ], [ %iv.next, %loop.latch ]
  %red = phi i32 [ 0, %ph ], [ %add, %loop.latch ]
  %cmp1 = icmp eq i64 %iv, %0
  br i1 %cmp1, label %if.then, label %loop.latch

if.then:
  tail call void @foo()
  br label %loop.latch

loop.latch:
  %arrayidx = getelementptr inbounds nuw i32, ptr %x, i64 %iv
  %1 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %1, %red
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %wide.trip.count
  br i1 %ec, label %exit, label %loop.header

exit:
  %red.lcssa = phi i32 [ 0, %entry ], [ %add, %loop.latch ]
  ret i32 %red.lcssa
}

define void @peel_with_guard2(i32 %n) {
; CHECK-LABEL: define void @peel_with_guard2(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = add i32 [[N]], -1
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp eq i32 [[SUB]], 0
; CHECK-NEXT:    br i1 [[PRECOND]], label %[[EXIT:.*]], label %[[LOOP_HEADER_PREHEADER:.*]]
; CHECK:       [[LOOP_HEADER_PREHEADER]]:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[N]], -2
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TMP1]], label %[[LOOP_HEADER_PREHEADER_SPLIT:.*]], label %[[EXIT_LOOPEXIT_PEEL_BEGIN:.*]]
; CHECK:       [[LOOP_HEADER_PREHEADER_SPLIT]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ 1, %[[LOOP_HEADER_PREHEADER_SPLIT]] ]
; CHECK-NEXT:    br i1 false, label %[[THEN:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[THEN]]:
; CHECK-NEXT:    call void @foo()
; CHECK-NEXT:    br label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i32 [[IV]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = sub i32 [[N]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], [[TMP2]]
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT_LOOPEXIT_PEEL_BEGIN_LOOPEXIT:.*]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP2:![0-9]+]]
; CHECK:       [[EXIT_LOOPEXIT_PEEL_BEGIN_LOOPEXIT]]:
; CHECK-NEXT:    [[DOTPH:%.*]] = phi i32 [ [[IV_NEXT]], %[[LOOP_LATCH]] ]
; CHECK-NEXT:    br label %[[EXIT_LOOPEXIT_PEEL_BEGIN]]
; CHECK:       [[EXIT_LOOPEXIT_PEEL_BEGIN]]:
; CHECK-NEXT:    [[TMP3:%.*]] = phi i32 [ 1, %[[LOOP_HEADER_PREHEADER]] ], [ [[DOTPH]], %[[EXIT_LOOPEXIT_PEEL_BEGIN_LOOPEXIT]] ]
; CHECK-NEXT:    br label %[[LOOP_HEADER_PEEL:.*]]
; CHECK:       [[LOOP_HEADER_PEEL]]:
; CHECK-NEXT:    [[C_PEEL:%.*]] = icmp eq i32 [[TMP3]], [[SUB]]
; CHECK-NEXT:    br i1 [[C_PEEL]], label %[[THEN_PEEL:.*]], label %[[LOOP_LATCH_PEEL:.*]]
; CHECK:       [[THEN_PEEL]]:
; CHECK-NEXT:    call void @foo()
; CHECK-NEXT:    br label %[[LOOP_LATCH_PEEL]]
; CHECK:       [[LOOP_LATCH_PEEL]]:
; CHECK-NEXT:    [[IV_NEXT_PEEL:%.*]] = add nuw i32 [[TMP3]], 1
; CHECK-NEXT:    [[EC_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_PEEL]], [[N]]
; CHECK-NEXT:    br i1 [[EC_PEEL]], label %[[EXIT_LOOPEXIT_PEEL_NEXT:.*]], label %[[EXIT_LOOPEXIT_PEEL_NEXT]]
; CHECK:       [[EXIT_LOOPEXIT_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER_PEEL_NEXT:.*]]
; CHECK:       [[LOOP_HEADER_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[EXIT_LOOPEXIT:.*]]
; CHECK:       [[EXIT_LOOPEXIT]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  %sub = add i32 %n, -1
  %precond = icmp eq i32 %sub, 0
  br i1 %precond, label %exit, label %loop.header

loop.header:
  %iv = phi i32 [ 1, %entry ], [ %iv.next, %loop.latch ]
  %c = icmp eq i32 %iv, %sub
  br i1 %c, label %then, label %loop.latch

then:
  call void @foo()
  br label %loop.latch

loop.latch:
  %iv.next = add nuw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, %n
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.peeled.count", i32 1}
; CHECK: [[LOOP2]] = distinct !{[[LOOP2]], [[META1]]}
;.
