; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

; The pattern:
;   add(add A, 1), (sext(icmp ne A, 0))
; is transformed into:
;   umax(A, 1)

define i32 @add_sext_icmp(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD2:%.*]] = call i32 @llvm.umax.i32(i32 [[A]], i32 1)
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  %icmp = icmp ne i32 %A, 0
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %add1, %sext
  ret i32 %add2
}

define i32 @add_sext_icmp_commutative(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_commutative(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD2:%.*]] = call i32 @llvm.umax.i32(i32 [[A]], i32 1)
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  %icmp = icmp ne i32 %A, 0
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %sext, %add1
  ret i32 %add2
}

; Negative test

define i32 @add_sext_icmp_negative_constant(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_negative_constant(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A]], 2
; CHECK-NEXT:    [[ICMP:%.*]] = icmp ne i32 [[A]], 0
; CHECK-NEXT:    [[SEXT:%.*]] = sext i1 [[ICMP]] to i32
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[SEXT]]
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 2
  %icmp = icmp ne i32 %A, 0
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %add1, %sext
  ret i32 %add2
}

define i32 @add_sext_icmp_negative_pred(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_negative_pred(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A]], 1
; CHECK-NEXT:    [[ICMP:%.*]] = icmp eq i32 [[A]], 0
; CHECK-NEXT:    [[SEXT:%.*]] = sext i1 [[ICMP]] to i32
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[SEXT]]
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  %icmp = icmp eq i32 %A, 0
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %add1, %sext
  ret i32 %add2
}

; multi-use test

define i32 @add_sext_icmp_multi_use_add2(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_multi_use_add2(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD2:%.*]] = call i32 @llvm.umax.i32(i32 [[A]], i32 1)
; CHECK-NEXT:    call void @use(i32 [[ADD2]])
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  %icmp = icmp ne i32 %A, 0
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %add1, %sext
  call void @use(i32 %add2)
  ret i32 %add2
}

define i32 @add_sext_icmp_multi_use_sext(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_multi_use_sext(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A]], 1
; CHECK-NEXT:    [[ICMP:%.*]] = icmp ne i32 [[A]], 0
; CHECK-NEXT:    [[SEXT:%.*]] = sext i1 [[ICMP]] to i32
; CHECK-NEXT:    call void @use(i32 [[SEXT]])
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[SEXT]]
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  %icmp = icmp ne i32 %A, 0
  %sext = sext i1 %icmp to i32
  call void @use(i32 %sext)
  %add2 = add i32 %add1, %sext
  ret i32 %add2
}

define i32 @add_sext_icmp_multi_use_icmp(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_multi_use_icmp(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A]], 1
; CHECK-NEXT:    [[ICMP:%.*]] = icmp ne i32 [[A]], 0
; CHECK-NEXT:    call void @use(i1 [[ICMP]])
; CHECK-NEXT:    [[SEXT:%.*]] = sext i1 [[ICMP]] to i32
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[SEXT]]
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  %icmp = icmp ne i32 %A, 0
  call void @use(i1 %icmp)
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %add1, %sext
  ret i32 %add2
}

define i32 @add_sext_icmp_multi_use_add1(i32 %A) {
; CHECK-LABEL: define i32 @add_sext_icmp_multi_use_add1(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A]], 1
; CHECK-NEXT:    call void @use(i32 [[ADD1]])
; CHECK-NEXT:    [[ADD2:%.*]] = call i32 @llvm.umax.i32(i32 [[A]], i32 1)
; CHECK-NEXT:    ret i32 [[ADD2]]
;
  %add1 = add i32 %A, 1
  call void @use(i32 %add1)
  %icmp = icmp ne i32 %A, 0
  %sext = sext i1 %icmp to i32
  %add2 = add i32 %add1, %sext
  ret i32 %add2
}

declare void @use(i32)

