; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -mtriple=x86_64-- -expand-large-div-rem -expand-div-rem-bits 128 < %s | FileCheck %s
; RUN: opt -S -mtriple=x86_64-- -passes=expand-large-div-rem -expand-div-rem-bits 128 < %s | FileCheck %s

define <2 x i129> @sdiv129(<2 x i129> %a, <2 x i129> %b) nounwind {
; CHECK-LABEL: define <2 x i129> @sdiv129(
; CHECK-SAME: <2 x i129> [[A:%.*]], <2 x i129> [[B:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  _udiv-special-cases_udiv-special-cases:
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <2 x i129> [[A]], i64 0
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <2 x i129> [[B]], i64 0
; CHECK-NEXT:    [[TMP2:%.*]] = freeze i129 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = freeze i129 [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = ashr i129 [[TMP2]], 128
; CHECK-NEXT:    [[TMP5:%.*]] = ashr i129 [[TMP3]], 128
; CHECK-NEXT:    [[TMP6:%.*]] = xor i129 [[TMP4]], [[TMP2]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub i129 [[TMP6]], [[TMP4]]
; CHECK-NEXT:    [[TMP8:%.*]] = xor i129 [[TMP5]], [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = sub i129 [[TMP8]], [[TMP5]]
; CHECK-NEXT:    [[TMP10:%.*]] = xor i129 [[TMP5]], [[TMP4]]
; CHECK-NEXT:    [[TMP11:%.*]] = freeze i129 [[TMP9]]
; CHECK-NEXT:    [[TMP12:%.*]] = freeze i129 [[TMP7]]
; CHECK-NEXT:    [[TMP13:%.*]] = icmp eq i129 [[TMP11]], 0
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i129 [[TMP12]], 0
; CHECK-NEXT:    [[TMP15:%.*]] = or i1 [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP11]], i1 true)
; CHECK-NEXT:    [[TMP17:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP12]], i1 true)
; CHECK-NEXT:    [[TMP18:%.*]] = sub i129 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = icmp ugt i129 [[TMP18]], 128
; CHECK-NEXT:    [[TMP20:%.*]] = select i1 [[TMP15]], i1 true, i1 [[TMP19]]
; CHECK-NEXT:    [[TMP21:%.*]] = icmp eq i129 [[TMP18]], 128
; CHECK-NEXT:    [[TMP22:%.*]] = select i1 [[TMP20]], i129 0, i129 [[TMP12]]
; CHECK-NEXT:    [[TMP23:%.*]] = select i1 [[TMP20]], i1 true, i1 [[TMP21]]
; CHECK-NEXT:    br i1 [[TMP23]], label [[UDIV_END1:%.*]], label [[UDIV_BB15:%.*]]
; CHECK:       udiv-loop-exit2:
; CHECK-NEXT:    [[TMP24:%.*]] = phi i129 [ 0, [[UDIV_BB15]] ], [ [[TMP39:%.*]], [[UDIV_DO_WHILE3:%.*]] ]
; CHECK-NEXT:    [[TMP25:%.*]] = phi i129 [ [[TMP48:%.*]], [[UDIV_BB15]] ], [ [[TMP36:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP26:%.*]] = shl i129 [[TMP25]], 1
; CHECK-NEXT:    [[TMP27:%.*]] = or i129 [[TMP24]], [[TMP26]]
; CHECK-NEXT:    br label [[UDIV_END1]]
; CHECK:       udiv-do-while3:
; CHECK-NEXT:    [[TMP28:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER4:%.*]] ], [ [[TMP39]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP29:%.*]] = phi i129 [ [[TMP46:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP42:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP30:%.*]] = phi i129 [ [[TMP44:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP41:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP31:%.*]] = phi i129 [ [[TMP48]], [[UDIV_PREHEADER4]] ], [ [[TMP36]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP32:%.*]] = shl i129 [[TMP30]], 1
; CHECK-NEXT:    [[TMP33:%.*]] = lshr i129 [[TMP31]], 128
; CHECK-NEXT:    [[TMP34:%.*]] = or i129 [[TMP32]], [[TMP33]]
; CHECK-NEXT:    [[TMP35:%.*]] = shl i129 [[TMP31]], 1
; CHECK-NEXT:    [[TMP36]] = or i129 [[TMP28]], [[TMP35]]
; CHECK-NEXT:    [[TMP37:%.*]] = sub i129 [[TMP45:%.*]], [[TMP34]]
; CHECK-NEXT:    [[TMP38:%.*]] = ashr i129 [[TMP37]], 128
; CHECK-NEXT:    [[TMP39]] = and i129 [[TMP38]], 1
; CHECK-NEXT:    [[TMP40:%.*]] = and i129 [[TMP38]], [[TMP11]]
; CHECK-NEXT:    [[TMP41]] = sub i129 [[TMP34]], [[TMP40]]
; CHECK-NEXT:    [[TMP42]] = add i129 [[TMP29]], -1
; CHECK-NEXT:    [[TMP43:%.*]] = icmp eq i129 [[TMP42]], 0
; CHECK-NEXT:    br i1 [[TMP43]], label [[UDIV_LOOP_EXIT2:%.*]], label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-preheader4:
; CHECK-NEXT:    [[TMP44]] = lshr i129 [[TMP12]], [[TMP46]]
; CHECK-NEXT:    [[TMP45]] = add i129 [[TMP11]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-bb15:
; CHECK-NEXT:    [[TMP46]] = add i129 [[TMP18]], 1
; CHECK-NEXT:    [[TMP47:%.*]] = sub i129 128, [[TMP18]]
; CHECK-NEXT:    [[TMP48]] = shl i129 [[TMP12]], [[TMP47]]
; CHECK-NEXT:    [[TMP49:%.*]] = icmp eq i129 [[TMP46]], 0
; CHECK-NEXT:    br i1 [[TMP49]], label [[UDIV_LOOP_EXIT2]], label [[UDIV_PREHEADER4]]
; CHECK:       udiv-end1:
; CHECK-NEXT:    [[TMP50:%.*]] = phi i129 [ [[TMP27]], [[UDIV_LOOP_EXIT2]] ], [ [[TMP22]], [[_UDIV_SPECIAL_CASES_UDIV_SPECIAL_CASES:%.*]] ]
; CHECK-NEXT:    [[TMP51:%.*]] = xor i129 [[TMP50]], [[TMP10]]
; CHECK-NEXT:    [[TMP52:%.*]] = sub i129 [[TMP51]], [[TMP10]]
; CHECK-NEXT:    [[TMP53:%.*]] = insertelement <2 x i129> poison, i129 [[TMP52]], i64 0
; CHECK-NEXT:    [[TMP54:%.*]] = extractelement <2 x i129> [[A]], i64 1
; CHECK-NEXT:    [[TMP55:%.*]] = extractelement <2 x i129> [[B]], i64 1
; CHECK-NEXT:    [[TMP56:%.*]] = freeze i129 [[TMP54]]
; CHECK-NEXT:    [[TMP57:%.*]] = freeze i129 [[TMP55]]
; CHECK-NEXT:    [[TMP58:%.*]] = ashr i129 [[TMP56]], 128
; CHECK-NEXT:    [[TMP59:%.*]] = ashr i129 [[TMP57]], 128
; CHECK-NEXT:    [[TMP60:%.*]] = xor i129 [[TMP58]], [[TMP56]]
; CHECK-NEXT:    [[TMP61:%.*]] = sub i129 [[TMP60]], [[TMP58]]
; CHECK-NEXT:    [[TMP62:%.*]] = xor i129 [[TMP59]], [[TMP57]]
; CHECK-NEXT:    [[TMP63:%.*]] = sub i129 [[TMP62]], [[TMP59]]
; CHECK-NEXT:    [[TMP64:%.*]] = xor i129 [[TMP59]], [[TMP58]]
; CHECK-NEXT:    [[TMP65:%.*]] = freeze i129 [[TMP63]]
; CHECK-NEXT:    [[TMP66:%.*]] = freeze i129 [[TMP61]]
; CHECK-NEXT:    [[TMP67:%.*]] = icmp eq i129 [[TMP65]], 0
; CHECK-NEXT:    [[TMP68:%.*]] = icmp eq i129 [[TMP66]], 0
; CHECK-NEXT:    [[TMP69:%.*]] = or i1 [[TMP67]], [[TMP68]]
; CHECK-NEXT:    [[TMP70:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP65]], i1 true)
; CHECK-NEXT:    [[TMP71:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP66]], i1 true)
; CHECK-NEXT:    [[TMP72:%.*]] = sub i129 [[TMP70]], [[TMP71]]
; CHECK-NEXT:    [[TMP73:%.*]] = icmp ugt i129 [[TMP72]], 128
; CHECK-NEXT:    [[TMP74:%.*]] = select i1 [[TMP69]], i1 true, i1 [[TMP73]]
; CHECK-NEXT:    [[TMP75:%.*]] = icmp eq i129 [[TMP72]], 128
; CHECK-NEXT:    [[TMP76:%.*]] = select i1 [[TMP74]], i129 0, i129 [[TMP66]]
; CHECK-NEXT:    [[TMP77:%.*]] = select i1 [[TMP74]], i1 true, i1 [[TMP75]]
; CHECK-NEXT:    br i1 [[TMP77]], label [[UDIV_END:%.*]], label [[UDIV_BB1:%.*]]
; CHECK:       udiv-loop-exit:
; CHECK-NEXT:    [[TMP78:%.*]] = phi i129 [ 0, [[UDIV_BB1]] ], [ [[TMP93:%.*]], [[UDIV_DO_WHILE:%.*]] ]
; CHECK-NEXT:    [[TMP79:%.*]] = phi i129 [ [[TMP102:%.*]], [[UDIV_BB1]] ], [ [[TMP90:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP80:%.*]] = shl i129 [[TMP79]], 1
; CHECK-NEXT:    [[TMP81:%.*]] = or i129 [[TMP78]], [[TMP80]]
; CHECK-NEXT:    br label [[UDIV_END]]
; CHECK:       udiv-do-while:
; CHECK-NEXT:    [[TMP82:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER:%.*]] ], [ [[TMP93]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP83:%.*]] = phi i129 [ [[TMP100:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP96:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP84:%.*]] = phi i129 [ [[TMP98:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP95:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP85:%.*]] = phi i129 [ [[TMP102]], [[UDIV_PREHEADER]] ], [ [[TMP90]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP86:%.*]] = shl i129 [[TMP84]], 1
; CHECK-NEXT:    [[TMP87:%.*]] = lshr i129 [[TMP85]], 128
; CHECK-NEXT:    [[TMP88:%.*]] = or i129 [[TMP86]], [[TMP87]]
; CHECK-NEXT:    [[TMP89:%.*]] = shl i129 [[TMP85]], 1
; CHECK-NEXT:    [[TMP90]] = or i129 [[TMP82]], [[TMP89]]
; CHECK-NEXT:    [[TMP91:%.*]] = sub i129 [[TMP99:%.*]], [[TMP88]]
; CHECK-NEXT:    [[TMP92:%.*]] = ashr i129 [[TMP91]], 128
; CHECK-NEXT:    [[TMP93]] = and i129 [[TMP92]], 1
; CHECK-NEXT:    [[TMP94:%.*]] = and i129 [[TMP92]], [[TMP65]]
; CHECK-NEXT:    [[TMP95]] = sub i129 [[TMP88]], [[TMP94]]
; CHECK-NEXT:    [[TMP96]] = add i129 [[TMP83]], -1
; CHECK-NEXT:    [[TMP97:%.*]] = icmp eq i129 [[TMP96]], 0
; CHECK-NEXT:    br i1 [[TMP97]], label [[UDIV_LOOP_EXIT:%.*]], label [[UDIV_DO_WHILE]]
; CHECK:       udiv-preheader:
; CHECK-NEXT:    [[TMP98]] = lshr i129 [[TMP66]], [[TMP100]]
; CHECK-NEXT:    [[TMP99]] = add i129 [[TMP65]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE]]
; CHECK:       udiv-bb1:
; CHECK-NEXT:    [[TMP100]] = add i129 [[TMP72]], 1
; CHECK-NEXT:    [[TMP101:%.*]] = sub i129 128, [[TMP72]]
; CHECK-NEXT:    [[TMP102]] = shl i129 [[TMP66]], [[TMP101]]
; CHECK-NEXT:    [[TMP103:%.*]] = icmp eq i129 [[TMP100]], 0
; CHECK-NEXT:    br i1 [[TMP103]], label [[UDIV_LOOP_EXIT]], label [[UDIV_PREHEADER]]
; CHECK:       udiv-end:
; CHECK-NEXT:    [[TMP104:%.*]] = phi i129 [ [[TMP81]], [[UDIV_LOOP_EXIT]] ], [ [[TMP76]], [[UDIV_END1]] ]
; CHECK-NEXT:    [[TMP105:%.*]] = xor i129 [[TMP104]], [[TMP64]]
; CHECK-NEXT:    [[TMP106:%.*]] = sub i129 [[TMP105]], [[TMP64]]
; CHECK-NEXT:    [[TMP107:%.*]] = insertelement <2 x i129> [[TMP53]], i129 [[TMP106]], i64 1
; CHECK-NEXT:    ret <2 x i129> [[TMP107]]
;
  %res = sdiv <2 x i129> %a, %b
  ret <2 x i129> %res
}

define <2 x i129> @udiv129(<2 x i129> %a, <2 x i129> %b) nounwind {
; CHECK-LABEL: define <2 x i129> @udiv129(
; CHECK-SAME: <2 x i129> [[A:%.*]], <2 x i129> [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  _udiv-special-cases_udiv-special-cases:
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <2 x i129> [[A]], i64 0
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <2 x i129> [[B]], i64 0
; CHECK-NEXT:    [[TMP2:%.*]] = freeze i129 [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = freeze i129 [[TMP0]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i129 [[TMP2]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i129 [[TMP3]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = or i1 [[TMP4]], [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP2]], i1 true)
; CHECK-NEXT:    [[TMP8:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP3]], i1 true)
; CHECK-NEXT:    [[TMP9:%.*]] = sub i129 [[TMP7]], [[TMP8]]
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ugt i129 [[TMP9]], 128
; CHECK-NEXT:    [[TMP11:%.*]] = select i1 [[TMP6]], i1 true, i1 [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = icmp eq i129 [[TMP9]], 128
; CHECK-NEXT:    [[TMP13:%.*]] = select i1 [[TMP11]], i129 0, i129 [[TMP3]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 [[TMP11]], i1 true, i1 [[TMP12]]
; CHECK-NEXT:    br i1 [[TMP14]], label [[UDIV_END1:%.*]], label [[UDIV_BB15:%.*]]
; CHECK:       udiv-loop-exit2:
; CHECK-NEXT:    [[TMP15:%.*]] = phi i129 [ 0, [[UDIV_BB15]] ], [ [[TMP30:%.*]], [[UDIV_DO_WHILE3:%.*]] ]
; CHECK-NEXT:    [[TMP16:%.*]] = phi i129 [ [[TMP39:%.*]], [[UDIV_BB15]] ], [ [[TMP27:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP17:%.*]] = shl i129 [[TMP16]], 1
; CHECK-NEXT:    [[TMP18:%.*]] = or i129 [[TMP15]], [[TMP17]]
; CHECK-NEXT:    br label [[UDIV_END1]]
; CHECK:       udiv-do-while3:
; CHECK-NEXT:    [[TMP19:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER4:%.*]] ], [ [[TMP30]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP20:%.*]] = phi i129 [ [[TMP37:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP33:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP21:%.*]] = phi i129 [ [[TMP35:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP32:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP22:%.*]] = phi i129 [ [[TMP39]], [[UDIV_PREHEADER4]] ], [ [[TMP27]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP23:%.*]] = shl i129 [[TMP21]], 1
; CHECK-NEXT:    [[TMP24:%.*]] = lshr i129 [[TMP22]], 128
; CHECK-NEXT:    [[TMP25:%.*]] = or i129 [[TMP23]], [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = shl i129 [[TMP22]], 1
; CHECK-NEXT:    [[TMP27]] = or i129 [[TMP19]], [[TMP26]]
; CHECK-NEXT:    [[TMP28:%.*]] = sub i129 [[TMP36:%.*]], [[TMP25]]
; CHECK-NEXT:    [[TMP29:%.*]] = ashr i129 [[TMP28]], 128
; CHECK-NEXT:    [[TMP30]] = and i129 [[TMP29]], 1
; CHECK-NEXT:    [[TMP31:%.*]] = and i129 [[TMP29]], [[TMP2]]
; CHECK-NEXT:    [[TMP32]] = sub i129 [[TMP25]], [[TMP31]]
; CHECK-NEXT:    [[TMP33]] = add i129 [[TMP20]], -1
; CHECK-NEXT:    [[TMP34:%.*]] = icmp eq i129 [[TMP33]], 0
; CHECK-NEXT:    br i1 [[TMP34]], label [[UDIV_LOOP_EXIT2:%.*]], label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-preheader4:
; CHECK-NEXT:    [[TMP35]] = lshr i129 [[TMP3]], [[TMP37]]
; CHECK-NEXT:    [[TMP36]] = add i129 [[TMP2]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-bb15:
; CHECK-NEXT:    [[TMP37]] = add i129 [[TMP9]], 1
; CHECK-NEXT:    [[TMP38:%.*]] = sub i129 128, [[TMP9]]
; CHECK-NEXT:    [[TMP39]] = shl i129 [[TMP3]], [[TMP38]]
; CHECK-NEXT:    [[TMP40:%.*]] = icmp eq i129 [[TMP37]], 0
; CHECK-NEXT:    br i1 [[TMP40]], label [[UDIV_LOOP_EXIT2]], label [[UDIV_PREHEADER4]]
; CHECK:       udiv-end1:
; CHECK-NEXT:    [[TMP41:%.*]] = phi i129 [ [[TMP18]], [[UDIV_LOOP_EXIT2]] ], [ [[TMP13]], [[_UDIV_SPECIAL_CASES_UDIV_SPECIAL_CASES:%.*]] ]
; CHECK-NEXT:    [[TMP42:%.*]] = insertelement <2 x i129> poison, i129 [[TMP41]], i64 0
; CHECK-NEXT:    [[TMP43:%.*]] = extractelement <2 x i129> [[A]], i64 1
; CHECK-NEXT:    [[TMP44:%.*]] = extractelement <2 x i129> [[B]], i64 1
; CHECK-NEXT:    [[TMP45:%.*]] = freeze i129 [[TMP44]]
; CHECK-NEXT:    [[TMP46:%.*]] = freeze i129 [[TMP43]]
; CHECK-NEXT:    [[TMP47:%.*]] = icmp eq i129 [[TMP45]], 0
; CHECK-NEXT:    [[TMP48:%.*]] = icmp eq i129 [[TMP46]], 0
; CHECK-NEXT:    [[TMP49:%.*]] = or i1 [[TMP47]], [[TMP48]]
; CHECK-NEXT:    [[TMP50:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP45]], i1 true)
; CHECK-NEXT:    [[TMP51:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP46]], i1 true)
; CHECK-NEXT:    [[TMP52:%.*]] = sub i129 [[TMP50]], [[TMP51]]
; CHECK-NEXT:    [[TMP53:%.*]] = icmp ugt i129 [[TMP52]], 128
; CHECK-NEXT:    [[TMP54:%.*]] = select i1 [[TMP49]], i1 true, i1 [[TMP53]]
; CHECK-NEXT:    [[TMP55:%.*]] = icmp eq i129 [[TMP52]], 128
; CHECK-NEXT:    [[TMP56:%.*]] = select i1 [[TMP54]], i129 0, i129 [[TMP46]]
; CHECK-NEXT:    [[TMP57:%.*]] = select i1 [[TMP54]], i1 true, i1 [[TMP55]]
; CHECK-NEXT:    br i1 [[TMP57]], label [[UDIV_END:%.*]], label [[UDIV_BB1:%.*]]
; CHECK:       udiv-loop-exit:
; CHECK-NEXT:    [[TMP58:%.*]] = phi i129 [ 0, [[UDIV_BB1]] ], [ [[TMP73:%.*]], [[UDIV_DO_WHILE:%.*]] ]
; CHECK-NEXT:    [[TMP59:%.*]] = phi i129 [ [[TMP82:%.*]], [[UDIV_BB1]] ], [ [[TMP70:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP60:%.*]] = shl i129 [[TMP59]], 1
; CHECK-NEXT:    [[TMP61:%.*]] = or i129 [[TMP58]], [[TMP60]]
; CHECK-NEXT:    br label [[UDIV_END]]
; CHECK:       udiv-do-while:
; CHECK-NEXT:    [[TMP62:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER:%.*]] ], [ [[TMP73]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP63:%.*]] = phi i129 [ [[TMP80:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP76:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP64:%.*]] = phi i129 [ [[TMP78:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP75:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP65:%.*]] = phi i129 [ [[TMP82]], [[UDIV_PREHEADER]] ], [ [[TMP70]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP66:%.*]] = shl i129 [[TMP64]], 1
; CHECK-NEXT:    [[TMP67:%.*]] = lshr i129 [[TMP65]], 128
; CHECK-NEXT:    [[TMP68:%.*]] = or i129 [[TMP66]], [[TMP67]]
; CHECK-NEXT:    [[TMP69:%.*]] = shl i129 [[TMP65]], 1
; CHECK-NEXT:    [[TMP70]] = or i129 [[TMP62]], [[TMP69]]
; CHECK-NEXT:    [[TMP71:%.*]] = sub i129 [[TMP79:%.*]], [[TMP68]]
; CHECK-NEXT:    [[TMP72:%.*]] = ashr i129 [[TMP71]], 128
; CHECK-NEXT:    [[TMP73]] = and i129 [[TMP72]], 1
; CHECK-NEXT:    [[TMP74:%.*]] = and i129 [[TMP72]], [[TMP45]]
; CHECK-NEXT:    [[TMP75]] = sub i129 [[TMP68]], [[TMP74]]
; CHECK-NEXT:    [[TMP76]] = add i129 [[TMP63]], -1
; CHECK-NEXT:    [[TMP77:%.*]] = icmp eq i129 [[TMP76]], 0
; CHECK-NEXT:    br i1 [[TMP77]], label [[UDIV_LOOP_EXIT:%.*]], label [[UDIV_DO_WHILE]]
; CHECK:       udiv-preheader:
; CHECK-NEXT:    [[TMP78]] = lshr i129 [[TMP46]], [[TMP80]]
; CHECK-NEXT:    [[TMP79]] = add i129 [[TMP45]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE]]
; CHECK:       udiv-bb1:
; CHECK-NEXT:    [[TMP80]] = add i129 [[TMP52]], 1
; CHECK-NEXT:    [[TMP81:%.*]] = sub i129 128, [[TMP52]]
; CHECK-NEXT:    [[TMP82]] = shl i129 [[TMP46]], [[TMP81]]
; CHECK-NEXT:    [[TMP83:%.*]] = icmp eq i129 [[TMP80]], 0
; CHECK-NEXT:    br i1 [[TMP83]], label [[UDIV_LOOP_EXIT]], label [[UDIV_PREHEADER]]
; CHECK:       udiv-end:
; CHECK-NEXT:    [[TMP84:%.*]] = phi i129 [ [[TMP61]], [[UDIV_LOOP_EXIT]] ], [ [[TMP56]], [[UDIV_END1]] ]
; CHECK-NEXT:    [[TMP85:%.*]] = insertelement <2 x i129> [[TMP42]], i129 [[TMP84]], i64 1
; CHECK-NEXT:    ret <2 x i129> [[TMP85]]
;
  %res = udiv <2 x i129> %a, %b
  ret <2 x i129> %res
}

define <2 x i129> @srem129(<2 x i129> %a, <2 x i129> %b) nounwind {
; CHECK-LABEL: define <2 x i129> @srem129(
; CHECK-SAME: <2 x i129> [[A:%.*]], <2 x i129> [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  _udiv-special-cases_udiv-special-cases:
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <2 x i129> [[A]], i64 0
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <2 x i129> [[B]], i64 0
; CHECK-NEXT:    [[TMP2:%.*]] = freeze i129 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = freeze i129 [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = ashr i129 [[TMP2]], 128
; CHECK-NEXT:    [[TMP5:%.*]] = ashr i129 [[TMP3]], 128
; CHECK-NEXT:    [[TMP6:%.*]] = xor i129 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = xor i129 [[TMP3]], [[TMP5]]
; CHECK-NEXT:    [[TMP8:%.*]] = sub i129 [[TMP6]], [[TMP4]]
; CHECK-NEXT:    [[TMP9:%.*]] = sub i129 [[TMP7]], [[TMP5]]
; CHECK-NEXT:    [[TMP10:%.*]] = freeze i129 [[TMP8]]
; CHECK-NEXT:    [[TMP11:%.*]] = freeze i129 [[TMP9]]
; CHECK-NEXT:    [[TMP12:%.*]] = freeze i129 [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = freeze i129 [[TMP10]]
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i129 [[TMP12]], 0
; CHECK-NEXT:    [[TMP15:%.*]] = icmp eq i129 [[TMP13]], 0
; CHECK-NEXT:    [[TMP16:%.*]] = or i1 [[TMP14]], [[TMP15]]
; CHECK-NEXT:    [[TMP17:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP12]], i1 true)
; CHECK-NEXT:    [[TMP18:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP13]], i1 true)
; CHECK-NEXT:    [[TMP19:%.*]] = sub i129 [[TMP17]], [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = icmp ugt i129 [[TMP19]], 128
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP16]], i1 true, i1 [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = icmp eq i129 [[TMP19]], 128
; CHECK-NEXT:    [[TMP23:%.*]] = select i1 [[TMP21]], i129 0, i129 [[TMP13]]
; CHECK-NEXT:    [[TMP24:%.*]] = select i1 [[TMP21]], i1 true, i1 [[TMP22]]
; CHECK-NEXT:    br i1 [[TMP24]], label [[UDIV_END1:%.*]], label [[UDIV_BB15:%.*]]
; CHECK:       udiv-loop-exit2:
; CHECK-NEXT:    [[TMP25:%.*]] = phi i129 [ 0, [[UDIV_BB15]] ], [ [[TMP40:%.*]], [[UDIV_DO_WHILE3:%.*]] ]
; CHECK-NEXT:    [[TMP26:%.*]] = phi i129 [ [[TMP49:%.*]], [[UDIV_BB15]] ], [ [[TMP37:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP27:%.*]] = shl i129 [[TMP26]], 1
; CHECK-NEXT:    [[TMP28:%.*]] = or i129 [[TMP25]], [[TMP27]]
; CHECK-NEXT:    br label [[UDIV_END1]]
; CHECK:       udiv-do-while3:
; CHECK-NEXT:    [[TMP29:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER4:%.*]] ], [ [[TMP40]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP30:%.*]] = phi i129 [ [[TMP47:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP43:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP31:%.*]] = phi i129 [ [[TMP45:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP42:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP32:%.*]] = phi i129 [ [[TMP49]], [[UDIV_PREHEADER4]] ], [ [[TMP37]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP33:%.*]] = shl i129 [[TMP31]], 1
; CHECK-NEXT:    [[TMP34:%.*]] = lshr i129 [[TMP32]], 128
; CHECK-NEXT:    [[TMP35:%.*]] = or i129 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = shl i129 [[TMP32]], 1
; CHECK-NEXT:    [[TMP37]] = or i129 [[TMP29]], [[TMP36]]
; CHECK-NEXT:    [[TMP38:%.*]] = sub i129 [[TMP46:%.*]], [[TMP35]]
; CHECK-NEXT:    [[TMP39:%.*]] = ashr i129 [[TMP38]], 128
; CHECK-NEXT:    [[TMP40]] = and i129 [[TMP39]], 1
; CHECK-NEXT:    [[TMP41:%.*]] = and i129 [[TMP39]], [[TMP12]]
; CHECK-NEXT:    [[TMP42]] = sub i129 [[TMP35]], [[TMP41]]
; CHECK-NEXT:    [[TMP43]] = add i129 [[TMP30]], -1
; CHECK-NEXT:    [[TMP44:%.*]] = icmp eq i129 [[TMP43]], 0
; CHECK-NEXT:    br i1 [[TMP44]], label [[UDIV_LOOP_EXIT2:%.*]], label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-preheader4:
; CHECK-NEXT:    [[TMP45]] = lshr i129 [[TMP13]], [[TMP47]]
; CHECK-NEXT:    [[TMP46]] = add i129 [[TMP12]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-bb15:
; CHECK-NEXT:    [[TMP47]] = add i129 [[TMP19]], 1
; CHECK-NEXT:    [[TMP48:%.*]] = sub i129 128, [[TMP19]]
; CHECK-NEXT:    [[TMP49]] = shl i129 [[TMP13]], [[TMP48]]
; CHECK-NEXT:    [[TMP50:%.*]] = icmp eq i129 [[TMP47]], 0
; CHECK-NEXT:    br i1 [[TMP50]], label [[UDIV_LOOP_EXIT2]], label [[UDIV_PREHEADER4]]
; CHECK:       udiv-end1:
; CHECK-NEXT:    [[TMP51:%.*]] = phi i129 [ [[TMP28]], [[UDIV_LOOP_EXIT2]] ], [ [[TMP23]], [[_UDIV_SPECIAL_CASES_UDIV_SPECIAL_CASES:%.*]] ]
; CHECK-NEXT:    [[TMP52:%.*]] = mul i129 [[TMP11]], [[TMP51]]
; CHECK-NEXT:    [[TMP53:%.*]] = sub i129 [[TMP10]], [[TMP52]]
; CHECK-NEXT:    [[TMP54:%.*]] = xor i129 [[TMP53]], [[TMP4]]
; CHECK-NEXT:    [[TMP55:%.*]] = sub i129 [[TMP54]], [[TMP4]]
; CHECK-NEXT:    [[TMP56:%.*]] = insertelement <2 x i129> poison, i129 [[TMP55]], i64 0
; CHECK-NEXT:    [[TMP57:%.*]] = extractelement <2 x i129> [[A]], i64 1
; CHECK-NEXT:    [[TMP58:%.*]] = extractelement <2 x i129> [[B]], i64 1
; CHECK-NEXT:    [[TMP59:%.*]] = freeze i129 [[TMP57]]
; CHECK-NEXT:    [[TMP60:%.*]] = freeze i129 [[TMP58]]
; CHECK-NEXT:    [[TMP61:%.*]] = ashr i129 [[TMP59]], 128
; CHECK-NEXT:    [[TMP62:%.*]] = ashr i129 [[TMP60]], 128
; CHECK-NEXT:    [[TMP63:%.*]] = xor i129 [[TMP59]], [[TMP61]]
; CHECK-NEXT:    [[TMP64:%.*]] = xor i129 [[TMP60]], [[TMP62]]
; CHECK-NEXT:    [[TMP65:%.*]] = sub i129 [[TMP63]], [[TMP61]]
; CHECK-NEXT:    [[TMP66:%.*]] = sub i129 [[TMP64]], [[TMP62]]
; CHECK-NEXT:    [[TMP67:%.*]] = freeze i129 [[TMP65]]
; CHECK-NEXT:    [[TMP68:%.*]] = freeze i129 [[TMP66]]
; CHECK-NEXT:    [[TMP69:%.*]] = freeze i129 [[TMP68]]
; CHECK-NEXT:    [[TMP70:%.*]] = freeze i129 [[TMP67]]
; CHECK-NEXT:    [[TMP71:%.*]] = icmp eq i129 [[TMP69]], 0
; CHECK-NEXT:    [[TMP72:%.*]] = icmp eq i129 [[TMP70]], 0
; CHECK-NEXT:    [[TMP73:%.*]] = or i1 [[TMP71]], [[TMP72]]
; CHECK-NEXT:    [[TMP74:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP69]], i1 true)
; CHECK-NEXT:    [[TMP75:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP70]], i1 true)
; CHECK-NEXT:    [[TMP76:%.*]] = sub i129 [[TMP74]], [[TMP75]]
; CHECK-NEXT:    [[TMP77:%.*]] = icmp ugt i129 [[TMP76]], 128
; CHECK-NEXT:    [[TMP78:%.*]] = select i1 [[TMP73]], i1 true, i1 [[TMP77]]
; CHECK-NEXT:    [[TMP79:%.*]] = icmp eq i129 [[TMP76]], 128
; CHECK-NEXT:    [[TMP80:%.*]] = select i1 [[TMP78]], i129 0, i129 [[TMP70]]
; CHECK-NEXT:    [[TMP81:%.*]] = select i1 [[TMP78]], i1 true, i1 [[TMP79]]
; CHECK-NEXT:    br i1 [[TMP81]], label [[UDIV_END:%.*]], label [[UDIV_BB1:%.*]]
; CHECK:       udiv-loop-exit:
; CHECK-NEXT:    [[TMP82:%.*]] = phi i129 [ 0, [[UDIV_BB1]] ], [ [[TMP97:%.*]], [[UDIV_DO_WHILE:%.*]] ]
; CHECK-NEXT:    [[TMP83:%.*]] = phi i129 [ [[TMP106:%.*]], [[UDIV_BB1]] ], [ [[TMP94:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP84:%.*]] = shl i129 [[TMP83]], 1
; CHECK-NEXT:    [[TMP85:%.*]] = or i129 [[TMP82]], [[TMP84]]
; CHECK-NEXT:    br label [[UDIV_END]]
; CHECK:       udiv-do-while:
; CHECK-NEXT:    [[TMP86:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER:%.*]] ], [ [[TMP97]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP87:%.*]] = phi i129 [ [[TMP104:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP100:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP88:%.*]] = phi i129 [ [[TMP102:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP99:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP89:%.*]] = phi i129 [ [[TMP106]], [[UDIV_PREHEADER]] ], [ [[TMP94]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP90:%.*]] = shl i129 [[TMP88]], 1
; CHECK-NEXT:    [[TMP91:%.*]] = lshr i129 [[TMP89]], 128
; CHECK-NEXT:    [[TMP92:%.*]] = or i129 [[TMP90]], [[TMP91]]
; CHECK-NEXT:    [[TMP93:%.*]] = shl i129 [[TMP89]], 1
; CHECK-NEXT:    [[TMP94]] = or i129 [[TMP86]], [[TMP93]]
; CHECK-NEXT:    [[TMP95:%.*]] = sub i129 [[TMP103:%.*]], [[TMP92]]
; CHECK-NEXT:    [[TMP96:%.*]] = ashr i129 [[TMP95]], 128
; CHECK-NEXT:    [[TMP97]] = and i129 [[TMP96]], 1
; CHECK-NEXT:    [[TMP98:%.*]] = and i129 [[TMP96]], [[TMP69]]
; CHECK-NEXT:    [[TMP99]] = sub i129 [[TMP92]], [[TMP98]]
; CHECK-NEXT:    [[TMP100]] = add i129 [[TMP87]], -1
; CHECK-NEXT:    [[TMP101:%.*]] = icmp eq i129 [[TMP100]], 0
; CHECK-NEXT:    br i1 [[TMP101]], label [[UDIV_LOOP_EXIT:%.*]], label [[UDIV_DO_WHILE]]
; CHECK:       udiv-preheader:
; CHECK-NEXT:    [[TMP102]] = lshr i129 [[TMP70]], [[TMP104]]
; CHECK-NEXT:    [[TMP103]] = add i129 [[TMP69]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE]]
; CHECK:       udiv-bb1:
; CHECK-NEXT:    [[TMP104]] = add i129 [[TMP76]], 1
; CHECK-NEXT:    [[TMP105:%.*]] = sub i129 128, [[TMP76]]
; CHECK-NEXT:    [[TMP106]] = shl i129 [[TMP70]], [[TMP105]]
; CHECK-NEXT:    [[TMP107:%.*]] = icmp eq i129 [[TMP104]], 0
; CHECK-NEXT:    br i1 [[TMP107]], label [[UDIV_LOOP_EXIT]], label [[UDIV_PREHEADER]]
; CHECK:       udiv-end:
; CHECK-NEXT:    [[TMP108:%.*]] = phi i129 [ [[TMP85]], [[UDIV_LOOP_EXIT]] ], [ [[TMP80]], [[UDIV_END1]] ]
; CHECK-NEXT:    [[TMP109:%.*]] = mul i129 [[TMP68]], [[TMP108]]
; CHECK-NEXT:    [[TMP110:%.*]] = sub i129 [[TMP67]], [[TMP109]]
; CHECK-NEXT:    [[TMP111:%.*]] = xor i129 [[TMP110]], [[TMP61]]
; CHECK-NEXT:    [[TMP112:%.*]] = sub i129 [[TMP111]], [[TMP61]]
; CHECK-NEXT:    [[TMP113:%.*]] = insertelement <2 x i129> [[TMP56]], i129 [[TMP112]], i64 1
; CHECK-NEXT:    ret <2 x i129> [[TMP113]]
;
  %res = srem <2 x i129> %a, %b
  ret <2 x i129> %res
}

define <2 x i129> @urem129(<2 x i129> %a, <2 x i129> %b) nounwind {
; CHECK-LABEL: define <2 x i129> @urem129(
; CHECK-SAME: <2 x i129> [[A:%.*]], <2 x i129> [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  _udiv-special-cases_udiv-special-cases:
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <2 x i129> [[A]], i64 0
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <2 x i129> [[B]], i64 0
; CHECK-NEXT:    [[TMP2:%.*]] = freeze i129 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = freeze i129 [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = freeze i129 [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = freeze i129 [[TMP2]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i129 [[TMP4]], 0
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i129 [[TMP5]], 0
; CHECK-NEXT:    [[TMP8:%.*]] = or i1 [[TMP6]], [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP4]], i1 true)
; CHECK-NEXT:    [[TMP10:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP5]], i1 true)
; CHECK-NEXT:    [[TMP11:%.*]] = sub i129 [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ugt i129 [[TMP11]], 128
; CHECK-NEXT:    [[TMP13:%.*]] = select i1 [[TMP8]], i1 true, i1 [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i129 [[TMP11]], 128
; CHECK-NEXT:    [[TMP15:%.*]] = select i1 [[TMP13]], i129 0, i129 [[TMP5]]
; CHECK-NEXT:    [[TMP16:%.*]] = select i1 [[TMP13]], i1 true, i1 [[TMP14]]
; CHECK-NEXT:    br i1 [[TMP16]], label [[UDIV_END1:%.*]], label [[UDIV_BB15:%.*]]
; CHECK:       udiv-loop-exit2:
; CHECK-NEXT:    [[TMP17:%.*]] = phi i129 [ 0, [[UDIV_BB15]] ], [ [[TMP32:%.*]], [[UDIV_DO_WHILE3:%.*]] ]
; CHECK-NEXT:    [[TMP18:%.*]] = phi i129 [ [[TMP41:%.*]], [[UDIV_BB15]] ], [ [[TMP29:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP19:%.*]] = shl i129 [[TMP18]], 1
; CHECK-NEXT:    [[TMP20:%.*]] = or i129 [[TMP17]], [[TMP19]]
; CHECK-NEXT:    br label [[UDIV_END1]]
; CHECK:       udiv-do-while3:
; CHECK-NEXT:    [[TMP21:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER4:%.*]] ], [ [[TMP32]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP22:%.*]] = phi i129 [ [[TMP39:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP35:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP23:%.*]] = phi i129 [ [[TMP37:%.*]], [[UDIV_PREHEADER4]] ], [ [[TMP34:%.*]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP24:%.*]] = phi i129 [ [[TMP41]], [[UDIV_PREHEADER4]] ], [ [[TMP29]], [[UDIV_DO_WHILE3]] ]
; CHECK-NEXT:    [[TMP25:%.*]] = shl i129 [[TMP23]], 1
; CHECK-NEXT:    [[TMP26:%.*]] = lshr i129 [[TMP24]], 128
; CHECK-NEXT:    [[TMP27:%.*]] = or i129 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP28:%.*]] = shl i129 [[TMP24]], 1
; CHECK-NEXT:    [[TMP29]] = or i129 [[TMP21]], [[TMP28]]
; CHECK-NEXT:    [[TMP30:%.*]] = sub i129 [[TMP38:%.*]], [[TMP27]]
; CHECK-NEXT:    [[TMP31:%.*]] = ashr i129 [[TMP30]], 128
; CHECK-NEXT:    [[TMP32]] = and i129 [[TMP31]], 1
; CHECK-NEXT:    [[TMP33:%.*]] = and i129 [[TMP31]], [[TMP4]]
; CHECK-NEXT:    [[TMP34]] = sub i129 [[TMP27]], [[TMP33]]
; CHECK-NEXT:    [[TMP35]] = add i129 [[TMP22]], -1
; CHECK-NEXT:    [[TMP36:%.*]] = icmp eq i129 [[TMP35]], 0
; CHECK-NEXT:    br i1 [[TMP36]], label [[UDIV_LOOP_EXIT2:%.*]], label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-preheader4:
; CHECK-NEXT:    [[TMP37]] = lshr i129 [[TMP5]], [[TMP39]]
; CHECK-NEXT:    [[TMP38]] = add i129 [[TMP4]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE3]]
; CHECK:       udiv-bb15:
; CHECK-NEXT:    [[TMP39]] = add i129 [[TMP11]], 1
; CHECK-NEXT:    [[TMP40:%.*]] = sub i129 128, [[TMP11]]
; CHECK-NEXT:    [[TMP41]] = shl i129 [[TMP5]], [[TMP40]]
; CHECK-NEXT:    [[TMP42:%.*]] = icmp eq i129 [[TMP39]], 0
; CHECK-NEXT:    br i1 [[TMP42]], label [[UDIV_LOOP_EXIT2]], label [[UDIV_PREHEADER4]]
; CHECK:       udiv-end1:
; CHECK-NEXT:    [[TMP43:%.*]] = phi i129 [ [[TMP20]], [[UDIV_LOOP_EXIT2]] ], [ [[TMP15]], [[_UDIV_SPECIAL_CASES_UDIV_SPECIAL_CASES:%.*]] ]
; CHECK-NEXT:    [[TMP44:%.*]] = mul i129 [[TMP3]], [[TMP43]]
; CHECK-NEXT:    [[TMP45:%.*]] = sub i129 [[TMP2]], [[TMP44]]
; CHECK-NEXT:    [[TMP46:%.*]] = insertelement <2 x i129> poison, i129 [[TMP45]], i64 0
; CHECK-NEXT:    [[TMP47:%.*]] = extractelement <2 x i129> [[A]], i64 1
; CHECK-NEXT:    [[TMP48:%.*]] = extractelement <2 x i129> [[B]], i64 1
; CHECK-NEXT:    [[TMP49:%.*]] = freeze i129 [[TMP47]]
; CHECK-NEXT:    [[TMP50:%.*]] = freeze i129 [[TMP48]]
; CHECK-NEXT:    [[TMP51:%.*]] = freeze i129 [[TMP50]]
; CHECK-NEXT:    [[TMP52:%.*]] = freeze i129 [[TMP49]]
; CHECK-NEXT:    [[TMP53:%.*]] = icmp eq i129 [[TMP51]], 0
; CHECK-NEXT:    [[TMP54:%.*]] = icmp eq i129 [[TMP52]], 0
; CHECK-NEXT:    [[TMP55:%.*]] = or i1 [[TMP53]], [[TMP54]]
; CHECK-NEXT:    [[TMP56:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP51]], i1 true)
; CHECK-NEXT:    [[TMP57:%.*]] = call i129 @llvm.ctlz.i129(i129 [[TMP52]], i1 true)
; CHECK-NEXT:    [[TMP58:%.*]] = sub i129 [[TMP56]], [[TMP57]]
; CHECK-NEXT:    [[TMP59:%.*]] = icmp ugt i129 [[TMP58]], 128
; CHECK-NEXT:    [[TMP60:%.*]] = select i1 [[TMP55]], i1 true, i1 [[TMP59]]
; CHECK-NEXT:    [[TMP61:%.*]] = icmp eq i129 [[TMP58]], 128
; CHECK-NEXT:    [[TMP62:%.*]] = select i1 [[TMP60]], i129 0, i129 [[TMP52]]
; CHECK-NEXT:    [[TMP63:%.*]] = select i1 [[TMP60]], i1 true, i1 [[TMP61]]
; CHECK-NEXT:    br i1 [[TMP63]], label [[UDIV_END:%.*]], label [[UDIV_BB1:%.*]]
; CHECK:       udiv-loop-exit:
; CHECK-NEXT:    [[TMP64:%.*]] = phi i129 [ 0, [[UDIV_BB1]] ], [ [[TMP79:%.*]], [[UDIV_DO_WHILE:%.*]] ]
; CHECK-NEXT:    [[TMP65:%.*]] = phi i129 [ [[TMP88:%.*]], [[UDIV_BB1]] ], [ [[TMP76:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP66:%.*]] = shl i129 [[TMP65]], 1
; CHECK-NEXT:    [[TMP67:%.*]] = or i129 [[TMP64]], [[TMP66]]
; CHECK-NEXT:    br label [[UDIV_END]]
; CHECK:       udiv-do-while:
; CHECK-NEXT:    [[TMP68:%.*]] = phi i129 [ 0, [[UDIV_PREHEADER:%.*]] ], [ [[TMP79]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP69:%.*]] = phi i129 [ [[TMP86:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP82:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP70:%.*]] = phi i129 [ [[TMP84:%.*]], [[UDIV_PREHEADER]] ], [ [[TMP81:%.*]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP71:%.*]] = phi i129 [ [[TMP88]], [[UDIV_PREHEADER]] ], [ [[TMP76]], [[UDIV_DO_WHILE]] ]
; CHECK-NEXT:    [[TMP72:%.*]] = shl i129 [[TMP70]], 1
; CHECK-NEXT:    [[TMP73:%.*]] = lshr i129 [[TMP71]], 128
; CHECK-NEXT:    [[TMP74:%.*]] = or i129 [[TMP72]], [[TMP73]]
; CHECK-NEXT:    [[TMP75:%.*]] = shl i129 [[TMP71]], 1
; CHECK-NEXT:    [[TMP76]] = or i129 [[TMP68]], [[TMP75]]
; CHECK-NEXT:    [[TMP77:%.*]] = sub i129 [[TMP85:%.*]], [[TMP74]]
; CHECK-NEXT:    [[TMP78:%.*]] = ashr i129 [[TMP77]], 128
; CHECK-NEXT:    [[TMP79]] = and i129 [[TMP78]], 1
; CHECK-NEXT:    [[TMP80:%.*]] = and i129 [[TMP78]], [[TMP51]]
; CHECK-NEXT:    [[TMP81]] = sub i129 [[TMP74]], [[TMP80]]
; CHECK-NEXT:    [[TMP82]] = add i129 [[TMP69]], -1
; CHECK-NEXT:    [[TMP83:%.*]] = icmp eq i129 [[TMP82]], 0
; CHECK-NEXT:    br i1 [[TMP83]], label [[UDIV_LOOP_EXIT:%.*]], label [[UDIV_DO_WHILE]]
; CHECK:       udiv-preheader:
; CHECK-NEXT:    [[TMP84]] = lshr i129 [[TMP52]], [[TMP86]]
; CHECK-NEXT:    [[TMP85]] = add i129 [[TMP51]], -1
; CHECK-NEXT:    br label [[UDIV_DO_WHILE]]
; CHECK:       udiv-bb1:
; CHECK-NEXT:    [[TMP86]] = add i129 [[TMP58]], 1
; CHECK-NEXT:    [[TMP87:%.*]] = sub i129 128, [[TMP58]]
; CHECK-NEXT:    [[TMP88]] = shl i129 [[TMP52]], [[TMP87]]
; CHECK-NEXT:    [[TMP89:%.*]] = icmp eq i129 [[TMP86]], 0
; CHECK-NEXT:    br i1 [[TMP89]], label [[UDIV_LOOP_EXIT]], label [[UDIV_PREHEADER]]
; CHECK:       udiv-end:
; CHECK-NEXT:    [[TMP90:%.*]] = phi i129 [ [[TMP67]], [[UDIV_LOOP_EXIT]] ], [ [[TMP62]], [[UDIV_END1]] ]
; CHECK-NEXT:    [[TMP91:%.*]] = mul i129 [[TMP50]], [[TMP90]]
; CHECK-NEXT:    [[TMP92:%.*]] = sub i129 [[TMP49]], [[TMP91]]
; CHECK-NEXT:    [[TMP93:%.*]] = insertelement <2 x i129> [[TMP46]], i129 [[TMP92]], i64 1
; CHECK-NEXT:    ret <2 x i129> [[TMP93]]
;
  %res = urem <2 x i129> %a, %b
  ret <2 x i129> %res
}


define <vscale x 2 x i129> @sdiv129_scalable(<vscale x 2 x i129> %a, <vscale x 2 x i129> %b) nounwind {
; CHECK-LABEL: define <vscale x 2 x i129> @sdiv129_scalable(
; CHECK-SAME: <vscale x 2 x i129> [[A:%.*]], <vscale x 2 x i129> [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RES:%.*]] = sdiv <vscale x 2 x i129> [[A]], [[B]]
; CHECK-NEXT:    ret <vscale x 2 x i129> [[RES]]
;
  %res = sdiv <vscale x 2 x i129> %a, %b
  ret <vscale x 2 x i129> %res
}
