; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -x86-asm-syntax=intel | FileCheck %s

;; X's live range extends beyond the shift, so the register allocator
;; cannot coalesce it with Y.  Because of this, a copy needs to be
;; emitted before the shift to save the register value before it is
;; clobbered.  However, this copy is not needed if the register
;; allocator turns the shift into an LEA.  This also occurs for ADD.

; Check that the shift gets turned into an LEA.

@G = external dso_local global i32                ; <ptr> [#uses=1]

define i32 @test1(i32 %X) {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mov eax, dword ptr [esp + 4]
; CHECK-NEXT:    lea ecx, [4*eax]
; CHECK-NEXT:    mov dword ptr [G], ecx
; CHECK-NEXT:    ret
        %Z = shl i32 %X, 2              ; <i32> [#uses=1]
        store volatile i32 %Z, ptr @G
        ret i32 %X
}

