; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfbfwma -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFWMA
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfbfwma -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFWMA
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfbfmin -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFMIN
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfbfmin -verify-machineinstrs | FileCheck %s --check-prefix=ZVFBFMIN

define <vscale x 1 x float> @vfwmaccbf16_vv_nxv1f32(<vscale x 1 x float> %a, <vscale x 1 x bfloat> %b, <vscale x 1 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_nxv1f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v9, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_nxv1f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v9
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <vscale x 1 x bfloat> %b to <vscale x 1 x float>
  %c.ext = fpext <vscale x 1 x bfloat> %c to <vscale x 1 x float>
  %res = call <vscale x 1 x float> @llvm.fma.nxv1f32(<vscale x 1 x float> %b.ext, <vscale x 1 x float> %c.ext, <vscale x 1 x float> %a)
  ret <vscale x 1 x float> %res
}

define <vscale x 1 x float> @vfwmaccbf16_vf_nxv1f32(<vscale x 1 x float> %a, bfloat %b, <vscale x 1 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_nxv1f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vf v8, fa0, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_nxv1f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    slli a0, a0, 16
; ZVFBFMIN-NEXT:    fmv.w.x fa5, a0
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v10, v9
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vf v8, fa5, v10
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <vscale x 1 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <vscale x 1 x bfloat> %b.head, <vscale x 1 x bfloat> poison, <vscale x 1 x i32> zeroinitializer
  %b.ext = fpext <vscale x 1 x bfloat> %b.splat to <vscale x 1 x float>
  %c.ext = fpext <vscale x 1 x bfloat> %c to <vscale x 1 x float>
  %res = call <vscale x 1 x float> @llvm.fma.nxv1f32(<vscale x 1 x float> %b.ext, <vscale x 1 x float> %c.ext, <vscale x 1 x float> %a)
  ret <vscale x 1 x float> %res
}

define <vscale x 2 x float> @vfwmaccbf16_vv_nxv2f32(<vscale x 2 x float> %a, <vscale x 2 x bfloat> %b, <vscale x 2 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_nxv2f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v9, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_nxv2f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v11, v9
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v9, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <vscale x 2 x bfloat> %b to <vscale x 2 x float>
  %c.ext = fpext <vscale x 2 x bfloat> %c to <vscale x 2 x float>
  %res = call <vscale x 2 x float> @llvm.fma.nxv2f32(<vscale x 2 x float> %b.ext, <vscale x 2 x float> %c.ext, <vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x float> @vfwmaccbf16_vf_nxv2f32(<vscale x 2 x float> %a, bfloat %b, <vscale x 2 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_nxv2f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vf v8, fa0, v9
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_nxv2f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    slli a0, a0, 16
; ZVFBFMIN-NEXT:    fmv.w.x fa5, a0
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v10, v9
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vf v8, fa5, v10
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <vscale x 2 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <vscale x 2 x bfloat> %b.head, <vscale x 2 x bfloat> poison, <vscale x 2 x i32> zeroinitializer
  %b.ext = fpext <vscale x 2 x bfloat> %b.splat to <vscale x 2 x float>
  %c.ext = fpext <vscale x 2 x bfloat> %c to <vscale x 2 x float>
  %res = call <vscale x 2 x float> @llvm.fma.nxv2f32(<vscale x 2 x float> %b.ext, <vscale x 2 x float> %c.ext, <vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 4 x float> @vfwmaccbf16_vv_nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x bfloat> %b, <vscale x 4 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_nxv4f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v10, v11
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_nxv4f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v12, v10
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v14, v11
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v12, v14
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <vscale x 4 x bfloat> %b to <vscale x 4 x float>
  %c.ext = fpext <vscale x 4 x bfloat> %c to <vscale x 4 x float>
  %res = call <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float> %b.ext, <vscale x 4 x float> %c.ext, <vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 4 x float> @vfwmaccbf16_vf_nxv4f32(<vscale x 4 x float> %a, bfloat %b, <vscale x 4 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_nxv4f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vf v8, fa0, v10
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_nxv4f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    slli a0, a0, 16
; ZVFBFMIN-NEXT:    fmv.w.x fa5, a0
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v12, v10
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vf v8, fa5, v12
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <vscale x 4 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <vscale x 4 x bfloat> %b.head, <vscale x 4 x bfloat> poison, <vscale x 4 x i32> zeroinitializer
  %b.ext = fpext <vscale x 4 x bfloat> %b.splat to <vscale x 4 x float>
  %c.ext = fpext <vscale x 4 x bfloat> %c to <vscale x 4 x float>
  %res = call <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float> %b.ext, <vscale x 4 x float> %c.ext, <vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 8 x float> @vfwmaccbf16_vv_nxv8f32(<vscale x 8 x float> %a, <vscale x 8 x bfloat> %b, <vscale x 8 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_nxv8f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v12, v14
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_nxv8f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v16, v12
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v20, v14
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v16, v20
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <vscale x 8 x bfloat> %b to <vscale x 8 x float>
  %c.ext = fpext <vscale x 8 x bfloat> %c to <vscale x 8 x float>
  %res = call <vscale x 8 x float> @llvm.fma.nxv8f32(<vscale x 8 x float> %b.ext, <vscale x 8 x float> %c.ext, <vscale x 8 x float> %a)
  ret <vscale x 8 x float> %res
}

define <vscale x 8 x float> @vfwmaccbf16_vf_nxv8f32(<vscale x 8 x float> %a, bfloat %b, <vscale x 8 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_nxv8f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vf v8, fa0, v12
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_nxv8f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    slli a0, a0, 16
; ZVFBFMIN-NEXT:    fmv.w.x fa5, a0
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v16, v12
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vf v8, fa5, v16
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <vscale x 8 x bfloat> %b.head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %b.ext = fpext <vscale x 8 x bfloat> %b.splat to <vscale x 8 x float>
  %c.ext = fpext <vscale x 8 x bfloat> %c to <vscale x 8 x float>
  %res = call <vscale x 8 x float> @llvm.fma.nxv8f32(<vscale x 8 x float> %b.ext, <vscale x 8 x float> %c.ext, <vscale x 8 x float> %a)
  ret <vscale x 8 x float> %res
}

define <vscale x 16 x float> @vfwmaccbf16_vv_nxv16f32(<vscale x 16 x float> %a, <vscale x 16 x bfloat> %b, <vscale x 16 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vv_nxv16f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vv v8, v16, v20
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vv_nxv16f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v24, v16
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v0, v20
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vv v8, v24, v0
; ZVFBFMIN-NEXT:    ret
  %b.ext = fpext <vscale x 16 x bfloat> %b to <vscale x 16 x float>
  %c.ext = fpext <vscale x 16 x bfloat> %c to <vscale x 16 x float>
  %res = call <vscale x 16 x float> @llvm.fma.nxv16f32(<vscale x 16 x float> %b.ext, <vscale x 16 x float> %c.ext, <vscale x 16 x float> %a)
  ret <vscale x 16 x float> %res
}

define <vscale x 16 x float> @vfwmaccbf16_vf_nxv16f32(<vscale x 16 x float> %a, bfloat %b, <vscale x 16 x bfloat> %c) {
; ZVFBFWMA-LABEL: vfwmaccbf16_vf_nxv16f32:
; ZVFBFWMA:       # %bb.0:
; ZVFBFWMA-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFBFWMA-NEXT:    vfwmaccbf16.vf v8, fa0, v16
; ZVFBFWMA-NEXT:    ret
;
; ZVFBFMIN-LABEL: vfwmaccbf16_vf_nxv16f32:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    slli a0, a0, 16
; ZVFBFMIN-NEXT:    fmv.w.x fa5, a0
; ZVFBFMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFBFMIN-NEXT:    vfwcvtbf16.f.f.v v24, v16
; ZVFBFMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFBFMIN-NEXT:    vfmacc.vf v8, fa5, v24
; ZVFBFMIN-NEXT:    ret
  %b.head = insertelement <vscale x 16 x bfloat> poison, bfloat %b, i32 0
  %b.splat = shufflevector <vscale x 16 x bfloat> %b.head, <vscale x 16 x bfloat> poison, <vscale x 16 x i32> zeroinitializer
  %b.ext = fpext <vscale x 16 x bfloat> %b.splat to <vscale x 16 x float>
  %c.ext = fpext <vscale x 16 x bfloat> %c to <vscale x 16 x float>
  %res = call <vscale x 16 x float> @llvm.fma.nxv16f32(<vscale x 16 x float> %b.ext, <vscale x 16 x float> %c.ext, <vscale x 16 x float> %a)
  ret <vscale x 16 x float> %res
}
