; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 4
; RUN: opt -mtriple=riscv64-unknown-linux-gnu -mattr=+v -vector-library=sleefgnuabi -replace-with-veclib -S < %s | FileCheck %s

;.
; CHECK: @llvm.compiler.used = appending global [22 x ptr] [ptr @Sleef_cosdx_u10rvvm2, ptr @Sleef_cosfx_u10rvvm2, ptr @Sleef_expdx_u10rvvm2, ptr @Sleef_expfx_u10rvvm2, ptr @Sleef_exp10dx_u10rvvm2, ptr @Sleef_exp10fx_u10rvvm2, ptr @Sleef_exp2dx_u10rvvm2, ptr @Sleef_exp2fx_u10rvvm2, ptr @Sleef_fmadx_rvvm2, ptr @Sleef_fmafx_rvvm2, ptr @Sleef_logdx_u10rvvm2, ptr @Sleef_logfx_u10rvvm2, ptr @Sleef_log10dx_u10rvvm2, ptr @Sleef_log10fx_u10rvvm2, ptr @Sleef_log2dx_u10rvvm2, ptr @Sleef_log2fx_u10rvvm2, ptr @Sleef_powdx_u10rvvm2, ptr @Sleef_powfx_u10rvvm2, ptr @Sleef_sindx_u10rvvm2, ptr @Sleef_sinfx_u10rvvm2, ptr @Sleef_sqrtdx_u05rvvm2, ptr @Sleef_sqrtfx_u05rvvm2], section "llvm.metadata"
;.
define <vscale x 2 x double> @llvm_ceil_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_ceil_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.ceil.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.ceil.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_ceil_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_ceil_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.ceil.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.ceil.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_copysign_vscale_f64(<vscale x 2 x double> %mag, <vscale x 2 x double> %sgn) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_copysign_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[MAG:%.*]], <vscale x 2 x double> [[SGN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> [[MAG]], <vscale x 2 x double> [[SGN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %mag, <vscale x 2 x double> %sgn)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_copysign_vscale_f32(<vscale x 4 x float> %mag, <vscale x 4 x float> %sgn) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_copysign_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[MAG:%.*]], <vscale x 4 x float> [[SGN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> [[MAG]], <vscale x 4 x float> [[SGN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %mag, <vscale x 4 x float> %sgn)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_cos_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_cos_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_cosdx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.cos.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_cos_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_cos_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_cosfx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.cos.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_exp_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_exp_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_expdx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.exp.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_exp_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_exp_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_expfx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.exp.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_exp10_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_exp10_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_exp10dx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.exp10.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_exp10_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_exp10_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_exp10fx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.exp10.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_exp2_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_exp2_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_exp2dx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.exp2.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_exp2_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_exp2_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_exp2fx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.exp2.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_fabs_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_fabs_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.fabs.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.fabs.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_fabs_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_fabs_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.fabs.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.fabs.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_floor_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_floor_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.floor.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.floor.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_floor_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_floor_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.floor.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.floor.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_fma_vscale_f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b, <vscale x 2 x double> %c ) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_fma_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[A:%.*]], <vscale x 2 x double> [[B:%.*]], <vscale x 2 x double> [[C:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_fmadx_rvvm2(<vscale x 2 x double> [[A]], <vscale x 2 x double> [[B]], <vscale x 2 x double> [[C]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b, <vscale x 2 x double> %c)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_fma_vscale_f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_fma_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[A:%.*]], <vscale x 4 x float> [[B:%.*]], <vscale x 4 x float> [[C:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_fmafx_rvvm2(<vscale x 4 x float> [[A]], <vscale x 4 x float> [[B]], <vscale x 4 x float> [[C]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_log_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_log_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_logdx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.log.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_log_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_log_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_logfx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.log.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_log10_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_log10_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_log10dx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.log10.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_log10_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_log10_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_log10fx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.log10.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_log2_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_log2_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_log2dx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.log2.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_log2_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_log2_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_log2fx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.log2.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_maxnum_vscale_f64(<vscale x 2 x double> %in0, <vscale x 2 x double> %in1) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_maxnum_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN0:%.*]], <vscale x 2 x double> [[IN1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.maxnum.nxv2f64(<vscale x 2 x double> [[IN0]], <vscale x 2 x double> [[IN1]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.maxnum.nxv2f64(<vscale x 2 x double> %in0, <vscale x 2 x double> %in1)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_maxnum_vscale_f32(<vscale x 4 x float> %in0, <vscale x 4 x float> %in1) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_maxnum_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN0:%.*]], <vscale x 4 x float> [[IN1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.maxnum.nxv4f32(<vscale x 4 x float> [[IN0]], <vscale x 4 x float> [[IN1]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.maxnum.nxv4f32(<vscale x 4 x float> %in0, <vscale x 4 x float> %in1)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_minnum_vscale_f64(<vscale x 2 x double> %in0, <vscale x 2 x double> %in1) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_minnum_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN0:%.*]], <vscale x 2 x double> [[IN1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.minnum.nxv2f64(<vscale x 2 x double> [[IN0]], <vscale x 2 x double> [[IN1]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.minnum.nxv2f64(<vscale x 2 x double> %in0, <vscale x 2 x double> %in1)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_minnum_vscale_f32(<vscale x 4 x float> %in0, <vscale x 4 x float> %in1) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_minnum_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN0:%.*]], <vscale x 4 x float> [[IN1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.minnum.nxv4f32(<vscale x 4 x float> [[IN0]], <vscale x 4 x float> [[IN1]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.minnum.nxv4f32(<vscale x 4 x float> %in0, <vscale x 4 x float> %in1)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_nearbyint_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_nearbyint_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.nearbyint.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.nearbyint.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_nearbyint_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_nearbyint_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.nearbyint.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.nearbyint.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_pow_vscale_f64(<vscale x 2 x double> %in, <vscale x 2 x double> %pow) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_pow_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]], <vscale x 2 x double> [[POW:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_powdx_u10rvvm2(<vscale x 2 x double> [[IN]], <vscale x 2 x double> [[POW]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.pow.nxv2f64(<vscale x 2 x double> %in, <vscale x 2 x double> %pow)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_pow_vscale_f32(<vscale x 4 x float> %in, <vscale x 4 x float> %pow) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_pow_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]], <vscale x 4 x float> [[POW:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_powfx_u10rvvm2(<vscale x 4 x float> [[IN]], <vscale x 4 x float> [[POW]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.pow.nxv4f32(<vscale x 4 x float> %in, <vscale x 4 x float> %pow)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_rint_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_rint_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.rint.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.rint.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_rint_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_rint_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.rint.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.rint.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_round_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_round_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.round.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.round.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_round_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_round_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.round.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.round.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_sin_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_sin_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_sindx_u10rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.sin.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_sin_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_sin_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_sinfx_u10rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.sin.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_sqrt_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_sqrt_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @Sleef_sqrtdx_u05rvvm2(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_sqrt_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_sqrt_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @Sleef_sqrtfx_u05rvvm2(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @llvm_trunc_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @llvm_trunc_vscale_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.trunc.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.trunc.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_trunc_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @llvm_trunc_vscale_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.trunc.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.trunc.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}

define <vscale x 2 x double> @frem_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define <vscale x 2 x double> @frem_f64(
; CHECK-SAME: <vscale x 2 x double> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = frem <vscale x 2 x double> [[IN]], [[IN]]
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1= frem <vscale x 2 x double> %in, %in
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @frem_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define <vscale x 4 x float> @frem_f32(
; CHECK-SAME: <vscale x 4 x float> [[IN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = frem <vscale x 4 x float> [[IN]], [[IN]]
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1= frem <vscale x 4 x float> %in, %in
  ret <vscale x 4 x float> %1
}

declare <vscale x 2 x double> @llvm.ceil.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.ceil.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.cos.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.cos.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.exp.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.exp.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.exp2.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.exp2.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.exp10.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.exp10.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.fabs.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.fabs.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.floor.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.floor.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.fma.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.fma.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.log.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.log.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.log10.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.log10.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.log2.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.log2.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.maxnum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.maxnum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.minnum.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.minnum.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.nearbyint.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.nearbyint.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.pow.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.pow.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.rint.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.rint.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.round.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.round.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.sin.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.sin.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.trunc.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.trunc.nxv4f32(<vscale x 4 x float>)
;.
; CHECK: attributes #[[ATTR0]] = { "target-features"="+v" }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { nocallback nofree nosync nounwind speculatable willreturn memory(none) "target-features"="+v" }
;.
