; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx --verify-machineinstrs < %s | FileCheck %s

define i16 @vmsk_eq_allzeros_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_eq_allzeros_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmsknz.b $vr0, $vr0
; CHECK-NEXT:    vnor.v $vr0, $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp eq <16 x i8> %a, splat (i8 0)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i16 @vmsk_sgt_allzeros_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_sgt_allzeros_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sgt <16 x i8> %a, splat (i8 0)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i16 @vmsk_sgt_allones_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_sgt_allones_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskgez.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sgt <16 x i8> %a, splat (i8 -1)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i16 @vmsk_sge_allzeros_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_sge_allzeros_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskgez.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sge <16 x i8> %a, splat (i8 0)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i16 @vmsk_slt_allzeros_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_slt_allzeros_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp slt <16 x i8> %a, splat (i8 0)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i8 @vmsk_slt_allzeros_i16(<8 x i16 > %a) {
; CHECK-LABEL: vmsk_slt_allzeros_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp slt <8 x i16> %a, splat (i16 0)
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define i4 @vmsk_slt_allzeros_i32(<4 x i32 > %a) {
; CHECK-LABEL: vmsk_slt_allzeros_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp slt <4 x i32> %a, splat (i32 0)
  %2 = bitcast <4 x i1> %1 to i4
  ret i4 %2
}

define i2 @vmsk_slt_allzeros_i64(<2 x i64 > %a) {
; CHECK-LABEL: vmsk_slt_allzeros_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp slt <2 x i64> %a, splat (i64 0)
  %2 = bitcast <2 x i1> %1 to i2
  ret i2 %2
}

define i16 @vmsk_sle_allzeros_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_sle_allzeros_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vslei.b $vr0, $vr0, 0
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sle <16 x i8> %a, splat (i8 0)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i16 @vmsk_sle_allones_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_sle_allones_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sle <16 x i8> %a, splat (i8 -1)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i8 @vmsk_sle_allones_i16(<8 x i16 > %a) {
; CHECK-LABEL: vmsk_sle_allones_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sle <8 x i16> %a, splat (i16 -1)
  %2 = bitcast <8 x i1> %1 to i8
  ret i8 %2
}

define i4 @vmsk_sle_allones_i32(<4 x i32 > %a) {
; CHECK-LABEL: vmsk_sle_allones_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sle <4 x i32> %a, splat (i32 -1)
  %2 = bitcast <4 x i1> %1 to i4
  ret i4 %2
}

define i2 @vmsk_sle_allones_i64(<2 x i64 > %a) {
; CHECK-LABEL: vmsk_sle_allones_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp sle <2 x i64> %a, splat (i64 -1)
  %2 = bitcast <2 x i1> %1 to i2
  ret i2 %2
}

define i16 @vmsk_ne_allzeros_i8(<16 x i8 > %a) {
; CHECK-LABEL: vmsk_ne_allzeros_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmsknz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
entry:
  %1 = icmp ne <16 x i8> %a, splat (i8 0)
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define i2 @vmsk_sgt_v2i8(<2 x i8> %a, <2 x i8> %b) {
; CHECK-LABEL: vmsk_sgt_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 56
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <2 x i8> %a, %b
  %res = bitcast <2 x i1> %x to i2
  ret i2 %res
}

define i2 @vmsk_sgt_v2i16(<2 x i16> %a, <2 x i16> %b) {
; CHECK-LABEL: vmsk_sgt_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 48
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <2 x i16> %a, %b
  %res = bitcast <2 x i1> %x to i2
  ret i2 %res
}

define i2 @vmsk_sgt_v2i32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: vmsk_sgt_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 16
; CHECK-NEXT:    vslli.d $vr0, $vr0, 32
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <2 x i32> %a, %b
  %res = bitcast <2 x i1> %x to i2
  ret i2 %res
}

define i2 @vmsk_sgt_v2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vmsk_sgt_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <2 x i64> %a, %b
  %res = bitcast <2 x i1> %x to i2
  ret i2 %res
}

define i2 @vmsk_ogt_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vmsk_ogt_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcmp.clt.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = fcmp ogt <2 x double> %a, %b
  %res = bitcast <2 x i1> %x to i2
  ret i2 %res
}

define i4 @vmsk_sgt_v4i8(<4 x i8> %a, <4 x i8> %b) {
; CHECK-LABEL: vmsk_sgt_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 24
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <4 x i8> %a, %b
  %res = bitcast <4 x i1> %x to i4
  ret i4 %res
}

define i4 @vmsk_sgt_v4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: vmsk_sgt_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 16
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <4 x i16> %a, %b
  %res = bitcast <4 x i1> %x to i4
  ret i4 %res
}

define i4 @vmsk_sgt_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vmsk_sgt_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <4 x i32> %a, %b
  %res = bitcast <4 x i1> %x to i4
  ret i4 %res
}

define i4 @vmsk_ogt_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vmsk_ogt_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcmp.clt.s $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = fcmp ogt <4 x float> %a, %b
  %res = bitcast <4 x i1> %x to i4
  ret i4 %res
}

define i8 @vmsk_sgt_v8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: vmsk_sgt_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.h $vr0, $vr0, 8
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <8 x i8> %a, %b
  %res = bitcast <8 x i1> %x to i8
  ret i8 %res
}

define i8 @vmsk_sgt_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vmsk_sgt_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <8 x i16> %a, %b
  %res = bitcast <8 x i1> %x to i8
  ret i8 %res
}

define i16 @vmsk_sgt_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vmsk_sgt_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x = icmp sgt <16 x i8> %a, %b
  %res = bitcast <16 x i1> %x to i16
  ret i16 %res
}

define i2 @vmsk_sgt_and_sgt_v2i8(<2 x i8> %a, <2 x i8> %b, <2 x i8> %c, <2 x i8> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.b $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 56
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <2 x i8> %a, %b
  %x1 = icmp sgt <2 x i8> %c, %d
  %y = and <2 x i1> %x0, %x1
  %res = bitcast <2 x i1> %y to i2
  ret i2 %res
}

define i2 @vmsk_sgt_and_sgt_v2i16(<2 x i16> %a, <2 x i16> %b, <2 x i16> %c, <2 x i16> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.h $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.d $vr0, $vr0, 48
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <2 x i16> %a, %b
  %x1 = icmp sgt <2 x i16> %c, %d
  %y = and <2 x i1> %x0, %x1
  %res = bitcast <2 x i1> %y to i2
  ret i2 %res
}

define i2 @vmsk_sgt_and_sgt_v2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i32> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.w $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 16
; CHECK-NEXT:    vslli.d $vr0, $vr0, 32
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <2 x i32> %a, %b
  %x1 = icmp sgt <2 x i32> %c, %d
  %y = and <2 x i1> %x0, %x1
  %res = bitcast <2 x i1> %y to i2
  ret i2 %res
}

define i2 @vmsk_sgt_and_sgt_v2i64(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i64> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.d $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <2 x i64> %a, %b
  %x1 = icmp sgt <2 x i64> %c, %d
  %y = and <2 x i1> %x0, %x1
  %res = bitcast <2 x i1> %y to i2
  ret i2 %res
}

define i2 @vmsk_ogt_and_ogt_v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c, <2 x double> %d) {
; CHECK-LABEL: vmsk_ogt_and_ogt_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcmp.clt.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vfcmp.clt.d $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = fcmp ogt <2 x double> %a, %b
  %x1 = fcmp ogt <2 x double> %c, %d
  %y = and <2 x i1> %x0, %x1
  %res = bitcast <2 x i1> %y to i2
  ret i2 %res
}

define i4 @vmsk_sgt_and_sgt_v4i8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i8> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.b $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 24
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <4 x i8> %a, %b
  %x1 = icmp sgt <4 x i8> %c, %d
  %y = and <4 x i1> %x0, %x1
  %res = bitcast <4 x i1> %y to i4
  ret i4 %res
}

define i4 @vmsk_sgt_and_sgt_v4i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c, <4 x i16> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.h $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 16
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <4 x i16> %a, %b
  %x1 = icmp sgt <4 x i16> %c, %d
  %y = and <4 x i1> %x0, %x1
  %res = bitcast <4 x i1> %y to i4
  ret i4 %res
}

define i4 @vmsk_sgt_and_sgt_v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i32> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.w $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <4 x i32> %a, %b
  %x1 = icmp sgt <4 x i32> %c, %d
  %y = and <4 x i1> %x0, %x1
  %res = bitcast <4 x i1> %y to i4
  ret i4 %res
}

define i4 @vmsk_ogt_and_ogt_v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c, <4 x float> %d) {
; CHECK-LABEL: vmsk_ogt_and_ogt_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcmp.clt.s $vr0, $vr1, $vr0
; CHECK-NEXT:    vfcmp.clt.s $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = fcmp ogt <4 x float> %a, %b
  %x1 = fcmp ogt <4 x float> %c, %d
  %y = and <4 x i1> %x0, %x1
  %res = bitcast <4 x i1> %y to i4
  ret i4 %res
}

define i8 @vmsk_sgt_and_sgt_v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.b $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.h $vr0, $vr0, 8
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <8 x i8> %a, %b
  %x1 = icmp sgt <8 x i8> %c, %d
  %y = and <8 x i1> %x0, %x1
  %res = bitcast <8 x i1> %y to i8
  ret i8 %res
}

define i8 @vmsk_sgt_and_sgt_v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i16> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.h $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <8 x i16> %a, %b
  %x1 = icmp sgt <8 x i16> %c, %d
  %y = and <8 x i1> %x0, %x1
  %res = bitcast <8 x i1> %y to i8
  ret i8 %res
}

define i16 @vmsk_sgt_and_sgt_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i8> %d) {
; CHECK-LABEL: vmsk_sgt_and_sgt_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vslt.b $vr1, $vr3, $vr2
; CHECK-NEXT:    vand.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %x0 = icmp sgt <16 x i8> %a, %b
  %x1 = icmp sgt <16 x i8> %c, %d
  %y = and <16 x i1> %x0, %x1
  %res = bitcast <16 x i1> %y to i16
  ret i16 %res
}

define i16 @vmsk_trunc_i8(<16 x i8> %a) {
; CHECK-LABEL: vmsk_trunc_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.b $vr0, $vr0, 7
; CHECK-NEXT:    vmskltz.b $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %y = trunc <16 x i8> %a to <16 x i1>
  %res = bitcast <16 x i1> %y to i16
  ret i16 %res
}

define i8 @vmsk_trunc_i16(<8 x i16> %a) {
; CHECK-LABEL: vmsk_trunc_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.h $vr0, $vr0, 15
; CHECK-NEXT:    vmskltz.h $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %y = trunc <8 x i16> %a to <8 x i1>
  %res = bitcast <8 x i1> %y to i8
  ret i8 %res
}

define i4 @vmsk_trunc_i32(<4 x i32> %a) {
; CHECK-LABEL: vmsk_trunc_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.w $vr0, $vr0, 31
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %y = trunc <4 x i32> %a to <4 x i1>
  %res = bitcast <4 x i1> %y to i4
  ret i4 %res
}

define i2 @vmsk_trunc_i64(<2 x i64> %a) {
; CHECK-LABEL: vmsk_trunc_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 63
; CHECK-NEXT:    vmskltz.d $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %y = trunc <2 x i64> %a to <2 x i1>
  %res = bitcast <2 x i1> %y to i2
  ret i2 %res
}

define i4 @vmsk_eq_allzeros_v4i8(<4 x i8> %a) {
; CHECK-LABEL: vmsk_eq_allzeros_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vseqi.b $vr0, $vr0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vslli.w $vr0, $vr0, 24
; CHECK-NEXT:    vmskltz.w $vr0, $vr0
; CHECK-NEXT:    vpickve2gr.hu $a0, $vr0, 0
; CHECK-NEXT:    ret
  %1 = icmp eq <4 x i8> %a, zeroinitializer
  %2 = bitcast <4 x i1> %1 to i4
  ret i4 %2
}
