# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x390 -instruction-tables=full -iterations=1 < %s | FileCheck %s

vsetvli zero, zero, e32, m1, tu, mu

vlse8.v  v1, (a1), a2
vlse16.v v1, (a1), a2
vlse32.v v1, (a1), a2
vlse64.v v1, (a1), a2

vlse8.v  v1, (a1), zero
vlse16.v v1, (a1), zero
vlse32.v v1, (a1), zero
vlse64.v v1, (a1), zero

vle8.v  v1, (a1)
vle16.v v1, (a1)
vle32.v v1, (a1)
vle64.v v1, (a1)

vsetvli zero, zero, e64, m1, tu, mu

vlse8.v  v1, (a1), a2
vlse16.v v1, (a1), a2
vlse32.v v1, (a1), a2
vlse64.v v1, (a1), a2

vlse8.v  v1, (a1), zero
vlse16.v v1, (a1), zero
vlse32.v v1, (a1), zero
vlse64.v v1, (a1), zero

vle8.v  v1, (a1)
vle16.v v1, (a1)
vle32.v v1, (a1)
vle64.v v1, (a1)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv:1
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv:1
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA:1
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeAB:2 VLEN1024X300SiFive7PipeA, VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7PipeB:1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA1:1
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VA1OrVA2:2 VLEN1024X300SiFive7VA1, VLEN1024X300SiFive7VA2
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VA2:1
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VCQ:1
# CHECK-NEXT: [9]   - VLEN1024X300SiFive7VL:1
# CHECK-NEXT: [10]  - VLEN1024X300SiFive7VS:1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE8_V            vlse8.v	v1, (a1), a2
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE16_V           vlse16.v	v1, (a1), a2
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE32_V           vlse32.v	v1, (a1), a2
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE64_V           vlse64.v	v1, (a1), a2
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE8_V            vlse8.v	v1, (a1), zero
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE16_V           vlse16.v	v1, (a1), zero
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE32_V           vlse32.v	v1, (a1), zero
# CHECK-NEXT:  1      35    32.00   *                    35    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,33] VLSE64_V           vlse64.v	v1, (a1), zero
# CHECK-NEXT:  1      4     1.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,2] VLE8_V              vle8.v	v1, (a1)
# CHECK-NEXT:  1      4     1.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,2] VLE16_V             vle16.v	v1, (a1)
# CHECK-NEXT:  1      4     2.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,3] VLE32_V             vle32.v	v1, (a1)
# CHECK-NEXT:  1      4     4.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,5] VLE64_V             vle64.v	v1, (a1)
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE8_V            vlse8.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE16_V           vlse16.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE32_V           vlse32.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE64_V           vlse64.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE8_V            vlse8.v	v1, (a1), zero
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE16_V           vlse16.v	v1, (a1), zero
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE32_V           vlse32.v	v1, (a1), zero
# CHECK-NEXT:  1      19    16.00   *                    19    VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,17] VLSE64_V           vlse64.v	v1, (a1), zero
# CHECK-NEXT:  1      4     1.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,2] VLE8_V              vle8.v	v1, (a1)
# CHECK-NEXT:  1      4     1.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,2] VLE16_V             vle16.v	v1, (a1)
# CHECK-NEXT:  1      4     1.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,2] VLE32_V             vle32.v	v1, (a1)
# CHECK-NEXT:  1      4     2.00    *                    4     VLEN1024X300SiFive7VCQ,VLEN1024X300SiFive7VL[1,3] VLE64_V             vle64.v	v1, (a1)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7VA1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA2
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VCQ
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VL
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT:  -      -     2.00    -      -      -     24.00  421.00  -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse8.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse16.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse32.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse64.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse8.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse16.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse32.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   33.00   -     vlse64.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   2.00    -     vle8.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00   2.00    -     vle16.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00   3.00    -     vle32.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00   5.00    -     vle64.v	v1, (a1)
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse8.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse16.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse32.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse64.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse8.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse16.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse32.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   17.00   -     vlse64.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -      -     1.00   2.00    -     vle8.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00   2.00    -     vle16.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00   2.00    -     vle32.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00   3.00    -     vle64.v	v1, (a1)
