; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S < %s -passes=newgvn | FileCheck %s

declare void @llvm.sideeffect()

; Store-to-load forwarding across a @llvm.sideeffect.

define float @s2l(ptr %p) {
; CHECK-LABEL: define float @s2l(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    store float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    call void @llvm.sideeffect()
; CHECK-NEXT:    ret float 0.000000e+00
;
  store float 0.0, ptr %p
  call void @llvm.sideeffect()
  %t = load float, ptr %p
  ret float %t
}

; Redundant load elimination across a @llvm.sideeffect.

define float @rle(ptr %p) {
; CHECK-LABEL: define float @rle(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = load float, ptr [[P]], align 4
; CHECK-NEXT:    call void @llvm.sideeffect()
; CHECK-NEXT:    [[T:%.*]] = fadd float [[R]], [[R]]
; CHECK-NEXT:    ret float [[T]]
;
  %r = load float, ptr %p
  call void @llvm.sideeffect()
  %s = load float, ptr %p
  %t = fadd float %r, %s
  ret float %t
}
