; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test looks at the constants in the regions, and if it they are the
; differents it elevates the constants to arguments.

define void @outline_constants1() {
; CHECK-LABEL: @outline_constants1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 3, ptr [[A]], i32 4, ptr [[B]], i32 5, ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 3, ptr %a, align 4
  store i32 4, ptr %b, align 4
  store i32 5, ptr %c, align 4
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

define void @outline_constants2() {
; CHECK-LABEL: @outline_constants2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 2, ptr [[A]], i32 3, ptr [[B]], i32 4, ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

; CHECK: define internal void @outlined_ir_func_0(i32 [[ARG0:%.*]], ptr [[ARG1:%.*]], i32 [[ARG2:%.*]], ptr [[ARG3:%.*]], i32 [[ARG4:%.*]], ptr [[ARG5:%.*]]) #0 {
; CHECK: entry_to_outline:
; CHECK-NEXT:    store i32 [[ARG0]], ptr [[ARG1]], align 4
; CHECK-NEXT:    store i32 [[ARG2]], ptr [[ARG3]], align 4
; CHECK-NEXT:    store i32 [[ARG4]], ptr [[ARG5]], align 4
; CHECK-NEXT:    [[AL:%.*]] = load i32, ptr [[ARG1]], align 4
; CHECK-NEXT:    [[BL:%.*]] = load i32, ptr [[ARG3]], align 4
; CHECK-NEXT:    [[CL:%.*]] = load i32, ptr [[ARG5]], align 4
