; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S < %s -passes=gvn | FileCheck %s

; Analyze Load from clobbering memset.pattern.
define i32 @memset_pattern_clobber_load(ptr %p) {
; CHECK-LABEL: @memset_pattern_clobber_load(
; CHECK-NEXT:    call void @llvm.experimental.memset.pattern.p0.i8.i64(ptr [[P:%.*]], i8 1, i64 8, i1 false)
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
  call void @llvm.experimental.memset.pattern.p0.p0.i64(ptr %p, i8 1, i64 8, i1 false)
  %load = load i32, ptr %p
  ret i32 %load
}

define i32 @memset_pattern_clobber_load2(ptr %p) {
; CHECK-LABEL: @memset_pattern_clobber_load2(
; CHECK-NEXT:    call void @llvm.experimental.memset.pattern.p0.i16.i64(ptr [[P:%.*]], i16 1, i64 8, i1 false)
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
  call void @llvm.experimental.memset.pattern(ptr %p, i16 1, i64 8, i1 false)
  %load = load i32, ptr %p
  ret i32 %load
}

define ptr @memset_pattern_clobber_load3(ptr %p) {
; CHECK-LABEL: @memset_pattern_clobber_load3(
; CHECK-NEXT:    call void @llvm.experimental.memset.pattern.p0.p0.i64(ptr [[P:%.*]], ptr [[P]], i64 8, i1 false)
; CHECK-NEXT:    [[LOAD:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    ret ptr [[LOAD]]
;
  call void @llvm.experimental.memset.pattern(ptr %p, ptr %p, i64 8, i1 false)
  %load = load ptr, ptr %p
  ret ptr %load
}

define i32 @load_forward_over_memset_pattern(ptr %P, ptr noalias %Q) {
; CHECK-LABEL: @load_forward_over_memset_pattern(
; CHECK-NEXT:    tail call void @llvm.experimental.memset.pattern.p0.i8.i64(ptr [[P:%.*]], i8 27, i64 8, i1 false)
; CHECK-NEXT:    ret i32 0
;
  %v1 = load i32, ptr %Q
  tail call void @llvm.experimental.memset.pattern(ptr %P, i8 27, i64 8, i1 false)
  %v2 = load i32, ptr %Q
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @load_forward_over_memset_pattern2(ptr %P, ptr noalias %Q) nounwind ssp {
; CHECK-LABEL: @load_forward_over_memset_pattern2(
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    tail call void @llvm.experimental.memset.pattern.p0.p0.i64(ptr [[P:%.*]], ptr [[Q]], i64 8, i1 false)
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[Q]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %v1 = load i32, ptr %Q
  tail call void @llvm.experimental.memset.pattern(ptr %P, ptr %Q, i64 8, i1 false)
  %v2 = load i32, ptr %Q
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}
