// RUN: llvm-mc -triple=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

s_cmp_eq_i32 s1, s2
// CHECK: [0x01,0x02,0x00,0xbf]

s_cmp_eq_i32 s103, s2
// CHECK: [0x67,0x02,0x00,0xbf]

s_cmp_eq_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x00,0xbf]

s_cmp_eq_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x00,0xbf]

s_cmp_eq_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x00,0xbf]

s_cmp_eq_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x00,0xbf]

s_cmp_eq_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x00,0xbf]

s_cmp_eq_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x00,0xbf]

s_cmp_eq_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x00,0xbf]

s_cmp_eq_i32 m0, s2
// CHECK: [0x7c,0x02,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x00,0xbf]

s_cmp_eq_i32 0, s2
// CHECK: [0x80,0x02,0x00,0xbf]

s_cmp_eq_i32 -1, s2
// CHECK: [0xc1,0x02,0x00,0xbf]

s_cmp_eq_i32 0.5, s2
// CHECK: [0xf0,0x02,0x00,0xbf]

s_cmp_eq_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x00,0xbf]

s_cmp_eq_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x00,0xbf]

s_cmp_eq_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x00,0xbf]

s_cmp_eq_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x00,0xbf]

s_cmp_eq_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s1, s103
// CHECK: [0x01,0x67,0x00,0xbf]

s_cmp_eq_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x00,0xbf]

s_cmp_eq_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x00,0xbf]

s_cmp_eq_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x00,0xbf]

s_cmp_eq_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x00,0xbf]

s_cmp_eq_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x00,0xbf]

s_cmp_eq_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x00,0xbf]

s_cmp_eq_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x00,0xbf]

s_cmp_eq_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x00,0xbf]

s_cmp_eq_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x00,0xbf]

s_cmp_eq_i32 s1, m0
// CHECK: [0x01,0x7c,0x00,0xbf]

s_cmp_eq_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x00,0xbf]

s_cmp_eq_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x00,0xbf]

s_cmp_eq_i32 s1, 0
// CHECK: [0x01,0x80,0x00,0xbf]

s_cmp_eq_i32 s1, -1
// CHECK: [0x01,0xc1,0x00,0xbf]

s_cmp_eq_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x00,0xbf]

s_cmp_eq_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x00,0xbf]

s_cmp_eq_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x00,0xbf]

s_cmp_eq_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x00,0xbf]

s_cmp_eq_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x00,0xbf]

s_cmp_eq_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s1, s2
// CHECK: [0x01,0x02,0x01,0xbf]

s_cmp_lg_i32 s103, s2
// CHECK: [0x67,0x02,0x01,0xbf]

s_cmp_lg_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x01,0xbf]

s_cmp_lg_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x01,0xbf]

s_cmp_lg_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x01,0xbf]

s_cmp_lg_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x01,0xbf]

s_cmp_lg_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x01,0xbf]

s_cmp_lg_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x01,0xbf]

s_cmp_lg_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x01,0xbf]

s_cmp_lg_i32 m0, s2
// CHECK: [0x7c,0x02,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x01,0xbf]

s_cmp_lg_i32 0, s2
// CHECK: [0x80,0x02,0x01,0xbf]

s_cmp_lg_i32 -1, s2
// CHECK: [0xc1,0x02,0x01,0xbf]

s_cmp_lg_i32 0.5, s2
// CHECK: [0xf0,0x02,0x01,0xbf]

s_cmp_lg_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x01,0xbf]

s_cmp_lg_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x01,0xbf]

s_cmp_lg_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x01,0xbf]

s_cmp_lg_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x01,0xbf]

s_cmp_lg_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s1, s103
// CHECK: [0x01,0x67,0x01,0xbf]

s_cmp_lg_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x01,0xbf]

s_cmp_lg_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x01,0xbf]

s_cmp_lg_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x01,0xbf]

s_cmp_lg_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x01,0xbf]

s_cmp_lg_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x01,0xbf]

s_cmp_lg_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x01,0xbf]

s_cmp_lg_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x01,0xbf]

s_cmp_lg_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x01,0xbf]

s_cmp_lg_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x01,0xbf]

s_cmp_lg_i32 s1, m0
// CHECK: [0x01,0x7c,0x01,0xbf]

s_cmp_lg_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x01,0xbf]

s_cmp_lg_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x01,0xbf]

s_cmp_lg_i32 s1, 0
// CHECK: [0x01,0x80,0x01,0xbf]

s_cmp_lg_i32 s1, -1
// CHECK: [0x01,0xc1,0x01,0xbf]

s_cmp_lg_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x01,0xbf]

s_cmp_lg_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x01,0xbf]

s_cmp_lg_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x01,0xbf]

s_cmp_lg_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x01,0xbf]

s_cmp_lg_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x01,0xbf]

s_cmp_lg_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s1, s2
// CHECK: [0x01,0x02,0x02,0xbf]

s_cmp_gt_i32 s103, s2
// CHECK: [0x67,0x02,0x02,0xbf]

s_cmp_gt_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x02,0xbf]

s_cmp_gt_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x02,0xbf]

s_cmp_gt_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x02,0xbf]

s_cmp_gt_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x02,0xbf]

s_cmp_gt_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x02,0xbf]

s_cmp_gt_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x02,0xbf]

s_cmp_gt_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x02,0xbf]

s_cmp_gt_i32 m0, s2
// CHECK: [0x7c,0x02,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x02,0xbf]

s_cmp_gt_i32 0, s2
// CHECK: [0x80,0x02,0x02,0xbf]

s_cmp_gt_i32 -1, s2
// CHECK: [0xc1,0x02,0x02,0xbf]

s_cmp_gt_i32 0.5, s2
// CHECK: [0xf0,0x02,0x02,0xbf]

s_cmp_gt_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x02,0xbf]

s_cmp_gt_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x02,0xbf]

s_cmp_gt_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x02,0xbf]

s_cmp_gt_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x02,0xbf]

s_cmp_gt_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s1, s103
// CHECK: [0x01,0x67,0x02,0xbf]

s_cmp_gt_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x02,0xbf]

s_cmp_gt_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x02,0xbf]

s_cmp_gt_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x02,0xbf]

s_cmp_gt_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x02,0xbf]

s_cmp_gt_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x02,0xbf]

s_cmp_gt_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x02,0xbf]

s_cmp_gt_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x02,0xbf]

s_cmp_gt_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x02,0xbf]

s_cmp_gt_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x02,0xbf]

s_cmp_gt_i32 s1, m0
// CHECK: [0x01,0x7c,0x02,0xbf]

s_cmp_gt_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x02,0xbf]

s_cmp_gt_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x02,0xbf]

s_cmp_gt_i32 s1, 0
// CHECK: [0x01,0x80,0x02,0xbf]

s_cmp_gt_i32 s1, -1
// CHECK: [0x01,0xc1,0x02,0xbf]

s_cmp_gt_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x02,0xbf]

s_cmp_gt_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x02,0xbf]

s_cmp_gt_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x02,0xbf]

s_cmp_gt_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x02,0xbf]

s_cmp_gt_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x02,0xbf]

s_cmp_gt_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s1, s2
// CHECK: [0x01,0x02,0x03,0xbf]

s_cmp_ge_i32 s103, s2
// CHECK: [0x67,0x02,0x03,0xbf]

s_cmp_ge_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x03,0xbf]

s_cmp_ge_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x03,0xbf]

s_cmp_ge_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x03,0xbf]

s_cmp_ge_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x03,0xbf]

s_cmp_ge_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x03,0xbf]

s_cmp_ge_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x03,0xbf]

s_cmp_ge_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x03,0xbf]

s_cmp_ge_i32 m0, s2
// CHECK: [0x7c,0x02,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x03,0xbf]

s_cmp_ge_i32 0, s2
// CHECK: [0x80,0x02,0x03,0xbf]

s_cmp_ge_i32 -1, s2
// CHECK: [0xc1,0x02,0x03,0xbf]

s_cmp_ge_i32 0.5, s2
// CHECK: [0xf0,0x02,0x03,0xbf]

s_cmp_ge_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x03,0xbf]

s_cmp_ge_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x03,0xbf]

s_cmp_ge_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x03,0xbf]

s_cmp_ge_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x03,0xbf]

s_cmp_ge_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s1, s103
// CHECK: [0x01,0x67,0x03,0xbf]

s_cmp_ge_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x03,0xbf]

s_cmp_ge_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x03,0xbf]

s_cmp_ge_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x03,0xbf]

s_cmp_ge_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x03,0xbf]

s_cmp_ge_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x03,0xbf]

s_cmp_ge_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x03,0xbf]

s_cmp_ge_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x03,0xbf]

s_cmp_ge_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x03,0xbf]

s_cmp_ge_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x03,0xbf]

s_cmp_ge_i32 s1, m0
// CHECK: [0x01,0x7c,0x03,0xbf]

s_cmp_ge_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x03,0xbf]

s_cmp_ge_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x03,0xbf]

s_cmp_ge_i32 s1, 0
// CHECK: [0x01,0x80,0x03,0xbf]

s_cmp_ge_i32 s1, -1
// CHECK: [0x01,0xc1,0x03,0xbf]

s_cmp_ge_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x03,0xbf]

s_cmp_ge_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x03,0xbf]

s_cmp_ge_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x03,0xbf]

s_cmp_ge_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x03,0xbf]

s_cmp_ge_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x03,0xbf]

s_cmp_ge_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s1, s2
// CHECK: [0x01,0x02,0x04,0xbf]

s_cmp_lt_i32 s103, s2
// CHECK: [0x67,0x02,0x04,0xbf]

s_cmp_lt_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x04,0xbf]

s_cmp_lt_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x04,0xbf]

s_cmp_lt_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x04,0xbf]

s_cmp_lt_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x04,0xbf]

s_cmp_lt_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x04,0xbf]

s_cmp_lt_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x04,0xbf]

s_cmp_lt_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x04,0xbf]

s_cmp_lt_i32 m0, s2
// CHECK: [0x7c,0x02,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x04,0xbf]

s_cmp_lt_i32 0, s2
// CHECK: [0x80,0x02,0x04,0xbf]

s_cmp_lt_i32 -1, s2
// CHECK: [0xc1,0x02,0x04,0xbf]

s_cmp_lt_i32 0.5, s2
// CHECK: [0xf0,0x02,0x04,0xbf]

s_cmp_lt_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x04,0xbf]

s_cmp_lt_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x04,0xbf]

s_cmp_lt_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x04,0xbf]

s_cmp_lt_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x04,0xbf]

s_cmp_lt_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s1, s103
// CHECK: [0x01,0x67,0x04,0xbf]

s_cmp_lt_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x04,0xbf]

s_cmp_lt_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x04,0xbf]

s_cmp_lt_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x04,0xbf]

s_cmp_lt_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x04,0xbf]

s_cmp_lt_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x04,0xbf]

s_cmp_lt_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x04,0xbf]

s_cmp_lt_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x04,0xbf]

s_cmp_lt_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x04,0xbf]

s_cmp_lt_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x04,0xbf]

s_cmp_lt_i32 s1, m0
// CHECK: [0x01,0x7c,0x04,0xbf]

s_cmp_lt_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x04,0xbf]

s_cmp_lt_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x04,0xbf]

s_cmp_lt_i32 s1, 0
// CHECK: [0x01,0x80,0x04,0xbf]

s_cmp_lt_i32 s1, -1
// CHECK: [0x01,0xc1,0x04,0xbf]

s_cmp_lt_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x04,0xbf]

s_cmp_lt_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x04,0xbf]

s_cmp_lt_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x04,0xbf]

s_cmp_lt_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x04,0xbf]

s_cmp_lt_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x04,0xbf]

s_cmp_lt_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s1, s2
// CHECK: [0x01,0x02,0x05,0xbf]

s_cmp_le_i32 s103, s2
// CHECK: [0x67,0x02,0x05,0xbf]

s_cmp_le_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0xbf]

s_cmp_le_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0xbf]

s_cmp_le_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0xbf]

s_cmp_le_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0xbf]

s_cmp_le_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0xbf]

s_cmp_le_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0xbf]

s_cmp_le_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0xbf]

s_cmp_le_i32 m0, s2
// CHECK: [0x7c,0x02,0x05,0xbf]

s_cmp_le_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0xbf]

s_cmp_le_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0xbf]

s_cmp_le_i32 0, s2
// CHECK: [0x80,0x02,0x05,0xbf]

s_cmp_le_i32 -1, s2
// CHECK: [0xc1,0x02,0x05,0xbf]

s_cmp_le_i32 0.5, s2
// CHECK: [0xf0,0x02,0x05,0xbf]

s_cmp_le_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x05,0xbf]

s_cmp_le_i32 src_vccz, s2
// CHECK: [0xfb,0x02,0x05,0xbf]

s_cmp_le_i32 src_execz, s2
// CHECK: [0xfc,0x02,0x05,0xbf]

s_cmp_le_i32 src_scc, s2
// CHECK: [0xfd,0x02,0x05,0xbf]

s_cmp_le_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s1, s103
// CHECK: [0x01,0x67,0x05,0xbf]

s_cmp_le_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0xbf]

s_cmp_le_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0xbf]

s_cmp_le_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0xbf]

s_cmp_le_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0xbf]

s_cmp_le_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0xbf]

s_cmp_le_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0xbf]

s_cmp_le_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0xbf]

s_cmp_le_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0xbf]

s_cmp_le_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0xbf]

s_cmp_le_i32 s1, m0
// CHECK: [0x01,0x7c,0x05,0xbf]

s_cmp_le_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0xbf]

s_cmp_le_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0xbf]

s_cmp_le_i32 s1, 0
// CHECK: [0x01,0x80,0x05,0xbf]

s_cmp_le_i32 s1, -1
// CHECK: [0x01,0xc1,0x05,0xbf]

s_cmp_le_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x05,0xbf]

s_cmp_le_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x05,0xbf]

s_cmp_le_i32 s1, src_vccz
// CHECK: [0x01,0xfb,0x05,0xbf]

s_cmp_le_i32 s1, src_execz
// CHECK: [0x01,0xfc,0x05,0xbf]

s_cmp_le_i32 s1, src_scc
// CHECK: [0x01,0xfd,0x05,0xbf]

s_cmp_le_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s1, s2
// CHECK: [0x01,0x02,0x06,0xbf]

s_cmp_eq_u32 s103, s2
// CHECK: [0x67,0x02,0x06,0xbf]

s_cmp_eq_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x06,0xbf]

s_cmp_eq_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x06,0xbf]

s_cmp_eq_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x06,0xbf]

s_cmp_eq_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x06,0xbf]

s_cmp_eq_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x06,0xbf]

s_cmp_eq_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x06,0xbf]

s_cmp_eq_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x06,0xbf]

s_cmp_eq_u32 m0, s2
// CHECK: [0x7c,0x02,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x06,0xbf]

s_cmp_eq_u32 0, s2
// CHECK: [0x80,0x02,0x06,0xbf]

s_cmp_eq_u32 -1, s2
// CHECK: [0xc1,0x02,0x06,0xbf]

s_cmp_eq_u32 0.5, s2
// CHECK: [0xf0,0x02,0x06,0xbf]

s_cmp_eq_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x06,0xbf]

s_cmp_eq_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x06,0xbf]

s_cmp_eq_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x06,0xbf]

s_cmp_eq_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x06,0xbf]

s_cmp_eq_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s1, s103
// CHECK: [0x01,0x67,0x06,0xbf]

s_cmp_eq_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x06,0xbf]

s_cmp_eq_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x06,0xbf]

s_cmp_eq_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x06,0xbf]

s_cmp_eq_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x06,0xbf]

s_cmp_eq_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x06,0xbf]

s_cmp_eq_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x06,0xbf]

s_cmp_eq_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x06,0xbf]

s_cmp_eq_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x06,0xbf]

s_cmp_eq_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x06,0xbf]

s_cmp_eq_u32 s1, m0
// CHECK: [0x01,0x7c,0x06,0xbf]

s_cmp_eq_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x06,0xbf]

s_cmp_eq_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x06,0xbf]

s_cmp_eq_u32 s1, 0
// CHECK: [0x01,0x80,0x06,0xbf]

s_cmp_eq_u32 s1, -1
// CHECK: [0x01,0xc1,0x06,0xbf]

s_cmp_eq_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x06,0xbf]

s_cmp_eq_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x06,0xbf]

s_cmp_eq_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x06,0xbf]

s_cmp_eq_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x06,0xbf]

s_cmp_eq_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x06,0xbf]

s_cmp_eq_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s1, s2
// CHECK: [0x01,0x02,0x07,0xbf]

s_cmp_lg_u32 s103, s2
// CHECK: [0x67,0x02,0x07,0xbf]

s_cmp_lg_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x07,0xbf]

s_cmp_lg_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x07,0xbf]

s_cmp_lg_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x07,0xbf]

s_cmp_lg_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x07,0xbf]

s_cmp_lg_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x07,0xbf]

s_cmp_lg_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x07,0xbf]

s_cmp_lg_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x07,0xbf]

s_cmp_lg_u32 m0, s2
// CHECK: [0x7c,0x02,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x07,0xbf]

s_cmp_lg_u32 0, s2
// CHECK: [0x80,0x02,0x07,0xbf]

s_cmp_lg_u32 -1, s2
// CHECK: [0xc1,0x02,0x07,0xbf]

s_cmp_lg_u32 0.5, s2
// CHECK: [0xf0,0x02,0x07,0xbf]

s_cmp_lg_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x07,0xbf]

s_cmp_lg_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x07,0xbf]

s_cmp_lg_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x07,0xbf]

s_cmp_lg_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x07,0xbf]

s_cmp_lg_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s1, s103
// CHECK: [0x01,0x67,0x07,0xbf]

s_cmp_lg_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x07,0xbf]

s_cmp_lg_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x07,0xbf]

s_cmp_lg_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x07,0xbf]

s_cmp_lg_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x07,0xbf]

s_cmp_lg_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x07,0xbf]

s_cmp_lg_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x07,0xbf]

s_cmp_lg_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x07,0xbf]

s_cmp_lg_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x07,0xbf]

s_cmp_lg_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x07,0xbf]

s_cmp_lg_u32 s1, m0
// CHECK: [0x01,0x7c,0x07,0xbf]

s_cmp_lg_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x07,0xbf]

s_cmp_lg_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x07,0xbf]

s_cmp_lg_u32 s1, 0
// CHECK: [0x01,0x80,0x07,0xbf]

s_cmp_lg_u32 s1, -1
// CHECK: [0x01,0xc1,0x07,0xbf]

s_cmp_lg_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x07,0xbf]

s_cmp_lg_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x07,0xbf]

s_cmp_lg_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x07,0xbf]

s_cmp_lg_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x07,0xbf]

s_cmp_lg_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x07,0xbf]

s_cmp_lg_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s1, s2
// CHECK: [0x01,0x02,0x08,0xbf]

s_cmp_gt_u32 s103, s2
// CHECK: [0x67,0x02,0x08,0xbf]

s_cmp_gt_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x08,0xbf]

s_cmp_gt_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x08,0xbf]

s_cmp_gt_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x08,0xbf]

s_cmp_gt_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x08,0xbf]

s_cmp_gt_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x08,0xbf]

s_cmp_gt_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x08,0xbf]

s_cmp_gt_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x08,0xbf]

s_cmp_gt_u32 m0, s2
// CHECK: [0x7c,0x02,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x08,0xbf]

s_cmp_gt_u32 0, s2
// CHECK: [0x80,0x02,0x08,0xbf]

s_cmp_gt_u32 -1, s2
// CHECK: [0xc1,0x02,0x08,0xbf]

s_cmp_gt_u32 0.5, s2
// CHECK: [0xf0,0x02,0x08,0xbf]

s_cmp_gt_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x08,0xbf]

s_cmp_gt_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x08,0xbf]

s_cmp_gt_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x08,0xbf]

s_cmp_gt_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x08,0xbf]

s_cmp_gt_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s1, s103
// CHECK: [0x01,0x67,0x08,0xbf]

s_cmp_gt_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x08,0xbf]

s_cmp_gt_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x08,0xbf]

s_cmp_gt_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x08,0xbf]

s_cmp_gt_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x08,0xbf]

s_cmp_gt_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x08,0xbf]

s_cmp_gt_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x08,0xbf]

s_cmp_gt_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x08,0xbf]

s_cmp_gt_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x08,0xbf]

s_cmp_gt_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x08,0xbf]

s_cmp_gt_u32 s1, m0
// CHECK: [0x01,0x7c,0x08,0xbf]

s_cmp_gt_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x08,0xbf]

s_cmp_gt_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x08,0xbf]

s_cmp_gt_u32 s1, 0
// CHECK: [0x01,0x80,0x08,0xbf]

s_cmp_gt_u32 s1, -1
// CHECK: [0x01,0xc1,0x08,0xbf]

s_cmp_gt_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x08,0xbf]

s_cmp_gt_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x08,0xbf]

s_cmp_gt_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x08,0xbf]

s_cmp_gt_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x08,0xbf]

s_cmp_gt_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x08,0xbf]

s_cmp_gt_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s1, s2
// CHECK: [0x01,0x02,0x09,0xbf]

s_cmp_ge_u32 s103, s2
// CHECK: [0x67,0x02,0x09,0xbf]

s_cmp_ge_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x09,0xbf]

s_cmp_ge_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x09,0xbf]

s_cmp_ge_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x09,0xbf]

s_cmp_ge_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x09,0xbf]

s_cmp_ge_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x09,0xbf]

s_cmp_ge_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x09,0xbf]

s_cmp_ge_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x09,0xbf]

s_cmp_ge_u32 m0, s2
// CHECK: [0x7c,0x02,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x09,0xbf]

s_cmp_ge_u32 0, s2
// CHECK: [0x80,0x02,0x09,0xbf]

s_cmp_ge_u32 -1, s2
// CHECK: [0xc1,0x02,0x09,0xbf]

s_cmp_ge_u32 0.5, s2
// CHECK: [0xf0,0x02,0x09,0xbf]

s_cmp_ge_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x09,0xbf]

s_cmp_ge_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x09,0xbf]

s_cmp_ge_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x09,0xbf]

s_cmp_ge_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x09,0xbf]

s_cmp_ge_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s1, s103
// CHECK: [0x01,0x67,0x09,0xbf]

s_cmp_ge_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x09,0xbf]

s_cmp_ge_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x09,0xbf]

s_cmp_ge_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x09,0xbf]

s_cmp_ge_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x09,0xbf]

s_cmp_ge_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x09,0xbf]

s_cmp_ge_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x09,0xbf]

s_cmp_ge_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x09,0xbf]

s_cmp_ge_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x09,0xbf]

s_cmp_ge_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x09,0xbf]

s_cmp_ge_u32 s1, m0
// CHECK: [0x01,0x7c,0x09,0xbf]

s_cmp_ge_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x09,0xbf]

s_cmp_ge_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x09,0xbf]

s_cmp_ge_u32 s1, 0
// CHECK: [0x01,0x80,0x09,0xbf]

s_cmp_ge_u32 s1, -1
// CHECK: [0x01,0xc1,0x09,0xbf]

s_cmp_ge_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x09,0xbf]

s_cmp_ge_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x09,0xbf]

s_cmp_ge_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x09,0xbf]

s_cmp_ge_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x09,0xbf]

s_cmp_ge_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x09,0xbf]

s_cmp_ge_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s1, s2
// CHECK: [0x01,0x02,0x0a,0xbf]

s_cmp_lt_u32 s103, s2
// CHECK: [0x67,0x02,0x0a,0xbf]

s_cmp_lt_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0a,0xbf]

s_cmp_lt_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0a,0xbf]

s_cmp_lt_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0a,0xbf]

s_cmp_lt_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0a,0xbf]

s_cmp_lt_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0a,0xbf]

s_cmp_lt_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0a,0xbf]

s_cmp_lt_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0a,0xbf]

s_cmp_lt_u32 m0, s2
// CHECK: [0x7c,0x02,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0a,0xbf]

s_cmp_lt_u32 0, s2
// CHECK: [0x80,0x02,0x0a,0xbf]

s_cmp_lt_u32 -1, s2
// CHECK: [0xc1,0x02,0x0a,0xbf]

s_cmp_lt_u32 0.5, s2
// CHECK: [0xf0,0x02,0x0a,0xbf]

s_cmp_lt_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x0a,0xbf]

s_cmp_lt_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0a,0xbf]

s_cmp_lt_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x0a,0xbf]

s_cmp_lt_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x0a,0xbf]

s_cmp_lt_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s1, s103
// CHECK: [0x01,0x67,0x0a,0xbf]

s_cmp_lt_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0a,0xbf]

s_cmp_lt_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0a,0xbf]

s_cmp_lt_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0a,0xbf]

s_cmp_lt_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0a,0xbf]

s_cmp_lt_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0a,0xbf]

s_cmp_lt_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0a,0xbf]

s_cmp_lt_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0a,0xbf]

s_cmp_lt_u32 s1, m0
// CHECK: [0x01,0x7c,0x0a,0xbf]

s_cmp_lt_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s1, 0
// CHECK: [0x01,0x80,0x0a,0xbf]

s_cmp_lt_u32 s1, -1
// CHECK: [0x01,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0a,0xbf]

s_cmp_lt_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x0a,0xbf]

s_cmp_lt_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x0a,0xbf]

s_cmp_lt_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s1, s2
// CHECK: [0x01,0x02,0x0b,0xbf]

s_cmp_le_u32 s103, s2
// CHECK: [0x67,0x02,0x0b,0xbf]

s_cmp_le_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0b,0xbf]

s_cmp_le_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0b,0xbf]

s_cmp_le_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0b,0xbf]

s_cmp_le_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0b,0xbf]

s_cmp_le_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0b,0xbf]

s_cmp_le_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0b,0xbf]

s_cmp_le_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0b,0xbf]

s_cmp_le_u32 m0, s2
// CHECK: [0x7c,0x02,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0b,0xbf]

s_cmp_le_u32 0, s2
// CHECK: [0x80,0x02,0x0b,0xbf]

s_cmp_le_u32 -1, s2
// CHECK: [0xc1,0x02,0x0b,0xbf]

s_cmp_le_u32 0.5, s2
// CHECK: [0xf0,0x02,0x0b,0xbf]

s_cmp_le_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x0b,0xbf]

s_cmp_le_u32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0b,0xbf]

s_cmp_le_u32 src_execz, s2
// CHECK: [0xfc,0x02,0x0b,0xbf]

s_cmp_le_u32 src_scc, s2
// CHECK: [0xfd,0x02,0x0b,0xbf]

s_cmp_le_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s1, s103
// CHECK: [0x01,0x67,0x0b,0xbf]

s_cmp_le_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0b,0xbf]

s_cmp_le_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0b,0xbf]

s_cmp_le_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0b,0xbf]

s_cmp_le_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0b,0xbf]

s_cmp_le_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0b,0xbf]

s_cmp_le_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0b,0xbf]

s_cmp_le_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0b,0xbf]

s_cmp_le_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0b,0xbf]

s_cmp_le_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0b,0xbf]

s_cmp_le_u32 s1, m0
// CHECK: [0x01,0x7c,0x0b,0xbf]

s_cmp_le_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0b,0xbf]

s_cmp_le_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0b,0xbf]

s_cmp_le_u32 s1, 0
// CHECK: [0x01,0x80,0x0b,0xbf]

s_cmp_le_u32 s1, -1
// CHECK: [0x01,0xc1,0x0b,0xbf]

s_cmp_le_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x0b,0xbf]

s_cmp_le_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x0b,0xbf]

s_cmp_le_u32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0b,0xbf]

s_cmp_le_u32 s1, src_execz
// CHECK: [0x01,0xfc,0x0b,0xbf]

s_cmp_le_u32 s1, src_scc
// CHECK: [0x01,0xfd,0x0b,0xbf]

s_cmp_le_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s1, s2
// CHECK: [0x01,0x02,0x0c,0xbf]

s_bitcmp0_b32 s103, s2
// CHECK: [0x67,0x02,0x0c,0xbf]

s_bitcmp0_b32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0c,0xbf]

s_bitcmp0_b32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0c,0xbf]

s_bitcmp0_b32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0c,0xbf]

s_bitcmp0_b32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0c,0xbf]

s_bitcmp0_b32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0c,0xbf]

s_bitcmp0_b32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0c,0xbf]

s_bitcmp0_b32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0c,0xbf]

s_bitcmp0_b32 m0, s2
// CHECK: [0x7c,0x02,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0c,0xbf]

s_bitcmp0_b32 0, s2
// CHECK: [0x80,0x02,0x0c,0xbf]

s_bitcmp0_b32 -1, s2
// CHECK: [0xc1,0x02,0x0c,0xbf]

s_bitcmp0_b32 0.5, s2
// CHECK: [0xf0,0x02,0x0c,0xbf]

s_bitcmp0_b32 -4.0, s2
// CHECK: [0xf7,0x02,0x0c,0xbf]

s_bitcmp0_b32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0c,0xbf]

s_bitcmp0_b32 src_execz, s2
// CHECK: [0xfc,0x02,0x0c,0xbf]

s_bitcmp0_b32 src_scc, s2
// CHECK: [0xfd,0x02,0x0c,0xbf]

s_bitcmp0_b32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s1, s103
// CHECK: [0x01,0x67,0x0c,0xbf]

s_bitcmp0_b32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0c,0xbf]

s_bitcmp0_b32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0c,0xbf]

s_bitcmp0_b32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0c,0xbf]

s_bitcmp0_b32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0c,0xbf]

s_bitcmp0_b32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0c,0xbf]

s_bitcmp0_b32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0c,0xbf]

s_bitcmp0_b32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0c,0xbf]

s_bitcmp0_b32 s1, m0
// CHECK: [0x01,0x7c,0x0c,0xbf]

s_bitcmp0_b32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s1, 0
// CHECK: [0x01,0x80,0x0c,0xbf]

s_bitcmp0_b32 s1, -1
// CHECK: [0x01,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s1, 0.5
// CHECK: [0x01,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s1, -4.0
// CHECK: [0x01,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0c,0xbf]

s_bitcmp0_b32 s1, src_execz
// CHECK: [0x01,0xfc,0x0c,0xbf]

s_bitcmp0_b32 s1, src_scc
// CHECK: [0x01,0xfd,0x0c,0xbf]

s_bitcmp0_b32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s1, s2
// CHECK: [0x01,0x02,0x0d,0xbf]

s_bitcmp1_b32 s103, s2
// CHECK: [0x67,0x02,0x0d,0xbf]

s_bitcmp1_b32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0d,0xbf]

s_bitcmp1_b32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0d,0xbf]

s_bitcmp1_b32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0d,0xbf]

s_bitcmp1_b32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0d,0xbf]

s_bitcmp1_b32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0d,0xbf]

s_bitcmp1_b32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0d,0xbf]

s_bitcmp1_b32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0d,0xbf]

s_bitcmp1_b32 m0, s2
// CHECK: [0x7c,0x02,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0d,0xbf]

s_bitcmp1_b32 0, s2
// CHECK: [0x80,0x02,0x0d,0xbf]

s_bitcmp1_b32 -1, s2
// CHECK: [0xc1,0x02,0x0d,0xbf]

s_bitcmp1_b32 0.5, s2
// CHECK: [0xf0,0x02,0x0d,0xbf]

s_bitcmp1_b32 -4.0, s2
// CHECK: [0xf7,0x02,0x0d,0xbf]

s_bitcmp1_b32 src_vccz, s2
// CHECK: [0xfb,0x02,0x0d,0xbf]

s_bitcmp1_b32 src_execz, s2
// CHECK: [0xfc,0x02,0x0d,0xbf]

s_bitcmp1_b32 src_scc, s2
// CHECK: [0xfd,0x02,0x0d,0xbf]

s_bitcmp1_b32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s1, s103
// CHECK: [0x01,0x67,0x0d,0xbf]

s_bitcmp1_b32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0d,0xbf]

s_bitcmp1_b32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0d,0xbf]

s_bitcmp1_b32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0d,0xbf]

s_bitcmp1_b32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0d,0xbf]

s_bitcmp1_b32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0d,0xbf]

s_bitcmp1_b32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0d,0xbf]

s_bitcmp1_b32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0d,0xbf]

s_bitcmp1_b32 s1, m0
// CHECK: [0x01,0x7c,0x0d,0xbf]

s_bitcmp1_b32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s1, 0
// CHECK: [0x01,0x80,0x0d,0xbf]

s_bitcmp1_b32 s1, -1
// CHECK: [0x01,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s1, 0.5
// CHECK: [0x01,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s1, -4.0
// CHECK: [0x01,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s1, src_vccz
// CHECK: [0x01,0xfb,0x0d,0xbf]

s_bitcmp1_b32 s1, src_execz
// CHECK: [0x01,0xfc,0x0d,0xbf]

s_bitcmp1_b32 s1, src_scc
// CHECK: [0x01,0xfd,0x0d,0xbf]

s_bitcmp1_b32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[102:103], s2
// CHECK: [0x66,0x02,0x0e,0xbf]

s_bitcmp0_b64 flat_scratch, s2
// CHECK: [0x68,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// CHECK: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 tba, s2
// CHECK: [0x6c,0x02,0x0e,0xbf]

s_bitcmp0_b64 tma, s2
// CHECK: [0x6e,0x02,0x0e,0xbf]

s_bitcmp0_b64 ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// CHECK: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 0, s2
// CHECK: [0x80,0x02,0x0e,0xbf]

s_bitcmp0_b64 -1, s2
// CHECK: [0xc1,0x02,0x0e,0xbf]

s_bitcmp0_b64 0.5, s2
// CHECK: [0xf0,0x02,0x0e,0xbf]

s_bitcmp0_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x0e,0xbf]

s_bitcmp0_b64 src_vccz, s2
// CHECK: [0xfb,0x02,0x0e,0xbf]

s_bitcmp0_b64 src_execz, s2
// CHECK: [0xfc,0x02,0x0e,0xbf]

s_bitcmp0_b64 src_scc, s2
// CHECK: [0xfd,0x02,0x0e,0xbf]

s_bitcmp0_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[2:3], s103
// CHECK: [0x02,0x67,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[102:103], s2
// CHECK: [0x66,0x02,0x0f,0xbf]

s_bitcmp1_b64 flat_scratch, s2
// CHECK: [0x68,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// CHECK: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 tba, s2
// CHECK: [0x6c,0x02,0x0f,0xbf]

s_bitcmp1_b64 tma, s2
// CHECK: [0x6e,0x02,0x0f,0xbf]

s_bitcmp1_b64 ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// CHECK: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 0, s2
// CHECK: [0x80,0x02,0x0f,0xbf]

s_bitcmp1_b64 -1, s2
// CHECK: [0xc1,0x02,0x0f,0xbf]

s_bitcmp1_b64 0.5, s2
// CHECK: [0xf0,0x02,0x0f,0xbf]

s_bitcmp1_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x0f,0xbf]

s_bitcmp1_b64 src_vccz, s2
// CHECK: [0xfb,0x02,0x0f,0xbf]

s_bitcmp1_b64 src_execz, s2
// CHECK: [0xfc,0x02,0x0f,0xbf]

s_bitcmp1_b64 src_scc, s2
// CHECK: [0xfd,0x02,0x0f,0xbf]

s_bitcmp1_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[2:3], s103
// CHECK: [0x02,0x67,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], src_vccz
// CHECK: [0x02,0xfb,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], src_execz
// CHECK: [0x02,0xfc,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], src_scc
// CHECK: [0x02,0xfd,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_setvskip s1, s2
// CHECK: [0x01,0x02,0x10,0xbf]

s_setvskip s103, s2
// CHECK: [0x67,0x02,0x10,0xbf]

s_setvskip flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x10,0xbf]

s_setvskip flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x10,0xbf]

s_setvskip vcc_lo, s2
// CHECK: [0x6a,0x02,0x10,0xbf]

s_setvskip vcc_hi, s2
// CHECK: [0x6b,0x02,0x10,0xbf]

s_setvskip tba_lo, s2
// CHECK: [0x6c,0x02,0x10,0xbf]

s_setvskip tba_hi, s2
// CHECK: [0x6d,0x02,0x10,0xbf]

s_setvskip tma_lo, s2
// CHECK: [0x6e,0x02,0x10,0xbf]

s_setvskip tma_hi, s2
// CHECK: [0x6f,0x02,0x10,0xbf]

s_setvskip ttmp11, s2
// CHECK: [0x7b,0x02,0x10,0xbf]

s_setvskip m0, s2
// CHECK: [0x7c,0x02,0x10,0xbf]

s_setvskip exec_lo, s2
// CHECK: [0x7e,0x02,0x10,0xbf]

s_setvskip exec_hi, s2
// CHECK: [0x7f,0x02,0x10,0xbf]

s_setvskip 0, s2
// CHECK: [0x80,0x02,0x10,0xbf]

s_setvskip -1, s2
// CHECK: [0xc1,0x02,0x10,0xbf]

s_setvskip 0.5, s2
// CHECK: [0xf0,0x02,0x10,0xbf]

s_setvskip -4.0, s2
// CHECK: [0xf7,0x02,0x10,0xbf]

s_setvskip src_vccz, s2
// CHECK: [0xfb,0x02,0x10,0xbf]

s_setvskip src_execz, s2
// CHECK: [0xfc,0x02,0x10,0xbf]

s_setvskip src_scc, s2
// CHECK: [0xfd,0x02,0x10,0xbf]

s_setvskip 0xaf123456, s2
// CHECK: [0xff,0x02,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_setvskip 0x3f717273, s2
// CHECK: [0xff,0x02,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_setvskip s1, s103
// CHECK: [0x01,0x67,0x10,0xbf]

s_setvskip s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x10,0xbf]

s_setvskip s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x10,0xbf]

s_setvskip s1, vcc_lo
// CHECK: [0x01,0x6a,0x10,0xbf]

s_setvskip s1, vcc_hi
// CHECK: [0x01,0x6b,0x10,0xbf]

s_setvskip s1, tba_lo
// CHECK: [0x01,0x6c,0x10,0xbf]

s_setvskip s1, tba_hi
// CHECK: [0x01,0x6d,0x10,0xbf]

s_setvskip s1, tma_lo
// CHECK: [0x01,0x6e,0x10,0xbf]

s_setvskip s1, tma_hi
// CHECK: [0x01,0x6f,0x10,0xbf]

s_setvskip s1, ttmp11
// CHECK: [0x01,0x7b,0x10,0xbf]

s_setvskip s1, m0
// CHECK: [0x01,0x7c,0x10,0xbf]

s_setvskip s1, exec_lo
// CHECK: [0x01,0x7e,0x10,0xbf]

s_setvskip s1, exec_hi
// CHECK: [0x01,0x7f,0x10,0xbf]

s_setvskip s1, 0
// CHECK: [0x01,0x80,0x10,0xbf]

s_setvskip s1, -1
// CHECK: [0x01,0xc1,0x10,0xbf]

s_setvskip s1, 0.5
// CHECK: [0x01,0xf0,0x10,0xbf]

s_setvskip s1, -4.0
// CHECK: [0x01,0xf7,0x10,0xbf]

s_setvskip s1, src_vccz
// CHECK: [0x01,0xfb,0x10,0xbf]

s_setvskip s1, src_execz
// CHECK: [0x01,0xfc,0x10,0xbf]

s_setvskip s1, src_scc
// CHECK: [0x01,0xfd,0x10,0xbf]

s_setvskip s1, 0xaf123456
// CHECK: [0x01,0xff,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_setvskip s1, 0x3f717273
// CHECK: [0x01,0xff,0x10,0xbf,0x73,0x72,0x71,0x3f]
