; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X86,X86-AVX512F
; RUN: llc < %s -mtriple=i686-unknown -mattr=+avx512bw | FileCheck %s --check-prefixes=CHECK,X86,X86-AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X64,X64-AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx512bw | FileCheck %s --check-prefixes=CHECK,X64,X64-AVX512BW

declare <16 x float> @llvm.x86.avx512.mask.vpermilvar.ps.512(<16 x float>, <16 x i32>, <16 x float>, i16)

declare <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double>, <8 x i64>)
declare <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64>, <8 x i64>)
declare <16 x i32> @llvm.x86.avx512.permvar.si.512(<16 x i32>, <16 x i32>)

declare <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64>, <8 x double>, <8 x double>, i8)
declare <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32>, <16 x float>, <16 x float>, i16)

declare <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64>, <8 x i64>, <8 x i64>, i8)
declare <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32>, <16 x i32>, <16 x i32>, i16)

declare <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double>, <8 x i64>, <8 x double>, i8)
declare <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float>, <16 x i32>, <16 x float>, i16)

declare <8 x i64> @llvm.x86.avx512.mask.vpermi2var.q.512(<8 x i64>, <8 x i64>, <8 x i64>, i8)
declare <16 x i32> @llvm.x86.avx512.mask.vpermi2var.d.512(<16 x i32>, <16 x i32>, <16 x i32>, i16)

define <8 x double> @combine_permvar_8f64_identity(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_permvar_8f64_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %x0, <8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>)
  %2 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %1, <8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>)
  ret <8 x double> %2
}
define <8 x double> @combine_permvar_8f64_identity_mask(<8 x double> %x0, <8 x double> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_permvar_8f64_identity_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vpermpd %zmm0, %zmm2, %zmm1 {%k1}
; X86-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X86-AVX512F-NEXT:    vpermpd %zmm1, %zmm0, %zmm1 {%k1}
; X86-AVX512F-NEXT:    vmovapd %zmm1, %zmm0
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_permvar_8f64_identity_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vpermpd %zmm0, %zmm2, %zmm1 {%k1}
; X86-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X86-AVX512BW-NEXT:    vpermpd %zmm1, %zmm0, %zmm1 {%k1}
; X86-AVX512BW-NEXT:    vmovapd %zmm1, %zmm0
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_permvar_8f64_identity_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermpd %zmm0, %zmm2, %zmm1 {%k1}
; X64-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X64-AVX512F-NEXT:    vpermpd %zmm1, %zmm0, %zmm1 {%k1}
; X64-AVX512F-NEXT:    vmovapd %zmm1, %zmm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_permvar_8f64_identity_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermpd %zmm0, %zmm2, %zmm1 {%k1}
; X64-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X64-AVX512BW-NEXT:    vpermpd %zmm1, %zmm0, %zmm1 {%k1}
; X64-AVX512BW-NEXT:    vmovapd %zmm1, %zmm0
; X64-AVX512BW-NEXT:    retq
  %1 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %x0, <8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>)
  %2 = bitcast i8 %m to <8 x i1>
  %3 = select <8 x i1> %2, <8 x double> %1, <8 x double> %x1
  %4 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %3, <8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>)
  %5 = bitcast i8 %m to <8 x i1>
  %6 = select <8 x i1> %5, <8 x double> %4, <8 x double> %3
  ret <8 x double> %6
}

define <8 x i64> @combine_permvar_8i64_identity(<8 x i64> %x0, <8 x i64> %x1) {
; CHECK-LABEL: combine_permvar_8i64_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %x0, <8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>)
  %2 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %1, <8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>)
  ret <8 x i64> %2
}
define <8 x i64> @combine_permvar_8i64_identity_mask(<8 x i64> %x0, <8 x i64> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_permvar_8i64_identity_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vpermq %zmm0, %zmm2, %zmm1 {%k1}
; X86-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X86-AVX512F-NEXT:    vpermq %zmm1, %zmm0, %zmm1 {%k1}
; X86-AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_permvar_8i64_identity_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vpermq %zmm0, %zmm2, %zmm1 {%k1}
; X86-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X86-AVX512BW-NEXT:    vpermq %zmm1, %zmm0, %zmm1 {%k1}
; X86-AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_permvar_8i64_identity_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermq %zmm0, %zmm2, %zmm1 {%k1}
; X64-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X64-AVX512F-NEXT:    vpermq %zmm1, %zmm0, %zmm1 {%k1}
; X64-AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_permvar_8i64_identity_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [7,6,5,4,3,2,1,0]
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermq %zmm0, %zmm2, %zmm1 {%k1}
; X64-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [7,14,5,12,3,10,1,8]
; X64-AVX512BW-NEXT:    vpermq %zmm1, %zmm0, %zmm1 {%k1}
; X64-AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-AVX512BW-NEXT:    retq
  %1 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %x0, <8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>)
  %2 = bitcast i8 %m to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %x1
  %4 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %3, <8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>)
  %5 = bitcast i8 %m to <8 x i1>
  %6 = select <8 x i1> %5, <8 x i64> %4, <8 x i64> %3
  ret <8 x i64> %6
}

define <8 x double> @combine_vpermt2var_8f64_identity(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_vpermt2var_8f64_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>, <8 x double> %x0, <8 x double> %x1, i8 -1)
  %res1 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>, <8 x double> %res0, <8 x double> %res0, i8 -1)
  ret <8 x double> %res1
}
define <8 x double> @combine_vpermt2var_8f64_identity_mask(<8 x double> %x0, <8 x double> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_vpermt2var_8f64_identity_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vpermt2pd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512F-NEXT:    vpermpd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_vpermt2var_8f64_identity_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vpermt2pd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512BW-NEXT:    vpermpd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_8f64_identity_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermt2pd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    vpermpd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_8f64_identity_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermt2pd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    vpermpd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    retq
  %res0 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>, <8 x double> %x0, <8 x double> %x1, i8 %m)
  %res1 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>, <8 x double> %res0, <8 x double> %res0, i8 %m)
  ret <8 x double> %res1
}

define <8 x double> @combine_vpermt2var_8f64_movddup(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_vpermt2var_8f64_movddup:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovddup {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 0, i64 0, i64 2, i64 2, i64 4, i64 4, i64 undef, i64 undef>, <8 x double> %x0, <8 x double> %x1, i8 -1)
  ret <8 x double> %res0
}
define <8 x double> @combine_vpermt2var_8f64_movddup_load(ptr%p0, <8 x double> %x1) {
; X86-LABEL: combine_vpermt2var_8f64_movddup_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovddup {{.*#+}} zmm0 = mem[0,0,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermt2var_8f64_movddup_load:
; X64:       # %bb.0:
; X64-NEXT:    vmovddup {{.*#+}} zmm0 = mem[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %x0 = load <8 x double>, ptr%p0
  %res0 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 0, i64 0, i64 2, i64 2, i64 4, i64 4, i64 6, i64 6>, <8 x double> %x0, <8 x double> %x1, i8 -1)
  ret <8 x double> %res0
}
define <8 x double> @combine_vpermt2var_8f64_movddup_mask(<8 x double> %x0, <8 x double> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_vpermt2var_8f64_movddup_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6]
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_vpermt2var_8f64_movddup_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6]
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_8f64_movddup_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_8f64_movddup_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6]
; X64-AVX512BW-NEXT:    retq
  %res0 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 0, i64 0, i64 2, i64 2, i64 4, i64 4, i64 6, i64 6>, <8 x double> %x0, <8 x double> %x1, i8 %m)
  ret <8 x double> %res0
}

define <8 x i64> @combine_vpermt2var_8i64_identity(<8 x i64> %x0, <8 x i64> %x1) {
; CHECK-LABEL: combine_vpermt2var_8i64_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 undef, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>, <8 x i64> %x0, <8 x i64> %x1, i8 -1)
  %res1 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 undef, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>, <8 x i64> %res0, <8 x i64> %res0, i8 -1)
  ret <8 x i64> %res1
}
define <8 x i64> @combine_vpermt2var_8i64_identity_mask(<8 x i64> %x0, <8 x i64> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_vpermt2var_8i64_identity_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vpermt2q %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512F-NEXT:    vpermq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_vpermt2var_8i64_identity_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512BW-NEXT:    vpermq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_8i64_identity_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermt2q %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    vpermq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_8i64_identity_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    vpermq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    retq
  %res0 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>, <8 x i64> %x0, <8 x i64> %x1, i8 %m)
  %res1 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>, <8 x i64> %res0, <8 x i64> %res0, i8 %m)
  ret <8 x i64> %res1
}

define <16 x float> @combine_vpermt2var_16f32_identity(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermt2var_16f32_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  %res1 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 15, i32 30, i32 13, i32 28, i32 11, i32 26, i32 9, i32 24, i32 7, i32 22, i32 5, i32 20, i32 3, i32 18, i32 1, i32 16>, <16 x float> %res0, <16 x float> %res0, i16 -1)
  ret <16 x float> %res1
}
define <16 x float> @combine_vpermt2var_16f32_identity_mask(<16 x float> %x0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_identity_mask:
; X86:       # %bb.0:
; X86-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpermt2ps %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    vpermps %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_identity_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermt2ps %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    vpermps %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_identity_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermt2ps %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    retq
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  %res1 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 15, i32 30, i32 13, i32 28, i32 11, i32 26, i32 9, i32 24, i32 7, i32 22, i32 5, i32 20, i32 3, i32 18, i32 1, i32 16>, <16 x float> %res0, <16 x float> %res0, i16 %m)
  ret <16 x float> %res1
}

define <16 x float> @combine_vpermt2var_16f32_vmovddup(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermt2var_16f32_vmovddup:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovddup {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 4, i32 5, i32 4, i32 5, i32 8, i32 9, i32 8, i32 9, i32 12, i32 13, i32 12, i32 13>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovddup_load(ptr%p0, <16 x float> %x1) {
; X86-LABEL: combine_vpermt2var_16f32_vmovddup_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovddup {{.*#+}} zmm0 = mem[0,0,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermt2var_16f32_vmovddup_load:
; X64:       # %bb.0:
; X64-NEXT:    vmovddup {{.*#+}} zmm0 = mem[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 4, i32 5, i32 4, i32 5, i32 8, i32 9, i32 8, i32 9, i32 12, i32 13, i32 12, i32 13>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovddup_mask(<16 x float> %x0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vmovddup_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vshufps {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,0,1,4,5,4,5,8,9,8,9,12,13,12,13]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vmovddup_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vshufps {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,0,1,4,5,4,5,8,9,8,9,12,13,12,13]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vmovddup_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vshufps {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,0,1,4,5,4,5,8,9,8,9,12,13,12,13]
; X64-AVX512BW-NEXT:    retq
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 4, i32 5, i32 4, i32 5, i32 8, i32 9, i32 8, i32 9, i32 12, i32 13, i32 12, i32 13>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovddup_mask_load(ptr%p0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vmovddup_mask_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,4,5,4,5,8,9,8,9,12,13,12,13]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vmovddup_mask_load:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %esi, %k1
; X64-AVX512F-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,4,5,4,5,8,9,8,9,12,13,12,13]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vmovddup_mask_load:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %esi, %k1
; X64-AVX512BW-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,4,5,4,5,8,9,8,9,12,13,12,13]
; X64-AVX512BW-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 4, i32 5, i32 4, i32 5, i32 8, i32 9, i32 8, i32 9, i32 12, i32 13, i32 12, i32 13>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}

define <16 x float> @combine_vpermt2var_16f32_vmovshdup(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermt2var_16f32_vmovshdup:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovshdup {{.*#+}} zmm0 = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7, i32 9, i32 9, i32 11, i32 11, i32 13, i32 13, i32 15, i32 15>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovshdup_load(ptr%p0, <16 x float> %x1) {
; X86-LABEL: combine_vpermt2var_16f32_vmovshdup_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovshdup {{.*#+}} zmm0 = mem[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermt2var_16f32_vmovshdup_load:
; X64:       # %bb.0:
; X64-NEXT:    vmovshdup {{.*#+}} zmm0 = mem[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X64-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7, i32 9, i32 9, i32 11, i32 11, i32 13, i32 13, i32 15, i32 15>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovshdup_mask(<16 x float> %x0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vmovshdup_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} {z} = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vmovshdup_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} {z} = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vmovshdup_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} {z} = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X64-AVX512BW-NEXT:    retq
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7, i32 9, i32 9, i32 11, i32 11, i32 13, i32 13, i32 15, i32 15>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}

define <16 x float> @combine_vpermt2var_16f32_vmovsldup(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermt2var_16f32_vmovsldup:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovsldup {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovsldup_load(ptr%p0, <16 x float> %x1) {
; X86-LABEL: combine_vpermt2var_16f32_vmovsldup_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovsldup {{.*#+}} zmm0 = mem[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermt2var_16f32_vmovsldup_load:
; X64:       # %bb.0:
; X64-NEXT:    vmovsldup {{.*#+}} zmm0 = mem[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovsldup_mask(<16 x float> %x0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vmovsldup_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vmovsldup_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vmovsldup_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-AVX512BW-NEXT:    retq
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vmovsldup_mask_load(ptr%p0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vmovsldup_mask_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = mem[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vmovsldup_mask_load:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %esi, %k1
; X64-AVX512F-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = mem[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vmovsldup_mask_load:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %esi, %k1
; X64-AVX512BW-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = mem[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-AVX512BW-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}

define <16 x float> @combine_vpermt2var_16f32_vpermilps(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermt2var_16f32_vpermilps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufps {{.*#+}} zmm0 = zmm0[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vpermilps_load(ptr%p0, <16 x float> %x1) {
; X86-LABEL: combine_vpermt2var_16f32_vpermilps_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpermilps {{.*#+}} zmm0 = mem[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermt2var_16f32_vpermilps_load:
; X64:       # %bb.0:
; X64-NEXT:    vpermilps {{.*#+}} zmm0 = mem[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X64-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>, <16 x float> %x0, <16 x float> %x1, i16 -1)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vpermilps_mask(<16 x float> %x0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vpermilps_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vshufps {{.*#+}} zmm0 {%k1} {z} = zmm0[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vpermilps_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vshufps {{.*#+}} zmm0 {%k1} {z} = zmm0[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vpermilps_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vshufps {{.*#+}} zmm0 {%k1} {z} = zmm0[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X64-AVX512BW-NEXT:    retq
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}
define <16 x float> @combine_vpermt2var_16f32_vpermilps_mask_load(ptr%p0, <16 x float> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16f32_vpermilps_mask_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = mem[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16f32_vpermilps_mask_load:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %esi, %k1
; X64-AVX512F-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = mem[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16f32_vpermilps_mask_load:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %esi, %k1
; X64-AVX512BW-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = mem[3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12]
; X64-AVX512BW-NEXT:    retq
  %x0 = load <16 x float>, ptr%p0
  %res0 = call <16 x float> @llvm.x86.avx512.maskz.vpermt2var.ps.512(<16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>, <16 x float> %x0, <16 x float> %x1, i16 %m)
  ret <16 x float> %res0
}

define <16 x i32> @combine_vpermt2var_16i32_identity(<16 x i32> %x0, <16 x i32> %x1) {
; CHECK-LABEL: combine_vpermt2var_16i32_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 undef>, <16 x i32> %x0, <16 x i32> %x1, i16 -1)
  %res1 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 15, i32 30, i32 13, i32 28, i32 undef, i32 26, i32 9, i32 24, i32 7, i32 22, i32 5, i32 20, i32 3, i32 18, i32 1, i32 16>, <16 x i32> %res0, <16 x i32> %res0, i16 -1)
  ret <16 x i32> %res1
}
define <16 x i32> @combine_vpermt2var_16i32_identity_mask(<16 x i32> %x0, <16 x i32> %x1, i16 %m) {
; X86-LABEL: combine_vpermt2var_16i32_identity_mask:
; X86:       # %bb.0:
; X86-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vpermt2d %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    vpermd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_vpermt2var_16i32_identity_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    vpermd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_vpermt2var_16i32_identity_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0]
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    vpermd %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-AVX512BW-NEXT:    retq
  %res0 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>, <16 x i32> %x0, <16 x i32> %x1, i16 %m)
  %res1 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 15, i32 30, i32 13, i32 28, i32 11, i32 26, i32 9, i32 24, i32 7, i32 22, i32 5, i32 20, i32 3, i32 18, i32 1, i32 16>, <16 x i32> %res0, <16 x i32> %res0, i16 %m)
  ret <16 x i32> %res1
}

define <16 x i32> @combine_permvar_as_vpbroadcastd512(<16 x i32> %x0) {
; CHECK-LABEL: combine_permvar_as_vpbroadcastd512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <16 x i32> @llvm.x86.avx512.permvar.si.512(<16 x i32> %x0, <16 x i32> zeroinitializer)
  ret <16 x i32> %1
}

define <8 x i64> @combine_permvar_as_vpbroadcastq512(<8 x i64> %x0) {
; CHECK-LABEL: combine_permvar_as_vpbroadcastq512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %x0, <8 x i64> zeroinitializer)
  ret <8 x i64> %1
}

define <8 x i64> @combine_permvar_8i64_as_permq(<8 x i64> %x0, <8 x i64> %x1) {
; CHECK-LABEL: combine_permvar_8i64_as_permq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermpd {{.*#+}} zmm0 = zmm0[3,2,1,0,7,6,5,4]
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %x0, <8 x i64> <i64 3, i64 2, i64 1, i64 undef, i64 undef, i64 6, i64 5, i64 4>)
  ret <8 x i64> %1
}
define <8 x i64> @combine_permvar_8i64_as_permq_mask(<8 x i64> %x0, <8 x i64> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_permvar_8i64_as_permq_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vpermq {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X86-AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_permvar_8i64_as_permq_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X86-AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_permvar_8i64_as_permq_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermq {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X64-AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_permvar_8i64_as_permq_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermq {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X64-AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-AVX512BW-NEXT:    retq
  %1 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %x0, <8 x i64> <i64 3, i64 2, i64 1, i64 undef, i64 undef, i64 6, i64 5, i64 4>)
  %2 = bitcast i8 %m to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %x1
  ret <8 x i64> %3
}

define <8 x double> @combine_permvar_8f64_as_permpd(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_permvar_8f64_as_permpd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermpd {{.*#+}} zmm0 = zmm0[3,2,1,0,7,6,5,4]
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %x0, <8 x i64> <i64 3, i64 2, i64 1, i64 undef, i64 undef, i64 6, i64 5, i64 4>)
  ret <8 x double> %1
}
define <8 x double> @combine_permvar_8f64_as_permpd_mask(<8 x double> %x0, <8 x double> %x1, i8 %m) {
; X86-AVX512F-LABEL: combine_permvar_8f64_as_permpd_mask:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    kmovw %eax, %k1
; X86-AVX512F-NEXT:    vpermpd {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X86-AVX512F-NEXT:    vmovapd %zmm1, %zmm0
; X86-AVX512F-NEXT:    retl
;
; X86-AVX512BW-LABEL: combine_permvar_8f64_as_permpd_mask:
; X86-AVX512BW:       # %bb.0:
; X86-AVX512BW-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX512BW-NEXT:    kmovd %eax, %k1
; X86-AVX512BW-NEXT:    vpermpd {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X86-AVX512BW-NEXT:    vmovapd %zmm1, %zmm0
; X86-AVX512BW-NEXT:    retl
;
; X64-AVX512F-LABEL: combine_permvar_8f64_as_permpd_mask:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    kmovw %edi, %k1
; X64-AVX512F-NEXT:    vpermpd {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X64-AVX512F-NEXT:    vmovapd %zmm1, %zmm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: combine_permvar_8f64_as_permpd_mask:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    kmovd %edi, %k1
; X64-AVX512BW-NEXT:    vpermpd {{.*#+}} zmm1 {%k1} = zmm0[3,2,1,0,7,6,5,4]
; X64-AVX512BW-NEXT:    vmovapd %zmm1, %zmm0
; X64-AVX512BW-NEXT:    retq
  %1 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %x0, <8 x i64> <i64 3, i64 2, i64 1, i64 undef, i64 undef, i64 6, i64 5, i64 4>)
  %2 = bitcast i8 %m to <8 x i1>
  %3 = select <8 x i1> %2, <8 x double> %1, <8 x double> %x1
  ret <8 x double> %3
}

define <16 x float> @combine_vpermilvar_16f32_230146759A8BCFDE(<16 x float> %x0) {
; CHECK-LABEL: combine_vpermilvar_16f32_230146759A8BCFDE:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermilps {{.*#+}} zmm0 = zmm0[2,3,0,1,4,6,7,5,9,10,8,11,12,15,13,14]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.mask.vpermilvar.ps.512(<16 x float> %x0, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 3, i32 2, i32 1, i32 0, i32 2, i32 3, i32 0, i32 1, i32 1, i32 0, i32 3, i32 2>, <16 x float> undef, i16 -1)
  %res1 = call <16 x float> @llvm.x86.avx512.mask.vpermilvar.ps.512(<16 x float> %res0, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 3, i32 1, i32 0, i32 2, i32 3, i32 0, i32 2, i32 1, i32 1, i32 2, i32 0, i32 3>, <16 x float> undef, i16 -1)
  ret <16 x float> %res1
}

define <8 x double> @combine_vpermi2var_8f64_identity(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_vpermi2var_8f64_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %x0, <8 x i64> <i64 7, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>, <8 x double> %x1, i8 -1)
  %res1 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %res0, <8 x i64> <i64 7, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>, <8 x double> %res0, i8 -1)
  ret <8 x double> %res1
}

define <8 x double> @combine_vpermi2var_8f64_as_shufpd(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_vpermi2var_8f64_as_shufpd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufpd {{.*#+}} zmm0 = zmm0[1],zmm1[0],zmm0[2],zmm1[2],zmm0[5],zmm1[5],zmm0[6],zmm1[7]
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %x0, <8 x i64> <i64 1, i64 8, i64 2, i64 10, i64 5, i64 13, i64 6, i64 15>, <8 x double> %x1, i8 -1)
  ret <8 x double> %1
}

define <8 x i64> @combine_vpermi2var_8i64_identity(<8 x i64> %x0, <8 x i64> %x1) {
; CHECK-LABEL: combine_vpermi2var_8i64_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x i64> @llvm.x86.avx512.mask.vpermi2var.q.512(<8 x i64> %x0, <8 x i64> <i64 undef, i64 6, i64 5, i64 4, i64 3, i64 2, i64 1, i64 0>, <8 x i64> %x1, i8 -1)
  %res1 = call <8 x i64> @llvm.x86.avx512.mask.vpermi2var.q.512(<8 x i64> %res0, <8 x i64> <i64 undef, i64 14, i64 5, i64 12, i64 3, i64 10, i64 1, i64 8>, <8 x i64> %res0, i8 -1)
  ret <8 x i64> %res1
}

define <16 x float> @combine_vpermi2var_16f32_identity(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermi2var_16f32_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float> %x0, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>, <16 x float> %x1, i16 -1)
  %res1 = call <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float> %res0, <16 x i32> <i32 15, i32 30, i32 13, i32 28, i32 11, i32 26, i32 9, i32 24, i32 7, i32 22, i32 5, i32 20, i32 3, i32 18, i32 1, i32 16>, <16 x float> %res0, i16 -1)
  ret <16 x float> %res1
}

define <16 x i32> @combine_vpermi2var_16i32_identity(<16 x i32> %x0, <16 x i32> %x1) {
; CHECK-LABEL: combine_vpermi2var_16i32_identity:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.mask.vpermi2var.d.512(<16 x i32> %x0, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 undef>, <16 x i32> %x1, i16 -1)
  %res1 = call <16 x i32> @llvm.x86.avx512.mask.vpermi2var.d.512(<16 x i32> %res0, <16 x i32> <i32 15, i32 30, i32 13, i32 28, i32 undef, i32 26, i32 9, i32 24, i32 7, i32 22, i32 5, i32 20, i32 3, i32 18, i32 1, i32 16>, <16 x i32> %res0, i16 -1)
  ret <16 x i32> %res1
}

define <16 x float> @combine_vpermt2var_vpermi2var_16f32_as_unpckhps(<16 x float> %a0, <16 x float> %a1) {
; CHECK-LABEL: combine_vpermt2var_vpermi2var_16f32_as_unpckhps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhps {{.*#+}} zmm0 = zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[14],zmm0[14],zmm1[15],zmm0[15]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float> %a0, <16 x i32> <i32 18, i32 2, i32 19, i32 3, i32 22, i32 6, i32 23, i32 7, i32 26, i32 10, i32 27, i32 11, i32 30, i32 14, i32 31, i32 15>, <16 x float> %a1, i16 -1)
  ret <16 x float> %res0
}

define <16 x i32> @vpermt2var_vpermi2var_16i32_as_unpckldq(<16 x i32> %a0, <16 x i32> %a1) {
; CHECK-LABEL: vpermt2var_vpermi2var_16i32_as_unpckldq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklps {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.mask.vpermi2var.d.512(<16 x i32> %a0, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>, <16 x i32> %a1, i16 -1)
  ret <16 x i32> %res0
}

define <8 x double> @combine_vpermi2var_8f64_as_vpermpd(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_vpermi2var_8f64_as_vpermpd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; CHECK-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %x0, <8 x i64> <i64 3, i64 2, i64 1, i64 0, i64 7, i64 6, i64 5, i64 4>, <8 x double> %x1, i8 -1)
  %res1 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %res0, <8 x i64> <i64 12, i64 5, i64 14, i64 7, i64 8, i64 1, i64 10, i64 3>, <8 x double> %res0, i8 -1)
  ret <8 x double> %res1
}

define <8 x i64> @combine_vpermt2var_8i64_as_valignq(<8 x i64> %x0, <8 x i64> %x1) {
; CHECK-LABEL: combine_vpermt2var_8i64_as_valignq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    valignq {{.*#+}} zmm0 = zmm1[7],zmm0[0,1,2,3,4,5,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 15, i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6>, <8 x i64> %x0, <8 x i64> %x1, i8 -1)
  ret <8 x i64> %res0
}

define <8 x i64> @combine_vpermt2var_8i64_as_valignq_zero(<8 x i64> %x0) {
; CHECK-LABEL: combine_vpermt2var_8i64_as_valignq_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    valignq {{.*#+}} zmm0 = zmm0[7],zmm1[0,1,2,3,4,5,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 15, i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6>, <8 x i64> zeroinitializer, <8 x i64> %x0, i8 -1)
  ret <8 x i64> %res0
}

define <8 x i64> @combine_vpermt2var_8i64_as_zero_valignq(<8 x i64> %x0) {
; CHECK-LABEL: combine_vpermt2var_8i64_as_zero_valignq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    valignq {{.*#+}} zmm0 = zmm1[7],zmm0[0,1,2,3,4,5,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 15, i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6>, <8 x i64> %x0, <8 x i64> zeroinitializer, i8 -1)
  ret <8 x i64> %res0
}

define <8 x i64> @combine_vpermt2var_8i64_as_vpermq(<8 x i64> %x0, <8 x i64> %x1) {
; CHECK-LABEL: combine_vpermt2var_8i64_as_vpermq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [7,6,5,4,3,2,1,0]
; CHECK-NEXT:    vpermpd %zmm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 3, i64 2, i64 1, i64 0, i64 7, i64 6, i64 5, i64 4>, <8 x i64> %x0, <8 x i64> %x1, i8 -1)
  %res1 = call <8 x i64> @llvm.x86.avx512.maskz.vpermt2var.q.512(<8 x i64> <i64 12, i64 5, i64 14, i64 7, i64 8, i64 1, i64 10, i64 3>, <8 x i64> %res0, <8 x i64> %res0, i8 -1)
  ret <8 x i64> %res1
}

define <16 x float> @combine_vpermi2var_16f32_as_vpermps(<16 x float> %x0, <16 x float> %x1) {
; CHECK-LABEL: combine_vpermi2var_16f32_as_vpermps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [7,7,5,5,3,3,1,1,15,15,13,13,11,11,9,9]
; CHECK-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float> %x0, <16 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8>, <16 x float> %x1, i16 -1)
  %res1 = call <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float> %res0, <16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>, <16 x float> %res0, i16 -1)
  ret <16 x float> %res1
}

define <16 x i32> @combine_vpermt2var_16i32_as_vpermd(<16 x i32> %x0, <16 x i32> %x1) {
; CHECK-LABEL: combine_vpermt2var_16i32_as_vpermd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [7,7,5,5,3,3,1,1,15,15,13,13,11,11,9,9]
; CHECK-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8>, <16 x i32> %x0, <16 x i32> %x1, i16 -1)
  %res1 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>, <16 x i32> %res0, <16 x i32> %res0, i16 -1)
  ret <16 x i32> %res1
}

define <16 x i32> @combine_vpermt2var_16i32_as_vpsrlq(<16 x i32> %x0) {
; CHECK-LABEL: combine_vpermt2var_16i32_as_vpsrlq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpsrlq $32, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 1, i32 16, i32 3, i32 16, i32 5, i32 16, i32 7, i32 16, i32 9, i32 16, i32 11, i32 16, i32 13, i32 16, i32 15, i32 16>, <16 x i32> %x0, <16 x i32> zeroinitializer, i16 -1)
  ret <16 x i32> %res0
}

define <16 x i32> @combine_vpermt2var_16i32_as_vpsllq(<16 x i32> %x0) {
; CHECK-LABEL: combine_vpermt2var_16i32_as_vpsllq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpsllq $32, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 16, i32 0, i32 16, i32 2, i32 16, i32 4, i32 16, i32 6, i32 16, i32 8, i32 16, i32 10, i32 16, i32 12, i32 16, i32 14>, <16 x i32> %x0, <16 x i32> zeroinitializer, i16 -1)
  ret <16 x i32> %res0
}

define <8 x double> @combine_vpermi2var_vpermt2var_8f64_as_vperm2(<8 x double> %x0, <8 x double> %x1) {
; CHECK-LABEL: combine_vpermi2var_vpermt2var_8f64_as_vperm2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,14,3,12,7,8,0,15]
; CHECK-NEXT:    vpermi2pd %zmm0, %zmm1, %zmm2
; CHECK-NEXT:    vmovapd %zmm2, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %x0, <8 x i64> <i64 15, i64 0, i64 8, i64 7, i64 12, i64 6, i64 11, i64 4>, <8 x double> %x1, i8 -1)
  %res1 = call <8 x double> @llvm.x86.avx512.maskz.vpermt2var.pd.512(<8 x i64> <i64 12, i64 5, i64 14, i64 7, i64 8, i64 1, i64 10, i64 3>, <8 x double> %res0, <8 x double> %res0, i8 -1)
  ret <8 x double> %res1
}

define <8 x double> @combine_vpermi2var_8f64_as_permpd(<8 x double> %x0, <8 x double> %x1, i64 %a2) {
; X86-LABEL: combine_vpermi2var_8f64_as_permpd:
; X86:       # %bb.0:
; X86-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; X86-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; X86-NEXT:    vinsertf128 $1, {{\.?LCPI[0-9]+_[0-9]+}}, %ymm2, %ymm2
; X86-NEXT:    vinsertf64x4 $1, {{\.?LCPI[0-9]+_[0-9]+}}, %zmm2, %zmm2
; X86-NEXT:    vpermi2pd %zmm1, %zmm0, %zmm2
; X86-NEXT:    vpermpd {{.*#+}} zmm0 = zmm2[2,3,1,1,6,7,5,5]
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermi2var_8f64_as_permpd:
; X64:       # %bb.0:
; X64-NEXT:    vpermpd {{.*#+}} zmm0 = zmm0[1,3,2,2,5,7,6,6]
; X64-NEXT:    retq
  %res0 = insertelement <8 x i64> <i64 0, i64 2, i64 1, i64 3, i64 4, i64 6, i64 5, i64 7>, i64 %a2, i32 0
  %res1 = call <8 x double> @llvm.x86.avx512.mask.vpermi2var.pd.512(<8 x double> %x0, <8 x i64> %res0, <8 x double> %x1, i8 -1)
  %res2 = shufflevector <8 x double> %res1, <8 x double> undef, <8 x i32> <i32 2, i32 3, i32 1, i32 1, i32 6, i32 7, i32 5, i32 5>
  ret <8 x double> %res2
}

define <16 x i32> @combine_vpermi2var_vpermt2var_16i32_as_vpermd(<16 x i32> %x0, <16 x i32> %x1) {
; CHECK-LABEL: combine_vpermi2var_vpermt2var_16i32_as_vpermd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,31,2,2,4,29,6,27,8,25,10,23,12,21,14,19]
; CHECK-NEXT:    vpermt2d %zmm1, %zmm2, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = call <16 x i32> @llvm.x86.avx512.mask.vpermi2var.d.512(<16 x i32> %x0, <16 x i32> <i32 0, i32 31, i32 2, i32 29, i32 4, i32 27, i32 6, i32 25, i32 8, i32 23, i32 10, i32 21, i32 12, i32 19, i32 14, i32 17>, <16 x i32> %x1, i16 -1)
  %res1 = call <16 x i32> @llvm.x86.avx512.maskz.vpermt2var.d.512(<16 x i32> <i32 0, i32 17, i32 2, i32 18, i32 4, i32 19, i32 6, i32 21, i32 8, i32 23, i32 10, i32 25, i32 12, i32 27, i32 14, i32 29>, <16 x i32> %res0, <16 x i32> %res0, i16 -1)
  ret <16 x i32> %res1
}

define <8 x double> @combine_vpermi2var_vpermvar_8f64_as_vperm2_zero(<8 x double> %x0) {
; CHECK-LABEL: combine_vpermi2var_vpermvar_8f64_as_vperm2_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [8,3,10,11,1,7,14,5]
; CHECK-NEXT:    vpermt2pd %zmm1, %zmm2, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = shufflevector <8 x double> %x0, <8 x double> zeroinitializer, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %1 = call <8 x double> @llvm.x86.avx512.permvar.df.512(<8 x double> %res0, <8 x i64> <i64 3, i64 2, i64 1, i64 7, i64 0, i64 6, i64 5, i64 4>)
  ret <8 x double> %1
}

define <16 x float> @combine_vpermi2var_vpermvar_16f32_as_vperm2_zero(<16 x float> %x0) {
; CHECK-LABEL: combine_vpermi2var_vpermvar_16f32_as_vperm2_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,13,1,12,4,9,22,12,4,25,26,9,5,29,30,8]
; CHECK-NEXT:    vpermt2ps %zmm1, %zmm2, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res0 = shufflevector <16 x float> %x0, <16 x float> zeroinitializer, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  %res1 = call <16 x float> @llvm.x86.avx512.mask.vpermi2var.ps.512(<16 x float> %res0, <16 x i32> <i32 0, i32 14, i32 2, i32 12, i32 4, i32 10, i32 3, i32 12, i32 4, i32 11, i32 5, i32 10, i32 6, i32 9, i32 7, i32 8>, <16 x float> %res0, i16 -1)
  ret <16 x float> %res1
}

define <8 x i64> @combine_vpermvar_insertion_as_broadcast_v8i64(i64 %a0) {
; X86-LABEL: combine_vpermvar_insertion_as_broadcast_v8i64:
; X86:       # %bb.0:
; X86-NEXT:    vbroadcastsd {{[0-9]+}}(%esp), %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: combine_vpermvar_insertion_as_broadcast_v8i64:
; X64:       # %bb.0:
; X64-NEXT:    vpbroadcastq %rdi, %zmm0
; X64-NEXT:    retq
  %1 = insertelement <8 x i64> undef, i64 %a0, i32 0
  %2 = call <8 x i64> @llvm.x86.avx512.permvar.di.512(<8 x i64> %1, <8 x i64> zeroinitializer)
  ret <8 x i64> %2
}

define <16 x i32> @blend_of_permutes_v16i32(<8 x i64> %a0, <8x i64> %a1) {
; CHECK-LABEL: blend_of_permutes_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [4,21,6,23,16,1,2,19,12,29,14,31,24,9,10,27]
; CHECK-NEXT:    vpermt2d %zmm1, %zmm2, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %s0 = shufflevector <8 x i64> %a0, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %s1 = shufflevector <8 x i64> %a1, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %x0 = bitcast <8 x i64> %s0 to <16 x i32>
  %x1 = bitcast <8 x i64> %s1 to <16 x i32>
  %r = shufflevector <16 x i32> %x0, <16 x i32> %x1, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 20, i32 5, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 28, i32 13, i32 14, i32 31>
  ret <16 x i32> %r
}

define <8 x double> @concat_vpermilvar_v8f64_v2f64(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2, <2 x double> %a3, <8 x i64> %m) nounwind {
; X86-LABEL: concat_vpermilvar_v8f64_v2f64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-64, %esp
; X86-NEXT:    subl $64, %esp
; X86-NEXT:    # kill: def $xmm2 killed $xmm2 def $ymm2
; X86-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; X86-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X86-NEXT:    vinsertf128 $1, 8(%ebp), %ymm2, %ymm1
; X86-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; X86-NEXT:    vpermilpd 72(%ebp), %zmm0, %zmm0
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: concat_vpermilvar_v8f64_v2f64:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $xmm2 killed $xmm2 def $ymm2
; X64-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; X64-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; X64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-NEXT:    vinsertf64x4 $1, %ymm2, %zmm0, %zmm0
; X64-NEXT:    vpermilpd %zmm4, %zmm0, %zmm0
; X64-NEXT:    retq
  %m0 = shufflevector <8 x i64> %m, <8 x i64> poison, <2 x i32> <i32 0, i32 1>
  %m1 = shufflevector <8 x i64> %m, <8 x i64> poison, <2 x i32> <i32 2, i32 3>
  %m2 = shufflevector <8 x i64> %m, <8 x i64> poison, <2 x i32> <i32 4, i32 5>
  %m3 = shufflevector <8 x i64> %m, <8 x i64> poison, <2 x i32> <i32 6, i32 7>
  %v0 = tail call noundef <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %a0, <2 x i64> %m0)
  %v1 = tail call noundef <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %a1, <2 x i64> %m1)
  %v2 = tail call noundef <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %a2, <2 x i64> %m2)
  %v3 = tail call noundef <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %a3, <2 x i64> %m3)
  %lo = shufflevector <2 x double> %v0, <2 x double> %v1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %hi = shufflevector <2 x double> %v2, <2 x double> %v3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x double> %lo, <4 x double> %hi, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x double> %res
}

define <8 x double> @concat_vpermilvar_v8f64_v4f64(<4 x double> %a0, <4 x double> %a1, <8 x i64> %m) nounwind {
; CHECK-LABEL: concat_vpermilvar_v8f64_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; CHECK-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; CHECK-NEXT:    vpermilpd %zmm2, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %m0 = shufflevector <8 x i64> %m, <8 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %m1 = shufflevector <8 x i64> %m, <8 x i64> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %v0 = tail call noundef <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double> %a0, <4 x i64> %m0)
  %v1 = tail call noundef <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double> %a1, <4 x i64> %m1)
  %res = shufflevector <4 x double> %v0, <4 x double> %v1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x double> %res
}
