; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+mmx,+ssse3 | FileCheck %s

define <1 x i64> @stack_fold_cvtpd2pi(<2 x double> %a0) {
; CHECK-LABEL: stack_fold_cvtpd2pi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    cvtpd2pi {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 16-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{flags}"()
  %2 = call <1 x i64> @llvm.x86.sse.cvtpd2pi(<2 x double> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.sse.cvtpd2pi(<2 x double>) nounwind readnone

define <2 x double> @stack_fold_cvtpi2pd(<1 x i64> %a0) {
; CHECK-LABEL: stack_fold_cvtpi2pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    cvtpi2pd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 8-byte Folded Reload
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <2 x double> @llvm.x86.sse.cvtpi2pd(<1 x i64> %a0) nounwind readnone
  ret <2 x double> %2
}
declare <2 x double> @llvm.x86.sse.cvtpi2pd(<1 x i64>) nounwind readnone

define <4 x float> @stack_fold_cvtpi2ps(<4 x float> %a0, <1 x i64> %a1) {
; CHECK-LABEL: stack_fold_cvtpi2ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    cvtpi2ps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 8-byte Folded Reload
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <4 x float> @llvm.x86.sse.cvtpi2ps(<4 x float> %a0, <1 x i64> %a1) nounwind readnone
  ret <4 x float> %2
}
declare <4 x float> @llvm.x86.sse.cvtpi2ps(<4 x float>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_cvtps2pi(<4 x float> %a0) {
; CHECK-LABEL: stack_fold_cvtps2pi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    cvtps2pi {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 16-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{flags}"()
  %2 = call <1 x i64> @llvm.x86.sse.cvtps2pi(<4 x float> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.sse.cvtps2pi(<4 x float>) nounwind readnone

define <1 x i64> @stack_fold_cvttpd2pi(<2 x double> %a0) {
; CHECK-LABEL: stack_fold_cvttpd2pi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    cvttpd2pi {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 16-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{flags}"()
  %2 = call <1 x i64> @llvm.x86.sse.cvttpd2pi(<2 x double> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.sse.cvttpd2pi(<2 x double>) nounwind readnone

define <1 x i64> @stack_fold_cvttps2pi(<4 x float> %a0) {
; CHECK-LABEL: stack_fold_cvttps2pi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    cvttps2pi {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 16-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <2 x i64> asm sideeffect "nop", "=x,~{xmm1},~{xmm1},~{xmm2},~{xmm3},~{xmm4},~{xmm5},~{xmm6},~{xmm7},~{xmm8},~{xmm9},~{xmm10},~{xmm11},~{xmm12},~{xmm13},~{xmm14},~{xmm15},~{flags}"()
  %2 = call <1 x i64> @llvm.x86.sse.cvttps2pi(<4 x float> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.sse.cvttps2pi(<4 x float>) nounwind readnone

; TODO stack_fold_movd_load

; padd forces execution on mmx
define i32 @stack_fold_movd_store(<1 x i64> %a0) nounwind {
; CHECK-LABEL: stack_fold_movd_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    paddb %mm0, %mm0
; CHECK-NEXT:    movd %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    movl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %1 = call <1 x i64> @llvm.x86.mmx.padd.b(<1 x i64> %a0, <1 x i64> %a0)
  %2 = bitcast <1 x i64> %1 to <2 x i32>
  %3 = extractelement <2 x i32> %2, i32 0
  %4 = tail call i64 asm sideeffect "nop", "=x,~{rax},~{rbx},~{rcx},~{rdx},~{rsi},~{rdi},~{rbp},~{r8},~{r9},~{r10},~{r11},~{r12},~{r13},~{r14},~{r15}"()
  ret i32 %3
}

; TODO stack_fold_movq_load

; padd forces execution on mmx
define i64 @stack_fold_movq_store(<1 x i64> %a0) nounwind {
; CHECK-LABEL: stack_fold_movq_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    paddb %mm0, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
  %1 = call <1 x i64> @llvm.x86.mmx.padd.b(<1 x i64> %a0, <1 x i64> %a0)
  %2 = bitcast <1 x i64> %1 to i64
  %3 = tail call i64 asm sideeffect "nop", "=x,~{rax},~{rbx},~{rcx},~{rdx},~{rsi},~{rdi},~{rbp},~{r8},~{r9},~{r10},~{r11},~{r12},~{r13},~{r14},~{r15}"()
  ret i64 %2
}

define <1 x i64> @stack_fold_pabsb(<1 x i64> %a0) {
; CHECK-LABEL: stack_fold_pabsb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    pabsb {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 8-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.pabs.b(<1 x i64> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.pabs.b(<1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pabsd(<1 x i64> %a0) {
; CHECK-LABEL: stack_fold_pabsd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    pabsd {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 8-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.pabs.d(<1 x i64> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.pabs.d(<1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pabsw(<1 x i64> %a0) {
; CHECK-LABEL: stack_fold_pabsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    pabsw {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 8-byte Folded Reload
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.pabs.w(<1 x i64> %a0) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.pabs.w(<1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_packssdw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_packssdw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    packssdw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.packssdw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.packssdw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_packsswb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_packsswb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    packsswb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.packsswb(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.packsswb(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_packuswb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_packuswb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    packuswb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.packuswb(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.packuswb(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.padd.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.padd.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.padd.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.padd.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddq %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.padd.q(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.padd.q(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddsb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddsb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddsb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.padds.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.padds.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.padds.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.padds.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddusb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddusb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddusb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.paddus.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.paddus.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddusw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddusw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddusw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.paddus.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.paddus.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_paddw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_paddw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    paddw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.padd.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.padd.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_palignr(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_palignr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    palignr $1, %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.palignr.b(<1 x i64> %a, <1 x i64> %b, i8 1) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.palignr.b(<1 x i64>, <1 x i64>, i8) nounwind readnone

define <1 x i64> @stack_fold_pand(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pand:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pand %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pand(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pand(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pandn(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pandn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pandn %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pandn(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pandn(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pavgb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pavgb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pavgb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pavg.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pavg.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pavgw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pavgw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pavgw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pavg.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pavg.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pcmpeqb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pcmpeqb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pcmpeqb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pcmpeq.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pcmpeq.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pcmpeqd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pcmpeqd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pcmpeqd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pcmpeq.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pcmpeq.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pcmpeqw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pcmpeqw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pcmpeqw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pcmpeq.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pcmpeq.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pcmpgtb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pcmpgtb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pcmpgtb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pcmpgt.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pcmpgt.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pcmpgtd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pcmpgtd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pcmpgtd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pcmpgt.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pcmpgt.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pcmpgtw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pcmpgtw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pcmpgtw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pcmpgt.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pcmpgt.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_phaddd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_phaddd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    phaddd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.phadd.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.phadd.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_phaddsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_phaddsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    phaddsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.phadd.sw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.phadd.sw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_phaddw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_phaddw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    phaddw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.phadd.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.phadd.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_phsubd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_phsubd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    phsubd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.phsub.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.phsub.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_phsubsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_phsubsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    phsubsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.phsub.sw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.phsub.sw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_phsubw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_phsubw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    phsubw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.phsub.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.phsub.w(<1 x i64>, <1 x i64>) nounwind readnone

; TODO stack_fold_pinsrw

define <1 x i64> @stack_fold_pmaddubsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmaddubsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmaddubsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.pmadd.ub.sw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.pmadd.ub.sw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmaddwd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmaddwd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmaddwd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmadd.wd(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmadd.wd(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmaxsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmaxsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmaxsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmaxs.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmaxs.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmaxub(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmaxub:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmaxub %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmaxu.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmaxu.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pminsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pminsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pminsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmins.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmins.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pminub(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pminub:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pminub %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pminu.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pminu.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmulhrsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmulhrsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmulhrsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.pmul.hr.sw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.pmul.hr.sw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmulhuw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmulhuw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmulhuw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmulhu.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmulhu.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmulhw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmulhw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmulhw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmulh.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmulh.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmullw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmullw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmullw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmull.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmull.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pmuludq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pmuludq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pmuludq %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pmulu.dq(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pmulu.dq(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_por(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_por:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    por %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.por(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.por(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psadbw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psadbw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psadbw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psad.bw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psad.bw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pshufb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pshufb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pshufb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.pshuf.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.pshuf.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pshufw(<1 x i64> %a) {
; CHECK-LABEL: stack_fold_pshufw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %mm0
; CHECK-NEXT:    movq %mm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    pshufw $1, {{[-0-9]+}}(%r{{[sb]}}p), %mm0 # 8-byte Folded Reload
; CHECK-NEXT:    # mm0 = mem[1,0,0,0]
; CHECK-NEXT:    movq %mm0, %rax
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm1},~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.sse.pshuf.w(<1 x i64> %a, i8 1) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.sse.pshuf.w(<1 x i64>, i8) nounwind readnone

define <1 x i64> @stack_fold_psignb(<1 x i64> %a0, <1 x i64> %a1) {
; CHECK-LABEL: stack_fold_psignb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psignb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.psign.b(<1 x i64> %a0, <1 x i64> %a1) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.psign.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psignd(<1 x i64> %a0, <1 x i64> %a1) {
; CHECK-LABEL: stack_fold_psignd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psignd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.psign.d(<1 x i64> %a0, <1 x i64> %a1) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.psign.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psignw(<1 x i64> %a0, <1 x i64> %a1) {
; CHECK-LABEL: stack_fold_psignw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psignw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.ssse3.psign.w(<1 x i64> %a0, <1 x i64> %a1) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.ssse3.psign.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pslld(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pslld:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pslld %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psll.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psll.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psllq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psllq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psllq %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psll.q(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psll.q(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psllw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psllw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psllw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psll.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psll.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psrad(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psrad:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psrad %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psra.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psra.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psraw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psraw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psraw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psra.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psra.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psrld(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psrld:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psrld %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psrl.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psrl.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psrlq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psrlq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psrlq %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psrl.q(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psrl.q(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psrlw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psrlw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psrlw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psrl.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psrl.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psub.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psub.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubd %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psub.d(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psub.d(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubq %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psub.q(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psub.q(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubsb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubsb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubsb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psubs.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psubs.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubsw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubsw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psubs.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psubs.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubusb(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubusb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubusb %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psubus.b(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psubus.b(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubusw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubusw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubusw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psubus.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psubus.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_psubw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_psubw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    psubw %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.psub.w(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.psub.w(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_punpckhbw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_punpckhbw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    punpckhbw %mm0, %mm1 # mm1 = mm1[4],mm0[4],mm1[5],mm0[5],mm1[6],mm0[6],mm1[7],mm0[7]
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.punpckhbw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.punpckhbw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_punpckhdq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_punpckhdq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    punpckhdq %mm0, %mm1 # mm1 = mm1[1],mm0[1]
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.punpckhdq(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.punpckhdq(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_punpckhwd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_punpckhwd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    punpckhwd %mm0, %mm1 # mm1 = mm1[2],mm0[2],mm1[3],mm0[3]
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.punpckhwd(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.punpckhwd(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_punpcklbw(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_punpcklbw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    punpcklbw %mm0, %mm1 # mm1 = mm1[0],mm0[0],mm1[1],mm0[1],mm1[2],mm0[2],mm1[3],mm0[3]
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.punpcklbw(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.punpcklbw(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_punpckldq(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_punpckldq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    punpckldq %mm0, %mm1 # mm1 = mm1[0],mm0[0]
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.punpckldq(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.punpckldq(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_punpcklwd(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_punpcklwd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    punpcklwd %mm0, %mm1 # mm1 = mm1[0],mm0[0],mm1[1],mm0[1]
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.punpcklwd(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.punpcklwd(<1 x i64>, <1 x i64>) nounwind readnone

define <1 x i64> @stack_fold_pxor(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: stack_fold_pxor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %mm0
; CHECK-NEXT:    movq %rdi, %mm1
; CHECK-NEXT:    pxor %mm0, %mm1
; CHECK-NEXT:    movq %mm1, %rax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    nop
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    retq
  %1 = tail call <1 x i64> asm sideeffect "nop", "=y,~{mm2},~{mm3},~{mm4},~{mm5},~{mm6},~{mm7}"()
  %2 = call <1 x i64> @llvm.x86.mmx.pxor(<1 x i64> %a, <1 x i64> %b) nounwind readnone
  ret <1 x i64> %2
}
declare <1 x i64> @llvm.x86.mmx.pxor(<1 x i64>, <1 x i64>) nounwind readnone
