; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686--        | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-- -O0 | FileCheck %s -check-prefixes=CHECK-X64,CHECK-X64-O0
; RUN: llc < %s -mtriple=x86_64-- -O2 | FileCheck %s -check-prefixes=CHECK-X64,CHECK-X64-O2

; CHECK-LABEL: shift1
define void @shift1(i256 %x, i256 %a, ptr nocapture %r) nounwind readnone {
; CHECK-LABEL: shift1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    pushl %edi
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    subl $112, %esp
; CHECK-NEXT:    movl 40(%ebp), %ecx
; CHECK-NEXT:    movl 8(%ebp), %eax
; CHECK-NEXT:    movl 12(%ebp), %edx
; CHECK-NEXT:    movl 16(%ebp), %esi
; CHECK-NEXT:    movl 32(%ebp), %edi
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl 28(%ebp), %edi
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl 24(%ebp), %edi
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl 20(%ebp), %edi
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl 36(%ebp), %edi
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    sarl $31, %edi
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    shrb $5, %al
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    movl 40(%esp,%eax,4), %edx
; CHECK-NEXT:    movl 36(%esp,%eax,4), %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    shrdl %cl, %edx, %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 44(%esp,%eax,4), %esi
; CHECK-NEXT:    shrdl %cl, %esi, %edx
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 48(%esp,%eax,4), %ebx
; CHECK-NEXT:    shrdl %cl, %ebx, %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 52(%esp,%eax,4), %esi
; CHECK-NEXT:    shrdl %cl, %esi, %ebx
; CHECK-NEXT:    movl 56(%esp,%eax,4), %edx
; CHECK-NEXT:    shrdl %cl, %edx, %esi
; CHECK-NEXT:    movl 32(%esp,%eax,4), %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 60(%esp,%eax,4), %eax
; CHECK-NEXT:    shrdl %cl, %eax, %edx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    shrdl %cl, %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    sarl %cl, %eax
; CHECK-NEXT:    movl 72(%ebp), %ecx
; CHECK-NEXT:    movl %eax, 28(%ecx)
; CHECK-NEXT:    movl %edx, 24(%ecx)
; CHECK-NEXT:    movl %esi, 20(%ecx)
; CHECK-NEXT:    movl %ebx, 16(%ecx)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    movl %eax, 12(%ecx)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    movl %eax, 8(%ecx)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    movl %eax, 4(%ecx)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    movl %eax, (%ecx)
; CHECK-NEXT:    leal -12(%ebp), %esp
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    popl %edi
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    retl
;
; CHECK-X64-O0-LABEL: shift1:
; CHECK-X64-O0:       # %bb.0: # %entry
; CHECK-X64-O0-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-X64-O0-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-X64-O0-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-X64-O0-NEXT:    movq %rdi, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq %rsi, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq %rdx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    sarq $63, %rcx
; CHECK-X64-O0-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movb %r8b, %cl
; CHECK-X64-O0-NEXT:    movb %cl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; CHECK-X64-O0-NEXT:    movb %cl, %dl
; CHECK-X64-O0-NEXT:    shrb $6, %dl
; CHECK-X64-O0-NEXT:    movzbl %dl, %edx
; CHECK-X64-O0-NEXT:    movl %edx, %edi
; CHECK-X64-O0-NEXT:    movq -56(%rsp,%rdi,8), %rsi
; CHECK-X64-O0-NEXT:    movq -72(%rsp,%rdi,8), %r8
; CHECK-X64-O0-NEXT:    movq -64(%rsp,%rdi,8), %r9
; CHECK-X64-O0-NEXT:    movq %r9, %rdx
; CHECK-X64-O0-NEXT:    shrdq %cl, %rsi, %rdx
; CHECK-X64-O0-NEXT:    movb {{[-0-9]+}}(%r{{[sb]}}p), %cl # 1-byte Reload
; CHECK-X64-O0-NEXT:    movq -48(%rsp,%rdi,8), %rdi
; CHECK-X64-O0-NEXT:    shrdq %cl, %rdi, %rsi
; CHECK-X64-O0-NEXT:    movb {{[-0-9]+}}(%r{{[sb]}}p), %cl # 1-byte Reload
; CHECK-X64-O0-NEXT:    shrdq %cl, %r9, %r8
; CHECK-X64-O0-NEXT:    movb {{[-0-9]+}}(%r{{[sb]}}p), %cl # 1-byte Reload
; CHECK-X64-O0-NEXT:    movq %r8, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-X64-O0-NEXT:    sarq %cl, %rdi
; CHECK-X64-O0-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; CHECK-X64-O0-NEXT:    movq %rdi, 24(%rax)
; CHECK-X64-O0-NEXT:    movq %rsi, 16(%rax)
; CHECK-X64-O0-NEXT:    movq %rdx, 8(%rax)
; CHECK-X64-O0-NEXT:    movq %rcx, (%rax)
; CHECK-X64-O0-NEXT:    retq
;
; CHECK-X64-O2-LABEL: shift1:
; CHECK-X64-O2:       # %bb.0: # %entry
; CHECK-X64-O2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-X64-O2-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq %rdx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq %rsi, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq %rdi, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    sarq $63, %rcx
; CHECK-X64-O2-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movl %r8d, %ecx
; CHECK-X64-O2-NEXT:    shrb $6, %cl
; CHECK-X64-O2-NEXT:    movzbl %cl, %edx
; CHECK-X64-O2-NEXT:    movq -56(%rsp,%rdx,8), %rsi
; CHECK-X64-O2-NEXT:    movq -72(%rsp,%rdx,8), %rdi
; CHECK-X64-O2-NEXT:    movq -64(%rsp,%rdx,8), %r9
; CHECK-X64-O2-NEXT:    movq %r9, %r10
; CHECK-X64-O2-NEXT:    movl %r8d, %ecx
; CHECK-X64-O2-NEXT:    shrdq %cl, %rsi, %r10
; CHECK-X64-O2-NEXT:    movq -48(%rsp,%rdx,8), %rdx
; CHECK-X64-O2-NEXT:    shrdq %cl, %rdx, %rsi
; CHECK-X64-O2-NEXT:    shrdq %cl, %r9, %rdi
; CHECK-X64-O2-NEXT:    sarq %cl, %rdx
; CHECK-X64-O2-NEXT:    movq %rdx, 24(%rax)
; CHECK-X64-O2-NEXT:    movq %rsi, 16(%rax)
; CHECK-X64-O2-NEXT:    movq %r10, 8(%rax)
; CHECK-X64-O2-NEXT:    movq %rdi, (%rax)
; CHECK-X64-O2-NEXT:    retq
entry:
	%0 = ashr i256 %x, %a
	store i256 %0, ptr %r
        ret void
}

define i256 @shift2(i256 %c) nounwind
; CHECK-LABEL: shift2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    pushl %edi
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    subl $112, %esp
; CHECK-NEXT:    movl 12(%ebp), %ecx
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $1, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    shrb $3, %al
; CHECK-NEXT:    andb $28, %al
; CHECK-NEXT:    negb %al
; CHECK-NEXT:    movsbl %al, %eax
; CHECK-NEXT:    movl 68(%esp,%eax), %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 72(%esp,%eax), %edx
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    shldl %cl, %esi, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 76(%esp,%eax), %esi
; CHECK-NEXT:    movl %esi, %edi
; CHECK-NEXT:    shldl %cl, %edx, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 80(%esp,%eax), %edx
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    shldl %cl, %esi, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 84(%esp,%eax), %esi
; CHECK-NEXT:    movl %esi, %ebx
; CHECK-NEXT:    shldl %cl, %edx, %ebx
; CHECK-NEXT:    movl 88(%esp,%eax), %edi
; CHECK-NEXT:    movl %edi, %edx
; CHECK-NEXT:    shldl %cl, %esi, %edx
; CHECK-NEXT:    movl 64(%esp,%eax), %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl 92(%esp,%eax), %esi
; CHECK-NEXT:    shldl %cl, %edi, %esi
; CHECK-NEXT:    movl 8(%ebp), %eax
; CHECK-NEXT:    movl %esi, 28(%eax)
; CHECK-NEXT:    movl %edx, 24(%eax)
; CHECK-NEXT:    movl %ebx, 20(%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, 16(%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, 12(%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, 8(%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    movl %edi, %edx
; CHECK-NEXT:    shll %cl, %edx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    shldl %cl, %edi, %esi
; CHECK-NEXT:    movl %esi, 4(%eax)
; CHECK-NEXT:    movl %edx, (%eax)
; CHECK-NEXT:    leal -12(%ebp), %esp
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    popl %edi
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    retl $4
;
; CHECK-X64-O0-LABEL: shift2:
; CHECK-X64-O0:       # %bb.0:
; CHECK-X64-O0-NEXT:    movq %rdi, %rax
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $1, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O0-NEXT:    movb %sil, %cl
; CHECK-X64-O0-NEXT:    movb %cl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; CHECK-X64-O0-NEXT:    movb %cl, %dl
; CHECK-X64-O0-NEXT:    shrb $3, %dl
; CHECK-X64-O0-NEXT:    andb $24, %dl
; CHECK-X64-O0-NEXT:    negb %dl
; CHECK-X64-O0-NEXT:    movsbq %dl, %r8
; CHECK-X64-O0-NEXT:    movq -40(%rsp,%r8), %r9
; CHECK-X64-O0-NEXT:    movq -32(%rsp,%r8), %rdx
; CHECK-X64-O0-NEXT:    movq -24(%rsp,%r8), %r10
; CHECK-X64-O0-NEXT:    movq %r10, %rsi
; CHECK-X64-O0-NEXT:    shldq %cl, %rdx, %rsi
; CHECK-X64-O0-NEXT:    movb {{[-0-9]+}}(%r{{[sb]}}p), %cl # 1-byte Reload
; CHECK-X64-O0-NEXT:    movq -16(%rsp,%r8), %r8
; CHECK-X64-O0-NEXT:    shldq %cl, %r10, %r8
; CHECK-X64-O0-NEXT:    movb {{[-0-9]+}}(%r{{[sb]}}p), %cl # 1-byte Reload
; CHECK-X64-O0-NEXT:    movq %r9, %r10
; CHECK-X64-O0-NEXT:    shlq %cl, %r10
; CHECK-X64-O0-NEXT:    movb {{[-0-9]+}}(%r{{[sb]}}p), %cl # 1-byte Reload
; CHECK-X64-O0-NEXT:    movq %r10, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; CHECK-X64-O0-NEXT:    shldq %cl, %r9, %rdx
; CHECK-X64-O0-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; CHECK-X64-O0-NEXT:    movq %r8, 24(%rdi)
; CHECK-X64-O0-NEXT:    movq %rsi, 16(%rdi)
; CHECK-X64-O0-NEXT:    movq %rdx, 8(%rdi)
; CHECK-X64-O0-NEXT:    movq %rcx, (%rdi)
; CHECK-X64-O0-NEXT:    retq
;
; CHECK-X64-O2-LABEL: shift2:
; CHECK-X64-O2:       # %bb.0:
; CHECK-X64-O2-NEXT:    movq %rsi, %rcx
; CHECK-X64-O2-NEXT:    movq %rdi, %rax
; CHECK-X64-O2-NEXT:    xorps %xmm0, %xmm0
; CHECK-X64-O2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movq $1, -{{[0-9]+}}(%rsp)
; CHECK-X64-O2-NEXT:    movl %ecx, %edx
; CHECK-X64-O2-NEXT:    shrb $3, %dl
; CHECK-X64-O2-NEXT:    andb $24, %dl
; CHECK-X64-O2-NEXT:    negb %dl
; CHECK-X64-O2-NEXT:    movsbq %dl, %rdx
; CHECK-X64-O2-NEXT:    movq -40(%rsp,%rdx), %rsi
; CHECK-X64-O2-NEXT:    movq -32(%rsp,%rdx), %rdi
; CHECK-X64-O2-NEXT:    movq -24(%rsp,%rdx), %r8
; CHECK-X64-O2-NEXT:    movq %r8, %r9
; CHECK-X64-O2-NEXT:    shldq %cl, %rdi, %r9
; CHECK-X64-O2-NEXT:    movq -16(%rsp,%rdx), %rdx
; CHECK-X64-O2-NEXT:    shldq %cl, %r8, %rdx
; CHECK-X64-O2-NEXT:    movq %rsi, %r8
; CHECK-X64-O2-NEXT:    shlq %cl, %r8
; CHECK-X64-O2-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-X64-O2-NEXT:    shldq %cl, %rsi, %rdi
; CHECK-X64-O2-NEXT:    movq %rdx, 24(%rax)
; CHECK-X64-O2-NEXT:    movq %r9, 16(%rax)
; CHECK-X64-O2-NEXT:    movq %rdi, 8(%rax)
; CHECK-X64-O2-NEXT:    movq %r8, (%rax)
; CHECK-X64-O2-NEXT:    retq
{
  %b = shl i256 1, %c  ; %c must not be a constant
  ; Special case when %c is 0:
  ret i256 %b
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-X64: {{.*}}
