; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-unknown -mattr=+f16c < %s | FileCheck %s --check-prefix=ALL
; RUN: llc -mtriple=x86_64-unknown-unknown -mattr=+avx < %s | FileCheck %s --check-prefix=ALL

define zeroext i16 @test1_fast(double %d) #0 {
; ALL-LABEL: test1_fast:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    pushq %rax
; ALL-NEXT:    callq __truncdfhf2@PLT
; ALL-NEXT:    vpextrw $0, %xmm0, %eax
; ALL-NEXT:    # kill: def $ax killed $ax killed $eax
; ALL-NEXT:    popq %rcx
; ALL-NEXT:    retq
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f64(double %d)
  ret i16 %0
}

define zeroext i16 @test2_fast(x86_fp80 %d) #0 {
; ALL-LABEL: test2_fast:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    subq $24, %rsp
; ALL-NEXT:    fldt {{[0-9]+}}(%rsp)
; ALL-NEXT:    fstpt (%rsp)
; ALL-NEXT:    callq __truncxfhf2@PLT
; ALL-NEXT:    vpextrw $0, %xmm0, %eax
; ALL-NEXT:    # kill: def $ax killed $ax killed $eax
; ALL-NEXT:    addq $24, %rsp
; ALL-NEXT:    retq
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f80(x86_fp80 %d)
  ret i16 %0
}

define zeroext i16 @test1(double %d) #1 {
; ALL-LABEL: test1:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    pushq %rax
; ALL-NEXT:    callq __truncdfhf2@PLT
; ALL-NEXT:    vpextrw $0, %xmm0, %eax
; ALL-NEXT:    # kill: def $ax killed $ax killed $eax
; ALL-NEXT:    popq %rcx
; ALL-NEXT:    retq
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f64(double %d)
  ret i16 %0
}

define zeroext i16 @test2(x86_fp80 %d) #1 {
; ALL-LABEL: test2:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    subq $24, %rsp
; ALL-NEXT:    fldt {{[0-9]+}}(%rsp)
; ALL-NEXT:    fstpt (%rsp)
; ALL-NEXT:    callq __truncxfhf2@PLT
; ALL-NEXT:    vpextrw $0, %xmm0, %eax
; ALL-NEXT:    # kill: def $ax killed $ax killed $eax
; ALL-NEXT:    addq $24, %rsp
; ALL-NEXT:    retq
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f80(x86_fp80 %d)
  ret i16 %0
}

declare i16 @llvm.convert.to.fp16.f64(double)
declare i16 @llvm.convert.to.fp16.f80(x86_fp80)

attributes #0 = { nounwind readnone "unsafe-fp-math"="true" "use-soft-float"="false" }
attributes #1 = { nounwind readnone "unsafe-fp-math"="false" "use-soft-float"="false" }
