; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=knl | FileCheck %s --check-prefixes=CHECK,KNL
;RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=skx | FileCheck %s --check-prefixes=CHECK,SKX

define i32 @hadd_16(<16 x i32> %x225) {
; KNL-LABEL: hadd_16:
; KNL:       # %bb.0:
; KNL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; KNL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; KNL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    vmovd %xmm0, %eax
; KNL-NEXT:    retq
;
; SKX-LABEL: hadd_16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpsrlq $32, %xmm0, %xmm1
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vmovd %xmm0, %eax
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %x226 = shufflevector <16 x i32> %x225, <16 x i32> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x227 = add <16 x i32> %x225, %x226
  %x228 = shufflevector <16 x i32> %x227, <16 x i32> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x229 = add <16 x i32> %x227, %x228
  %x230 = extractelement <16 x i32> %x229, i32 0
  ret i32 %x230
}

define i32 @hsub_16(<16 x i32> %x225) {
; KNL-LABEL: hsub_16:
; KNL:       # %bb.0:
; KNL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; KNL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; KNL-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    vmovd %xmm0, %eax
; KNL-NEXT:    retq
;
; SKX-LABEL: hsub_16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SKX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpsrlq $32, %xmm0, %xmm1
; SKX-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vmovd %xmm0, %eax
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %x226 = shufflevector <16 x i32> %x225, <16 x i32> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x227 = add <16 x i32> %x225, %x226
  %x228 = shufflevector <16 x i32> %x227, <16 x i32> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x229 = sub <16 x i32> %x227, %x228
  %x230 = extractelement <16 x i32> %x229, i32 0
  ret i32 %x230
}

define float @fhadd_16(<16 x float> %x225) {
; KNL-LABEL: fhadd_16:
; KNL:       # %bb.0:
; KNL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; KNL-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; KNL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; KNL-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retq
;
; SKX-LABEL: fhadd_16:
; SKX:       # %bb.0:
; SKX-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SKX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %x226 = shufflevector <16 x float> %x225, <16 x float> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x227 = fadd <16 x float> %x225, %x226
  %x228 = shufflevector <16 x float> %x227, <16 x float> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x229 = fadd <16 x float> %x227, %x228
  %x230 = extractelement <16 x float> %x229, i32 0
  ret float %x230
}

define float @fhsub_16(<16 x float> %x225) {
; KNL-LABEL: fhsub_16:
; KNL:       # %bb.0:
; KNL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; KNL-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; KNL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; KNL-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retq
;
; SKX-LABEL: fhsub_16:
; SKX:       # %bb.0:
; SKX-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SKX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %x226 = shufflevector <16 x float> %x225, <16 x float> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x227 = fadd <16 x float> %x225, %x226
  %x228 = shufflevector <16 x float> %x227, <16 x float> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x229 = fsub <16 x float> %x227, %x228
  %x230 = extractelement <16 x float> %x229, i32 0
  ret float %x230
}

define <16 x i32> @hadd_16_3(<16 x i32> %x225, <16 x i32> %x227) {
; CHECK-LABEL: hadd_16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vphaddd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x226 = shufflevector <16 x i32> %x225, <16 x i32> %x227, <16 x i32> <i32 0, i32 2, i32 16, i32 18
, i32 4, i32 6, i32 20, i32 22, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x228 = shufflevector <16 x i32> %x225, <16 x i32> %x227, <16 x i32> <i32 1, i32 3, i32 17, i32 19
, i32 5 , i32 7, i32 21,   i32 23, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef,
 i32 undef, i32 undef>
  %x229 = add <16 x i32> %x226, %x228
  ret <16 x i32> %x229
}

define <16 x float> @fhadd_16_3(<16 x float> %x225, <16 x float> %x227) {
; CHECK-LABEL: fhadd_16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vhaddps %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x226 = shufflevector <16 x float> %x225, <16 x float> %x227, <16 x i32> <i32 0, i32 2, i32 16, i32 18
, i32 4, i32 6, i32 20, i32 22, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x228 = shufflevector <16 x float> %x225, <16 x float> %x227, <16 x i32> <i32 1, i32 3, i32 17, i32 19
, i32 5 , i32 7, i32 21,   i32 23, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %x229 = fadd <16 x float> %x226, %x228
  ret <16 x float> %x229
}

define <8 x double> @fhadd_16_4(<8 x double> %x225, <8 x double> %x227) {
; CHECK-LABEL: fhadd_16_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x226 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 undef, i32 undef, i32 undef, i32 undef>
  %x228 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 undef ,i32 undef, i32 undef, i32 undef>
  %x229 = fadd <8 x double> %x226, %x228
  ret <8 x double> %x229
}

define <4 x double> @fadd_noundef_low(<8 x double> %x225, <8 x double> %x227) {
; CHECK-LABEL: fadd_noundef_low:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x226 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %x228 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5 ,i32 13, i32 7, i32 15>
  %x229 = fadd <8 x double> %x226, %x228
  %x230 = shufflevector <8 x double> %x229, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %x230
}

define <4 x double> @fadd_noundef_high(<8 x double> %x225, <8 x double> %x227) {
; CHECK-LABEL: fadd_noundef_high:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm2 = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; CHECK-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; CHECK-NEXT:    vextractf64x4 $1, %zmm2, %ymm1
; CHECK-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %x226 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %x228 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5 ,i32 13, i32 7, i32 15>
  %x229 = fadd <8 x double> %x226, %x228
  %x230 = shufflevector <8 x double> %x229, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  ret <4 x double> %x230
}


define <8 x i32> @hadd_16_3_sv(<16 x i32> %x225, <16 x i32> %x227) {
; CHECK-LABEL: hadd_16_3_sv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vphaddd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x226 = shufflevector <16 x i32> %x225, <16 x i32> %x227, <16 x i32> <i32 0, i32 2, i32 16, i32 18
, i32 4, i32 6, i32 20, i32 22, i32 8, i32 10, i32 24, i32 26, i32 12, i32 14, i32 28, i32 30>
  %x228 = shufflevector <16 x i32> %x225, <16 x i32> %x227, <16 x i32> <i32 1, i32 3, i32 17, i32 19
, i32 5 , i32 7, i32 21,   i32 23, i32 9, i32 11, i32 25, i32 27, i32 13, i32 15,
 i32 29, i32 31>
  %x229 = add <16 x i32> %x226, %x228
  %x230 = shufflevector <16 x i32> %x229, <16 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4 ,i32 5, i32 6, i32 7>
  ret <8 x i32> %x230
}


define double @fadd_noundef_eel(<8 x double> %x225, <8 x double> %x227) {
; KNL-LABEL: fadd_noundef_eel:
; KNL:       # %bb.0:
; KNL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; KNL-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retq
;
; SKX-LABEL: fadd_noundef_eel:
; SKX:       # %bb.0:
; SKX-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; SKX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %x226 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %x228 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5 ,i32 13, i32 7, i32 15>
  %x229 = fadd <8 x double> %x226, %x228
  %x230 = extractelement <8 x double> %x229, i32 0
  ret double %x230
}



define double @fsub_noundef_ee (<8 x double> %x225, <8 x double> %x227) {
; KNL-LABEL: fsub_noundef_ee:
; KNL:       # %bb.0:
; KNL-NEXT:    vextractf32x4 $2, %zmm1, %xmm0
; KNL-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; KNL-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retq
;
; SKX-LABEL: fsub_noundef_ee:
; SKX:       # %bb.0:
; SKX-NEXT:    vextractf32x4 $2, %zmm1, %xmm0
; SKX-NEXT:    vshufpd {{.*#+}} xmm1 = xmm0[1,0]
; SKX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %x226 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %x228 = shufflevector <8 x double> %x225, <8 x double> %x227, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5 ,i32 13, i32 7, i32 15>
  %x229 = fsub <8 x double> %x226, %x228
  %x230 = extractelement <8 x double> %x229, i32 5
  ret double %x230
}

