; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64 --show-mc-encoding -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686 --show-mc-encoding -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X86

define dso_local <8 x i64> @test_mm512_ipcvtbf16_epi8(<32 x bfloat> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtbf16_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtbf162ibs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7f,0x48,0x69,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvtbf162ibs512(<32 x bfloat> %__A)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtbf16_epi8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtbf16_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbf162ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x69,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtbf16_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbf162ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x69,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.vcvtbf162ibs512(<32 x bfloat> %__B)
  %2 = bitcast i32 %__A to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i16> %1, <32 x i16> %0
  %4 = bitcast <32 x i16> %3 to <8 x i64>
  ret <8 x i64> %4
}

declare <32 x i16> @llvm.x86.avx10.vcvtbf162ibs512(<32 x bfloat>)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtbf16_epi8(i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtbf16_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbf162ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x69,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtbf16_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbf162ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x69,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvtbf162ibs512(<32 x bfloat> %__B)
  %1 = bitcast i32 %__A to <32 x i1>
  %2 = select <32 x i1> %1, <32 x i16> %0, <32 x i16> zeroinitializer
  %3 = bitcast <32 x i16> %2 to <8 x i64>
  ret <8 x i64> %3
}

define dso_local <8 x i64> @test_mm512_ipcvtbf16_epu8(<32 x bfloat> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtbf16_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtbf162iubs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7f,0x48,0x6b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvtbf162iubs512(<32 x bfloat> %__A)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtbf16_epu8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtbf16_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbf162iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x6b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtbf16_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbf162iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x6b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.vcvtbf162iubs512(<32 x bfloat> %__B)
  %2 = bitcast i32 %__A to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i16> %1, <32 x i16> %0
  %4 = bitcast <32 x i16> %3 to <8 x i64>
  ret <8 x i64> %4
}

declare <32 x i16> @llvm.x86.avx10.vcvtbf162iubs512(<32 x bfloat>)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtbf16_epu8(i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtbf16_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbf162iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x6b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtbf16_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbf162iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x6b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvtbf162iubs512(<32 x bfloat> %__B)
  %1 = bitcast i32 %__A to <32 x i1>
  %2 = select <32 x i1> %1, <32 x i16> %0, <32 x i16> zeroinitializer
  %3 = bitcast <32 x i16> %2 to <8 x i64>
  ret <8 x i64> %3
}

define dso_local <8 x i64> @test_mm512_ipcvtph_epi8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtph_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtph2ibs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x48,0x69,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtph_epi8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x69,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x69,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 4)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half>, <32 x i16>, i32, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtph_epi8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x69,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x69,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvt_roundph_epi8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvt_roundph_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtph2ibs {rz-sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x78,0x69,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 11)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvt_roundph_epi8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvt_roundph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2ibs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x79,0x69,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvt_roundph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2ibs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x79,0x69,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 11)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvt_roundph_epi8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvt_roundph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2ibs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xf9,0x69,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvt_roundph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2ibs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xf9,0x69,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2ibs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 11)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtph_epu8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtph_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtph2iubs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x48,0x6b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtph_epu8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x6b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x6b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512( <32 x half> %__B, <32 x i16> %0, i32 %__A, i32 4)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvtph_epu8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x6b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x6b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvt_roundph_epu8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvt_roundph_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtph2iubs {rz-sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x78,0x6b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 11)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvt_roundph_epu8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvt_roundph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2iubs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x79,0x6b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvt_roundph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2iubs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x79,0x6b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 11)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512(<32 x half>, <32 x i16>, i32, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvt_roundph_epu8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvt_roundph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2iubs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xf9,0x6b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvt_roundph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2iubs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xf9,0x6b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvtph2iubs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 11)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtps_epi8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtps_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2ibs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x69,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtps_epi8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x69,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x69,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 4)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float>, <16 x i32>, i16, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtps_epi8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x69,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x69,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvt_roundps_epi8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvt_roundps_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2ibs {rz-sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x78,0x69,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 11)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvt_roundps_epi8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvt_roundps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2ibs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x79,0x69,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvt_roundps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2ibs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x79,0x69,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 11)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvt_roundps_epi8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvt_roundps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2ibs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xf9,0x69,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvt_roundps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2ibs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xf9,0x69,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2ibs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 11)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtps_epu8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtps_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2iubs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x6b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtps_epu8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x6b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x6b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 4)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvtps_epu8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x6b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x6b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvt_roundps_epu8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvt_roundps_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2iubs {rz-sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x78,0x6b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 11)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvt_roundps_epu8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvt_roundps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2iubs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x79,0x6b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvt_roundps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2iubs {rz-sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x79,0x6b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 11)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float>, <16 x i32>, i16, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvt_roundps_epu8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvt_roundps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2iubs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xf9,0x6b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvt_roundps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2iubs {rz-sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xf9,0x6b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvtps2iubs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 11)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvttbf16_epi8(<32 x bfloat> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvttbf16_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttbf162ibs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7f,0x48,0x68,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvttbf162ibs512(<32 x bfloat> %__A)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvttbf16_epi8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvttbf16_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttbf162ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x68,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvttbf16_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttbf162ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x68,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.vcvttbf162ibs512(<32 x bfloat> %__B)
  %2 = bitcast i32 %__A to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i16> %1, <32 x i16> %0
  %4 = bitcast <32 x i16> %3 to <8 x i64>
  ret <8 x i64> %4
}

declare <32 x i16> @llvm.x86.avx10.vcvttbf162ibs512(<32 x bfloat>)

define dso_local <8 x i64> @test_mm512_maskz_ipcvttbf16_epi8(i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvttbf16_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttbf162ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x68,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvttbf16_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttbf162ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x68,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvttbf162ibs512(<32 x bfloat> %__B)
  %1 = bitcast i32 %__A to <32 x i1>
  %2 = select <32 x i1> %1, <32 x i16> %0, <32 x i16> zeroinitializer
  %3 = bitcast <32 x i16> %2 to <8 x i64>
  ret <8 x i64> %3
}

define dso_local <8 x i64> @test_mm512_ipcvttbf16_epu8(<32 x bfloat> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvttbf16_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttbf162iubs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7f,0x48,0x6a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvttbf162iubs512(<32 x bfloat> %__A)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvttbf16_epu8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvttbf16_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttbf162iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x6a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvttbf16_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttbf162iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x6a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.vcvttbf162iubs512(<32 x bfloat> %__B)
  %2 = bitcast i32 %__A to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i16> %1, <32 x i16> %0
  %4 = bitcast <32 x i16> %3 to <8 x i64>
  ret <8 x i64> %4
}

declare <32 x i16> @llvm.x86.avx10.vcvttbf162iubs512(<32 x bfloat>)

define dso_local <8 x i64> @test_mm512_maskz_ipcvttbf16_epu8(i32 noundef %__A, <32 x bfloat> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvttbf16_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttbf162iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x6a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvttbf16_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttbf162iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x6a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vcvttbf162iubs512(<32 x bfloat> %__B)
  %1 = bitcast i32 %__A to <32 x i1>
  %2 = select <32 x i1> %1, <32 x i16> %0, <32 x i16> zeroinitializer
  %3 = bitcast <32 x i16> %2 to <8 x i64>
  ret <8 x i64> %3
}

define dso_local <8 x i64> @test_mm512_ipcvttph_epi8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvttph_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttph2ibs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x48,0x68,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvttph_epi8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvttph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x68,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvttph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x68,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 4)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvttph_epi8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvttph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x68,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvttph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x68,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtt_roundph_epi8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtt_roundph_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttph2ibs {sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x18,0x68,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 8)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtt_roundph_epi8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtt_roundph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2ibs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x19,0x68,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtt_roundph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2ibs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x19,0x68,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 8)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half>, <32 x i16>, i32, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtt_roundph_epi8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtt_roundph_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2ibs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x99,0x68,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtt_roundph_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2ibs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x99,0x68,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2ibs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 8)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvttph_epu8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvttph_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttph2iubs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x48,0x6a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvttph_epu8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvttph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x6a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvttph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x49,0x6a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 4)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvttph_epu8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvttph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x6a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvttph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xc9,0x6a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 4)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtt_roundph_epu8(<32 x half> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtt_roundph_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttph2iubs {sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7c,0x18,0x6a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half> %__A, <32 x i16> zeroinitializer, i32 -1, i32 8)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtt_roundph_epu8(<8 x i64> noundef %__S, i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtt_roundph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2iubs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x19,0x6a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtt_roundph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2iubs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7c,0x19,0x6a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <32 x i16>
  %1 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half> %__B, <32 x i16> %0, i32 %__A, i32 8)
  %2 = bitcast <32 x i16> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half>, <32 x i16>, i32, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtt_roundph_epu8(i32 noundef %__A, <32 x half> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtt_roundph_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2iubs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x99,0x6a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtt_roundph_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2iubs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x99,0x6a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.mask.vcvttph2iubs512(<32 x half> %__B, <32 x i16> zeroinitializer, i32 %__A, i32 8)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvttps_epi8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvttps_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttps2ibs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x68,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvttps_epi8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvttps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x68,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvttps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2ibs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x68,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 4)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvttps_epi8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvttps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x68,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvttps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2ibs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x68,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtt_roundps_epi8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtt_roundps_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttps2ibs {sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x18,0x68,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 8)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtt_roundps_epi8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtt_roundps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2ibs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x19,0x68,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtt_roundps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2ibs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x19,0x68,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 8)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float>, <16 x i32>, i16, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtt_roundps_epi8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtt_roundps_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2ibs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x99,0x68,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtt_roundps_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2ibs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x99,0x68,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2ibs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 8)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvttps_epu8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvttps_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttps2iubs %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x6a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvttps_epu8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvttps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x6a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvttps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2iubs %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x6a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 4)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

define dso_local <8 x i64> @test_mm512_maskz_ipcvttps_epu8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvttps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x6a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvttps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2iubs %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x6a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 4)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_ipcvtt_roundps_epu8(<16 x float> noundef %__A) {
; CHECK-LABEL: test_mm512_ipcvtt_roundps_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvttps2iubs {sae}, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x18,0x6a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float> %__A, <16 x i32> zeroinitializer, i16 -1, i32 8)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define dso_local <8 x i64> @test_mm512_mask_ipcvtt_roundps_epu8(<8 x i64> noundef %__S, i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_mask_ipcvtt_roundps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2iubs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x19,0x6a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_ipcvtt_roundps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2iubs {sae}, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x19,0x6a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = bitcast <8 x i64> %__S to <16 x i32>
  %1 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float> %__B, <16 x i32> %0, i16 %__A, i32 8)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

declare <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float>, <16 x i32>, i16, i32)

define dso_local <8 x i64> @test_mm512_maskz_ipcvtt_roundps_epu8(i16 noundef zeroext %__A, <16 x float> noundef %__B) {
; X64-LABEL: test_mm512_maskz_ipcvtt_roundps_epu8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2iubs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x99,0x6a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_ipcvtt_roundps_epu8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2iubs {sae}, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x99,0x6a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.mask.vcvttps2iubs512(<16 x float> %__B, <16 x i32> zeroinitializer, i16 %__A, i32 8)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}
