; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+f,+d -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+f,+d -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64

define <1 x i64> @llrint_v1i64_v1f32(<1 x float> %x, <1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v1i64_v1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v9, v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v1i64_v1f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v9, v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %a = call <1 x i64> @llvm.vp.llrint.v1i64.v1f32(<1 x float> %x, <1 x i1> %m, i32 %evl)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.vp.llrint.v1i64.v1f32(<1 x float>, <1 x i1>, i32)

define <2 x i64> @llrint_v2i64_v2f32(<2 x float> %x, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v2i64_v2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vfwcvt.x.f.v v9, v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v2i64_v2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vfwcvt.x.f.v v9, v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %a = call <2 x i64> @llvm.vp.llrint.v2i64.v2f32(<2 x float> %x, <2 x i1> %m, i32 %evl)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.vp.llrint.v2i64.v2f32(<2 x float>, <2 x i1>, i32)

define <3 x i64> @llrint_v3i64_v3f32(<3 x float> %x, <3 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v3i64_v3f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vmv1r.v v10, v8
; RV32-NEXT:    vfwcvt.x.f.v v8, v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v3i64_v3f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vmv1r.v v10, v8
; RV64-NEXT:    vfwcvt.x.f.v v8, v10, v0.t
; RV64-NEXT:    ret
  %a = call <3 x i64> @llvm.vp.llrint.v3i64.v3f32(<3 x float> %x, <3 x i1> %m, i32 %evl)
  ret <3 x i64> %a
}
declare <3 x i64> @llvm.vp.llrint.v3i64.v3f32(<3 x float>, <3 x i1>, i32)

define <4 x i64> @llrint_v4i64_v4f32(<4 x float> %x, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v4i64_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vmv1r.v v10, v8
; RV32-NEXT:    vfwcvt.x.f.v v8, v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v4i64_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vmv1r.v v10, v8
; RV64-NEXT:    vfwcvt.x.f.v v8, v10, v0.t
; RV64-NEXT:    ret
  %a = call <4 x i64> @llvm.vp.llrint.v4i64.v4f32(<4 x float> %x, <4 x i1> %m, i32 %evl)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.vp.llrint.v4i64.v4f32(<4 x float>, <4 x i1>, i32)

define <8 x i64> @llrint_v8i64_v8f32(<8 x float> %x, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v8i64_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV32-NEXT:    vmv2r.v v12, v8
; RV32-NEXT:    vfwcvt.x.f.v v8, v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v8i64_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV64-NEXT:    vmv2r.v v12, v8
; RV64-NEXT:    vfwcvt.x.f.v v8, v12, v0.t
; RV64-NEXT:    ret
  %a = call <8 x i64> @llvm.vp.llrint.v8i64.v8f32(<8 x float> %x, <8 x i1> %m, i32 %evl)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.vp.llrint.v8i64.v8f32(<8 x float>, <8 x i1>, i32)

define <16 x i64> @llrint_v16i64_v16f32(<16 x float> %x, <16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v16i64_v16f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; RV32-NEXT:    vmv4r.v v16, v8
; RV32-NEXT:    vfwcvt.x.f.v v8, v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v16i64_v16f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; RV64-NEXT:    vmv4r.v v16, v8
; RV64-NEXT:    vfwcvt.x.f.v v8, v16, v0.t
; RV64-NEXT:    ret
  %a = call <16 x i64> @llvm.vp.llrint.v16i64.v16f32(<16 x float> %x, <16 x i1> %m, i32 %evl)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.vp.llrint.v16i64.v16f32(<16 x float>, <16 x i1>, i32)

define <1 x i64> @llrint_v1i64_v1f64(<1 x double> %x, <1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v1i64_v1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v1i64_v1f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV64-NEXT:    ret
  %a = call <1 x i64> @llvm.vp.llrint.v1i64.v1f64(<1 x double> %x, <1 x i1> %m, i32 %evl)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.vp.llrint.v1i64.v1f64(<1 x double>, <1 x i1>, i32)

define <2 x i64> @llrint_v2i64_v2f64(<2 x double> %x, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v2i64_v2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v2i64_v2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV64-NEXT:    ret
  %a = call <2 x i64> @llvm.vp.llrint.v2i64.v2f64(<2 x double> %x, <2 x i1> %m, i32 %evl)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.vp.llrint.v2i64.v2f64(<2 x double>, <2 x i1>, i32)

define <4 x i64> @llrint_v4i64_v4f64(<4 x double> %x, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v4i64_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v4i64_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV64-NEXT:    ret
  %a = call <4 x i64> @llvm.vp.llrint.v4i64.v4f64(<4 x double> %x, <4 x i1> %m, i32 %evl)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.vp.llrint.v4i64.v4f64(<4 x double>, <4 x i1>, i32)

define <8 x i64> @llrint_v8i64_v8f64(<8 x double> %x, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: llrint_v8i64_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: llrint_v8i64_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vfcvt.x.f.v v8, v8, v0.t
; RV64-NEXT:    ret
  %a = call <8 x i64> @llvm.vp.llrint.v8i64.v8f64(<8 x double> %x, <8 x i1> %m, i32 %evl)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.vp.llrint.v8i64.v8f64(<8 x double>, <8 x i1>, i32)
