; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+d -verify-machineinstrs < %s | FileCheck %s

; Negative test
define void @single_fdiv(double %a0, double %a1, ptr %res) {
; CHECK-LABEL: single_fdiv:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fdiv.d fa5, fa1, fa0
; CHECK-NEXT:    fsd fa5, 0(a0)
; CHECK-NEXT:    ret
entry:
  %div = fdiv arcp double %a1, %a0
  store double %div, ptr %res
  ret void
}

define void @two_fdivs(double %a0, double %a1, double %a2, ptr %res) {
; CHECK-LABEL: two_fdivs:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lui a1, %hi(.LCPI1_0)
; CHECK-NEXT:    fld fa5, %lo(.LCPI1_0)(a1)
; CHECK-NEXT:    fdiv.d fa5, fa5, fa0
; CHECK-NEXT:    fmul.d fa4, fa1, fa5
; CHECK-NEXT:    fmul.d fa5, fa2, fa5
; CHECK-NEXT:    fsd fa4, 0(a0)
; CHECK-NEXT:    fsd fa5, 8(a0)
; CHECK-NEXT:    ret
entry:
  %div = fdiv arcp double %a1, %a0
  %div1 = fdiv arcp double %a2, %a0
  store double %div, ptr %res
  %arrayidx2 = getelementptr inbounds double, ptr %res, i64 1
  store double %div1, ptr %arrayidx2
  ret void
}

; Negative test
define void @no_arcp(double %a0, double %a1, double %a2, ptr %res) {
; CHECK-LABEL: no_arcp:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fdiv.d fa5, fa1, fa0
; CHECK-NEXT:    fdiv.d fa4, fa2, fa0
; CHECK-NEXT:    fsd fa5, 0(a0)
; CHECK-NEXT:    fsd fa4, 8(a0)
; CHECK-NEXT:    ret
entry:
  %div = fdiv arcp double %a1, %a0
  %div1 = fdiv double %a2, %a0
  store double %div, ptr %res
  %arrayidx2 = getelementptr inbounds double, ptr %res, i64 1
  store double %div1, ptr %arrayidx2
  ret void
}
