; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define <16 x i8> @shuffle_to_vslli_h_8(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_h_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.h $vr0, $vr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 0, i32 16, i32 2, i32 16, i32 4, i32 16, i32 6, i32 16, i32 8, i32 16, i32 10, i32 16, i32 12, i32 16, i32 14>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_h_8(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_h_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.h $vr0, $vr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 1, i32 16, i32 3, i32 16, i32 5, i32 16, i32 7, i32 16, i32 9, i32 16, i32 11, i32 16, i32 13, i32 16, i32 15, i32 16>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vslli_w_8(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_w_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.w $vr0, $vr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 0, i32 1, i32 2, i32 16, i32 4, i32 5, i32 6, i32 16, i32 8, i32 9, i32 10, i32 16, i32 12, i32 13, i32 14>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_w_8(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_w_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.w $vr0, $vr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 1, i32 2, i32 3, i32 16, i32 5, i32 6, i32 7, i32 16, i32 9, i32 10, i32 11, i32 16, i32 13, i32 14, i32 15, i32 16>
  ret <16 x i8> %shuffle
}

define <8 x i16> @shuffle_to_vslli_w_16(<8 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_w_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.w $vr0, $vr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32><i32 8, i32 0, i32 8, i32 2, i32 8, i32 4, i32 8, i32 6>
  ret <8 x i16> %shuffle
}

define <8 x i16> @shuffle_to_vsrli_w_16(<8 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_w_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.w $vr0, $vr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32><i32 1, i32 8, i32 3, i32 8, i32 5, i32 8, i32 7, i32 8>
  ret <8 x i16> %shuffle
}

define <16 x i8> @shuffle_to_vslli_w_24(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_w_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.w $vr0, $vr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 16, i32 16, i32 0, i32 16, i32 16, i32 16, i32 4, i32 16, i32 16, i32 16, i32 8, i32 16, i32 16, i32 16, i32 12>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_w_24(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_w_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.w $vr0, $vr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 3, i32 16, i32 16, i32 16, i32 7, i32 16, i32 16, i32 16, i32 11, i32 16, i32 16, i32 16, i32 15, i32 16, i32 16, i32 16>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vslli_d_8(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 16, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_d_8(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16>
  ret <16 x i8> %shuffle
}

define <8 x i16> @shuffle_to_vslli_d_16(<8 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32><i32 8, i32 0, i32 1, i32 2, i32 8, i32 4, i32 5, i32 6>
  ret <8 x i16> %shuffle
}

define <8 x i16> @shuffle_to_vsrli_d_16(<8 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32><i32 1, i32 2, i32 3, i32 8, i32 5, i32 6, i32 7, i32 8>
  ret <8 x i16> %shuffle
}

define <16 x i8> @shuffle_to_vslli_d_24(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 16, i32 16, i32 0, i32 1, i32 2, i32 3, i32 4, i32 16, i32 16, i32 16, i32 8, i32 9, i32 10, i32 11, i32 12>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_d_24(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 16, i32 16, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 16, i32 16>
  ret <16 x i8> %shuffle
}

define <4 x i32> @shuffle_to_vslli_d_32(<4 x i32> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 32
; CHECK-NEXT:    ret
  %shuffle = shufflevector <4 x i32> %a, <4 x i32> zeroinitializer, <4 x i32> <i32 4, i32 0, i32 4, i32 poison>
  ret <4 x i32> %shuffle
}

define <4 x i32> @shuffle_to_vsrli_d_32(<4 x i32> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 32
; CHECK-NEXT:    ret
  %shuffle = shufflevector <4 x i32> %a, <4 x i32> zeroinitializer, <4 x i32> <i32 1, i32 4, i32 3, i32 4>
  ret <4 x i32> %shuffle
}

define <16 x i8> @shuffle_to_vslli_d_40(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_40:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 40
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 16, i32 16, i32 16, i32 16, i32 0, i32 1, i32 2, i32 16, i32 16, i32 16, i32 16, i32 16, i32 8, i32 9, i32 10>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_d_40(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_40:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 40
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 5, i32 6, i32 7, i32 16, i32 16, i32 16, i32 16, i32 16, i32 13, i32 14, i32 15, i32 16, i32 16, i32 16, i32 16, i32 16>
  ret <16 x i8> %shuffle
}

define <8 x i16> @shuffle_to_vslli_d_48(<8 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_48:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 48
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32><i32 8, i32 8, i32 8, i32 0, i32 8, i32 8, i32 8, i32 4>
  ret <8 x i16> %shuffle
}

define <8 x i16> @shuffle_to_vsrli_d_48(<8 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_48:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 48
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32><i32 3, i32 8, i32 8, i32 8, i32 7, i32 8, i32 8, i32 8>
  ret <8 x i16> %shuffle
}

define <16 x i8> @shuffle_to_vslli_d_56(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vslli_d_56:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslli.d $vr0, $vr0, 56
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 0, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 8>
  ret <16 x i8> %shuffle
}

define <16 x i8> @shuffle_to_vsrli_d_56(<16 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_vsrli_d_56:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrli.d $vr0, $vr0, 56
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32><i32 7, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 15, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16>
  ret <16 x i8> %shuffle
}
