; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

;; Exercise the 'mul' LLVM IR: https://llvm.org/docs/LangRef.html#mul-instruction

define i1 @mul_i1(i1 %a, i1 %b) {
; LA32R-LABEL: mul_i1:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i1:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    and $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    ret
entry:
  %r = mul i1 %a, %b
  ret i1 %r
}

define i8 @mul_i8(i8 %a, i8 %b) {
; LA32R-LABEL: mul_i8:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i8:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mul.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    ret
entry:
  %r = mul i8 %a, %b
  ret i8 %r
}

define i16 @mul_i16(i16 %a, i16 %b) {
; LA32R-LABEL: mul_i16:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i16:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mul.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    ret
entry:
  %r = mul i16 %a, %b
  ret i16 %r
}

define i32 @mul_i32(i32 %a, i32 %b) {
; LA32R-LABEL: mul_i32:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mul.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    ret
entry:
  %r = mul i32 %a, %b
  ret i32 %r
}

define i64 @mul_i64(i64 %a, i64 %b) {
; LA32R-LABEL: mul_i64:
; LA32R:       # %bb.0: # %entry
; LA32R-NEXT:    mul.w $a3, $a0, $a3
; LA32R-NEXT:    mulh.wu $a4, $a0, $a2
; LA32R-NEXT:    add.w $a3, $a4, $a3
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64:
; LA32S:       # %bb.0: # %entry
; LA32S-NEXT:    mul.w $a3, $a0, $a3
; LA32S-NEXT:    mulh.wu $a4, $a0, $a2
; LA32S-NEXT:    add.w $a3, $a4, $a3
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    ret
entry:
  %r = mul i64 %a, %b
  ret i64 %r
}

define i64 @mul_pow2(i64 %a) {
; LA32R-LABEL: mul_pow2:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srli.w $a2, $a0, 29
; LA32R-NEXT:    slli.w $a1, $a1, 3
; LA32R-NEXT:    or $a1, $a1, $a2
; LA32R-NEXT:    slli.w $a0, $a0, 3
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_pow2:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srli.w $a2, $a0, 29
; LA32S-NEXT:    slli.w $a1, $a1, 3
; LA32S-NEXT:    or $a1, $a1, $a2
; LA32S-NEXT:    slli.w $a0, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_pow2:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a0, $a0, 3
; LA64-NEXT:    ret
  %1 = mul i64 %a, 8
  ret i64 %1
}

define i64 @mul_p5(i64 %a) {
; LA32R-LABEL: mul_p5:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 5
; LA32R-NEXT:    mulh.wu $a2, $a0, $a2
; LA32R-NEXT:    slli.w $a3, $a1, 2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    add.w $a1, $a2, $a1
; LA32R-NEXT:    slli.w $a2, $a0, 2
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_p5:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 5
; LA32S-NEXT:    mulh.wu $a2, $a0, $a2
; LA32S-NEXT:    alsl.w $a1, $a1, $a1, 2
; LA32S-NEXT:    add.w $a1, $a2, $a1
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_p5:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 2
; LA64-NEXT:    ret
  %1 = mul i64 %a, 5
  ret i64 %1
}

define i32 @mulh_w(i32 %a, i32 %b) {
; LA32R-LABEL: mulh_w:
; LA32R:       # %bb.0:
; LA32R-NEXT:    mulh.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mulh_w:
; LA32S:       # %bb.0:
; LA32S-NEXT:    mulh.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mulh_w:
; LA64:       # %bb.0:
; LA64-NEXT:    mulw.d.w $a0, $a0, $a1
; LA64-NEXT:    srli.d $a0, $a0, 32
; LA64-NEXT:    ret
  %1 = sext i32 %a to i64
  %2 = sext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}

define i32 @mulh_wu(i32 %a, i32 %b) {
; LA32R-LABEL: mulh_wu:
; LA32R:       # %bb.0:
; LA32R-NEXT:    mulh.wu $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mulh_wu:
; LA32S:       # %bb.0:
; LA32S-NEXT:    mulh.wu $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mulh_wu:
; LA64:       # %bb.0:
; LA64-NEXT:    mulw.d.wu $a0, $a0, $a1
; LA64-NEXT:    srli.d $a0, $a0, 32
; LA64-NEXT:    ret
  %1 = zext i32 %a to i64
  %2 = zext i32 %b to i64
  %3 = mul i64 %1, %2
  %4 = lshr i64 %3, 32
  %5 = trunc i64 %4 to i32
  ret i32 %5
}

define i64 @mulh_d(i64 %a, i64 %b) {
; LA32R-LABEL: mulh_d:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srai.w $a5, $a1, 31
; LA32R-NEXT:    srai.w $a6, $a3, 31
; LA32R-NEXT:    mulh.wu $a4, $a0, $a2
; LA32R-NEXT:    mul.w $a7, $a1, $a2
; LA32R-NEXT:    add.w $a4, $a7, $a4
; LA32R-NEXT:    sltu $a7, $a4, $a7
; LA32R-NEXT:    mulh.wu $t0, $a1, $a2
; LA32R-NEXT:    add.w $a7, $t0, $a7
; LA32R-NEXT:    mul.w $t0, $a0, $a3
; LA32R-NEXT:    add.w $a4, $t0, $a4
; LA32R-NEXT:    sltu $a4, $a4, $t0
; LA32R-NEXT:    mulh.wu $t0, $a0, $a3
; LA32R-NEXT:    add.w $a4, $t0, $a4
; LA32R-NEXT:    add.w $t0, $a7, $a4
; LA32R-NEXT:    mul.w $t1, $a1, $a3
; LA32R-NEXT:    add.w $t2, $t1, $t0
; LA32R-NEXT:    mul.w $t3, $a2, $a5
; LA32R-NEXT:    mul.w $t4, $a6, $a0
; LA32R-NEXT:    add.w $t5, $t4, $t3
; LA32R-NEXT:    add.w $a4, $t2, $t5
; LA32R-NEXT:    sltu $t6, $a4, $t2
; LA32R-NEXT:    sltu $t1, $t2, $t1
; LA32R-NEXT:    sltu $a7, $t0, $a7
; LA32R-NEXT:    mulh.wu $t0, $a1, $a3
; LA32R-NEXT:    add.w $a7, $t0, $a7
; LA32R-NEXT:    add.w $a7, $a7, $t1
; LA32R-NEXT:    mulh.wu $a2, $a2, $a5
; LA32R-NEXT:    add.w $a2, $a2, $t3
; LA32R-NEXT:    mul.w $a3, $a3, $a5
; LA32R-NEXT:    add.w $a2, $a2, $a3
; LA32R-NEXT:    mul.w $a1, $a6, $a1
; LA32R-NEXT:    mulh.wu $a0, $a6, $a0
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a0, $t4
; LA32R-NEXT:    add.w $a0, $a0, $a2
; LA32R-NEXT:    sltu $a1, $t5, $t4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a7, $a0
; LA32R-NEXT:    add.w $a1, $a0, $t6
; LA32R-NEXT:    move $a0, $a4
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mulh_d:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srai.w $a5, $a1, 31
; LA32S-NEXT:    srai.w $a6, $a3, 31
; LA32S-NEXT:    mulh.wu $a4, $a0, $a2
; LA32S-NEXT:    mul.w $a7, $a1, $a2
; LA32S-NEXT:    add.w $a4, $a7, $a4
; LA32S-NEXT:    sltu $a7, $a4, $a7
; LA32S-NEXT:    mulh.wu $t0, $a1, $a2
; LA32S-NEXT:    add.w $a7, $t0, $a7
; LA32S-NEXT:    mul.w $t0, $a0, $a3
; LA32S-NEXT:    add.w $a4, $t0, $a4
; LA32S-NEXT:    sltu $a4, $a4, $t0
; LA32S-NEXT:    mulh.wu $t0, $a0, $a3
; LA32S-NEXT:    add.w $a4, $t0, $a4
; LA32S-NEXT:    add.w $t0, $a7, $a4
; LA32S-NEXT:    mul.w $t1, $a1, $a3
; LA32S-NEXT:    add.w $t2, $t1, $t0
; LA32S-NEXT:    mul.w $t3, $a2, $a5
; LA32S-NEXT:    mul.w $t4, $a6, $a0
; LA32S-NEXT:    add.w $t5, $t4, $t3
; LA32S-NEXT:    add.w $a4, $t2, $t5
; LA32S-NEXT:    sltu $t6, $a4, $t2
; LA32S-NEXT:    sltu $t1, $t2, $t1
; LA32S-NEXT:    sltu $a7, $t0, $a7
; LA32S-NEXT:    mulh.wu $t0, $a1, $a3
; LA32S-NEXT:    add.w $a7, $t0, $a7
; LA32S-NEXT:    add.w $a7, $a7, $t1
; LA32S-NEXT:    mulh.wu $a2, $a2, $a5
; LA32S-NEXT:    add.w $a2, $a2, $t3
; LA32S-NEXT:    mul.w $a3, $a3, $a5
; LA32S-NEXT:    add.w $a2, $a2, $a3
; LA32S-NEXT:    mul.w $a1, $a6, $a1
; LA32S-NEXT:    mulh.wu $a0, $a6, $a0
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    add.w $a0, $a0, $t4
; LA32S-NEXT:    add.w $a0, $a0, $a2
; LA32S-NEXT:    sltu $a1, $t5, $t4
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    add.w $a0, $a7, $a0
; LA32S-NEXT:    add.w $a1, $a0, $t6
; LA32S-NEXT:    move $a0, $a4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mulh_d:
; LA64:       # %bb.0:
; LA64-NEXT:    mulh.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %1 = sext i64 %a to i128
  %2 = sext i64 %b to i128
  %3 = mul i128 %1, %2
  %4 = lshr i128 %3, 64
  %5 = trunc i128 %4 to i64
  ret i64 %5
}

define i64 @mulh_du(i64 %a, i64 %b) {
; LA32R-LABEL: mulh_du:
; LA32R:       # %bb.0:
; LA32R-NEXT:    mulh.wu $a4, $a0, $a2
; LA32R-NEXT:    mul.w $a5, $a1, $a2
; LA32R-NEXT:    add.w $a4, $a5, $a4
; LA32R-NEXT:    sltu $a5, $a4, $a5
; LA32R-NEXT:    mulh.wu $a2, $a1, $a2
; LA32R-NEXT:    add.w $a2, $a2, $a5
; LA32R-NEXT:    mul.w $a5, $a0, $a3
; LA32R-NEXT:    add.w $a4, $a5, $a4
; LA32R-NEXT:    sltu $a4, $a4, $a5
; LA32R-NEXT:    mulh.wu $a0, $a0, $a3
; LA32R-NEXT:    add.w $a0, $a0, $a4
; LA32R-NEXT:    add.w $a4, $a2, $a0
; LA32R-NEXT:    mul.w $a5, $a1, $a3
; LA32R-NEXT:    add.w $a0, $a5, $a4
; LA32R-NEXT:    sltu $a5, $a0, $a5
; LA32R-NEXT:    sltu $a2, $a4, $a2
; LA32R-NEXT:    mulh.wu $a1, $a1, $a3
; LA32R-NEXT:    add.w $a1, $a1, $a2
; LA32R-NEXT:    add.w $a1, $a1, $a5
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mulh_du:
; LA32S:       # %bb.0:
; LA32S-NEXT:    mulh.wu $a4, $a0, $a2
; LA32S-NEXT:    mul.w $a5, $a1, $a2
; LA32S-NEXT:    add.w $a4, $a5, $a4
; LA32S-NEXT:    sltu $a5, $a4, $a5
; LA32S-NEXT:    mulh.wu $a2, $a1, $a2
; LA32S-NEXT:    add.w $a2, $a2, $a5
; LA32S-NEXT:    mul.w $a5, $a0, $a3
; LA32S-NEXT:    add.w $a4, $a5, $a4
; LA32S-NEXT:    sltu $a4, $a4, $a5
; LA32S-NEXT:    mulh.wu $a0, $a0, $a3
; LA32S-NEXT:    add.w $a0, $a0, $a4
; LA32S-NEXT:    add.w $a4, $a2, $a0
; LA32S-NEXT:    mul.w $a5, $a1, $a3
; LA32S-NEXT:    add.w $a0, $a5, $a4
; LA32S-NEXT:    sltu $a5, $a0, $a5
; LA32S-NEXT:    sltu $a2, $a4, $a2
; LA32S-NEXT:    mulh.wu $a1, $a1, $a3
; LA32S-NEXT:    add.w $a1, $a1, $a2
; LA32S-NEXT:    add.w $a1, $a1, $a5
; LA32S-NEXT:    ret
;
; LA64-LABEL: mulh_du:
; LA64:       # %bb.0:
; LA64-NEXT:    mulh.du $a0, $a0, $a1
; LA64-NEXT:    ret
  %1 = zext i64 %a to i128
  %2 = zext i64 %b to i128
  %3 = mul i128 %1, %2
  %4 = lshr i128 %3, 64
  %5 = trunc i128 %4 to i64
  ret i64 %5
}

define i64 @mulw_d_w(i32 %a, i32 %b) {
; LA32R-LABEL: mulw_d_w:
; LA32R:       # %bb.0:
; LA32R-NEXT:    mul.w $a2, $a0, $a1
; LA32R-NEXT:    mulh.w $a1, $a0, $a1
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mulw_d_w:
; LA32S:       # %bb.0:
; LA32S-NEXT:    mul.w $a2, $a0, $a1
; LA32S-NEXT:    mulh.w $a1, $a0, $a1
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mulw_d_w:
; LA64:       # %bb.0:
; LA64-NEXT:    mulw.d.w $a0, $a0, $a1
; LA64-NEXT:    ret
  %1 = sext i32 %a to i64
  %2 = sext i32 %b to i64
  %3 = mul i64 %1, %2
  ret i64 %3
}

define i64 @mulw_d_wu(i32 %a, i32 %b) {
; LA32R-LABEL: mulw_d_wu:
; LA32R:       # %bb.0:
; LA32R-NEXT:    mul.w $a2, $a0, $a1
; LA32R-NEXT:    mulh.wu $a1, $a0, $a1
; LA32R-NEXT:    move $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mulw_d_wu:
; LA32S:       # %bb.0:
; LA32S-NEXT:    mul.w $a2, $a0, $a1
; LA32S-NEXT:    mulh.wu $a1, $a0, $a1
; LA32S-NEXT:    move $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mulw_d_wu:
; LA64:       # %bb.0:
; LA64-NEXT:    mulw.d.wu $a0, $a0, $a1
; LA64-NEXT:    ret
  %1 = zext i32 %a to i64
  %2 = zext i32 %b to i64
  %3 = mul i64 %1, %2
  ret i64 %3
}

define signext i32 @mul_i32_11(i32 %a) {
; LA32R-LABEL: mul_i32_11:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 11
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_11:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_11:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 1
; LA64-NEXT:    ret
  %b = mul i32 %a, 11
  ret i32 %b
}

define signext i32 @mul_i32_13(i32 %a) {
; LA32R-LABEL: mul_i32_13:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 13
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_13:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 1
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_13:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 1
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i32 %a, 13
  ret i32 %b
}

define signext i32 @mul_i32_19(i32 %a) {
; LA32R-LABEL: mul_i32_19:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 19
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_19:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_19:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 1
; LA64-NEXT:    ret
  %b = mul i32 %a, 19
  ret i32 %b
}

define signext i32 @mul_i32_21(i32 %a) {
; LA32R-LABEL: mul_i32_21:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 21
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_21:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_21:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i32 %a, 21
  ret i32 %b
}

define signext i32 @mul_i32_25(i32 %a) {
; LA32R-LABEL: mul_i32_25:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 25
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_25:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 1
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_25:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 1
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 25
  ret i32 %b
}

define signext i32 @mul_i32_27(i32 %a) {
; LA32R-LABEL: mul_i32_27:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 27
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_27:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 1
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_27:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 1
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 27
  ret i32 %b
}

define signext i32 @mul_i32_35(i32 %a) {
; LA32R-LABEL: mul_i32_35:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 35
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_35:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_35:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 1
; LA64-NEXT:    ret
  %b = mul i32 %a, 35
  ret i32 %b
}

define signext i32 @mul_i32_37(i32 %a) {
; LA32R-LABEL: mul_i32_37:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 37
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_37:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_37:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i32 %a, 37
  ret i32 %b
}

define signext i32 @mul_i32_41(i32 %a) {
; LA32R-LABEL: mul_i32_41:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 41
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_41:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_41:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 41
  ret i32 %b
}

define signext i32 @mul_i32_45(i32 %a) {
; LA32R-LABEL: mul_i32_45:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 45
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_45:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_45:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 45
  ret i32 %b
}

define signext i32 @mul_i32_49(i32 %a) {
; LA32R-LABEL: mul_i32_49:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 49
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_49:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 1
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_49:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 1
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 49
  ret i32 %b
}

define signext i32 @mul_i32_51(i32 %a) {
; LA32R-LABEL: mul_i32_51:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 51
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_51:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 1
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_51:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 1
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 51
  ret i32 %b
}

define signext i32 @mul_i32_69(i32 %a) {
; LA32R-LABEL: mul_i32_69:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 69
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_69:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_69:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i32 %a, 69
  ret i32 %b
}

define signext i32 @mul_i32_73(i32 %a) {
; LA32R-LABEL: mul_i32_73:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 73
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_73:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_73:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 73
  ret i32 %b
}

define signext i32 @mul_i32_81(i32 %a) {
; LA32R-LABEL: mul_i32_81:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 81
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_81:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_81:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 81
  ret i32 %b
}

define signext i32 @mul_i32_85(i32 %a) {
; LA32R-LABEL: mul_i32_85:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 85
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_85:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_85:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 85
  ret i32 %b
}

define signext i32 @mul_i32_137(i32 %a) {
; LA32R-LABEL: mul_i32_137:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 137
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_137:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_137:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 137
  ret i32 %b
}

define signext i32 @mul_i32_145(i32 %a) {
; LA32R-LABEL: mul_i32_145:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 145
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_145:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_145:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 145
  ret i32 %b
}

define signext i32 @mul_i32_153(i32 %a) {
; LA32R-LABEL: mul_i32_153:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 153
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_153:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_153:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 153
  ret i32 %b
}

define signext i32 @mul_i32_273(i32 %a) {
; LA32R-LABEL: mul_i32_273:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 273
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_273:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA32S-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_273:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.w $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 273
  ret i32 %b
}

define signext i32 @mul_i32_289(i32 %a) {
; LA32R-LABEL: mul_i32_289:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 289
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_289:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_289:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 289
  ret i32 %b
}

define i64 @mul_i64_11(i64 %a) {
; LA32R-LABEL: mul_i64_11:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 11
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_11:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 11
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_11:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 1
; LA64-NEXT:    ret
  %b = mul i64 %a, 11
  ret i64 %b
}

define i64 @mul_i64_13(i64 %a) {
; LA32R-LABEL: mul_i64_13:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 13
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_13:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 13
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_13:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 1
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i64 %a, 13
  ret i64 %b
}

define i64 @mul_i64_19(i64 %a) {
; LA32R-LABEL: mul_i64_19:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 19
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_19:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 19
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_19:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 1
; LA64-NEXT:    ret
  %b = mul i64 %a, 19
  ret i64 %b
}

define i64 @mul_i64_21(i64 %a) {
; LA32R-LABEL: mul_i64_21:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 21
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_21:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 21
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_21:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i64 %a, 21
  ret i64 %b
}

define i64 @mul_i64_25(i64 %a) {
; LA32R-LABEL: mul_i64_25:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 25
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_25:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 25
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_25:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 1
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 25
  ret i64 %b
}

define i64 @mul_i64_27(i64 %a) {
; LA32R-LABEL: mul_i64_27:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 27
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_27:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 27
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_27:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 1
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 27
  ret i64 %b
}

define i64 @mul_i64_35(i64 %a) {
; LA32R-LABEL: mul_i64_35:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 35
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_35:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 35
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_35:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 1
; LA64-NEXT:    ret
  %b = mul i64 %a, 35
  ret i64 %b
}

define i64 @mul_i64_37(i64 %a) {
; LA32R-LABEL: mul_i64_37:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 37
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_37:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 37
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_37:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i64 %a, 37
  ret i64 %b
}

define i64 @mul_i64_41(i64 %a) {
; LA32R-LABEL: mul_i64_41:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 41
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_41:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 41
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_41:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 41
  ret i64 %b
}

define i64 @mul_i64_45(i64 %a) {
; LA32R-LABEL: mul_i64_45:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 45
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_45:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 45
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_45:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 2
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 45
  ret i64 %b
}

define i64 @mul_i64_49(i64 %a) {
; LA32R-LABEL: mul_i64_49:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 49
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_49:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 49
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_49:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 1
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 49
  ret i64 %b
}

define i64 @mul_i64_51(i64 %a) {
; LA32R-LABEL: mul_i64_51:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 51
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_51:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 51
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_51:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 1
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 51
  ret i64 %b
}

define i64 @mul_i64_69(i64 %a) {
; LA32R-LABEL: mul_i64_69:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 69
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_69:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 69
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_69:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 2
; LA64-NEXT:    ret
  %b = mul i64 %a, 69
  ret i64 %b
}

define i64 @mul_i64_73(i64 %a) {
; LA32R-LABEL: mul_i64_73:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 73
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_73:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 73
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_73:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 73
  ret i64 %b
}

define i64 @mul_i64_81(i64 %a) {
; LA32R-LABEL: mul_i64_81:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 81
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_81:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 81
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_81:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 2
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 81
  ret i64 %b
}

define i64 @mul_i64_85(i64 %a) {
; LA32R-LABEL: mul_i64_85:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 85
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_85:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 85
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_85:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 2
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 85
  ret i64 %b
}

define i64 @mul_i64_137(i64 %a) {
; LA32R-LABEL: mul_i64_137:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 137
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_137:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 137
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_137:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 137
  ret i64 %b
}

define i64 @mul_i64_145(i64 %a) {
; LA32R-LABEL: mul_i64_145:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 145
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_145:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 145
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_145:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 3
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 145
  ret i64 %b
}

define i64 @mul_i64_153(i64 %a) {
; LA32R-LABEL: mul_i64_153:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 153
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_153:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 153
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_153:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 3
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 153
  ret i64 %b
}

define i64 @mul_i64_273(i64 %a) {
; LA32R-LABEL: mul_i64_273:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 273
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_273:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 273
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_273:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a1, $a0, $a0, 4
; LA64-NEXT:    alsl.d $a0, $a1, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 273
  ret i64 %b
}

define i64 @mul_i64_289(i64 %a) {
; LA32R-LABEL: mul_i64_289:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 289
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_289:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 289
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_289:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 289
  ret i64 %b
}

define signext i32 @mul_i32_4098(i32 %a) {
; LA32R-LABEL: mul_i32_4098:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 1
; LA32R-NEXT:    slli.w $a0, $a0, 12
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_4098:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 12
; LA32S-NEXT:    alsl.w $a0, $a0, $a1, 1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_4098:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.w $a0, $a0, $a1, 1
; LA64-NEXT:    ret
  %b = mul i32 %a, 4098
  ret i32 %b
}

define signext i32 @mul_i32_4100(i32 %a) {
; LA32R-LABEL: mul_i32_4100:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 2
; LA32R-NEXT:    slli.w $a0, $a0, 12
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_4100:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 12
; LA32S-NEXT:    alsl.w $a0, $a0, $a1, 2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_4100:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.w $a0, $a0, $a1, 2
; LA64-NEXT:    ret
  %b = mul i32 %a, 4100
  ret i32 %b
}

define signext i32 @mul_i32_4104(i32 %a) {
; LA32R-LABEL: mul_i32_4104:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 3
; LA32R-NEXT:    slli.w $a0, $a0, 12
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_4104:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 12
; LA32S-NEXT:    alsl.w $a0, $a0, $a1, 3
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_4104:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.w $a0, $a0, $a1, 3
; LA64-NEXT:    ret
  %b = mul i32 %a, 4104
  ret i32 %b
}

define signext i32 @mul_i32_4112(i32 %a) {
; LA32R-LABEL: mul_i32_4112:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 4
; LA32R-NEXT:    slli.w $a0, $a0, 12
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_4112:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 12
; LA32S-NEXT:    alsl.w $a0, $a0, $a1, 4
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_4112:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.w $a0, $a0, $a1, 4
; LA64-NEXT:    ret
  %b = mul i32 %a, 4112
  ret i32 %b
}

define i64 @mul_i64_4098(i64 %a) {
; LA32R-LABEL: mul_i64_4098:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 1
; LA32R-NEXT:    ori $a2, $a2, 2
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_4098:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 1
; LA32S-NEXT:    ori $a2, $a2, 2
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_4098:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.d $a0, $a0, $a1, 1
; LA64-NEXT:    ret
  %b = mul i64 %a, 4098
  ret i64 %b
}

define i64 @mul_i64_4100(i64 %a) {
; LA32R-LABEL: mul_i64_4100:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 1
; LA32R-NEXT:    ori $a2, $a2, 4
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_4100:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 1
; LA32S-NEXT:    ori $a2, $a2, 4
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_4100:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.d $a0, $a0, $a1, 2
; LA64-NEXT:    ret
  %b = mul i64 %a, 4100
  ret i64 %b
}

define i64 @mul_i64_4104(i64 %a) {
; LA32R-LABEL: mul_i64_4104:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 1
; LA32R-NEXT:    ori $a2, $a2, 8
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_4104:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 1
; LA32S-NEXT:    ori $a2, $a2, 8
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_4104:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.d $a0, $a0, $a1, 3
; LA64-NEXT:    ret
  %b = mul i64 %a, 4104
  ret i64 %b
}

define i64 @mul_i64_4112(i64 %a) {
; LA32R-LABEL: mul_i64_4112:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 1
; LA32R-NEXT:    ori $a2, $a2, 16
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_4112:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 1
; LA32S-NEXT:    ori $a2, $a2, 16
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_4112:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 12
; LA64-NEXT:    alsl.d $a0, $a0, $a1, 4
; LA64-NEXT:    ret
  %b = mul i64 %a, 4112
  ret i64 %b
}

define signext i32 @mul_i32_768(i32 %a) {
; LA32R-LABEL: mul_i32_768:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 768
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_768:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 1
; LA32S-NEXT:    slli.w $a0, $a0, 8
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_768:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 1
; LA64-NEXT:    slli.w $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i32 %a, 768
  ret i32 %b
}

define signext i32 @mul_i32_1280(i32 %a) {
; LA32R-LABEL: mul_i32_1280:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 1280
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_1280:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA32S-NEXT:    slli.w $a0, $a0, 8
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_1280:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 2
; LA64-NEXT:    slli.w $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i32 %a, 1280
  ret i32 %b
}

define signext i32 @mul_i32_2304(i32 %a) {
; LA32R-LABEL: mul_i32_2304:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 2304
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_2304:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA32S-NEXT:    slli.w $a0, $a0, 8
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_2304:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 3
; LA64-NEXT:    slli.w $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i32 %a, 2304
  ret i32 %b
}

define signext i32 @mul_i32_4352(i32 %a) {
; LA32R-LABEL: mul_i32_4352:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a1, 1
; LA32R-NEXT:    ori $a1, $a1, 256
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_4352:
; LA32S:       # %bb.0:
; LA32S-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA32S-NEXT:    slli.w $a0, $a0, 8
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_4352:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.w $a0, $a0, $a0, 4
; LA64-NEXT:    slli.w $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i32 %a, 4352
  ret i32 %b
}

define i64 @mul_i64_768(i64 %a) {
; LA32R-LABEL: mul_i64_768:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 768
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_768:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 768
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_768:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 1
; LA64-NEXT:    slli.d $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i64 %a, 768
  ret i64 %b
}

define i64 @mul_i64_1280(i64 %a) {
; LA32R-LABEL: mul_i64_1280:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 1280
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_1280:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 1280
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_1280:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 2
; LA64-NEXT:    slli.d $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i64 %a, 1280
  ret i64 %b
}

define i64 @mul_i64_2304(i64 %a) {
; LA32R-LABEL: mul_i64_2304:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 2304
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_2304:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 2304
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_2304:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 3
; LA64-NEXT:    slli.d $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i64 %a, 2304
  ret i64 %b
}

define i64 @mul_i64_4352(i64 %a) {
; LA32R-LABEL: mul_i64_4352:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 1
; LA32R-NEXT:    ori $a2, $a2, 256
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_4352:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 1
; LA32S-NEXT:    ori $a2, $a2, 256
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_4352:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    slli.d $a0, $a0, 8
; LA64-NEXT:    ret
  %b = mul i64 %a, 4352
  ret i64 %b
}

define signext i32 @mul_i32_65792(i32 %a) {
; LA32R-LABEL: mul_i32_65792:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 8
; LA32R-NEXT:    slli.w $a0, $a0, 16
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_65792:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 8
; LA32S-NEXT:    slli.w $a0, $a0, 16
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_65792:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 8
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    add.w $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i32 %a, 65792
  ret i32 %b
}

define signext i32 @mul_i32_65280(i32 %a) {
; LA32R-LABEL: mul_i32_65280:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 8
; LA32R-NEXT:    slli.w $a0, $a0, 16
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_65280:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 8
; LA32S-NEXT:    slli.w $a0, $a0, 16
; LA32S-NEXT:    sub.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_65280:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 8
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    sub.w $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i32 %a, 65280
  ret i32 %b
}

define signext i32 @mul_i32_minus_65280(i32 %a) {
; LA32R-LABEL: mul_i32_minus_65280:
; LA32R:       # %bb.0:
; LA32R-NEXT:    slli.w $a1, $a0, 16
; LA32R-NEXT:    slli.w $a0, $a0, 8
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i32_minus_65280:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a1, $a0, 16
; LA32S-NEXT:    slli.w $a0, $a0, 8
; LA32S-NEXT:    sub.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i32_minus_65280:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 16
; LA64-NEXT:    slli.d $a0, $a0, 8
; LA64-NEXT:    sub.w $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i32 %a, -65280
  ret i32 %b
}

define i64 @mul_i64_65792(i64 %a) {
; LA32R-LABEL: mul_i64_65792:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 16
; LA32R-NEXT:    ori $a2, $a2, 256
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_65792:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 16
; LA32S-NEXT:    ori $a2, $a2, 256
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_65792:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 8
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i64 %a, 65792
  ret i64 %b
}

define i64 @mul_i64_65280(i64 %a) {
; LA32R-LABEL: mul_i64_65280:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 15
; LA32R-NEXT:    ori $a2, $a2, 3840
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_65280:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 15
; LA32S-NEXT:    ori $a2, $a2, 3840
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_65280:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 8
; LA64-NEXT:    slli.d $a0, $a0, 16
; LA64-NEXT:    sub.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i64 %a, 65280
  ret i64 %b
}

define i64 @mul_i64_minus_65280(i64 %a) {
; LA32R-LABEL: mul_i64_minus_65280:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, -16
; LA32R-NEXT:    ori $a2, $a2, 256
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    sub.w $a3, $a3, $a0
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_minus_65280:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, -16
; LA32S-NEXT:    ori $a2, $a2, 256
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    sub.w $a3, $a3, $a0
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_minus_65280:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a1, $a0, 16
; LA64-NEXT:    slli.d $a0, $a0, 8
; LA64-NEXT:    sub.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i64 %a, -65280
  ret i64 %b
}

;; This multiplication is not transformed, due to
;; 1088 can be composed via a single ORI.
define i64 @mul_i64_1088(i64 %a) {
; LA32R-LABEL: mul_i64_1088:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a2, $zero, 1088
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_1088:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a2, $zero, 1088
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_1088:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    slli.d $a0, $a0, 6
; LA64-NEXT:    ret
  %b = mul i64 %a, 1088
  ret i64 %b
}

;; This multiplication is not transformed, due to
;; -992 can be composed via a single ADDI.
define i64 @mul_i64_minus_992(i64 %a) {
; LA32R-LABEL: mul_i64_minus_992:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a2, $zero, -992
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    sub.w $a3, $a3, $a0
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_minus_992:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $a2, $zero, -992
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    sub.w $a3, $a3, $a0
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_minus_992:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $zero, -992
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %b = mul i64 %a, -992
  ret i64 %b
}

;; This multiplication is not transformed, due to
;; 4456448 can be composed via a single LUI.
define i64 @mul_i64_4456448(i64 %a) {
; LA32R-LABEL: mul_i64_4456448:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 1088
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    mulh.wu $a3, $a0, $a2
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_4456448:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a2, 1088
; LA32S-NEXT:    mul.w $a1, $a1, $a2
; LA32S-NEXT:    mulh.wu $a3, $a0, $a2
; LA32S-NEXT:    add.w $a1, $a3, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_4456448:
; LA64:       # %bb.0:
; LA64-NEXT:    alsl.d $a0, $a0, $a0, 4
; LA64-NEXT:    slli.d $a0, $a0, 18
; LA64-NEXT:    ret
  %b = mul i64 %a, 4456448
  ret i64 %b
}

;; This multiplication is not transformed, due to
;; 65280 is used multiple times.
define i64 @mul_i64_65280_twice(i64 %a, i64 %b) {
; LA32R-LABEL: mul_i64_65280_twice:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a4, 15
; LA32R-NEXT:    ori $a4, $a4, 3840
; LA32R-NEXT:    mul.w $a1, $a1, $a4
; LA32R-NEXT:    mulh.wu $a5, $a0, $a4
; LA32R-NEXT:    add.w $a1, $a5, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a4
; LA32R-NEXT:    mul.w $a3, $a3, $a4
; LA32R-NEXT:    mulh.wu $a5, $a2, $a4
; LA32R-NEXT:    add.w $a3, $a5, $a3
; LA32R-NEXT:    mul.w $a2, $a2, $a4
; LA32R-NEXT:    xor $a1, $a1, $a3
; LA32R-NEXT:    xor $a0, $a0, $a2
; LA32R-NEXT:    ret
;
; LA32S-LABEL: mul_i64_65280_twice:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a4, 15
; LA32S-NEXT:    ori $a4, $a4, 3840
; LA32S-NEXT:    mul.w $a1, $a1, $a4
; LA32S-NEXT:    mulh.wu $a5, $a0, $a4
; LA32S-NEXT:    add.w $a1, $a5, $a1
; LA32S-NEXT:    mul.w $a0, $a0, $a4
; LA32S-NEXT:    mul.w $a3, $a3, $a4
; LA32S-NEXT:    mulh.wu $a5, $a2, $a4
; LA32S-NEXT:    add.w $a3, $a5, $a3
; LA32S-NEXT:    mul.w $a2, $a2, $a4
; LA32S-NEXT:    xor $a1, $a1, $a3
; LA32S-NEXT:    xor $a0, $a0, $a2
; LA32S-NEXT:    ret
;
; LA64-LABEL: mul_i64_65280_twice:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a2, 15
; LA64-NEXT:    ori $a2, $a2, 3840
; LA64-NEXT:    mul.d $a0, $a0, $a2
; LA64-NEXT:    mul.d $a1, $a1, $a2
; LA64-NEXT:    xor $a0, $a0, $a1
; LA64-NEXT:    ret
  %c = mul i64 %a, 65280
  %d = mul i64 %b, 65280
  %e = xor i64 %c, %d
  ret i64 %e
}
