; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=-lzcnt,+sse2 | FileCheck %s -check-prefixes=NOLZCNT
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+sse2 | FileCheck %s -check-prefixes=LZCNT,SSE2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+sse4.2 | FileCheck %s -check-prefixes=LZCNT,SSE42
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+avx | FileCheck %s -check-prefixes=LZCNT,AVX1
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+avx2 | FileCheck %s -check-prefixes=LZCNT,AVX2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+avx512f | FileCheck %s -check-prefixes=LZCNT,AVX512,AVX512F
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+avx512vl,+avx512bw,+avx512dq | FileCheck %s -check-prefixes=LZCNT,AVX512,AVX512BW
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+lzcnt,+avx512vl,+avx512bw,+avx512dq,+avx512cd | FileCheck %s -check-prefixes=LZCNT,AVX512CD

; Verify the cost of scalar leading zero count instructions.

declare i64 @llvm.ctlz.i64(i64, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i16 @llvm.ctlz.i16(i16, i1)
declare  i8 @llvm.ctlz.i8(i8, i1)

define i64 @var_ctlz_i64(i64 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i64'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i64'
; LZCNT-NEXT:  Cost Model: Found costs of 1 for: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %ctlz
;
  %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 0)
  ret i64 %ctlz
}

define i64 @var_ctlz_i64u(i64 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i64u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i64u'
; LZCNT-NEXT:  Cost Model: Found costs of 1 for: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %ctlz
;
  %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 1)
  ret i64 %ctlz
}

define i32 @var_ctlz_i32(i32 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i32'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:2 SizeLat:3 for: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i32'
; LZCNT-NEXT:  Cost Model: Found costs of 1 for: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %ctlz
;
  %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 0)
  ret i32 %ctlz
}

define i32 @var_ctlz_i32u(i32 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i32u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i32u'
; LZCNT-NEXT:  Cost Model: Found costs of 1 for: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %ctlz
;
  %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 1)
  ret i32 %ctlz
}

define i16 @var_ctlz_i16(i16 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i16'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i16'
; LZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %ctlz
;
  %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 0)
  ret i16 %ctlz
}

define i16 @var_ctlz_i16u(i16 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i16u'
; NOLZCNT-NEXT:  Cost Model: Found costs of 2 for: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i16u'
; LZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %ctlz
;
  %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 1)
  ret i16 %ctlz
}

define i8 @var_ctlz_i8(i8 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i8'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:3 for: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i8'
; LZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %ctlz
;
  %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 0)
  ret i8 %ctlz
}

define i8 @var_ctlz_i8u(i8 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i8u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:2 SizeLat:3 for: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i8u'
; LZCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %ctlz
;
  %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 1)
  ret i8 %ctlz
}

; Verify the cost of vector leading zero count instructions.

declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1)
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1)
declare <8 x i16> @llvm.ctlz.v8i16(<8 x i16>, i1)
declare <16 x i8> @llvm.ctlz.v16i8(<16 x i8>, i1)

declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1)
declare <8 x i32> @llvm.ctlz.v8i32(<8 x i32>, i1)
declare <16 x i16> @llvm.ctlz.v16i16(<16 x i16>, i1)
declare <32 x i8> @llvm.ctlz.v32i8(<32 x i8>, i1)

declare <8 x i64> @llvm.ctlz.v8i64(<8 x i64>, i1)
declare <16 x i32> @llvm.ctlz.v16i32(<16 x i32>, i1)
declare <32 x i16> @llvm.ctlz.v32i16(<32 x i16>, i1)
declare <64 x i8> @llvm.ctlz.v64i8(<64 x i8>, i1)

define <2 x i64> @var_ctlz_v2i64(<2 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v2i64'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:36 Lat:45 SizeLat:38 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v2i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:36 Lat:45 SizeLat:38 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v2i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:28 Lat:28 SizeLat:35 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v2i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:24 SizeLat:28 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v2i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:24 Lat:18 SizeLat:25 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v2i64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:24 Lat:18 SizeLat:25 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v2i64'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX-LABEL: 'var_ctlz_v2i64'
; AVX-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i64> %ctlz
  %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 0)
  ret <2 x i64> %ctlz
}

define <2 x i64> @var_ctlz_v2i64u(<2 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v2i64u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:36 Lat:45 SizeLat:38 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v2i64u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:36 Lat:45 SizeLat:38 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v2i64u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:28 Lat:28 SizeLat:35 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v2i64u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:24 SizeLat:28 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v2i64u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:24 Lat:18 SizeLat:25 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v2i64u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:24 Lat:18 SizeLat:25 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v2i64u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctlz
;
; AVX-LABEL: 'var_ctlz_v2i64u'
; AVX-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <2 x i64> %ctlz
  %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 1)
  ret <2 x i64> %ctlz
}

define <4 x i64> @var_ctlz_v4i64(<4 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i64'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:72 Lat:90 SizeLat:76 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:72 Lat:90 SizeLat:76 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:56 Lat:56 SizeLat:70 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:29 CodeSize:49 Lat:33 SizeLat:58 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:18 SizeLat:44 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:18 SizeLat:44 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i64'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
  %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 0)
  ret <4 x i64> %ctlz
}

define <4 x i64> @var_ctlz_v4i64u(<4 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i64u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:72 Lat:90 SizeLat:76 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i64u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:72 Lat:90 SizeLat:76 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i64u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:56 Lat:56 SizeLat:70 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i64u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:29 CodeSize:49 Lat:33 SizeLat:58 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i64u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:18 SizeLat:44 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i64u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:18 SizeLat:44 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i64u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctlz
;
  %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 1)
  ret <4 x i64> %ctlz
}

define <8 x i64> @var_ctlz_v8i64(<8 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i64'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:144 Lat:180 SizeLat:152 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:144 Lat:180 SizeLat:152 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:112 Lat:112 SizeLat:140 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:58 CodeSize:98 Lat:66 SizeLat:116 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:48 Lat:36 SizeLat:88 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v8i64'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:32 Lat:28 SizeLat:32 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v8i64'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:23 Lat:22 SizeLat:23 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i64'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
  %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 0)
  ret <8 x i64> %ctlz
}

define <8 x i64> @var_ctlz_v8i64u(<8 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i64u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:144 Lat:180 SizeLat:152 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i64u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:144 Lat:180 SizeLat:152 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i64u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:112 Lat:112 SizeLat:140 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i64u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:58 CodeSize:98 Lat:66 SizeLat:116 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i64u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:48 Lat:36 SizeLat:88 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v8i64u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:32 Lat:28 SizeLat:32 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v8i64u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:23 Lat:22 SizeLat:23 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i64u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctlz
;
  %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 1)
  ret <8 x i64> %ctlz
}

define <4 x i32> @var_ctlz_v4i32(<4 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i32'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:38 Lat:45 SizeLat:40 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:38 Lat:45 SizeLat:40 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:22 Lat:20 SizeLat:28 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:19 Lat:20 SizeLat:23 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:19 Lat:16 SizeLat:20 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:19 Lat:16 SizeLat:20 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i32'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX-LABEL: 'var_ctlz_v4i32'
; AVX-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <4 x i32> %ctlz
  %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 0)
  ret <4 x i32> %ctlz
}

define <4 x i32> @var_ctlz_v4i32u(<4 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i32u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:38 Lat:45 SizeLat:40 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i32u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:38 Lat:45 SizeLat:40 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i32u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:22 Lat:20 SizeLat:28 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i32u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:19 Lat:20 SizeLat:23 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i32u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:19 Lat:16 SizeLat:20 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i32u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:19 Lat:16 SizeLat:20 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i32u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctlz
;
; AVX-LABEL: 'var_ctlz_v4i32u'
; AVX-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <4 x i32> %ctlz
  %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 1)
  ret <4 x i32> %ctlz
}

define <8 x i32> @var_ctlz_v8i32(<8 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i32'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:76 Lat:90 SizeLat:80 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:76 Lat:90 SizeLat:80 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:44 Lat:40 SizeLat:56 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:39 Lat:28 SizeLat:48 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:16 SizeLat:34 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:16 SizeLat:34 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i32'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
  %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 0)
  ret <8 x i32> %ctlz
}

define <8 x i32> @var_ctlz_v8i32u(<8 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i32u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:76 Lat:90 SizeLat:80 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i32u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:76 Lat:90 SizeLat:80 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i32u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:44 Lat:40 SizeLat:56 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i32u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:39 Lat:28 SizeLat:48 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i32u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:16 SizeLat:34 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i32u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:16 SizeLat:34 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i32u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctlz
;
  %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 1)
  ret <8 x i32> %ctlz
}

define <16 x i32> @var_ctlz_v16i32(<16 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i32'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:152 Lat:180 SizeLat:160 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:152 Lat:180 SizeLat:160 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:88 Lat:80 SizeLat:112 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:78 Lat:56 SizeLat:96 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:38 Lat:32 SizeLat:68 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v16i32'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:38 Lat:30 SizeLat:38 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v16i32'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:25 Lat:23 SizeLat:25 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i32'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
  %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 0)
  ret <16 x i32> %ctlz
}

define <16 x i32> @var_ctlz_v16i32u(<16 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i32u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:152 Lat:180 SizeLat:160 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i32u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:152 Lat:180 SizeLat:160 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i32u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:88 Lat:80 SizeLat:112 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i32u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:78 Lat:56 SizeLat:96 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i32u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:38 Lat:32 SizeLat:68 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v16i32u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:38 Lat:30 SizeLat:38 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v16i32u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:25 Lat:23 SizeLat:25 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i32u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctlz
;
  %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 1)
  ret <16 x i32> %ctlz
}

define <8 x i16> @var_ctlz_v8i16(<8 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i16'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:32 Lat:38 SizeLat:34 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:32 Lat:38 SizeLat:34 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:16 Lat:17 SizeLat:22 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:14 Lat:16 SizeLat:18 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:13 SizeLat:15 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i16'
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:13 SizeLat:15 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i16'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:15 SizeLat:6 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX-LABEL: 'var_ctlz_v8i16'
; AVX-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <8 x i16> %ctlz
  %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 0)
  ret <8 x i16> %ctlz
}

define <8 x i16> @var_ctlz_v8i16u(<8 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i16u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:32 Lat:38 SizeLat:34 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i16u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:32 Lat:38 SizeLat:34 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i16u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:16 Lat:17 SizeLat:22 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i16u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:14 Lat:16 SizeLat:18 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i16u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:13 SizeLat:15 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i16u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:13 SizeLat:15 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i16u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:15 SizeLat:6 for: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctlz
;
; AVX-LABEL: 'var_ctlz_v8i16u'
; AVX-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <8 x i16> %ctlz
  %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 1)
  ret <8 x i16> %ctlz
}

define <16 x i16> @var_ctlz_v16i16(<16 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i16'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:64 Lat:76 SizeLat:68 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:64 Lat:76 SizeLat:68 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:32 Lat:34 SizeLat:44 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:29 Lat:22 SizeLat:38 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:14 SizeLat:24 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i16'
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:14 SizeLat:24 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i16'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:11 Lat:19 SizeLat:13 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
  %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 0)
  ret <16 x i16> %ctlz
}

define <16 x i16> @var_ctlz_v16i16u(<16 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i16u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:64 Lat:76 SizeLat:68 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i16u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:64 Lat:76 SizeLat:68 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i16u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:32 Lat:34 SizeLat:44 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i16u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:29 Lat:22 SizeLat:38 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i16u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:14 SizeLat:24 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i16u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:14 SizeLat:24 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i16u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:11 Lat:19 SizeLat:13 for: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctlz
;
  %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 1)
  ret <16 x i16> %ctlz
}

define <32 x i16> @var_ctlz_v32i16(<32 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i16'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:128 Lat:152 SizeLat:136 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:128 Lat:152 SizeLat:136 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:64 Lat:68 SizeLat:88 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:58 Lat:44 SizeLat:76 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:28 SizeLat:48 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v32i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:29 Lat:15 SizeLat:29 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v32i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:15 Lat:15 SizeLat:16 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i16'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:23 Lat:27 SizeLat:27 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
  %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 0)
  ret <32 x i16> %ctlz
}

define <32 x i16> @var_ctlz_v32i16u(<32 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i16u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:128 Lat:152 SizeLat:136 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i16u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:128 Lat:152 SizeLat:136 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i16u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:64 Lat:68 SizeLat:88 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i16u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:58 Lat:44 SizeLat:76 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i16u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:28 SizeLat:48 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v32i16u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:29 Lat:15 SizeLat:29 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v32i16u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:15 Lat:15 SizeLat:16 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i16u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:23 Lat:27 SizeLat:27 for: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctlz
;
  %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 1)
  ret <32 x i16> %ctlz
}

define <16 x i8> @var_ctlz_v16i8(<16 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i8'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:29 Lat:39 SizeLat:32 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:29 Lat:39 SizeLat:32 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:10 Lat:15 SizeLat:16 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:12 SizeLat:13 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:12 SizeLat:10 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i8'
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:12 SizeLat:10 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i8'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:10 SizeLat:10 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX-LABEL: 'var_ctlz_v16i8'
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <16 x i8> %ctlz
  %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 0)
  ret <16 x i8> %ctlz
}

define <16 x i8> @var_ctlz_v16i8u(<16 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i8u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:29 Lat:39 SizeLat:32 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i8u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:29 Lat:39 SizeLat:32 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i8u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:10 Lat:15 SizeLat:16 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i8u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:12 SizeLat:13 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i8u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:12 SizeLat:10 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i8u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:12 SizeLat:10 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i8u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:10 SizeLat:10 for: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctlz
;
; AVX-LABEL: 'var_ctlz_v16i8u'
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <16 x i8> %ctlz
  %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 1)
  ret <16 x i8> %ctlz
}

define <32 x i8> @var_ctlz_v32i8(<32 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i8'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:58 Lat:78 SizeLat:64 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:58 Lat:78 SizeLat:64 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:20 Lat:30 SizeLat:32 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:15 SizeLat:28 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:12 SizeLat:14 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v32i8'
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:12 SizeLat:14 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i8'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:11 SizeLat:10 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
  %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 0)
  ret <32 x i8> %ctlz
}

define <32 x i8> @var_ctlz_v32i8u(<32 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i8u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:58 Lat:78 SizeLat:64 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i8u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:58 Lat:78 SizeLat:64 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i8u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:20 Lat:30 SizeLat:32 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i8u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:15 SizeLat:28 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i8u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:12 SizeLat:14 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v32i8u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:12 SizeLat:14 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i8u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:11 SizeLat:10 for: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctlz
;
  %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 1)
  ret <32 x i8> %ctlz
}

define <64 x i8> @var_ctlz_v64i8(<64 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v64i8'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:116 Lat:156 SizeLat:128 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v64i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:116 Lat:156 SizeLat:128 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v64i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:40 Lat:60 SizeLat:64 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v64i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:30 SizeLat:56 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v64i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:18 Lat:24 SizeLat:28 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v64i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:19 Lat:11 SizeLat:19 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v64i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:12 SizeLat:9 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v64i8'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:16 SizeLat:11 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
  %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 0)
  ret <64 x i8> %ctlz
}

define <64 x i8> @var_ctlz_v64i8u(<64 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v64i8u'
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:116 Lat:156 SizeLat:128 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v64i8u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:116 Lat:156 SizeLat:128 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v64i8u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:40 Lat:60 SizeLat:64 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v64i8u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:30 SizeLat:56 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v64i8u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:18 Lat:24 SizeLat:28 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v64i8u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:19 Lat:11 SizeLat:19 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v64i8u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:12 SizeLat:9 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v64i8u'
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:16 SizeLat:11 for: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctlz
;
  %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 1)
  ret <64 x i8> %ctlz
}
