; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=-sse2 | FileCheck %s --check-prefixes=SSE1
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512
;
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=goldmont | FileCheck %s --check-prefixes=GLM
; RUN: opt < %s -enable-no-nans-fp-math  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=AVX,AVX1

define i32 @fadd(i32 %arg) {
; SSE1-LABEL: 'fadd'
; SSE1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fadd float undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fadd double undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V2F64 = fadd <2 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V4F64 = fadd <4 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:24 SizeLat:8 for: %V8F64 = fadd <8 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fadd'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fadd float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fadd double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fadd <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fadd <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fadd'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fadd float undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fadd double undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fadd <4 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fadd <8 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fadd'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fadd float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fadd double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V4F64 = fadd <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V8F64 = fadd <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fadd'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fadd float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fadd double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fadd <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fadd <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fadd'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fadd float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fadd <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fadd <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fadd double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fadd <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fadd <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fadd'
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fadd float undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fadd double undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:8 SizeLat:2 for: %V4F64 = fadd <4 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:16 SizeLat:4 for: %V8F64 = fadd <8 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fadd'
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fadd float undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fadd <4 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fadd <8 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fadd <16 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fadd double undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fadd <2 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fadd <4 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fadd <8 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fadd float undef, undef
  %V4F32 = fadd <4 x float> undef, undef
  %V8F32 = fadd <8 x float> undef, undef
  %V16F32 = fadd <16 x float> undef, undef

  %F64 = fadd double undef, undef
  %V2F64 = fadd <2 x double> undef, undef
  %V4F64 = fadd <4 x double> undef, undef
  %V8F64 = fadd <8 x double> undef, undef

  ret i32 undef
}

define i32 @fsub(i32 %arg) {
; SSE1-LABEL: 'fsub'
; SSE1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V2F64 = fsub <2 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V4F64 = fsub <4 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:24 SizeLat:8 for: %V8F64 = fsub <8 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fsub'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fsub <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fsub <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fsub'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fsub <4 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fsub <8 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fsub'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fsub float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fsub double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V4F64 = fsub <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V8F64 = fsub <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fsub'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fsub float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fsub double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fsub <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fsub <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fsub'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fsub float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fsub <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fsub <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fsub double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fsub <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fsub <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fsub'
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:8 SizeLat:2 for: %V4F64 = fsub <4 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:16 SizeLat:4 for: %V8F64 = fsub <8 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fsub'
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fsub <2 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fsub <4 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fsub <8 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fsub float undef, undef
  %V4F32 = fsub <4 x float> undef, undef
  %V8F32 = fsub <8 x float> undef, undef
  %V16F32 = fsub <16 x float> undef, undef

  %F64 = fsub double undef, undef
  %V2F64 = fsub <2 x double> undef, undef
  %V4F64 = fsub <4 x double> undef, undef
  %V8F64 = fsub <8 x double> undef, undef

  ret i32 undef
}

define i32 @fneg_idiom(i32 %arg) {
; SSE1-LABEL: 'fneg_idiom'
; SSE1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:24 SizeLat:8 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fneg_idiom'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fneg_idiom'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fneg_idiom'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fneg_idiom'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fneg_idiom'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fneg_idiom'
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:8 SizeLat:2 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:16 SizeLat:4 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fneg_idiom'
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fsub float -0.000000e+00, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fsub <4 x float> splat (float -0.000000e+00), undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8F32 = fsub <8 x float> splat (float -0.000000e+00), undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V16F32 = fsub <16 x float> splat (float -0.000000e+00), undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fsub double -0.000000e+00, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fsub <2 x double> splat (double -0.000000e+00), undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V4F64 = fsub <4 x double> splat (double -0.000000e+00), undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V8F64 = fsub <8 x double> splat (double -0.000000e+00), undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fsub float -0.0, undef
  %V4F32 = fsub <4 x float> <float -0.0, float -0.0, float -0.0, float -0.0>, undef
  %V8F32 = fsub <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, undef
  %V16F32 = fsub <16 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, undef

  %F64 = fsub double -0.0, undef
  %V2F64 = fsub <2 x double> <double -0.0, double -0.0>, undef
  %V4F64 = fsub <4 x double> <double -0.0, double -0.0, double -0.0, double -0.0>, undef
  %V8F64 = fsub <8 x double> <double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0>, undef

  ret i32 undef
}

define i32 @fneg(i32 %arg) {
; SSE1-LABEL: 'fneg'
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %F32 = fneg float undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %V4F32 = fneg <4 x float> undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V8F32 = fneg <8 x float> undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:8 SizeLat:8 for: %V16F32 = fneg <16 x float> undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:3 for: %F64 = fneg double undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:6 for: %V2F64 = fneg <2 x double> undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:8 SizeLat:12 for: %V4F64 = fneg <4 x double> undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:16 SizeLat:24 for: %V8F64 = fneg <8 x double> undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fneg'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = fneg <8 x float> undef
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = fneg <16 x float> undef
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = fneg <4 x double> undef
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = fneg <8 x double> undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fneg'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = fneg <8 x float> undef
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = fneg <16 x float> undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = fneg <4 x double> undef
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = fneg <8 x double> undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fneg'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %V8F32 = fneg <8 x float> undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V16F32 = fneg <16 x float> undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %V4F64 = fneg <4 x double> undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V8F64 = fneg <8 x double> undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fneg'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8F32 = fneg <8 x float> undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16F32 = fneg <16 x float> undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4F64 = fneg <4 x double> undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8F64 = fneg <8 x double> undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fneg'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8F32 = fneg <8 x float> undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16F32 = fneg <16 x float> undef
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V4F64 = fneg <4 x double> undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8F64 = fneg <8 x double> undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fneg'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = fneg <8 x float> undef
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = fneg <16 x float> undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = fneg <4 x double> undef
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = fneg <8 x double> undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fneg'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = fneg float undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = fneg <4 x float> undef
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = fneg <8 x float> undef
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = fneg <16 x float> undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = fneg double undef
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = fneg <2 x double> undef
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = fneg <4 x double> undef
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = fneg <8 x double> undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fneg float undef
  %V4F32 = fneg <4 x float> undef
  %V8F32 = fneg <8 x float> undef
  %V16F32 = fneg <16 x float> undef

  %F64 = fneg double undef
  %V2F64 = fneg <2 x double> undef
  %V4F64 = fneg <4 x double> undef
  %V8F64 = fneg <8 x double> undef

  ret i32 undef
}

define i32 @fmul(i32 %arg) {
; SSE1-LABEL: 'fmul'
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fmul float undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V2F64 = fmul <2 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V4F64 = fmul <4 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V8F64 = fmul <8 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fmul'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fmul float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fmul <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fmul <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fmul'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fmul float undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fmul <4 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fmul <8 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fmul'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fmul float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:5 SizeLat:2 for: %V4F64 = fmul <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:10 SizeLat:4 for: %V8F64 = fmul <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fmul'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fmul float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:2 for: %V4F64 = fmul <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:4 for: %V8F64 = fmul <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fmul'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fmul float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fmul <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fmul <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fmul double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fmul <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fmul <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fmul'
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fmul float undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:7 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:14 SizeLat:2 for: %V4F64 = fmul <4 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:28 SizeLat:4 for: %V8F64 = fmul <8 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fmul'
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fmul float undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fmul <4 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fmul <8 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fmul <16 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fmul double undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fmul <2 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fmul <4 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fmul <8 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fmul float undef, undef
  %V4F32 = fmul <4 x float> undef, undef
  %V8F32 = fmul <8 x float> undef, undef
  %V16F32 = fmul <16 x float> undef, undef

  %F64 = fmul double undef, undef
  %V2F64 = fmul <2 x double> undef, undef
  %V4F64 = fmul <4 x double> undef, undef
  %V8F64 = fmul <8 x double> undef, undef

  ret i32 undef
}

define i32 @fdiv(i32 %arg) {
; SSE1-LABEL: 'fdiv'
; SSE1-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:1 Lat:18 SizeLat:1 for: %F32 = fdiv float undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:1 Lat:48 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:68 CodeSize:2 Lat:96 SizeLat:2 for: %V8F32 = fdiv <8 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:136 CodeSize:4 Lat:192 SizeLat:4 for: %V16F32 = fdiv <16 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:38 SizeLat:1 for: %F64 = fdiv double undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:76 CodeSize:2 Lat:76 SizeLat:2 for: %V2F64 = fdiv <2 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:152 CodeSize:4 Lat:152 SizeLat:4 for: %V4F64 = fdiv <4 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:304 CodeSize:8 Lat:304 SizeLat:8 for: %V8F64 = fdiv <8 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fdiv'
; SSE2-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:23 SizeLat:1 for: %F32 = fdiv float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:39 CodeSize:1 Lat:39 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:78 CodeSize:2 Lat:78 SizeLat:2 for: %V8F32 = fdiv <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:156 CodeSize:4 Lat:156 SizeLat:4 for: %V16F32 = fdiv <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:38 CodeSize:1 Lat:38 SizeLat:1 for: %F64 = fdiv double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:69 CodeSize:1 Lat:69 SizeLat:1 for: %V2F64 = fdiv <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:138 CodeSize:2 Lat:138 SizeLat:2 for: %V4F64 = fdiv <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:276 CodeSize:4 Lat:276 SizeLat:4 for: %V8F64 = fdiv <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fdiv'
; SSE42-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:14 SizeLat:1 for: %F32 = fdiv float undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:14 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:2 Lat:28 SizeLat:2 for: %V8F32 = fdiv <8 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:4 Lat:56 SizeLat:4 for: %V16F32 = fdiv <16 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:22 SizeLat:1 for: %F64 = fdiv double undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:22 SizeLat:1 for: %V2F64 = fdiv <2 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:2 Lat:44 SizeLat:2 for: %V4F64 = fdiv <4 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:4 Lat:88 SizeLat:4 for: %V8F64 = fdiv <8 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fdiv'
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:14 SizeLat:1 for: %F32 = fdiv float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:14 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:29 SizeLat:3 for: %V8F32 = fdiv <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:2 Lat:58 SizeLat:6 for: %V16F32 = fdiv <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:22 SizeLat:1 for: %F64 = fdiv double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:1 Lat:22 SizeLat:1 for: %V2F64 = fdiv <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:1 Lat:45 SizeLat:3 for: %V4F64 = fdiv <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:2 Lat:90 SizeLat:6 for: %V8F64 = fdiv <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fdiv'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:13 SizeLat:1 for: %F32 = fdiv float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:13 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:21 SizeLat:3 for: %V8F32 = fdiv <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:2 Lat:42 SizeLat:6 for: %V16F32 = fdiv <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:20 SizeLat:1 for: %F64 = fdiv double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:20 SizeLat:1 for: %V2F64 = fdiv <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:35 SizeLat:3 for: %V4F64 = fdiv <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:2 Lat:70 SizeLat:6 for: %V8F64 = fdiv <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fdiv'
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:11 SizeLat:1 for: %F32 = fdiv float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:11 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:11 SizeLat:1 for: %V8F32 = fdiv <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:18 SizeLat:3 for: %V16F32 = fdiv <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:14 SizeLat:1 for: %F64 = fdiv double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:14 SizeLat:1 for: %V2F64 = fdiv <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:14 SizeLat:1 for: %V4F64 = fdiv <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:1 Lat:23 SizeLat:3 for: %V8F64 = fdiv <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fdiv'
; SLM-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:1 Lat:19 SizeLat:1 for: %F32 = fdiv float undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:39 CodeSize:1 Lat:39 SizeLat:6 for: %V4F32 = fdiv <4 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:78 CodeSize:2 Lat:78 SizeLat:12 for: %V8F32 = fdiv <8 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:156 CodeSize:4 Lat:156 SizeLat:24 for: %V16F32 = fdiv <16 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:34 SizeLat:1 for: %F64 = fdiv double undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:69 CodeSize:1 Lat:69 SizeLat:6 for: %V2F64 = fdiv <2 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:138 CodeSize:2 Lat:138 SizeLat:12 for: %V4F64 = fdiv <4 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:276 CodeSize:4 Lat:276 SizeLat:24 for: %V8F64 = fdiv <8 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fdiv'
; GLM-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:19 SizeLat:1 for: %F32 = fdiv float undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:35 CodeSize:1 Lat:36 SizeLat:1 for: %V4F32 = fdiv <4 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:70 CodeSize:2 Lat:72 SizeLat:2 for: %V8F32 = fdiv <8 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:140 CodeSize:4 Lat:144 SizeLat:4 for: %V16F32 = fdiv <16 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:1 Lat:34 SizeLat:1 for: %F64 = fdiv double undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:65 CodeSize:1 Lat:66 SizeLat:1 for: %V2F64 = fdiv <2 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:130 CodeSize:2 Lat:132 SizeLat:2 for: %V4F64 = fdiv <4 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:260 CodeSize:4 Lat:264 SizeLat:4 for: %V8F64 = fdiv <8 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fdiv float undef, undef
  %V4F32 = fdiv <4 x float> undef, undef
  %V8F32 = fdiv <8 x float> undef, undef
  %V16F32 = fdiv <16 x float> undef, undef

  %F64 = fdiv double undef, undef
  %V2F64 = fdiv <2 x double> undef, undef
  %V4F64 = fdiv <4 x double> undef, undef
  %V8F64 = fdiv <8 x double> undef, undef

  ret i32 undef
}

define i32 @frem(i32 %arg) {
; SSE1-LABEL: 'frem'
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; SSE1-NEXT:  Cost Model: Found costs of 4 for: %V2F64 = frem <2 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'frem'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %V2F64 = frem <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'frem'
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %V2F64 = frem <2 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'frem'
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:46 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %V2F64 = frem <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'frem'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:47 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %V2F64 = frem <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'frem'
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %V2F64 = frem <2 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'frem'
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F32 = frem float undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:4 Lat:4 SizeLat:4 for: %V4F32 = frem <4 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:4 Lat:4 SizeLat:4 for: %V8F32 = frem <8 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = frem <16 x float> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %F64 = frem double undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:4 SizeLat:4 for: %V2F64 = frem <2 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:4 SizeLat:4 for: %V4F64 = frem <4 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = frem <8 x double> undef, undef
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = frem float undef, undef
  %V4F32 = frem <4 x float> undef, undef
  %V8F32 = frem <8 x float> undef, undef
  %V16F32 = frem <16 x float> undef, undef

  %F64 = frem double undef, undef
  %V2F64 = frem <2 x double> undef, undef
  %V4F64 = frem <4 x double> undef, undef
  %V8F64 = frem <8 x double> undef, undef

  ret i32 undef
}

define i32 @fsqrt(i32 %arg) {
; SSE1-LABEL: 'fsqrt'
; SSE1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:30 SizeLat:2 for: %F32 = call float @llvm.sqrt.f32(float undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:56 SizeLat:2 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:2 Lat:112 SizeLat:4 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:4 Lat:224 SizeLat:8 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:8 SizeLat:8 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:16 SizeLat:16 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fsqrt'
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:30 SizeLat:2 for: %F32 = call float @llvm.sqrt.f32(float undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:56 SizeLat:2 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:2 Lat:112 SizeLat:4 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:4 Lat:224 SizeLat:8 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:32 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:32 SizeLat:1 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:2 Lat:64 SizeLat:2 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:4 Lat:128 SizeLat:4 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fsqrt'
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:18 SizeLat:1 for: %F32 = call float @llvm.sqrt.f32(float undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:18 SizeLat:1 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:2 Lat:36 SizeLat:2 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:4 Lat:72 SizeLat:4 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:32 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:32 SizeLat:1 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:2 Lat:64 SizeLat:2 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:4 Lat:128 SizeLat:4 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'fsqrt'
; AVX1-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:21 SizeLat:1 for: %F32 = call float @llvm.sqrt.f32(float undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:21 SizeLat:1 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:1 Lat:42 SizeLat:3 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:2 Lat:84 SizeLat:6 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:27 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:27 SizeLat:1 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:54 CodeSize:1 Lat:54 SizeLat:3 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:108 CodeSize:2 Lat:108 SizeLat:6 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'fsqrt'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:15 SizeLat:1 for: %F32 = call float @llvm.sqrt.f32(float undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:15 SizeLat:1 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:21 SizeLat:3 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:2 Lat:42 SizeLat:6 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:21 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:21 SizeLat:1 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:35 SizeLat:3 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:2 Lat:70 SizeLat:6 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fsqrt'
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:12 SizeLat:1 for: %F32 = call float @llvm.sqrt.f32(float undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:12 SizeLat:1 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:12 SizeLat:1 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:20 SizeLat:3 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:18 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:18 SizeLat:1 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:18 SizeLat:1 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:32 SizeLat:3 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fsqrt'
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:20 SizeLat:1 for: %F32 = call float @llvm.sqrt.f32(float undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:41 SizeLat:5 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:2 Lat:82 SizeLat:10 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:4 Lat:164 SizeLat:20 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:35 CodeSize:1 Lat:35 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:70 CodeSize:1 Lat:71 SizeLat:5 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:140 CodeSize:2 Lat:142 SizeLat:10 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:280 CodeSize:4 Lat:284 SizeLat:20 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fsqrt'
; GLM-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:1 Lat:20 SizeLat:1 for: %F32 = call float @llvm.sqrt.f32(float undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:37 CodeSize:1 Lat:41 SizeLat:5 for: %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:74 CodeSize:2 Lat:82 SizeLat:10 for: %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:148 CodeSize:4 Lat:164 SizeLat:20 for: %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:1 Lat:35 SizeLat:1 for: %F64 = call double @llvm.sqrt.f64(double undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:67 CodeSize:1 Lat:71 SizeLat:5 for: %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:134 CodeSize:2 Lat:142 SizeLat:10 for: %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:268 CodeSize:4 Lat:284 SizeLat:20 for: %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call float @llvm.sqrt.f32(float undef)
  %V4F32 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> undef)
  %V8F32 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> undef)
  %V16F32 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> undef)

  %F64 = call double @llvm.sqrt.f64(double undef)
  %V2F64 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> undef)
  %V4F64 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> undef)
  %V8F64 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> undef)

  ret i32 undef
}

define i32 @fabs(i32 %arg) {
; SSE1-LABEL: 'fabs'
; SSE1-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; SSE1-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.fabs.f64(double undef)
; SSE1-NEXT:  Cost Model: Found costs of 4 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of 8 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of 16 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fabs'
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.fabs.f64(double undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fabs'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.fabs.f64(double undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'fabs'
; AVX-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.fabs.f64(double undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fabs'
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.fabs.f64(double undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fabs'
; SLM-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.fabs.f64(double undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fabs'
; GLM-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.fabs.f32(float undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.fabs.f64(double undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call float @llvm.fabs.f32(float undef)
  %V4F32 = call <4 x float> @llvm.fabs.v4f32(<4 x float> undef)
  %V8F32 = call <8 x float> @llvm.fabs.v8f32(<8 x float> undef)
  %V16F32 = call <16 x float> @llvm.fabs.v16f32(<16 x float> undef)

  %F64 = call double @llvm.fabs.f64(double undef)
  %V2F64 = call <2 x double> @llvm.fabs.v2f64(<2 x double> undef)
  %V4F64 = call <4 x double> @llvm.fabs.v4f64(<4 x double> undef)
  %V8F64 = call <8 x double> @llvm.fabs.v8f64(<8 x double> undef)

  ret i32 undef
}

define i32 @fcopysign(i32 %arg) {
; SSE1-LABEL: 'fcopysign'
; SSE1-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; SSE1-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:2 Lat:20 SizeLat:20 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:40 SizeLat:40 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:8 Lat:80 SizeLat:80 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fcopysign'
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fcopysign'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'fcopysign'
; AVX-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fcopysign'
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 2 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fcopysign'
; SLM-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fcopysign'
; GLM-NEXT:  Cost Model: Found costs of 2 for: %F32 = call float @llvm.copysign.f32(float undef, float undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %F64 = call double @llvm.copysign.f64(double undef, double undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call float @llvm.copysign.f32(float undef, float undef)
  %V4F32 = call <4 x float> @llvm.copysign.v4f32(<4 x float> undef, <4 x float> undef)
  %V8F32 = call <8 x float> @llvm.copysign.v8f32(<8 x float> undef, <8 x float> undef)
  %V16F32 = call <16 x float> @llvm.copysign.v16f32(<16 x float> undef, <16 x float> undef)

  %F64 = call double @llvm.copysign.f64(double undef, double undef)
  %V2F64 = call <2 x double> @llvm.copysign.v2f64(<2 x double> undef, <2 x double> undef)
  %V4F64 = call <4 x double> @llvm.copysign.v4f64(<4 x double> undef, <4 x double> undef)
  %V8F64 = call <8 x double> @llvm.copysign.v8f64(<8 x double> undef, <8 x double> undef)

  ret i32 undef
}

define i32 @fma(i32 %arg) {
; SSE1-LABEL: 'fma'
; SSE1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:2 Lat:20 SizeLat:20 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:40 SizeLat:40 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:8 Lat:80 SizeLat:80 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'fma'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:3 Lat:21 SizeLat:21 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:6 Lat:42 SizeLat:42 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:12 Lat:84 SizeLat:84 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'fma'
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:3 Lat:21 SizeLat:21 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:6 Lat:42 SizeLat:42 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:12 Lat:84 SizeLat:84 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'fma'
; AVX-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:87 CodeSize:15 Lat:87 SizeLat:87 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:174 CodeSize:30 Lat:174 SizeLat:174 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:3 Lat:21 SizeLat:21 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'fma'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'fma'
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:3 Lat:21 SizeLat:21 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:6 Lat:42 SizeLat:42 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:12 Lat:84 SizeLat:84 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'fma'
; GLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:3 Lat:21 SizeLat:21 for: %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:6 Lat:42 SizeLat:42 for: %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:12 Lat:84 SizeLat:84 for: %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call float @llvm.fma.f32(float undef, float undef, float undef)
  %V4F32 = call <4 x float> @llvm.fma.v4f32(<4 x float> undef, <4 x float> undef, <4 x float> undef)
  %V8F32 = call <8 x float> @llvm.fma.v8f32(<8 x float> undef, <8 x float> undef, <8 x float> undef)
  %V16F32 = call <16 x float> @llvm.fma.v16f32(<16 x float> undef, <16 x float> undef, <16 x float> undef)

  %F64 = call double @llvm.fma.f64(double undef, double undef, double undef)
  %V2F64 = call <2 x double> @llvm.fma.v2f64(<2 x double> undef, <2 x double> undef, <2 x double> undef)
  %V4F64 = call <4 x double> @llvm.fma.v4f64(<4 x double> undef, <4 x double> undef, <4 x double> undef)
  %V8F64 = call <8 x double> @llvm.fma.v8f64(<8 x double> undef, <8 x double> undef, <8 x double> undef)

  ret i32 undef
}

define i32 @rint(i32 %arg) {
; SSE1-LABEL: 'rint'
; SSE1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.rint.f32(float undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.rint.f64(double undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:2 Lat:20 SizeLat:20 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:4 Lat:40 SizeLat:40 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:8 Lat:80 SizeLat:80 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'rint'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F32 = call float @llvm.rint.f32(float undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:7 Lat:43 SizeLat:43 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:86 CodeSize:14 Lat:86 SizeLat:86 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:172 CodeSize:28 Lat:172 SizeLat:172 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:10 SizeLat:10 for: %F64 = call double @llvm.rint.f64(double undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:3 Lat:21 SizeLat:21 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:6 Lat:42 SizeLat:42 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:12 Lat:84 SizeLat:84 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'rint'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F32 = call float @llvm.rint.f32(float undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.rint.f64(double undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'rint'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %F32 = call float @llvm.rint.f32(float undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.rint.f64(double undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'rint'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F32 = call float @llvm.rint.f32(float undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.rint.f64(double undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'rint'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = call float @llvm.rint.f32(float undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.rint.f64(double undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'rint'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = call float @llvm.rint.f32(float undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V8F32 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 8 for: %V16F32 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = call double @llvm.rint.f64(double undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V4F64 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 8 for: %V8F64 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call float @llvm.rint.f32.f32(float undef)
  %V4F32 = call <4 x float> @llvm.rint.v4f32.v4f32(<4 x float> undef)
  %V8F32 = call <8 x float> @llvm.rint.v8f32.v8f32(<8 x float> undef)
  %V16F32 = call <16 x float> @llvm.rint.v16f32.v16f32(<16 x float> undef)

  %F64 = call double @llvm.rint.f64.f64(double undef)
  %V2F64 = call <2 x double> @llvm.rint.v2f64.v2f64(<2 x double> undef)
  %V4F64 = call <4 x double> @llvm.rint.v4f64.v4f64(<4 x double> undef)
  %V8F64 = call <8 x double> @llvm.rint.v8f64.v8f64(<8 x double> undef)

  ret i32 undef
}

define i32 @lrint(i32 %arg) {
; SSE1-LABEL: 'lrint'
; SSE1-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'lrint'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'lrint'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'lrint'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'lrint'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'lrint'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'lrint'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'lrint'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i32 @llvm.lrint.i32.f32(float undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i32 @llvm.lrint.i32.f64(double undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 2 for: %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of 4 for: %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call i32 @llvm.lrint.i32.f32(float undef)
  %V4F32 = call <4 x i32> @llvm.lrint.v4i32.v4f32(<4 x float> undef)
  %V8F32 = call <8 x i32> @llvm.lrint.v8i32.v8f32(<8 x float> undef)
  %V16F32 = call <16 x i32> @llvm.lrint.v16i32.v16f32(<16 x float> undef)

  %F64 = call i32 @llvm.lrint.i32.f64(double undef)
  %V2F64 = call <2 x i32> @llvm.lrint.v2i32.v2f64(<2 x double> undef)
  %V4F64 = call <4 x i32> @llvm.lrint.v4i32.v4f64(<4 x double> undef)
  %V8F64 = call <8 x i32> @llvm.lrint.v8i32.v8f64(<8 x double> undef)

  ret i32 undef
}

define i32 @llrint(i32 %arg) {
; SSE1-LABEL: 'llrint'
; SSE1-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; SSE1-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; SSE1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE2-LABEL: 'llrint'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:29 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:58 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:116 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'llrint'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX-LABEL: 'llrint'
; AVX-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:29 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:58 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; AVX-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; AVX-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'llrint'
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'llrint'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:25 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:100 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'llrint'
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F32 = call i64 @llvm.llrint.i64.f32(float undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:1 Lat:1 SizeLat:1 for: %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)
; GLM-NEXT:  Cost Model: Found costs of 1 for: %F64 = call i64 @llvm.llrint.i64.f64(double undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = call i64 @llvm.llrint.i64.f32(float undef)
  %V4F32 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> undef)
  %V8F32 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> undef)
  %V16F32 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> undef)

  %F64 = call i64 @llvm.llrint.i64.f64(double undef)
  %V2F64 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> undef)
  %V4F64 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> undef)
  %V8F64 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> undef)

  ret i32 undef
}

declare float @llvm.sqrt.f32(float)
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)
declare <16 x float> @llvm.sqrt.v16f32(<16 x float>)

declare double @llvm.sqrt.f64(double)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)
declare <8 x double> @llvm.sqrt.v8f64(<8 x double>)

declare float @llvm.fabs.f32(float)
declare <4 x float> @llvm.fabs.v4f32(<4 x float>)
declare <8 x float> @llvm.fabs.v8f32(<8 x float>)
declare <16 x float> @llvm.fabs.v16f32(<16 x float>)

declare double @llvm.fabs.f64(double)
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)
declare <4 x double> @llvm.fabs.v4f64(<4 x double>)
declare <8 x double> @llvm.fabs.v8f64(<8 x double>)

declare float @llvm.copysign.f32(float, float)
declare <4 x float> @llvm.copysign.v4f32(<4 x float>, <4 x float>)
declare <8 x float> @llvm.copysign.v8f32(<8 x float>, <8 x float>)
declare <16 x float> @llvm.copysign.v16f32(<16 x float>, <16 x float>)

declare double @llvm.copysign.f64(double, double)
declare <2 x double> @llvm.copysign.v2f64(<2 x double>, <2 x double>)
declare <4 x double> @llvm.copysign.v4f64(<4 x double>, <4 x double>)
declare <8 x double> @llvm.copysign.v8f64(<8 x double>, <8 x double>)

declare float @llvm.fma.f32(float, float, float)
declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>)
declare <16 x float> @llvm.fma.v16f32(<16 x float>, <16 x float>, <16 x float>)

declare double @llvm.fma.f64(double, double, double)
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>)
declare <8 x double> @llvm.fma.v8f64(<8 x double>, <8 x double>, <8 x double>)
