// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: aarch64-registered-target
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +neon -target-feature +sve -target-feature +bf16 -O1 -Werror -Wall -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +neon -target-feature +sve -target-feature +bf16 -O1 -Werror -Wall -emit-llvm -o - -x c++ %s | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +neon -target-feature +sve -target-feature +bf16 -S -O1 -Werror -Wall -o /dev/null %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -triple aarch64 -target-feature +neon -target-feature +sve -target-feature +bf16 -O1 -Werror -Wall -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -triple aarch64 -target-feature +neon -target-feature +sve -target-feature +bf16 -O1 -Werror -Wall -emit-llvm -o - -x c++ %s | FileCheck %s -check-prefix=CPP-CHECK
#include <arm_neon_sve_bridge.h>

#ifdef SVE_OVERLOADED_FORMS
// A simple used,unused... macro, long enough to represent any SVE builtin.
#define SVE_ACLE_FUNC(A1, A2_UNUSED, A3, A4_UNUSED) A1##A3
#else
#define SVE_ACLE_FUNC(A1, A2, A3, A4) A1##A2##A3##A4
#endif

// CHECK-LABEL: @test_svget_neonq_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <16 x i8> @llvm.vector.extract.v16i8.nxv16i8(<vscale x 16 x i8> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z19test_svget_neonq_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <16 x i8> @llvm.vector.extract.v16i8.nxv16i8(<vscale x 16 x i8> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_svget_neonq_s8(svint8_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _s8, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x i16> @llvm.vector.extract.v8i16.nxv8i16(<vscale x 8 x i16> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x i16> @llvm.vector.extract.v8i16.nxv8i16(<vscale x 8 x i16> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_svget_neonq_s16(svint16_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _s16, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <4 x i32> @llvm.vector.extract.v4i32.nxv4i32(<vscale x 4 x i32> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <4 x i32> @llvm.vector.extract.v4i32.nxv4i32(<vscale x 4 x i32> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_svget_neonq_s32(svint32_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _s32, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <2 x i64> @llvm.vector.extract.v2i64.nxv2i64(<vscale x 2 x i64> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <2 x i64> @llvm.vector.extract.v2i64.nxv2i64(<vscale x 2 x i64> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
int64x2_t test_svget_neonq_s64(svint64_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _s64, , )(n);
}

//
// CHECK-LABEL: @test_svget_neonq_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <16 x i8> @llvm.vector.extract.v16i8.nxv16i8(<vscale x 16 x i8> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z19test_svget_neonq_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <16 x i8> @llvm.vector.extract.v16i8.nxv16i8(<vscale x 16 x i8> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_svget_neonq_u8(svuint8_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _u8, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x i16> @llvm.vector.extract.v8i16.nxv8i16(<vscale x 8 x i16> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x i16> @llvm.vector.extract.v8i16.nxv8i16(<vscale x 8 x i16> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_svget_neonq_u16(svuint16_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _u16, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <4 x i32> @llvm.vector.extract.v4i32.nxv4i32(<vscale x 4 x i32> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <4 x i32> @llvm.vector.extract.v4i32.nxv4i32(<vscale x 4 x i32> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_svget_neonq_u32(svuint32_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _u32, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <2 x i64> @llvm.vector.extract.v2i64.nxv2i64(<vscale x 2 x i64> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <2 x i64> @llvm.vector.extract.v2i64.nxv2i64(<vscale x 2 x i64> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <2 x i64> [[TMP0]]
//
uint64x2_t test_svget_neonq_u64(svuint64_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _u64, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x half> @llvm.vector.extract.v8f16.nxv8f16(<vscale x 8 x half> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <8 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x half> @llvm.vector.extract.v8f16.nxv8f16(<vscale x 8 x half> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_svget_neonq_f16(svfloat16_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _f16, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <4 x float> @llvm.vector.extract.v4f32.nxv4f32(<vscale x 4 x float> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <4 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <4 x float> @llvm.vector.extract.v4f32.nxv4f32(<vscale x 4 x float> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_svget_neonq_f32(svfloat32_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _f32, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <2 x double> @llvm.vector.extract.v2f64.nxv2f64(<vscale x 2 x double> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <2 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z20test_svget_neonq_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <2 x double> @llvm.vector.extract.v2f64.nxv2f64(<vscale x 2 x double> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <2 x double> [[TMP0]]
//
float64x2_t test_svget_neonq_f64(svfloat64_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _f64, , )(n);
}

// CHECK-LABEL: @test_svget_neonq_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x bfloat> @llvm.vector.extract.v8bf16.nxv8bf16(<vscale x 8 x bfloat> [[N:%.*]], i64 0)
// CHECK-NEXT:    ret <8 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z21test_svget_neonq_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call <8 x bfloat> @llvm.vector.extract.v8bf16.nxv8bf16(<vscale x 8 x bfloat> [[N:%.*]], i64 0)
// CPP-CHECK-NEXT:    ret <8 x bfloat> [[TMP0]]
//
bfloat16x8_t test_svget_neonq_bf16(svbfloat16_t n) {
  return SVE_ACLE_FUNC(svget_neonq, _bf16, , )(n);
}
